/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.EditableListModelDecorator;
import com.intellij.util.ui.EditableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class PyModuleDependenciesConfigurable
implements UnnamedConfigurable {
    private final Module myModule;
    private List<Module> myInitialDependencies;
    private JPanel myMainPanel;
    private JPanel myListHolderPanel;
    private final CheckBoxList<Module> myDependenciesList;

    public PyModuleDependenciesConfigurable(Module module2) {
        this.myModule = module2;
        this.$$$setupUI$$$();
        this.myDependenciesList = new CheckBoxList();
        this.resetModel();
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myDependenciesList, (EditableModel)new EditableListModelDecorator((DefaultListModel)this.myDependenciesList.getModel()));
        decorator.disableRemoveAction();
        this.myListHolderPanel.add((Component)decorator.createPanel(), "Center");
    }

    private void resetModel() {
        this.myInitialDependencies = Arrays.asList(ModuleRootManager.getInstance((Module)this.myModule).getDependencies());
        ArrayList<Module> possibleDependencies = new ArrayList<Module>(this.myInitialDependencies);
        for (Module otherModule : ModuleManager.getInstance((Project)this.myModule.getProject()).getModules()) {
            if (possibleDependencies.contains(otherModule) || otherModule == this.myModule) continue;
            possibleDependencies.add(otherModule);
        }
        this.myDependenciesList.setItems(possibleDependencies, module2 -> module2.getName());
        this.myDependenciesList.setBorder(null);
        for (Module dependency : this.myInitialDependencies) {
            this.myDependenciesList.setItemSelected((Object)dependency, true);
        }
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        return !this.collectDependencies().equals(this.myInitialDependencies);
    }

    private List<Module> collectDependencies() {
        ArrayList<Module> result2 = new ArrayList<Module>();
        for (int i = 0; i < this.myDependenciesList.getItemsCount(); ++i) {
            Module module2 = (Module)this.myDependenciesList.getItemAt(i);
            if (!this.myDependenciesList.isItemSelected((Object)module2)) continue;
            result2.add(module2);
        }
        return result2;
    }

    public void apply() throws ConfigurationException {
        ApplicationManager.getApplication().runWriteAction(() -> {
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)this.myModule).getModifiableModel();
            ArrayList<ModuleOrderEntry> entries = new ArrayList<ModuleOrderEntry>();
            for (OrderEntry entry : model.getOrderEntries()) {
                if (!(entry instanceof ModuleOrderEntry)) continue;
                entries.add((ModuleOrderEntry)entry);
            }
            for (ModuleOrderEntry entry : entries) {
                model.removeOrderEntry((OrderEntry)entry);
            }
            for (Module module2 : this.collectDependencies()) {
                model.addModuleOrderEntry(module2);
            }
            model.commit();
        });
    }

    public void reset() {
        this.resetModel();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Project depends on these projects:");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myListHolderPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

