/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.typing;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyCustomType;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.functionTypeComments.psi.PyFunctionTypeAnnotation;
import com.jetbrains.python.codeInsight.functionTypeComments.psi.PyFunctionTypeAnnotationFile;
import com.jetbrains.python.codeInsight.functionTypeComments.psi.PyParameterTypeList;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAnnotationOwner;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDoubleStarExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithAncestors;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyCallExpressionNavigator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.stubs.PyClassElementType;
import com.jetbrains.python.psi.impl.stubs.PyTypingAliasStubType;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.stubs.PyClassStub;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import com.jetbrains.python.psi.stubs.PyTypingNewTypeStub;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableTypeImpl;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyTypeProviderBase;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyTypingNewType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypingTypeProvider
extends PyTypeProviderBase {
    private static final Object RECURSION_KEY = new Object();
    public static final String TYPING = "typing";
    public static final String GENERATOR = "typing.Generator";
    public static final String ASYNC_GENERATOR = "typing.AsyncGenerator";
    public static final String COROUTINE = "typing.Coroutine";
    public static final String NAMEDTUPLE = "typing.NamedTuple";
    public static final String GENERIC = "typing.Generic";
    public static final String PROTOCOL = "typing.Protocol";
    public static final String PROTOCOL_EXT = "typing_extensions.Protocol";
    public static final String TYPE = "typing.Type";
    public static final String ANY = "typing.Any";
    public static final String NEW_TYPE = "typing.NewType";
    public static final String CALLABLE = "typing.Callable";
    private static final String LIST = "typing.List";
    private static final String DICT = "typing.Dict";
    private static final String DEFAULT_DICT = "typing.DefaultDict";
    private static final String SET = "typing.Set";
    private static final String FROZEN_SET = "typing.FrozenSet";
    private static final String COUNTER = "typing.Counter";
    private static final String DEQUE = "typing.Deque";
    private static final String TUPLE = "typing.Tuple";
    public static final String CLASS_VAR = "typing.ClassVar";
    public static final String TYPE_VAR = "typing.TypeVar";
    private static final String CHAIN_MAP = "typing.ChainMap";
    public static final String UNION = "typing.Union";
    public static final String OPTIONAL = "typing.Optional";
    public static final String NO_RETURN = "typing.NoReturn";
    private static final String PY2_FILE_TYPE = "typing.BinaryIO";
    private static final String PY3_BINARY_FILE_TYPE = "typing.BinaryIO";
    private static final String PY3_TEXT_FILE_TYPE = "typing.TextIO";
    private static final Pattern TYPE_COMMENT_PATTERN = Pattern.compile("# *type: *([^#]+) *(#.*)?");
    public static final ImmutableMap<String, String> BUILTIN_COLLECTION_CLASSES = ImmutableMap.builder().put((Object)"typing.List", (Object)"list").put((Object)"typing.Dict", (Object)"dict").put((Object)"typing.Set", (Object)"set").put((Object)"typing.FrozenSet", (Object)"frozenset").put((Object)"typing.Tuple", (Object)"tuple").build();
    private static final ImmutableMap<String, String> COLLECTIONS_CLASSES = ImmutableMap.builder().put((Object)"typing.DefaultDict", (Object)"collections.defaultdict").put((Object)"typing.Counter", (Object)"collections.Counter").put((Object)"typing.Deque", (Object)"collections.deque").put((Object)"typing.ChainMap", (Object)"collections.ChainMap").build();
    public static final ImmutableMap<String, String> TYPING_COLLECTION_CLASSES = ImmutableMap.builder().put((Object)"list", (Object)"List").put((Object)"dict", (Object)"Dict").put((Object)"set", (Object)"Set").put((Object)"frozenset", (Object)"FrozenSet").build();
    public static final ImmutableSet<String> GENERIC_CLASSES = ImmutableSet.builder().add((Object[])new String[]{"typing.Tuple", "typing.Generic", "typing.Protocol", "typing.Callable", "typing.Type", "typing.ClassVar"}).add((Object[])new String[]{"typing.Union", "typing.Optional", "typing.List", "typing.Dict", "typing.DefaultDict", "typing.Set", "typing.FrozenSet", "typing.Counter", "typing.Deque", "typing.ChainMap"}).add((Object)"typing_extensions.Protocol").build();
    public static final ImmutableSet<String> OPAQUE_NAMES = ImmutableSet.builder().add((Object)PyKnownDecoratorUtil.KnownDecorator.TYPING_OVERLOAD.name()).add((Object)"typing.Any").add((Object)"typing.TypeVar").add((Object)"typing.Generic").add((Object)"typing.Tuple").add((Object)"typing.Callable").add((Object)"typing.Type").add((Object)"typing.no_type_check").add((Object)"typing.Union").add((Object)"typing.Optional").add((Object)"typing.List").add((Object)"typing.Dict").add((Object)"typing.DefaultDict").add((Object)"typing.Set").add((Object)"typing.FrozenSet").add((Object)"typing.Protocol").add((Object)"typing.ClassVar").add((Object)"typing.Counter").add((Object)"typing.Deque").add((Object)"typing.ChainMap").add((Object)"typing.NoReturn").build();

    @Override
    @Nullable
    public PyType getReferenceExpressionType(@NotNull PyReferenceExpression referenceExpression, @NotNull TypeEvalContext context) {
        if (referenceExpression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(1);
        }
        if ("Generic".equals(referenceExpression.getName()) && PyTypingTypeProvider.resolveToQualifiedNames(referenceExpression, context).contains(GENERIC)) {
            return PyTypingTypeProvider.createTypingGenericType((PsiElement)referenceExpression);
        }
        if ("Protocol".equals(referenceExpression.getName()) && ContainerUtil.exists(PyTypingTypeProvider.resolveToQualifiedNames(referenceExpression, context), n -> PROTOCOL.equals(n) || PROTOCOL_EXT.equals(n))) {
            return PyTypingTypeProvider.createTypingProtocolType((PsiElement)referenceExpression);
        }
        if ("Callable".equals(referenceExpression.getName()) && PyTypingTypeProvider.resolveToQualifiedNames(referenceExpression, context).contains(CALLABLE)) {
            return PyTypingTypeProvider.createTypingCallableType((PsiElement)referenceExpression);
        }
        PyType newType = PyTypingTypeProvider.getNewTypeForReference(referenceExpression, context);
        if (newType != null) {
            return newType;
        }
        return PyTypingTypeProvider.getTypeVarTypeForCallee(referenceExpression, context);
    }

    @Override
    @Nullable
    public Ref<PyType> getParameterType(@NotNull PyNamedParameter param, @NotNull PyFunction func, @NotNull TypeEvalContext context) {
        Ref<PyType> typeFromAnnotation;
        if (param == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(2);
        }
        if (func == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(3);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(4);
        }
        if ((typeFromAnnotation = PyTypingTypeProvider.getParameterTypeFromAnnotation(param, context)) != null) {
            return typeFromAnnotation;
        }
        Ref<PyType> typeFromTypeComment = PyTypingTypeProvider.getParameterTypeFromTypeComment(param, context);
        if (typeFromTypeComment != null) {
            return typeFromTypeComment;
        }
        PyFunctionTypeAnnotation annotation = PyTypingTypeProvider.getFunctionTypeAnnotation(func);
        if (annotation != null) {
            PyNoneLiteralExpression noneExpr;
            PyParameterTypeList list2 = annotation.getParameterTypeList();
            List<PyExpression> paramTypes = list2.getParameterTypes();
            if (paramTypes.size() == 1 && (noneExpr = PyUtil.as(paramTypes.get(0), PyNoneLiteralExpression.class)) != null && noneExpr.isEllipsis()) {
                return Ref.create();
            }
            int startOffset = PyTypingTypeProvider.omitFirstParamInTypeComment(func, annotation) ? 1 : 0;
            List<PyParameter> funcParams = Arrays.asList(func.getParameterList().getParameters());
            int i = funcParams.indexOf(param) - startOffset;
            if (i >= 0 && i < paramTypes.size()) {
                return PyTypingTypeProvider.getParameterTypeFromFunctionComment(paramTypes.get(i), context);
            }
        }
        return null;
    }

    public static boolean isGenerator(@NotNull PyType type) {
        if (type == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(5);
        }
        return type instanceof PyCollectionType && GENERATOR.equals(((PyClassLikeType)type).getClassQName());
    }

    @Nullable
    private static Ref<PyType> getParameterTypeFromFunctionComment(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        PyExpression inner;
        PyExpression inner2;
        PyStarExpression starExpr;
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(6);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(7);
        }
        if ((starExpr = PyUtil.as(expression, PyStarExpression.class)) != null && (inner2 = starExpr.getExpression()) != null) {
            return Ref.create((Object)PyTypeUtil.toPositionalContainerType((PsiElement)expression, (PyType)Ref.deref(PyTypingTypeProvider.getType(inner2, new Context(context)))));
        }
        PyDoubleStarExpression doubleStarExpr = PyUtil.as(expression, PyDoubleStarExpression.class);
        if (doubleStarExpr != null && (inner = doubleStarExpr.getExpression()) != null) {
            return Ref.create((Object)PyTypeUtil.toKeywordContainerType((PsiElement)expression, (PyType)Ref.deref(PyTypingTypeProvider.getType(inner, new Context(context)))));
        }
        return PyTypingTypeProvider.getType(expression, new Context(context));
    }

    @Nullable
    private static Ref<PyType> getParameterTypeFromTypeComment(@NotNull PyNamedParameter parameter, @NotNull TypeEvalContext context) {
        String typeComment;
        if (parameter == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(8);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(9);
        }
        if ((typeComment = parameter.getTypeCommentAnnotation()) != null) {
            PyType type = (PyType)Ref.deref(PyTypingTypeProvider.getStringBasedType(typeComment, (PsiElement)parameter, context));
            if (parameter.isPositionalContainer()) {
                return Ref.create((Object)PyTypeUtil.toPositionalContainerType(parameter, type));
            }
            if (parameter.isKeywordContainer()) {
                return Ref.create((Object)PyTypeUtil.toKeywordContainerType(parameter, type));
            }
            return Ref.create((Object)type);
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getParameterTypeFromAnnotation(@NotNull PyNamedParameter parameter, @NotNull TypeEvalContext context) {
        Ref annotationValueTypeRef;
        if (parameter == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(10);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(11);
        }
        if ((annotationValueTypeRef = (Ref)Optional.ofNullable(PyTypingTypeProvider.getAnnotationValue(parameter, context)).map(text2 -> {
            if (context == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(148);
            }
            return PyTypingTypeProvider.getType(text2, new Context(context));
        }).orElse(null)) != null) {
            PyType annotationValueType = (PyType)annotationValueTypeRef.get();
            if (parameter.isPositionalContainer()) {
                return Ref.create((Object)PyTypeUtil.toPositionalContainerType(parameter, annotationValueType));
            }
            if (parameter.isKeywordContainer()) {
                return Ref.create((Object)PyTypeUtil.toKeywordContainerType(parameter, annotationValueType));
            }
            if ("None".equals(parameter.getDefaultValueText())) {
                return Ref.create((Object)PyUnionType.union(annotationValueType, PyNoneType.INSTANCE));
            }
            return Ref.create((Object)annotationValueType);
        }
        return null;
    }

    @NotNull
    private static PyType createTypingGenericType(@NotNull PsiElement anchor2) {
        if (anchor2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(12);
        }
        PyCustomType pyCustomType = new PyCustomType(GENERIC, null, false, true, PyBuiltinCache.getInstance(anchor2).getObjectType());
        if (pyCustomType == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(13);
        }
        return pyCustomType;
    }

    @NotNull
    private static PyType createTypingProtocolType(@NotNull PsiElement anchor2) {
        if (anchor2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(14);
        }
        PyCustomType pyCustomType = new PyCustomType(PROTOCOL, null, false, true, PyBuiltinCache.getInstance(anchor2).getObjectType());
        if (pyCustomType == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(15);
        }
        return pyCustomType;
    }

    @NotNull
    public static PyType createTypingCallableType(@NotNull PsiElement anchor2) {
        if (anchor2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(16);
        }
        PyCustomType pyCustomType = new PyCustomType(CALLABLE, null, false, true, PyBuiltinCache.getInstance(anchor2).getObjectType());
        if (pyCustomType == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(17);
        }
        return pyCustomType;
    }

    @Nullable
    private static PyType getTypeVarTypeForCallee(@NotNull PyReferenceExpression referenceExpression, @NotNull TypeEvalContext context) {
        if (referenceExpression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(18);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(19);
        }
        if (PyCallExpressionNavigator.getPyCallExpressionByCallee((PsiElement)referenceExpression) == null) {
            return null;
        }
        if (PyTypingTypeProvider.resolveToQualifiedNames(referenceExpression, context).contains(TYPE_VAR)) {
            ArrayList<PyCallableParameter> parameters2 = new ArrayList<PyCallableParameter>();
            PyBuiltinCache builtinCache = PyBuiltinCache.getInstance((PsiElement)referenceExpression);
            LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)referenceExpression);
            PyElementGenerator generator = PyElementGenerator.getInstance(referenceExpression.getProject());
            parameters2.add(PyCallableParameterImpl.nonPsi("name", builtinCache.getStringType(languageLevel)));
            PyType typeOrForwardReference = PyUnionType.union(builtinCache.getTypeType(), builtinCache.getStrType());
            parameters2.add(PyCallableParameterImpl.positionalNonPsi("constraints", typeOrForwardReference));
            parameters2.add(PyCallableParameterImpl.nonPsi("bound", typeOrForwardReference, generator.createEllipsis()));
            PyClassType boolType = builtinCache.getBoolType();
            PyExpression falseValue = generator.createExpressionFromText(languageLevel, "False");
            parameters2.add(PyCallableParameterImpl.nonPsi("covariant", boolType, falseValue));
            parameters2.add(PyCallableParameterImpl.nonPsi("contravariant", boolType, falseValue));
            return new PyCallableTypeImpl(parameters2, null);
        }
        return null;
    }

    private static boolean omitFirstParamInTypeComment(@NotNull PyFunction func, @NotNull PyFunctionTypeAnnotation annotation) {
        if (func == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(20);
        }
        if (annotation == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(21);
        }
        return func.getContainingClass() != null && func.getModifier() != PyFunction.Modifier.STATICMETHOD && annotation.getParameterTypeList().getParameterTypes().size() < func.getParameterList().getParameters().length;
    }

    @Override
    @Nullable
    public Ref<PyType> getReturnType(@NotNull PyCallable callable, @NotNull TypeEvalContext context) {
        Ref<PyType> typeRef;
        PyFunction function;
        PyExpression returnTypeAnnotation;
        if (callable == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(22);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(23);
        }
        if (callable instanceof PyFunction && (returnTypeAnnotation = PyTypingTypeProvider.getReturnTypeAnnotation(function = (PyFunction)callable, context)) != null && (typeRef = PyTypingTypeProvider.getType(returnTypeAnnotation, new Context(context))) != null) {
            return Ref.create((Object)PyTypingTypeProvider.toAsyncIfNeeded(function, (PyType)typeRef.get()));
        }
        return null;
    }

    @Nullable
    static PyExpression getReturnTypeAnnotation(@NotNull PyFunction function, TypeEvalContext context) {
        PyExpression returnAnnotation;
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(24);
        }
        if ((returnAnnotation = PyTypingTypeProvider.getAnnotationValue(function, context)) != null) {
            return returnAnnotation;
        }
        PyFunctionTypeAnnotation functionAnnotation = PyTypingTypeProvider.getFunctionTypeAnnotation(function);
        if (functionAnnotation != null) {
            return functionAnnotation.getReturnType();
        }
        return null;
    }

    @Nullable
    public static PyFunctionTypeAnnotation getFunctionTypeAnnotation(@NotNull PyFunction function) {
        String comment;
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(25);
        }
        if ((comment = function.getTypeCommentAnnotation()) == null) {
            return null;
        }
        PyFunctionTypeAnnotationFile file2 = (PyFunctionTypeAnnotationFile)CachedValuesManager.getCachedValue((PsiElement)function, () -> {
            if (function == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(147);
            }
            return CachedValueProvider.Result.create((Object)new PyFunctionTypeAnnotationFile(function.getTypeCommentAnnotation(), function), (Object[])new Object[]{function});
        });
        return file2.getAnnotation();
    }

    @Override
    @Nullable
    public Ref<PyType> getCallType(@NotNull PyFunction function, @NotNull PyCallSiteExpression callSite, @NotNull TypeEvalContext context) {
        String functionQName;
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(26);
        }
        if (callSite == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(27);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(28);
        }
        if ("typing.cast".equals(functionQName = function.getQualifiedName())) {
            return Optional.ofNullable(PyUtil.as(callSite, PyCallExpression.class)).map(PyCallExpression::getArguments).filter(args -> ((PyExpression[])args).length > 0).map(args -> {
                if (context == null) {
                    PyTypingTypeProvider.$$$reportNull$$$0(146);
                }
                return PyTypingTypeProvider.getType(args[0], new Context(context));
            }).orElse(null);
        }
        if (callSite instanceof PyCallExpression) {
            LanguageLevel level;
            LanguageLevel languageLevel = "open".equals(functionQName) ? LanguageLevel.forElement((PsiElement)callSite) : (level = "pathlib.Path.open".equals(functionQName) || "_io.open".equals(functionQName) ? LanguageLevel.PYTHON34 : null);
            if (level != null) {
                return PyTypingTypeProvider.getOpenFunctionCallType(function, (PyCallExpression)callSite, level, context);
            }
        }
        if (callSite instanceof PyCallExpression && NEW_TYPE.equals(functionQName)) {
            return Ref.create((Object)PyTypingTypeProvider.getNewTypeForCallExpression((PyCallExpression)callSite, context));
        }
        return null;
    }

    @Nullable
    private static PyType getNewTypeForReference(@NotNull PyReferenceExpression referenceExpression, @NotNull TypeEvalContext context) {
        PyCallExpression callee;
        if (referenceExpression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(29);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(30);
        }
        if ((callee = PyCallExpressionNavigator.getPyCallExpressionByCallee((PsiElement)referenceExpression)) == null) {
            return null;
        }
        PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
        ResolveResult[] resolveResults = referenceExpression.getReference(resolveContext).multiResolve(false);
        for (PsiElement element : PyUtil.filterTopPriorityResults(resolveResults)) {
            PyType typeForTarget;
            if (!(element instanceof PyTargetExpression) || (typeForTarget = PyTypingTypeProvider.getNewTypeCreationForTarget((PyTargetExpression)element, context)) == null) continue;
            return typeForTarget;
        }
        return null;
    }

    @Nullable
    private static PyType getNewTypeCreationForTarget(@NotNull PyTargetExpression referenceTarget, @NotNull TypeEvalContext context) {
        PyTargetExpressionStub stub;
        if (referenceTarget == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(31);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(32);
        }
        if ((stub = (PyTargetExpressionStub)referenceTarget.getStub()) != null) {
            PyType type;
            PyTypingNewTypeStub customStub = stub.getCustomStub(PyTypingNewTypeStub.class);
            if (customStub != null && (type = (PyType)Ref.deref(PyTypingTypeProvider.getStringBasedType(customStub.getClassType(), (PsiElement)referenceTarget, context))) instanceof PyClassType) {
                return new PyTypingNewType((PyClassType)type, true, customStub.getName());
            }
        } else {
            PyExpression value = referenceTarget.findAssignedValue();
            if (value instanceof PyCallExpression) {
                return PyTypingTypeProvider.getNewTypeForCallExpression((PyCallExpression)value, context);
            }
        }
        return null;
    }

    @Nullable
    public static PyType getNewTypeForCallExpression(@NotNull PyCallExpression callExpression, @NotNull TypeEvalContext context) {
        PyType type;
        Ref<PyType> argType;
        PyExpression secondArg;
        String className;
        if (callExpression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(33);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(34);
        }
        if (PyTypingNewType.Companion.isTypingNewType(callExpression) && (className = PyResolveUtil.resolveFirstStrArgument(callExpression)) != null && (secondArg = PyPsiUtils.flattenParens(callExpression.getArgument(1, PyExpression.class))) != null && (argType = PyTypingTypeProvider.getType(secondArg, new Context(context))) != null && (type = (PyType)argType.get()) instanceof PyClassType) {
            return new PyTypingNewType((PyClassType)type, true, className);
        }
        return null;
    }

    @Override
    public Ref<PyType> getReferenceType(@NotNull PsiElement referenceTarget, @NotNull TypeEvalContext context, @Nullable PsiElement anchor2) {
        if (referenceTarget == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(35);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(36);
        }
        if (referenceTarget instanceof PyTargetExpression) {
            PyGenericType type;
            PyTargetExpression target2 = (PyTargetExpression)referenceTarget;
            String targetQName = target2.getQualifiedName();
            if (GENERIC.equals(targetQName)) {
                return Ref.create((Object)PyTypingTypeProvider.createTypingGenericType(target2));
            }
            if (PROTOCOL.equals(targetQName) || PROTOCOL_EXT.equals(targetQName)) {
                return Ref.create((Object)PyTypingTypeProvider.createTypingProtocolType(target2));
            }
            if (CALLABLE.equals(targetQName)) {
                return Ref.create((Object)PyTypingTypeProvider.createTypingCallableType(referenceTarget));
            }
            PyType collection = PyTypingTypeProvider.getCollection(target2, context);
            if (collection instanceof PyInstantiableType) {
                return Ref.create(((PyInstantiableType)collection).toClass());
            }
            PyType newType = PyTypingTypeProvider.getNewTypeCreationForTarget(target2, context);
            if (newType != null) {
                return Ref.create((Object)newType);
            }
            Ref<PyType> annotatedType = PyTypingTypeProvider.getTypeFromTargetExpressionAnnotation(target2, context);
            if (annotatedType != null) {
                return annotatedType;
            }
            PyExpression assignedValue = PyTypingAliasStubType.getAssignedValueStubLike(target2);
            if (assignedValue != null && (type = PyTypingTypeProvider.getGenericTypeFromTypeVar((PsiElement)assignedValue, new Context(context))) != null) {
                return Ref.create((Object)type);
            }
            String name = target2.getReferencedName();
            ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(target2);
            if (name == null || scopeOwner == null) {
                return null;
            }
            PyClass pyClass = target2.getContainingClass();
            if (target2.isQualified()) {
                if (pyClass != null && scopeOwner instanceof PyFunction) {
                    PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
                    boolean isInstanceAttribute = false;
                    isInstanceAttribute = context.maySwitchToAST(target2) ? ((StreamEx)StreamEx.of(PyUtil.multiResolveTopPriority((PsiElement)target2.getQualifier(), resolveContext)).select(PyParameter.class).filter(PyParameter::isSelf)).anyMatch(p -> PsiTreeUtil.getParentOfType((PsiElement)p, PyFunction.class) == scopeOwner) : PyUtil.isInstanceAttribute(target2);
                    if (!isInstanceAttribute) {
                        return null;
                    }
                    PyClassTypeImpl classType = new PyClassTypeImpl(pyClass, true);
                    List<? extends RatedResolveResult> classAttrs = classType.resolveMember(name, target2, AccessDirection.READ, resolveContext, true);
                    if (classAttrs == null) {
                        return null;
                    }
                    return (Ref)((StreamEx)StreamEx.of(classAttrs).map(RatedResolveResult::getElement).select(PyTargetExpression.class).filter(x -> ScopeUtil.getScopeOwner(x) instanceof PyClass)).map(x -> {
                        if (context == null) {
                            PyTypingTypeProvider.$$$reportNull$$$0(145);
                        }
                        return PyTypingTypeProvider.getTypeFromTargetExpressionAnnotation(x, context);
                    }).collect(PyTypeUtil.toUnionFromRef());
                }
            } else {
                StreamEx candidates = null;
                if (context.maySwitchToAST(target2)) {
                    Scope scope = ControlFlowCache.getScope(scopeOwner);
                    candidates = StreamEx.of(scope.getNamedElements(name, false)).select(PyTargetExpression.class);
                } else if (scopeOwner instanceof PyFile) {
                    candidates = (StreamEx)StreamEx.of(((PyFile)scopeOwner).getTopLevelAttributes()).filter(t -> name.equals(t.getName()));
                } else if (scopeOwner instanceof PyClass) {
                    candidates = (StreamEx)StreamEx.of(((PyClass)scopeOwner).getClassAttributes()).filter(t -> name.equals(t.getName()));
                }
                if (candidates != null) {
                    return candidates.map(x -> {
                        if (context == null) {
                            PyTypingTypeProvider.$$$reportNull$$$0(144);
                        }
                        return PyTypingTypeProvider.getTypeFromTargetExpressionAnnotation(x, context);
                    }).nonNull().findFirst().orElse(null);
                }
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTypeFromTargetExpressionAnnotation(@NotNull PyTargetExpression target2, @NotNull TypeEvalContext context) {
        PyExpression annotation;
        if (target2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(37);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(38);
        }
        if ((annotation = PyTypingTypeProvider.getAnnotationValue(target2, context)) != null) {
            return PyTypingTypeProvider.getType(annotation, new Context(context));
        }
        String comment = target2.getTypeCommentAnnotation();
        if (comment != null) {
            return PyTypingTypeProvider.getVariableTypeCommentType(comment, target2, new Context(context));
        }
        return null;
    }

    @Nullable
    public static String getTypeCommentValue(@NotNull String text2) {
        Matcher m;
        if (text2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(39);
        }
        if ((m = TYPE_COMMENT_PATTERN.matcher(text2)).matches()) {
            return StringUtil.nullize((String)m.group(1).trim());
        }
        return null;
    }

    @Nullable
    public static TextRange getTypeCommentValueRange(@NotNull String text2) {
        String hint;
        Matcher m;
        if (text2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(40);
        }
        if ((m = TYPE_COMMENT_PATTERN.matcher(text2)).matches() && (hint = PyTypingTypeProvider.getTypeCommentValue(text2)) != null) {
            return TextRange.from((int)m.start(1), (int)hint.length());
        }
        return null;
    }

    @Override
    @Nullable
    public PyType getGenericType(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        List<PyType> genericTypes;
        if (cls == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(41);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(42);
        }
        if ((genericTypes = PyTypingTypeProvider.collectGenericTypes(cls, new Context(context))).isEmpty()) {
            return null;
        }
        return new PyCollectionTypeImpl(cls, false, genericTypes);
    }

    @Override
    @NotNull
    public Map<PyType, PyType> getGenericSubstitutions(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        if (cls == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(43);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(44);
        }
        if (!PyTypingTypeProvider.isGeneric(cls, context)) {
            Map<PyType, PyType> map2 = Collections.emptyMap();
            if (map2 == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(45);
            }
            return map2;
        }
        HashMap<PyType, PyType> results = new HashMap<PyType, PyType>();
        for (Map.Entry<PyClass, PySubscriptionExpression> e : PyTypingTypeProvider.getResolvedSuperClassesAndTypeParameters(cls, context).entrySet()) {
            PySubscriptionExpression subscriptionExpr = e.getValue();
            PyClass superClass = e.getKey();
            Map superSubstitutions = (Map)RecursionManager.doPreventingRecursion((Object)RECURSION_KEY, (boolean)false, () -> {
                if (context == null) {
                    PyTypingTypeProvider.$$$reportNull$$$0(143);
                }
                return this.getGenericSubstitutions(superClass, context);
            });
            if (superSubstitutions != null) {
                results.putAll(superSubstitutions);
            }
            if (superClass == null) continue;
            Context ctx = new Context(context);
            List<PyType> superGenerics = PyTypingTypeProvider.collectGenericTypes(superClass, ctx);
            List<Object> indices = subscriptionExpr != null ? PyTypingTypeProvider.getSubscriptionIndices(subscriptionExpr) : Collections.emptyList();
            for (int i = 0; i < superGenerics.size(); ++i) {
                PyType actualType;
                PyExpression expr = (PyExpression)ContainerUtil.getOrElse(indices, (int)i, null);
                PyType superGeneric = superGenerics.get(i);
                Ref<PyType> typeRef = expr != null ? PyTypingTypeProvider.getType(expr, ctx) : null;
                PyType pyType = actualType = typeRef != null ? (PyType)typeRef.get() : null;
                if (superGeneric.equals(actualType)) continue;
                results.put(superGeneric, actualType);
            }
        }
        HashMap<PyType, PyType> hashMap = results;
        if (hashMap == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(46);
        }
        return hashMap;
    }

    @NotNull
    private static Map<PyClass, PySubscriptionExpression> getResolvedSuperClassesAndTypeParameters(@NotNull PyClass pyClass, @NotNull TypeEvalContext context) {
        if (pyClass == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(47);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(48);
        }
        LinkedHashMap<PyClass, PySubscriptionExpression> results = new LinkedHashMap<PyClass, PySubscriptionExpression>();
        PyClassStub classStub = (PyClassStub)pyClass.getStub();
        if (context.maySwitchToAST((PsiElement)pyClass)) {
            for (PyExpression e : pyClass.getSuperClassExpressions()) {
                PyClass superClass;
                PySubscriptionExpression subscriptionExpr = PyUtil.as(e, PySubscriptionExpression.class);
                PyExpression superExpr = subscriptionExpr != null ? subscriptionExpr.getOperand() : e;
                PyType superType = context.getType(superExpr);
                PyClassType superClassType = PyUtil.as(superType, PyClassType.class);
                PyClass pyClass2 = superClass = superClassType != null ? superClassType.getPyClass() : null;
                if (superClass == null) continue;
                results.put(superClass, subscriptionExpr);
            }
            LinkedHashMap<PyClass, PySubscriptionExpression> linkedHashMap = results;
            if (linkedHashMap == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(49);
            }
            return linkedHashMap;
        }
        List<PySubscriptionExpression> subscriptedBaseClasses = PyClassElementType.getSubscriptedSuperClassesStubLike(pyClass);
        HashMap<QualifiedName, PySubscriptionExpression> baseClassQNameToExpr = new HashMap<QualifiedName, PySubscriptionExpression>();
        Set<QualifiedName> allBaseClassesQNames = classStub == null ? PyClassElementType.getSuperClassQNames(pyClass).keySet() : classStub.getSuperClasses().keySet();
        for (PySubscriptionExpression subscriptedBase : subscriptedBaseClasses) {
            PyExpression operand = subscriptedBase.getOperand();
            if (!(operand instanceof PyReferenceExpression)) continue;
            QualifiedName className = PyPsiUtils.asQualifiedName(operand);
            baseClassQNameToExpr.put(className, subscriptedBase);
        }
        for (QualifiedName qName : allBaseClassesQNames) {
            List<PsiElement> classes = PyResolveUtil.resolveQualifiedNameInScope(qName, (PyFile)pyClass.getContainingFile(), context);
            PyClass firstFound = (PyClass)ContainerUtil.findInstance(classes, PyClass.class);
            if (firstFound == null) continue;
            results.put(firstFound, (PySubscriptionExpression)baseClassQNameToExpr.get(qName));
        }
        LinkedHashMap<PyClass, PySubscriptionExpression> linkedHashMap = results;
        if (linkedHashMap == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(50);
        }
        return linkedHashMap;
    }

    @NotNull
    private static List<PyExpression> getSubscriptionIndices(@NotNull PySubscriptionExpression expr) {
        PyExpression indexExpr;
        PyTupleExpression tupleExpr;
        if (expr == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(51);
        }
        List<PyExpression> list2 = (tupleExpr = PyUtil.as(indexExpr = expr.getIndexExpression(), PyTupleExpression.class)) != null ? Arrays.asList(tupleExpr.getElements()) : Collections.singletonList(indexExpr);
        if (list2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(52);
        }
        return list2;
    }

    @NotNull
    private static List<PyType> collectGenericTypes(@NotNull PyClass cls, @NotNull Context context) {
        if (cls == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(53);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(54);
        }
        if (!PyTypingTypeProvider.isGeneric(cls, context.getTypeContext())) {
            List<PyType> list2 = Collections.emptyList();
            if (list2 == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(55);
            }
            return list2;
        }
        TypeEvalContext typeEvalContext = context.getTypeContext();
        List list3 = ((StreamEx)StreamEx.of(PyClassElementType.getSubscriptedSuperClassesStubLike(cls)).map(PySubscriptionExpression::getIndexExpression).flatMap(e -> {
            PyTupleExpression tupleExpr = PyUtil.as(e, PyTupleExpression.class);
            return tupleExpr != null ? StreamEx.of((Object[])tupleExpr.getElements()) : StreamEx.of((Object)e);
        }).nonNull().flatMap(e -> PyTypingTypeProvider.tryResolving(e, typeEvalContext).stream()).map(e -> {
            if (context == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(142);
            }
            return PyTypingTypeProvider.getGenericTypeFromTypeVar(e, context);
        }).select(PyType.class).distinct()).toList();
        if (list3 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(56);
        }
        return list3;
    }

    public static boolean isGeneric(@NotNull PyWithAncestors descendant, @NotNull TypeEvalContext context) {
        if (descendant == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(57);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(58);
        }
        for (PyClassLikeType ancestor : descendant.getAncestorTypes(context)) {
            if (ancestor == null || !GENERIC_CLASSES.contains((Object)ancestor.getClassQName())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Ref<PyType> getType(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(59);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(60);
        }
        return PyTypingTypeProvider.getType(expression, new Context(context));
    }

    @Nullable
    static Ref<PyType> getType(@NotNull PyExpression expression, @NotNull Context context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(61);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(62);
        }
        ArrayList members = Lists.newArrayList();
        boolean foundAny = false;
        for (Pair<PyTargetExpression, PsiElement> pair : PyTypingTypeProvider.tryResolvingWithAliases(expression, context.getTypeContext())) {
            Ref<PyType> typeRef = PyTypingTypeProvider.getTypeForResolvedElement((PyTargetExpression)pair.getFirst(), (PsiElement)pair.getSecond(), context);
            if (typeRef == null) continue;
            PyType type = (PyType)typeRef.get();
            if (type == null) {
                foundAny = true;
            }
            members.add(type);
        }
        PyType union = PyUnionType.union(members);
        return union != null || foundAny ? Ref.create((Object)union) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Ref<PyType> getTypeForResolvedElement(@Nullable PyTargetExpression alias, @NotNull PsiElement resolved, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(63);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(64);
        }
        if (alias != null) {
            if (context.getExpressionCache().contains(alias)) {
                return null;
            }
            context.getExpressionCache().add(alias);
        }
        try {
            PyType unionType = PyTypingTypeProvider.getUnionType(resolved, context);
            if (unionType != null) {
                Ref ref = Ref.create((Object)unionType);
                return ref;
            }
            Ref<PyType> optionalType = PyTypingTypeProvider.getOptionalType(resolved, context);
            if (optionalType != null) {
                Ref<PyType> ref = optionalType;
                return ref;
            }
            PyType callableType = PyTypingTypeProvider.getCallableType(resolved, context);
            if (callableType != null) {
                Ref ref = Ref.create((Object)callableType);
                return ref;
            }
            Ref<PyType> classObjType = PyTypingTypeProvider.getClassObjectType(resolved, context);
            if (classObjType != null) {
                Ref ref = Ref.create((Object)PyTypingTypeProvider.addTypeVarAlias((PyType)classObjType.get(), alias));
                return ref;
            }
            PyType parameterizedType = PyTypingTypeProvider.getParameterizedType(resolved, context);
            if (parameterizedType != null) {
                Ref ref = Ref.create((Object)parameterizedType);
                return ref;
            }
            PyType collection = PyTypingTypeProvider.getCollection(resolved, context.getTypeContext());
            if (collection != null) {
                Ref ref = Ref.create((Object)collection);
                return ref;
            }
            PyGenericType genericType = PyTypingTypeProvider.getGenericTypeFromTypeVar(resolved, context);
            if (genericType != null) {
                Ref ref = Ref.create((Object)PyTypingTypeProvider.addTypeVarAlias(genericType, alias));
                return ref;
            }
            PyType stringBasedType = PyTypingTypeProvider.getStringLiteralType(resolved, context);
            if (stringBasedType != null) {
                Ref ref = Ref.create((Object)stringBasedType);
                return ref;
            }
            Ref<PyType> anyType = PyTypingTypeProvider.getAnyType(resolved);
            if (anyType != null) {
                Ref<PyType> ref = anyType;
                return ref;
            }
            Ref<PyType> classType = PyTypingTypeProvider.getClassType(resolved, context.getTypeContext());
            if (classType != null) {
                Ref<PyType> ref = classType;
                return ref;
            }
            Ref<PyType> ref = null;
            return ref;
        }
        finally {
            if (alias != null) {
                context.getExpressionCache().remove(alias);
            }
        }
    }

    @Nullable
    private static PyType addTypeVarAlias(@Nullable PyType type, @Nullable PyTargetExpression alias) {
        PyGenericType typeVar = PyUtil.as(type, PyGenericType.class);
        if (typeVar != null) {
            return new PyGenericType(typeVar.getName(), typeVar.getBound(), typeVar.isDefinition(), alias);
        }
        return type;
    }

    @Nullable
    private static Ref<PyType> getClassObjectType(@NotNull PsiElement resolved, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(65);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(66);
        }
        if (resolved instanceof PySubscriptionExpression) {
            PySubscriptionExpression subsExpr = (PySubscriptionExpression)resolved;
            PyExpression operand = subsExpr.getOperand();
            Collection<String> operandNames = PyTypingTypeProvider.resolveToQualifiedNames(operand, context.getTypeContext());
            if (operandNames.contains(TYPE)) {
                PyExpression indexExpr = subsExpr.getIndexExpression();
                if (indexExpr != null) {
                    if (PyTypingTypeProvider.resolveToQualifiedNames(indexExpr, context.getTypeContext()).contains(ANY)) {
                        return Ref.create((Object)PyBuiltinCache.getInstance(resolved).getTypeType());
                    }
                    PyType type = (PyType)Ref.deref(PyTypingTypeProvider.getType(indexExpr, context));
                    PyClassType classType = PyUtil.as(type, PyClassType.class);
                    if (classType != null && !classType.isDefinition()) {
                        return Ref.create((Object)new PyClassTypeImpl(classType.getPyClass(), true));
                    }
                    PyGenericType typeVar = PyUtil.as(type, PyGenericType.class);
                    if (typeVar != null && !typeVar.isDefinition()) {
                        return Ref.create((Object)new PyGenericType(typeVar.getName(), typeVar.getBound(), true));
                    }
                    PyUnionType unionType = PyUtil.as(type, PyUnionType.class);
                    if (unionType != null && unionType.getMembers().stream().allMatch(t -> t instanceof PyClassType && !((PyClassType)t).isDefinition())) {
                        return Ref.create((Object)PyUnionType.union(ContainerUtil.map(unionType.getMembers(), t -> (PyClassLikeType)((PyClassType)t).toClass())));
                    }
                }
                return Ref.create();
            }
        } else if (TYPE.equals(PyTypingTypeProvider.getQualifiedName(resolved))) {
            return Ref.create((Object)PyBuiltinCache.getInstance(resolved).getTypeType());
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getAnyType(@NotNull PsiElement element) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(67);
        }
        return ANY.equals(PyTypingTypeProvider.getQualifiedName(element)) ? Ref.create() : null;
    }

    @Nullable
    private static Ref<PyType> getClassType(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(68);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(69);
        }
        if (element instanceof PyTypedElement) {
            PyType type = context.getType((PyTypedElement)element);
            if (type instanceof PyClassLikeType) {
                PyClassLikeType classType = (PyClassLikeType)type;
                if (classType.isDefinition()) {
                    Object instanceType = classType.toInstance();
                    return Ref.create(instanceType);
                }
            } else if (type instanceof PyNoneType) {
                return Ref.create((Object)type);
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getOptionalType(@NotNull PsiElement element, @NotNull Context context) {
        PySubscriptionExpression subscriptionExpr;
        PyExpression operand;
        Collection<String> operandNames;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(70);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(71);
        }
        if (element instanceof PySubscriptionExpression && (operandNames = PyTypingTypeProvider.resolveToQualifiedNames(operand = (subscriptionExpr = (PySubscriptionExpression)element).getOperand(), context.getTypeContext())).contains(OPTIONAL)) {
            Ref<PyType> typeRef;
            PyExpression indexExpr = subscriptionExpr.getIndexExpression();
            if (indexExpr != null && (typeRef = PyTypingTypeProvider.getType(indexExpr, context)) != null) {
                return Ref.create((Object)PyUnionType.union((PyType)typeRef.get(), PyNoneType.INSTANCE));
            }
            return Ref.create();
        }
        return null;
    }

    @Nullable
    private static PyExpression getAnnotationValue(@NotNull PyAnnotationOwner owner, @NotNull TypeEvalContext context) {
        if (owner == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(72);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(73);
        }
        if (context.maySwitchToAST(owner)) {
            PyAnnotation annotation = owner.getAnnotation();
            if (annotation != null) {
                return annotation.getValue();
            }
        } else {
            String annotationText = owner.getAnnotationValue();
            if (annotationText != null) {
                return PyUtil.createExpressionFromFragment(annotationText, (PsiElement)owner.getContainingFile());
            }
        }
        return null;
    }

    @Nullable
    public static Ref<PyType> getStringBasedType(@NotNull String contents, @NotNull PsiElement anchor2, @NotNull TypeEvalContext context) {
        if (contents == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(74);
        }
        if (anchor2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(75);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(76);
        }
        return PyTypingTypeProvider.getStringBasedType(contents, anchor2, new Context(context));
    }

    @Nullable
    private static Ref<PyType> getStringBasedType(@NotNull String contents, @NotNull PsiElement anchor2, @NotNull Context context) {
        PsiFile file2;
        if (contents == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(77);
        }
        if (anchor2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(78);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(79);
        }
        if ((file2 = FileContextUtil.getContextFile(anchor2)) == null) {
            return null;
        }
        PyExpression expr = PyUtil.createExpressionFromFragment(contents, (PsiElement)file2);
        return expr != null ? PyTypingTypeProvider.getType(expr, context) : null;
    }

    @Nullable
    private static PyType getStringLiteralType(@NotNull PsiElement element, @NotNull Context context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(80);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(81);
        }
        if (element instanceof PyStringLiteralExpression) {
            String contents = ((PyStringLiteralExpression)element).getStringValue();
            return (PyType)Ref.deref(PyTypingTypeProvider.getStringBasedType(contents, element, context));
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getVariableTypeCommentType(@NotNull String contents, @NotNull PyTargetExpression target2, @NotNull Context context) {
        PyExpression expr;
        if (contents == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(82);
        }
        if (target2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(83);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(84);
        }
        if ((expr = PyPsiUtils.flattenParens(PyUtil.createExpressionFromFragment(contents, (PsiElement)target2.getContainingFile()))) != null) {
            if (expr instanceof PyTupleExpression) {
                Map<PyTargetExpression, PyExpression> targetToExpr;
                PyExpression typeExpr;
                PyExpression topmostTarget = PyTypingTypeProvider.findTopmostTarget(target2);
                if (topmostTarget != null && (typeExpr = (targetToExpr = PyTypingTypeProvider.mapTargetsToAnnotations(topmostTarget, expr)).get(target2)) != null) {
                    return PyTypingTypeProvider.getType(typeExpr, context);
                }
            } else {
                return PyTypingTypeProvider.getType(expr, context);
            }
        }
        return null;
    }

    @Nullable
    private static PyExpression findTopmostTarget(@NotNull PyTargetExpression target2) {
        PyElement validTargetParent;
        if (target2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(85);
        }
        if ((validTargetParent = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)target2, (Class[])new Class[]{PyForPart.class, PyWithItem.class, PyAssignmentStatement.class})) == null) {
            return null;
        }
        PyExpression topmostTarget = PyUtil.as(PsiTreeUtil.findPrevParent((PsiElement)validTargetParent, (PsiElement)target2), PyExpression.class);
        if (validTargetParent instanceof PyForPart && topmostTarget != ((PyForPart)validTargetParent).getTarget()) {
            return null;
        }
        if (validTargetParent instanceof PyWithItem && topmostTarget != ((PyWithItem)validTargetParent).getTarget()) {
            return null;
        }
        if (validTargetParent instanceof PyAssignmentStatement && ArrayUtil.indexOf((Object[])((PyAssignmentStatement)validTargetParent).getRawTargets(), (Object)topmostTarget) < 0) {
            return null;
        }
        return topmostTarget;
    }

    @NotNull
    public static Map<PyTargetExpression, PyExpression> mapTargetsToAnnotations(@NotNull PyExpression targetExpr, @NotNull PyExpression typeExpr) {
        if (targetExpr == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(86);
        }
        if (typeExpr == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(87);
        }
        PyExpression targetsNoParen = PyPsiUtils.flattenParens(targetExpr);
        PyExpression typesNoParen = PyPsiUtils.flattenParens(typeExpr);
        if (targetsNoParen == null || typesNoParen == null) {
            Map<PyTargetExpression, PyExpression> map2 = Collections.emptyMap();
            if (map2 == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(88);
            }
            return map2;
        }
        if (targetsNoParen instanceof PySequenceExpression && typesNoParen instanceof PySequenceExpression) {
            Ref result2 = new Ref(new LinkedHashMap());
            PyTypingTypeProvider.mapTargetsToExpressions((PySequenceExpression)targetsNoParen, (PySequenceExpression)typesNoParen, (Ref<Map<PyTargetExpression, PyExpression>>)result2);
            Map<PyTargetExpression, PyExpression> map3 = result2.isNull() ? Collections.emptyMap() : Collections.unmodifiableMap((Map)result2.get());
            if (map3 == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(89);
            }
            return map3;
        }
        if (targetsNoParen instanceof PyTargetExpression && !(typesNoParen instanceof PySequenceExpression)) {
            ImmutableMap immutableMap = ImmutableMap.of((Object)((PyTargetExpression)targetsNoParen), (Object)typesNoParen);
            if (immutableMap == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(90);
            }
            return immutableMap;
        }
        Map<PyTargetExpression, PyExpression> map4 = Collections.emptyMap();
        if (map4 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(91);
        }
        return map4;
    }

    private static void mapTargetsToExpressions(@NotNull PySequenceExpression targetSequence, @NotNull PySequenceExpression valueSequence, @NotNull Ref<Map<PyTargetExpression, PyExpression>> result2) {
        PyExpression[] values;
        PyExpression[] targets;
        if (targetSequence == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(92);
        }
        if (valueSequence == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(93);
        }
        if (result2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(94);
        }
        if ((targets = targetSequence.getElements()).length != (values = valueSequence.getElements()).length) {
            result2.set(null);
            return;
        }
        for (int i = 0; i < targets.length; ++i) {
            PyExpression target2 = PyPsiUtils.flattenParens(targets[i]);
            PyExpression value = PyPsiUtils.flattenParens(values[i]);
            if (target2 == null || value == null) {
                result2.set(null);
                return;
            }
            if (target2 instanceof PySequenceExpression && value instanceof PySequenceExpression) {
                PyTypingTypeProvider.mapTargetsToExpressions((PySequenceExpression)target2, (PySequenceExpression)value, result2);
                if (!result2.isNull()) continue;
                return;
            }
            if (target2 instanceof PyTargetExpression && !(value instanceof PySequenceExpression)) {
                Map map2 = (Map)result2.get();
                assert (map2 != null);
                map2.put((PyTargetExpression)target2, value);
                continue;
            }
            result2.set(null);
            return;
        }
    }

    @Nullable
    private static PyType getCallableType(@NotNull PsiElement resolved, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(95);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(96);
        }
        if (resolved instanceof PySubscriptionExpression) {
            PyTupleExpression tupleExpr;
            PyExpression[] elements;
            PyExpression indexExpr;
            PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)resolved;
            PyExpression operand = subscriptionExpr.getOperand();
            Collection<String> operandNames = PyTypingTypeProvider.resolveToQualifiedNames(operand, context.getTypeContext());
            if (operandNames.contains(CALLABLE) && (indexExpr = subscriptionExpr.getIndexExpression()) instanceof PyTupleExpression && (elements = (tupleExpr = (PyTupleExpression)indexExpr).getElements()).length == 2) {
                PyExpression parametersExpr = elements[0];
                PyExpression returnTypeExpr = elements[1];
                if (parametersExpr instanceof PyListLiteralExpression) {
                    ArrayList<PyCallableParameter> parameters2 = new ArrayList<PyCallableParameter>();
                    PyListLiteralExpression listExpr = (PyListLiteralExpression)parametersExpr;
                    for (PyExpression argExpr : listExpr.getElements()) {
                        parameters2.add(PyCallableParameterImpl.nonPsi((PyType)Ref.deref(PyTypingTypeProvider.getType(argExpr, context))));
                    }
                    PyType returnType = (PyType)Ref.deref(PyTypingTypeProvider.getType(returnTypeExpr, context));
                    return new PyCallableTypeImpl(parameters2, returnType);
                }
                if (PyTypingTypeProvider.isEllipsis(parametersExpr)) {
                    return new PyCallableTypeImpl(null, (PyType)Ref.deref(PyTypingTypeProvider.getType(returnTypeExpr, context)));
                }
            }
        } else if (resolved instanceof PyTargetExpression && PyTypingTypeProvider.resolveToQualifiedNames((PyTargetExpression)resolved, context.getTypeContext()).contains(CALLABLE)) {
            return new PyCallableTypeImpl(null, null);
        }
        return null;
    }

    private static boolean isEllipsis(@NotNull PyExpression parametersExpr) {
        if (parametersExpr == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(97);
        }
        return parametersExpr instanceof PyNoneLiteralExpression && ((PyNoneLiteralExpression)parametersExpr).isEllipsis();
    }

    @Nullable
    private static PyType getUnionType(@NotNull PsiElement element, @NotNull Context context) {
        PySubscriptionExpression subscriptionExpr;
        PyExpression operand;
        Collection<String> operandNames;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(98);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(99);
        }
        if (element instanceof PySubscriptionExpression && (operandNames = PyTypingTypeProvider.resolveToQualifiedNames(operand = (subscriptionExpr = (PySubscriptionExpression)element).getOperand(), context.getTypeContext())).contains(UNION)) {
            return PyUnionType.union(PyTypingTypeProvider.getIndexTypes(subscriptionExpr, context));
        }
        return null;
    }

    @Nullable
    private static PyGenericType getGenericTypeFromTypeVar(@NotNull PsiElement element, @NotNull Context context) {
        PyExpression firstArgument;
        PyExpression[] arguments;
        Collection<String> calleeQNames;
        PyCallExpression assignedCall;
        PyExpression callee;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(100);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(101);
        }
        if (element instanceof PyCallExpression && (callee = (assignedCall = (PyCallExpression)element).getCallee()) != null && (calleeQNames = PyTypingTypeProvider.resolveToQualifiedNames(callee, context.getTypeContext())).contains(TYPE_VAR) && (arguments = assignedCall.getArguments()).length > 0 && (firstArgument = arguments[0]) instanceof PyStringLiteralExpression) {
            String name = ((PyStringLiteralExpression)firstArgument).getStringValue();
            return new PyGenericType(name, PyTypingTypeProvider.getGenericTypeBound(arguments, context));
        }
        return null;
    }

    @Nullable
    private static PyType getGenericTypeBound(@NotNull PyExpression[] typeVarArguments, @NotNull Context context) {
        if (typeVarArguments == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(102);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(103);
        }
        ArrayList<PyType> types = new ArrayList<PyType>();
        for (int i = 1; i < typeVarArguments.length; ++i) {
            types.add((PyType)Ref.deref(PyTypingTypeProvider.getType(typeVarArguments[i], context)));
        }
        return PyUnionType.union(types);
    }

    @NotNull
    private static List<PyType> getIndexTypes(@NotNull PySubscriptionExpression expression, @NotNull Context context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(104);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(105);
        }
        ArrayList<PyType> types = new ArrayList<PyType>();
        PyExpression indexExpr = expression.getIndexExpression();
        if (indexExpr instanceof PyTupleExpression) {
            PyTupleExpression tupleExpr = (PyTupleExpression)indexExpr;
            for (PyExpression expr : tupleExpr.getElements()) {
                types.add((PyType)Ref.deref(PyTypingTypeProvider.getType(expr, context)));
            }
        } else if (indexExpr != null) {
            types.add((PyType)Ref.deref(PyTypingTypeProvider.getType(indexExpr, context)));
        }
        ArrayList<PyType> arrayList = types;
        if (arrayList == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(106);
        }
        return arrayList;
    }

    @Nullable
    private static PyType getParameterizedType(@NotNull PsiElement element, @NotNull Context context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(107);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(108);
        }
        if (element instanceof PySubscriptionExpression) {
            PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)element;
            PyExpression operand = subscriptionExpr.getOperand();
            PyExpression indexExpr = subscriptionExpr.getIndexExpression();
            PyType operandType = (PyType)Ref.deref(PyTypingTypeProvider.getType(operand, context));
            if (operandType instanceof PyClassType) {
                PyClass cls = ((PyClassType)operandType).getPyClass();
                List<PyType> indexTypes = PyTypingTypeProvider.getIndexTypes(subscriptionExpr, context);
                if ("tuple".equals(cls.getQualifiedName())) {
                    PyExpression[] elements;
                    if (indexExpr instanceof PyTupleExpression && (elements = ((PyTupleExpression)indexExpr).getElements()).length == 2 && PyTypingTypeProvider.isEllipsis(elements[1])) {
                        return PyTupleType.createHomogeneous(element, indexTypes.get(0));
                    }
                    return PyTupleType.create(element, indexTypes);
                }
                if (indexExpr != null) {
                    return new PyCollectionTypeImpl(cls, false, indexTypes);
                }
            }
        }
        return null;
    }

    @Nullable
    private static PyType getCollection(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        String typingName;
        String builtinName;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(109);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(110);
        }
        if ((builtinName = (String)BUILTIN_COLLECTION_CLASSES.get((Object)(typingName = PyTypingTypeProvider.getQualifiedName(element)))) != null) {
            return PyTypeParser.getTypeByName(element, builtinName, context);
        }
        String collectionName = (String)COLLECTIONS_CLASSES.get((Object)typingName);
        if (collectionName != null) {
            return PyTypeParser.getTypeByName(element, collectionName, context);
        }
        return null;
    }

    @NotNull
    private static List<PsiElement> tryResolving(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(111);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(112);
        }
        List list2 = ContainerUtil.map(PyTypingTypeProvider.tryResolvingWithAliases(expression, context), x -> (PsiElement)x.getSecond());
        if (list2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(113);
        }
        return list2;
    }

    @NotNull
    private static List<Pair<PyTargetExpression, PsiElement>> tryResolvingWithAliases(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(114);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(115);
        }
        ArrayList elements = Lists.newArrayList();
        if (expression instanceof PyReferenceExpression) {
            List<PsiElement> results;
            if (context.maySwitchToAST((PsiElement)expression)) {
                PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
                results = PyUtil.multiResolveTopPriority((PsiElement)expression, resolveContext);
            } else {
                results = PyTypingTypeProvider.tryResolvingOnStubs((PyReferenceExpression)expression, context);
            }
            for (PsiElement element : results) {
                QualifiedName osPathLikeQName;
                PsiElement osPathLike;
                PyTargetExpression targetExpr;
                PyExpression assignedValue;
                String name;
                PyClass cls;
                PyFunction function;
                if (element instanceof PyFunction && PyUtil.isInit(function = (PyFunction)element) && (cls = function.getContainingClass()) != null) {
                    elements.add(Pair.create(null, (Object)cls));
                    continue;
                }
                String string = name = element != null ? PyTypingTypeProvider.getQualifiedName(element) : null;
                if (name != null && OPAQUE_NAMES.contains((Object)name)) {
                    elements.add(Pair.create(null, (Object)element));
                    continue;
                }
                if (element instanceof PyTargetExpression && (assignedValue = context.maySwitchToAST(targetExpr = (PyTargetExpression)element) ? targetExpr.findAssignedValue() : PyTypingAliasStubType.getAssignedValueStubLike(targetExpr)) != null) {
                    elements.add(Pair.create((Object)targetExpr, (Object)assignedValue));
                    continue;
                }
                if (PyTypingTypeProvider.isBuiltinPathLike(element) && (osPathLike = PyResolveImportUtil.resolveTopLevelMember(osPathLikeQName = QualifiedName.fromComponents((String[])new String[]{"os", "PathLike"}), PyResolveImportUtil.fromFoothold(element))) != null) {
                    elements.add(Pair.create(null, (Object)osPathLike));
                    continue;
                }
                if (element == null) continue;
                elements.add(Pair.create(null, (Object)element));
            }
        }
        List<Object> list2 = !elements.isEmpty() ? elements : Collections.singletonList(Pair.create(null, (Object)expression));
        if (list2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(116);
        }
        return list2;
    }

    @NotNull
    private static List<PsiElement> tryResolvingOnStubs(@NotNull PyReferenceExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(117);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(118);
        }
        QualifiedName qualifiedName = expression.asQualifiedName();
        PyFile pyFile = PyUtil.as(FileContextUtil.getContextFile((PsiElement)expression), PyFile.class);
        if (pyFile != null && qualifiedName != null) {
            List<PsiElement> list2 = PyResolveUtil.resolveQualifiedNameInScope(qualifiedName, pyFile, context);
            if (list2 == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(119);
            }
            return list2;
        }
        List<PyReferenceExpression> list3 = Collections.singletonList(expression);
        if (list3 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(120);
        }
        return list3;
    }

    private static boolean isBuiltinPathLike(@Nullable PsiElement element) {
        return element instanceof PyClass && PyBuiltinCache.getInstance(element).isBuiltin(element) && "_PathLike".equals(((PyClass)element).getName());
    }

    @NotNull
    private static Collection<String> resolveToQualifiedNames(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(121);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(122);
        }
        LinkedHashSet names = Sets.newLinkedHashSet();
        for (PsiElement resolved : PyTypingTypeProvider.tryResolving(expression, context)) {
            String name = PyTypingTypeProvider.getQualifiedName(resolved);
            if (name == null) continue;
            names.add(name);
        }
        LinkedHashSet linkedHashSet = names;
        if (linkedHashSet == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(123);
        }
        return linkedHashSet;
    }

    @Nullable
    private static String getQualifiedName(@NotNull PsiElement element) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(124);
        }
        if (element instanceof PyQualifiedNameOwner) {
            PyQualifiedNameOwner qualifiedNameOwner = (PyQualifiedNameOwner)element;
            return qualifiedNameOwner.getQualifiedName();
        }
        return null;
    }

    @Nullable
    public static PyType toAsyncIfNeeded(@NotNull PyFunction function, @Nullable PyType returnType) {
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(125);
        }
        if (function.isAsync() && function.isAsyncAllowed()) {
            if (!function.isGenerator()) {
                return PyTypingTypeProvider.wrapInCoroutineType(returnType, function);
            }
            if (returnType instanceof PyCollectionType && PyTypingTypeProvider.isGenerator(returnType)) {
                return PyTypingTypeProvider.wrapInAsyncGeneratorType(((PyCollectionType)returnType).getIteratedItemType(), function);
            }
        }
        return returnType;
    }

    @Nullable
    private static PyType wrapInCoroutineType(@Nullable PyType returnType, @NotNull PsiElement resolveAnchor) {
        PyClass coroutine;
        if (resolveAnchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(126);
        }
        return (coroutine = PyUtil.as(PyResolveImportUtil.resolveTopLevelMember(QualifiedName.fromDottedString((String)COROUTINE), PyResolveImportUtil.fromFoothold(resolveAnchor)), PyClass.class)) != null ? new PyCollectionTypeImpl(coroutine, false, Arrays.asList(null, null, returnType)) : null;
    }

    @Nullable
    public static PyType wrapInGeneratorType(@Nullable PyType elementType, @Nullable PyType returnType, @NotNull PsiElement anchor2) {
        PyClass generator;
        if (anchor2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(127);
        }
        return (generator = PyUtil.as(PyResolveImportUtil.resolveTopLevelMember(QualifiedName.fromDottedString((String)GENERATOR), PyResolveImportUtil.fromFoothold(anchor2)), PyClass.class)) != null ? new PyCollectionTypeImpl(generator, false, Arrays.asList(elementType, null, returnType)) : null;
    }

    @Nullable
    private static PyType wrapInAsyncGeneratorType(@Nullable PyType elementType, @NotNull PsiElement anchor2) {
        PyClass asyncGenerator;
        if (anchor2 == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(128);
        }
        return (asyncGenerator = PyUtil.as(PyResolveImportUtil.resolveTopLevelMember(QualifiedName.fromDottedString((String)ASYNC_GENERATOR), PyResolveImportUtil.fromFoothold(anchor2)), PyClass.class)) != null ? new PyCollectionTypeImpl(asyncGenerator, false, Arrays.asList(elementType, null)) : null;
    }

    @Nullable
    public static Ref<PyType> coroutineOrGeneratorElementType(@Nullable PyType coroutineOrGeneratorType) {
        PyCollectionType genericType = PyUtil.as(coroutineOrGeneratorType, PyCollectionType.class);
        PyClassType classType = PyUtil.as(coroutineOrGeneratorType, PyClassType.class);
        if (genericType != null && classType != null && ArrayUtil.contains((String)classType.getClassQName(), (String[])new String[]{COROUTINE, GENERATOR})) {
            return Ref.create((Object)ContainerUtil.getOrElse(genericType.getElementTypes(), (int)2, null));
        }
        return null;
    }

    @NotNull
    public static Ref<PyType> getOpenFunctionCallType(@NotNull PyFunction function, @NotNull PyCallExpression call, @NotNull LanguageLevel typeLevel, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(129);
        }
        if (call == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(130);
        }
        if (typeLevel == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(131);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(132);
        }
        String type = typeLevel.isPython2() ? "typing.BinaryIO" : (PyTypingTypeProvider.getOpenMode(function, call, context).contains("b") ? "typing.BinaryIO" : PY3_TEXT_FILE_TYPE);
        Ref ref = Ref.create((Object)PyTypeParser.getTypeByName((PsiElement)call, type, context));
        if (ref == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(133);
        }
        return ref;
    }

    public static boolean isClassVar(@NotNull PyAnnotationOwner annotationOwner, @NotNull TypeEvalContext context) {
        PyExpression annotationValue;
        if (annotationOwner == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(134);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(135);
        }
        if ((annotationValue = PyTypingTypeProvider.getAnnotationValue(annotationOwner, context)) instanceof PySubscriptionExpression) {
            PyExpression operand = ((PySubscriptionExpression)annotationValue).getOperand();
            return operand instanceof PyReferenceExpression && PyTypingTypeProvider.resolveToQualifiedNames(operand, context).contains(CLASS_VAR);
        }
        if (annotationValue instanceof PyReferenceExpression) {
            return PyTypingTypeProvider.resolveToQualifiedNames(annotationValue, context).contains(CLASS_VAR);
        }
        return false;
    }

    @NotNull
    private static String getOpenMode(@NotNull PyFunction function, @NotNull PyCallExpression call, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(136);
        }
        if (call == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(137);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(138);
        }
        Map<PyExpression, PyCallableParameter> arguments = PyCallExpressionHelper.mapArguments((PyCallSiteExpression)call, function, context).getMappedParameters();
        for (Map.Entry<PyExpression, PyCallableParameter> entry : arguments.entrySet()) {
            if (!"mode".equals(entry.getValue().getName())) continue;
            PyExpression argument = entry.getKey();
            if (argument instanceof PyKeywordArgument) {
                argument = ((PyKeywordArgument)argument).getValueExpression();
            }
            if (!(argument instanceof PyStringLiteralExpression)) break;
            String string = ((PyStringLiteralExpression)argument).getStringValue();
            if (string == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(139);
            }
            return string;
        }
        if ("r" == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(140);
        }
        return "r";
    }

    public static boolean isInAnnotationOrTypeComment(@NotNull PsiElement element) {
        PsiElement realContext;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(141);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)(realContext = PyPsiUtils.getRealContext(element)), PyAnnotation.class, (boolean)false, (Class[])new Class[]{ScopeOwner.class}) != null) {
            return true;
        }
        PsiComment comment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)realContext, PsiComment.class, (boolean)false, (Class[])new Class[]{ScopeOwner.class});
        return comment != null && PyTypingTypeProvider.getTypeCommentValue(comment.getText()) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 52: 
            case 55: 
            case 56: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 106: 
            case 113: 
            case 116: 
            case 119: 
            case 120: 
            case 123: 
            case 133: 
            case 139: 
            case 140: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 52: 
            case 55: 
            case 56: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 106: 
            case 113: 
            case 116: 
            case 119: 
            case 120: 
            case 123: 
            case 133: 
            case 139: 
            case 140: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 19: 
            case 23: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 42: 
            case 44: 
            case 48: 
            case 54: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 69: 
            case 71: 
            case 73: 
            case 76: 
            case 79: 
            case 81: 
            case 84: 
            case 96: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 108: 
            case 110: 
            case 112: 
            case 115: 
            case 118: 
            case 122: 
            case 132: 
            case 135: 
            case 138: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 3: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 59: 
            case 61: 
            case 104: 
            case 111: 
            case 114: 
            case 117: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 75: 
            case 78: 
            case 127: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 52: 
            case 55: 
            case 56: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 106: 
            case 113: 
            case 116: 
            case 119: 
            case 120: 
            case 123: 
            case 133: 
            case 139: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/typing/PyTypingTypeProvider";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 125: 
            case 129: 
            case 136: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceTarget";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 37: 
            case 83: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 41: 
            case 43: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendant";
                break;
            }
            case 63: 
            case 65: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 67: 
            case 68: 
            case 70: 
            case 80: 
            case 98: 
            case 100: 
            case 107: 
            case 109: 
            case 124: 
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 74: 
            case 77: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetExpr";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeExpr";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetSequence";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueSequence";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersExpr";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeVarArguments";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveAnchor";
                break;
            }
            case 130: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeLevel";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/typing/PyTypingTypeProvider";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypingGenericType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypingProtocolType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypingCallableType";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericSubstitutions";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedSuperClassesAndTypeParameters";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubscriptionIndices";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "collectGenericTypes";
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "mapTargetsToAnnotations";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexTypes";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "tryResolving";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "tryResolvingWithAliases";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "tryResolvingOnStubs";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToQualifiedNames";
                break;
            }
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenFunctionCallType";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceExpressionType";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isGenerator";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypeFromFunctionComment";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypeFromTypeComment";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypeFromAnnotation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createTypingGenericType";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 52: 
            case 55: 
            case 56: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 106: 
            case 113: 
            case 116: 
            case 119: 
            case 120: 
            case 123: 
            case 133: 
            case 139: 
            case 140: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createTypingProtocolType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createTypingCallableType";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTypeVarTypeForCallee";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "omitFirstParamInTypeComment";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeAnnotation";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypeAnnotation";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getNewTypeForReference";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getNewTypeCreationForTarget";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getNewTypeForCallExpression";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceType";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromTargetExpressionAnnotation";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCommentValue";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCommentValueRange";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getGenericType";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getGenericSubstitutions";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedSuperClassesAndTypeParameters";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getSubscriptionIndices";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "collectGenericTypes";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isGeneric";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForResolvedElement";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getClassObjectType";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getAnyType";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getClassType";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getOptionalType";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationValue";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getStringBasedType";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getStringLiteralType";
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getVariableTypeCommentType";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "findTopmostTarget";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "mapTargetsToAnnotations";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "mapTargetsToExpressions";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "getCallableType";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "isEllipsis";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "getUnionType";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getGenericTypeFromTypeVar";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "getGenericTypeBound";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getIndexTypes";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getParameterizedType";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "getCollection";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "tryResolving";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "tryResolvingWithAliases";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "tryResolvingOnStubs";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "resolveToQualifiedNames";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "toAsyncIfNeeded";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "wrapInCoroutineType";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "wrapInGeneratorType";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "wrapInAsyncGeneratorType";
                break;
            }
            case 129: 
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "getOpenFunctionCallType";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "isClassVar";
                break;
            }
            case 136: 
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "getOpenMode";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "isInAnnotationOrTypeComment";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectGenericTypes$14";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getGenericSubstitutions$11";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getReferenceType$10";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getReferenceType$7";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCallType$4";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFunctionTypeAnnotation$2";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getParameterTypeFromAnnotation$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 52: 
            case 55: 
            case 56: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 106: 
            case 113: 
            case 116: 
            case 119: 
            case 120: 
            case 123: 
            case 133: 
            case 139: 
            case 140: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Context {
        @NotNull
        private final TypeEvalContext myContext;
        @NotNull
        private final Set<PsiElement> myCache;

        Context(@NotNull TypeEvalContext context) {
            if (context == null) {
                Context.$$$reportNull$$$0(0);
            }
            this.myCache = new HashSet<PsiElement>();
            this.myContext = context;
        }

        @NotNull
        public TypeEvalContext getTypeContext() {
            TypeEvalContext typeEvalContext = this.myContext;
            if (typeEvalContext == null) {
                Context.$$$reportNull$$$0(1);
            }
            return typeEvalContext;
        }

        @NotNull
        public Set<PsiElement> getExpressionCache() {
            Set<PsiElement> set2 = this.myCache;
            if (set2 == null) {
                Context.$$$reportNull$$$0(2);
            }
            return set2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/typing/PyTypingTypeProvider$Context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/typing/PyTypingTypeProvider$Context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpressionCache";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

