/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.documentation.doctest.PyDocstringFile;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeIntention
extends PyBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            TypeIntention.$$$reportNull$$$0(0);
        }
        if (!(file2 instanceof PyFile) || file2 instanceof PyDocstringFile) {
            return false;
        }
        this.updateText(false);
        PsiElement elementAt = PyUtil.findNonWhitespaceAtOffset(file2, editor.getCaretModel().getOffset());
        if (elementAt == null) {
            return false;
        }
        if (this.isAvailableForParameter(project, elementAt)) {
            return true;
        }
        if (this.isAvailableForReturn(elementAt)) {
            this.updateText(true);
            return true;
        }
        return false;
    }

    private boolean isAvailableForParameter(Project project, PsiElement elementAt) {
        ResolveResult[] results;
        PyExpression problemElement = TypeIntention.getProblemElement(elementAt);
        if (problemElement == null) {
            return false;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)problemElement, PyLambdaExpression.class) != null) {
            return false;
        }
        PsiReference reference = problemElement.getReference();
        if (reference instanceof PsiPolyVariantReference && (results = ((PsiPolyVariantReference)reference).multiResolve(false)).length != 1) {
            return false;
        }
        VirtualFile virtualFile = problemElement.getContainingFile().getVirtualFile();
        if (virtualFile != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInLibraryClasses(virtualFile)) {
            return false;
        }
        PsiElement resolved = reference != null ? reference.resolve() : null;
        PyNamedParameter parameter = TypeIntention.getParameter(problemElement, resolved);
        return parameter != null && !this.isParamTypeDefined(parameter);
    }

    @Nullable
    public static PyExpression getProblemElement(@Nullable PsiElement elementAt) {
        PyExpression qualifier;
        PyExpression problemElement = (PyExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, (Class[])new Class[]{PyNamedParameter.class, PyReferenceExpression.class});
        if (problemElement == null) {
            return null;
        }
        if (problemElement instanceof PyQualifiedExpression && (qualifier = ((PyQualifiedExpression)problemElement).getQualifier()) != null && !qualifier.getText().equals("self")) {
            problemElement = qualifier;
        }
        return problemElement;
    }

    protected abstract void updateText(boolean var1);

    protected boolean isParamTypeDefined(PyParameter parameter) {
        return false;
    }

    @Nullable
    protected static PyNamedParameter getParameter(PyExpression problemElement, PsiElement resolved) {
        PyNamedParameter parameter = PyUtil.as(problemElement, PyNamedParameter.class);
        if (resolved instanceof PyNamedParameter) {
            parameter = (PyNamedParameter)resolved;
        }
        return parameter == null || parameter.isSelf() ? null : parameter;
    }

    private boolean isAvailableForReturn(@NotNull PsiElement elementAt) {
        if (elementAt == null) {
            TypeIntention.$$$reportNull$$$0(1);
        }
        return this.findSuitableFunction(elementAt) != null;
    }

    @Nullable
    protected PyFunction findSuitableFunction(@NotNull PsiElement elementAt) {
        if (elementAt == null) {
            TypeIntention.$$$reportNull$$$0(2);
        }
        return TypeIntention.findSuitableFunction(elementAt, input -> !this.isReturnTypeDefined((PyFunction)input));
    }

    @Nullable
    public static PyFunction findSuitableFunction(@NotNull PsiElement elementAt, @NotNull Predicate<PyFunction> extraCondition) {
        if (elementAt == null) {
            TypeIntention.$$$reportNull$$$0(3);
        }
        if (extraCondition == null) {
            TypeIntention.$$$reportNull$$$0(4);
        }
        return (PyFunction)ContainerUtil.getOnlyItem(TypeIntention.findSuitableFunctions(elementAt, extraCondition));
    }

    @NotNull
    private static List<PyFunction> findSuitableFunctions(@NotNull PsiElement elementAt, @NotNull Predicate<PyFunction> extraCondition) {
        PyCallExpression callExpression;
        PyFunction underCaret;
        if (elementAt == null) {
            TypeIntention.$$$reportNull$$$0(5);
        }
        if (extraCondition == null) {
            TypeIntention.$$$reportNull$$$0(6);
        }
        StreamEx definitions = (underCaret = TypeIntention.findFunctionDefinitionUnderCaret(elementAt)) != null ? StreamEx.of((Object)underCaret) : ((callExpression = TypeIntention.getCallExpression(elementAt)) == null ? StreamEx.empty() : StreamEx.of(callExpression.multiResolveCallee(TypeIntention.getResolveContext(elementAt))).map(result2 -> result2.getElement()).select(PyFunction.class));
        ProjectFileIndex index = ProjectFileIndex.getInstance((Project)elementAt.getProject());
        List list2 = ((StreamEx)((StreamEx)definitions.filter(elem -> !index.isInLibraryClasses(elem.getContainingFile().getVirtualFile()))).filter(extraCondition)).toList();
        if (list2 == null) {
            TypeIntention.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Nullable
    private static PyFunction findFunctionDefinitionUnderCaret(@NotNull PsiElement elementAt) {
        ASTNode nameNode;
        PyFunction parentFunction;
        if (elementAt == null) {
            TypeIntention.$$$reportNull$$$0(8);
        }
        if ((parentFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyFunction.class)) != null && (nameNode = parentFunction.getNameNode()) != null) {
            PsiElement prev2 = elementAt.getContainingFile().findElementAt(elementAt.getTextOffset() - 1);
            if (nameNode.getPsi() == elementAt || nameNode.getPsi() == prev2) {
                return parentFunction;
            }
        }
        return null;
    }

    protected boolean isReturnTypeDefined(@NotNull PyFunction function) {
        if (function == null) {
            TypeIntention.$$$reportNull$$$0(9);
        }
        return false;
    }

    @Nullable
    static PyCallExpression getCallExpression(PsiElement elementAt) {
        PyExpression assignedValue;
        PyAssignmentStatement assignmentStatement;
        PyExpression problemElement = TypeIntention.getProblemElement(elementAt);
        if (problemElement != null) {
            PyExpression assignedValue2;
            PyResolveContext context;
            PsiElement resolved;
            PsiReference reference = problemElement.getReference();
            PsiElement psiElement = resolved = reference != null ? reference.resolve() : null;
            if (resolved instanceof PyTargetExpression && (context = TypeIntention.getResolveContext(elementAt)).getTypeEvalContext().maySwitchToAST(resolved) && (assignedValue2 = ((PyTargetExpression)resolved).findAssignedValue()) instanceof PyCallExpression) {
                return (PyCallExpression)assignedValue2;
            }
        }
        if ((assignmentStatement = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyAssignmentStatement.class)) != null && (assignedValue = assignmentStatement.getAssignedValue()) instanceof PyCallExpression) {
            return (PyCallExpression)assignedValue;
        }
        return (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyCallExpression.class, (boolean)false);
    }

    protected static PyResolveContext getResolveContext(@NotNull PsiElement origin) {
        if (origin == null) {
            TypeIntention.$$$reportNull$$$0(10);
        }
        return PyResolveContext.noImplicits().withTypeEvalContext(TypeEvalContext.codeAnalysis(origin.getProject(), origin.getContainingFile()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAt";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraCondition";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/TypeIntention";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/TypeIntention";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuitableFunctions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForReturn";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findSuitableFunction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findSuitableFunctions";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findFunctionDefinitionUnderCaret";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isReturnTypeDefined";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getResolveContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

