/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.fstrings;

import com.intellij.codeInsight.generation.CommentByLineCommentHandler;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.jetbrains.python.codeInsight.PyInjectorBase;
import com.jetbrains.python.codeInsight.fstrings.FStringParser;
import com.jetbrains.python.documentation.doctest.PyDocstringLanguageDialect;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyFStringsInjector
extends PyInjectorBase {
    @Override
    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        PyStringLiteralExpression pyString;
        if (registrar == null) {
            PyFStringsInjector.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyFStringsInjector.$$$reportNull$$$0(1);
        }
        if ((pyString = PyUtil.as(context, PyStringLiteralExpression.class)) == null) {
            return;
        }
        PyFStringsInjector.injectFStringFragments(registrar, pyString);
    }

    public static void injectFStringFragments(@NotNull MultiHostRegistrar registrar, @NotNull PyStringLiteralExpression pyString) {
        if (registrar == null) {
            PyFStringsInjector.$$$reportNull$$$0(2);
        }
        if (pyString == null) {
            PyFStringsInjector.$$$reportNull$$$0(3);
        }
        PyDocstringLanguageDialect docstringLanguage = PyDocstringLanguageDialect.getInstance();
        for (ASTNode node : pyString.getStringNodes()) {
            int relNodeOffset = node.getTextRange().getStartOffset() - pyString.getTextRange().getStartOffset();
            for (FStringParser.Fragment offsets : PyFStringsInjector.getInjectionRanges(node)) {
                if (offsets.containsNamedUnicodeEscape()) continue;
                registrar.startInjecting((Language)docstringLanguage);
                registrar.addPlace(null, null, (PsiLanguageInjectionHost)pyString, offsets.getContentRange().shiftRight(relNodeOffset));
                registrar.doneInjecting();
            }
        }
        PyFStringsInjector.disableCommentingInFragments(pyString);
    }

    private static void disableCommentingInFragments(@NotNull PyStringLiteralExpression pyString) {
        if (pyString == null) {
            PyFStringsInjector.$$$reportNull$$$0(4);
        }
        Project project = pyString.getProject();
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        PyDocstringLanguageDialect docstringLanguage = PyDocstringLanguageDialect.getInstance();
        ((StreamEx)StreamEx.of((Collection)injectedLanguageManager.getCachedInjectedDocumentsInRange(pyString.getContainingFile(), pyString.getTextRange())).map(window -> documentManager.getPsiFile((Document)window)).nonNull().filter(file2 -> file2.getLanguage().isKindOf((Language)docstringLanguage))).forEach(CommentByLineCommentHandler::markInjectedFileUnsuitableForLineComment);
    }

    @NotNull
    private static List<FStringParser.Fragment> getInjectionRanges(@NotNull ASTNode node) {
        PyUtil.StringNodeInfo nodeInfo;
        if (node == null) {
            PyFStringsInjector.$$$reportNull$$$0(5);
        }
        if ((nodeInfo = new PyUtil.StringNodeInfo(node)).isFormatted()) {
            List<FStringParser.Fragment> list2 = FStringParser.parse(node.getText()).getFragments();
            if (list2 == null) {
                PyFStringsInjector.$$$reportNull$$$0(6);
            }
            return list2;
        }
        List<FStringParser.Fragment> list3 = Collections.emptyList();
        if (list3 == null) {
            PyFStringsInjector.$$$reportNull$$$0(7);
        }
        return list3;
    }

    @Override
    @Nullable
    public Language getInjectedLanguage(@NotNull PsiElement context) {
        if (context == null) {
            PyFStringsInjector.$$$reportNull$$$0(8);
        }
        return context instanceof PyStringLiteralExpression ? PyDocstringLanguageDialect.getInstance() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyString";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/fstrings/PyFStringsInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/fstrings/PyFStringsInjector";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectionRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "injectFStringFragments";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "disableCommentingInFragments";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInjectionRanges";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

