/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.actions;

import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class PyQualifiedNameProvider
implements QualifiedNameProvider {
    @Override
    public PsiElement adjustElementToCopy(PsiElement element) {
        return element instanceof PyClass || element instanceof PyFunction ? element : null;
    }

    @Override
    @Nullable
    public String getQualifiedName(PsiElement element) {
        if (element instanceof PyClass) {
            return ((PyClass)element).getQualifiedName();
        }
        if (element instanceof PyFunction) {
            PyClass containingClass = ((PyFunction)element).getContainingClass();
            if (containingClass != null) {
                return containingClass.getQualifiedName() + "#" + ((PyFunction)element).getName();
            }
            return ((PyFunction)element).getQualifiedName();
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement qualifiedNameToElement(String fqn, Project project) {
        String className;
        PyClass aClass = PyClassNameIndex.findClass(fqn, project);
        if (aClass != null) {
            return aClass;
        }
        Collection<PyFunction> functions = PyFunctionNameIndex.find(fqn, project);
        if (!functions.isEmpty()) {
            return (PsiElement)ContainerUtil.getFirstItem(functions);
        }
        int sharpIdx = fqn.indexOf("#");
        if (sharpIdx > -1 && (aClass = PyClassNameIndex.findClass(className = StringUtil.getPackageName((String)fqn, (char)'#'), project)) != null) {
            String memberName = StringUtil.getShortName((String)fqn, (char)'#');
            PyClass nestedClass = aClass.findNestedClass(memberName, false);
            if (nestedClass != null) {
                return nestedClass;
            }
            PyFunction methodByName = aClass.findMethodByName(memberName, false, null);
            if (methodByName != null) {
                return methodByName;
            }
        }
        return null;
    }
}

