/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonSchemaVfsListener;
import com.jetbrains.jsonSchema.extension.JsonSchemaEnabler;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonCachedValues;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import com.jetbrains.jsonSchema.remote.JsonSchemaCatalogManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaServiceImpl
implements JsonSchemaService {
    @NotNull
    private final Project myProject;
    @NotNull
    private final MyState myState;
    private final AtomicLong myAnyChangeCount;
    private final ModificationTracker myAnySchemaChangeTracker;
    @NotNull
    private final JsonSchemaCatalogManager myCatalogManager;
    private final ConcurrentList<Runnable> myResetActions;

    public JsonSchemaServiceImpl(@NotNull Project project) {
        if (project == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(0);
        }
        this.myAnyChangeCount = new AtomicLong(0L);
        this.myResetActions = ContainerUtil.createConcurrentList();
        this.myProject = project;
        this.myState = new MyState(() -> this.getProvidersFromFactories());
        this.myAnySchemaChangeTracker = () -> this.myAnyChangeCount.get();
        this.myCatalogManager = new JsonSchemaCatalogManager(this.myProject);
        project.getMessageBus().connect().subscribe(JsonSchemaVfsListener.JSON_SCHEMA_CHANGED, this.myAnyChangeCount::incrementAndGet);
        JsonSchemaVfsListener.startListening(project, this);
        this.myCatalogManager.startUpdates();
    }

    @Override
    public ModificationTracker getAnySchemaChangeTracker() {
        return this.myAnySchemaChangeTracker;
    }

    private List<JsonSchemaFileProvider> getProvidersFromFactories() {
        ArrayList<JsonSchemaFileProvider> providers = new ArrayList<JsonSchemaFileProvider>();
        for (JsonSchemaProviderFactory factory : this.getProviderFactories()) {
            try {
                providers.addAll(factory.getProviders(this.myProject));
            }
            catch (Exception e) {
                Logger.getInstance(JsonSchemaService.class).error((Throwable)e);
            }
        }
        return providers;
    }

    @NotNull
    protected JsonSchemaProviderFactory[] getProviderFactories() {
        JsonSchemaProviderFactory[] jsonSchemaProviderFactoryArray = (JsonSchemaProviderFactory[])JsonSchemaProviderFactory.EP_NAME.getExtensions();
        if (jsonSchemaProviderFactoryArray == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(1);
        }
        return jsonSchemaProviderFactoryArray;
    }

    @Override
    @Nullable
    public JsonSchemaFileProvider getSchemaProvider(@NotNull VirtualFile schemaFile) {
        if (schemaFile == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(2);
        }
        return this.myState.getProvider(schemaFile);
    }

    @Override
    public void reset() {
        this.myState.reset();
        this.myAnyChangeCount.incrementAndGet();
        for (Runnable action : this.myResetActions) {
            action.run();
        }
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    @Override
    @Nullable
    public VirtualFile findSchemaFileByReference(@NotNull String reference, @Nullable VirtualFile referent) {
        if (reference == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(3);
        }
        Optional<VirtualFile> optional = this.findBuiltInSchemaByReference(reference);
        return optional.orElseGet(() -> {
            if (reference == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(30);
            }
            return JsonFileResolver.resolveSchemaByReference(referent, JsonSchemaService.normalizeId(reference));
        });
    }

    private Optional<VirtualFile> findBuiltInSchemaByReference(@NotNull String reference) {
        if (reference == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(4);
        }
        return this.myState.getFiles().stream().filter(file2 -> {
            if (reference == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(29);
            }
            return JsonSchemaService.normalizeId(reference).equals(JsonCachedValues.getSchemaId(file2, this.myProject));
        }).findFirst();
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getSchemaFilesForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(5);
        }
        Collection<VirtualFile> collection = this.getSchemasForFile(file2, false);
        if (collection == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    private Collection<VirtualFile> getSchemasForFile(@NotNull VirtualFile file2, boolean single) {
        VirtualFile virtualFile;
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(7);
        }
        List<JsonSchemaFileProvider> providers = this.getProvidersForFile(file2);
        boolean checkSchemaProperty = true;
        if (providers.stream().noneMatch(p -> p.getSchemaType() == SchemaType.userSchema)) {
            virtualFile = this.resolveFromSchemaProperty(file2);
            if (virtualFile != null) {
                List list2 = ContainerUtil.createMaybeSingletonList((Object)virtualFile);
                if (list2 == null) {
                    JsonSchemaServiceImpl.$$$reportNull$$$0(8);
                }
                return list2;
            }
            checkSchemaProperty = false;
        }
        if (!single) {
            ArrayList files2 = ContainerUtil.newArrayList();
            for (JsonSchemaFileProvider provider2 : providers) {
                VirtualFile schemaFile = provider2.getSchemaFile();
                if (schemaFile == null) continue;
                files2.add(schemaFile);
            }
            if (!files2.isEmpty()) {
                ArrayList arrayList = files2;
                if (arrayList == null) {
                    JsonSchemaServiceImpl.$$$reportNull$$$0(9);
                }
                return arrayList;
            }
        } else if (!providers.isEmpty()) {
            JsonSchemaFileProvider selected;
            if (providers.size() > 2) {
                List list3 = ContainerUtil.emptyList();
                if (list3 == null) {
                    JsonSchemaServiceImpl.$$$reportNull$$$0(10);
                }
                return list3;
            }
            if (providers.size() > 1) {
                Optional<JsonSchemaFileProvider> userSchema = providers.stream().filter(provider -> SchemaType.userSchema.equals((Object)provider.getSchemaType())).findFirst();
                if (!userSchema.isPresent()) {
                    List list4 = ContainerUtil.emptyList();
                    if (list4 == null) {
                        JsonSchemaServiceImpl.$$$reportNull$$$0(11);
                    }
                    return list4;
                }
                selected = userSchema.get();
            } else {
                selected = providers.get(0);
            }
            VirtualFile schemaFile = selected.getSchemaFile();
            List list5 = ContainerUtil.createMaybeSingletonList((Object)schemaFile);
            if (list5 == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(12);
            }
            return list5;
        }
        if (checkSchemaProperty && (virtualFile = this.resolveFromSchemaProperty(file2)) != null) {
            List list6 = ContainerUtil.createMaybeSingletonList((Object)virtualFile);
            if (list6 == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(13);
            }
            return list6;
        }
        List list7 = ContainerUtil.createMaybeSingletonList((Object)this.resolveSchemaFromOtherSources(file2));
        if (list7 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(14);
        }
        return list7;
    }

    @NotNull
    public List<JsonSchemaFileProvider> getProvidersForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(15);
        }
        List<JsonSchemaFileProvider> list2 = this.myState.getProviders().stream().filter(provider -> {
            if (file2 == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(28);
            }
            return JsonSchemaServiceImpl.isProviderAvailable(file2, provider);
        }).collect(Collectors.toList());
        if (list2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(16);
        }
        return list2;
    }

    @Nullable
    private VirtualFile resolveFromSchemaProperty(@NotNull VirtualFile file2) {
        VirtualFile virtualFile;
        String schemaUrl;
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(17);
        }
        if ((schemaUrl = JsonCachedValues.getSchemaUrlFromSchemaProperty(file2, this.myProject)) != null && (virtualFile = this.findSchemaFileByReference(schemaUrl, file2)) != null) {
            return virtualFile;
        }
        return null;
    }

    @Override
    public List<JsonSchemaInfo> getAllUserVisibleSchemas() {
        List<String> schemas = this.myCatalogManager.getAllCatalogSchemas();
        Collection<JsonSchemaFileProvider> providers = this.myState.getProviders();
        ArrayList results = ContainerUtil.newArrayListWithCapacity((int)(schemas.size() + providers.size()));
        HashSet processedRemotes = ContainerUtil.newHashSet();
        for (JsonSchemaFileProvider provider : providers) {
            if (!provider.isUserVisible()) continue;
            if (provider.getRemoteSource() != null) {
                if (!processedRemotes.add(provider.getRemoteSource())) continue;
                results.add(new JsonSchemaInfo(provider));
                continue;
            }
            results.add(new JsonSchemaInfo(provider));
        }
        for (String schema : schemas) {
            if (!processedRemotes.add(schema)) continue;
            results.add(new JsonSchemaInfo(schema));
        }
        return results;
    }

    @Override
    @Nullable
    public JsonSchemaObject getSchemaObject(@NotNull VirtualFile file2) {
        Collection<VirtualFile> schemas;
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(18);
        }
        if ((schemas = this.getSchemasForFile(file2, true)).size() == 0) {
            return null;
        }
        assert (schemas.size() == 1);
        VirtualFile schemaFile = schemas.iterator().next();
        return JsonCachedValues.getSchemaObject(this.replaceHttpFileWithBuiltinIfNeeded(schemaFile), this.myProject);
    }

    public VirtualFile replaceHttpFileWithBuiltinIfNeeded(VirtualFile schemaFile) {
        if (schemaFile instanceof HttpVirtualFile) {
            String url = schemaFile.getUrl();
            VirtualFile first1 = this.getLocalSchemaByUrl(url);
            return first1 != null ? first1 : schemaFile;
        }
        return schemaFile;
    }

    @Nullable
    public VirtualFile getLocalSchemaByUrl(String url) {
        return this.myState.getFiles().stream().filter(f -> {
            JsonSchemaFileProvider prov = this.getSchemaProvider((VirtualFile)f);
            return prov != null && !(prov.getSchemaFile() instanceof HttpVirtualFile) && (url.equals(prov.getRemoteSource()) || JsonFileResolver.replaceUnsafeSchemaStoreUrls(url).equals(prov.getRemoteSource()) || url.equals(JsonFileResolver.replaceUnsafeSchemaStoreUrls(prov.getRemoteSource())));
        }).findFirst().orElse(null);
    }

    @Override
    @Nullable
    public JsonSchemaObject getSchemaObjectForSchemaFile(@NotNull VirtualFile schemaFile) {
        if (schemaFile == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(19);
        }
        return JsonCachedValues.getSchemaObject(schemaFile, this.myProject);
    }

    @Override
    public boolean isSchemaFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(20);
        }
        return this.myState.getFiles().contains(file2) || this.isSchemaByProvider(file2) || this.hasSchemaSchema(file2);
    }

    private boolean isSchemaByProvider(@NotNull VirtualFile file2) {
        JsonSchemaFileProvider provider;
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(21);
        }
        if ((provider = this.myState.getProvider(file2)) == null) {
            for (JsonSchemaFileProvider stateProvider : this.myState.getProviders()) {
                if (!JsonSchemaServiceImpl.isSchemaProvider(stateProvider) || !stateProvider.isAvailable(file2)) continue;
                return true;
            }
            return false;
        }
        return JsonSchemaServiceImpl.isSchemaProvider(provider);
    }

    private static boolean isSchemaProvider(JsonSchemaFileProvider provider) {
        VirtualFile schemaFile = provider.getSchemaFile();
        if (schemaFile == null) {
            return false;
        }
        String url = schemaFile.getUrl();
        return url.startsWith("http://json-schema.org/") && url.endsWith("/schema");
    }

    @Override
    public JsonSchemaVersion getSchemaVersion(@NotNull VirtualFile file2) {
        JsonSchemaFileProvider provider;
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(22);
        }
        if (this.myState.getFiles().contains(file2) && (provider = this.myState.getProvider(file2)) != null) {
            return provider.getSchemaVersion();
        }
        return this.getSchemaVersionFromSchemaUrl(file2);
    }

    @Nullable
    private JsonSchemaVersion getSchemaVersionFromSchemaUrl(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(23);
        }
        Ref res = Ref.create(null);
        ApplicationManager.getApplication().runReadAction(() -> {
            if (file2 == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(27);
            }
            res.set((Object)JsonCachedValues.getSchemaUrlFromSchemaProperty(file2, this.myProject));
        });
        if (res.isNull()) {
            return null;
        }
        return JsonSchemaVersion.byId((String)res.get());
    }

    private boolean hasSchemaSchema(VirtualFile file2) {
        return this.getSchemaVersionFromSchemaUrl(file2) != null;
    }

    private static boolean isProviderAvailable(@NotNull VirtualFile file2, @NotNull JsonSchemaFileProvider provider) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(24);
        }
        if (provider == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(25);
        }
        return provider.isAvailable(file2);
    }

    @Nullable
    private VirtualFile resolveSchemaFromOtherSources(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(26);
        }
        return this.myCatalogManager.getSchemaFileForFile(file2);
    }

    @Override
    public void registerRemoteUpdateCallback(Runnable callback2) {
        this.myCatalogManager.registerCatalogUpdateCallback(callback2);
    }

    @Override
    public void unregisterRemoteUpdateCallback(Runnable callback2) {
        this.myCatalogManager.unregisterCatalogUpdateCallback(callback2);
    }

    @Override
    public void registerResetAction(Runnable action) {
        this.myResetActions.add((Object)action);
    }

    @Override
    public void unregisterResetAction(Runnable action) {
        this.myResetActions.remove((Object)action);
    }

    @Override
    public void triggerUpdateRemote() {
        this.myCatalogManager.triggerUpdateCatalog(this.myProject);
    }

    @Override
    public boolean isApplicableToFile(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return false;
        }
        return Arrays.stream(JsonSchemaEnabler.EXTENSION_POINT_NAME.getExtensions()).anyMatch(e -> e.isEnabledForFile(file2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl";
                break;
            }
            case 2: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFile";
                break;
            }
            case 3: 
            case 4: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: 
            case 7: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderFactories";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaFilesForFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemasForFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvidersForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaProvider";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findSchemaFileByReference";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findBuiltInSchemaByReference";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaFilesForFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSchemasForFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getProvidersForFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveFromSchemaProperty";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaObject";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaObjectForSchemaFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isSchemaFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isSchemaByProvider";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaVersion";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaVersionFromSchemaUrl";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isProviderAvailable";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resolveSchemaFromOtherSources";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSchemaVersionFromSchemaUrl$8";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getProvidersForFile$6";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findBuiltInSchemaByReference$3";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findSchemaFileByReference$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyState {
        @NotNull
        private final Factory<List<JsonSchemaFileProvider>> myFactory;
        @NotNull
        private final AtomicClearableLazyValue<Map<VirtualFile, JsonSchemaFileProvider>> myData;

        private MyState(@NotNull Factory<List<JsonSchemaFileProvider>> factory) {
            if (factory == null) {
                MyState.$$$reportNull$$$0(0);
            }
            this.myFactory = factory;
            this.myData = new AtomicClearableLazyValue<Map<VirtualFile, JsonSchemaFileProvider>>(){

                @NotNull
                public Map<VirtualFile, JsonSchemaFileProvider> compute() {
                    Map<VirtualFile, JsonSchemaFileProvider> map2 = Collections.unmodifiableMap(MyState.createFileProviderMap((List)myFactory.create()));
                    if (map2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return map2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$MyState$1", "compute"));
                }
            };
        }

        public void reset() {
            this.myData.drop();
        }

        @NotNull
        public Collection<JsonSchemaFileProvider> getProviders() {
            Collection<JsonSchemaFileProvider> collection = ((Map)this.myData.getValue()).values();
            if (collection == null) {
                MyState.$$$reportNull$$$0(1);
            }
            return collection;
        }

        @NotNull
        public Set<VirtualFile> getFiles() {
            Set<VirtualFile> set2 = ((Map)this.myData.getValue()).keySet();
            if (set2 == null) {
                MyState.$$$reportNull$$$0(2);
            }
            return set2;
        }

        @Nullable
        public JsonSchemaFileProvider getProvider(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyState.$$$reportNull$$$0(3);
            }
            return (JsonSchemaFileProvider)((Map)this.myData.getValue()).get(file2);
        }

        private static Map<VirtualFile, JsonSchemaFileProvider> createFileProviderMap(@NotNull List<JsonSchemaFileProvider> list2) {
            if (list2 == null) {
                MyState.$$$reportNull$$$0(4);
            }
            HashMap<VirtualFile, JsonSchemaFileProvider> map2 = new HashMap<VirtualFile, JsonSchemaFileProvider>();
            list2.stream().filter(provider -> provider.getSchemaFile() != null).forEach(provider -> map2.put(provider.getSchemaFile(), (JsonSchemaFileProvider)provider));
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$MyState";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$MyState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProviders";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getProvider";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createFileProviderMap";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

