/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.impl.SingletonRefGroup;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BranchPopupBuilder {
    @NotNull
    protected final VcsLogDataPack myDataPack;
    @Nullable
    private final Collection<VirtualFile> myVisibleRoots;
    @Nullable
    private final List<List<String>> myRecentItems;

    protected BranchPopupBuilder(@NotNull VcsLogDataPack dataPack, @Nullable Collection<VirtualFile> visibleRoots, @Nullable List<List<String>> recentItems) {
        if (dataPack == null) {
            BranchPopupBuilder.$$$reportNull$$$0(0);
        }
        this.myDataPack = dataPack;
        this.myVisibleRoots = visibleRoots;
        this.myRecentItems = recentItems;
    }

    @NotNull
    protected abstract AnAction createAction(@NotNull String var1, @NotNull Collection<VcsRef> var2);

    protected void createRecentAction(@NotNull DefaultActionGroup actionGroup, @NotNull List<String> recentItem) {
        if (actionGroup == null) {
            BranchPopupBuilder.$$$reportNull$$$0(1);
        }
        if (recentItem == null) {
            BranchPopupBuilder.$$$reportNull$$$0(2);
        }
        assert (this.myRecentItems == null);
    }

    protected void createFavoritesAction(@NotNull DefaultActionGroup actionGroup, @NotNull List<String> favorites) {
        if (actionGroup == null) {
            BranchPopupBuilder.$$$reportNull$$$0(3);
        }
        if (favorites == null) {
            BranchPopupBuilder.$$$reportNull$$$0(4);
        }
    }

    @NotNull
    protected AnAction createCollapsedAction(@NotNull String actionName, @NotNull Collection<VcsRef> refs) {
        if (actionName == null) {
            BranchPopupBuilder.$$$reportNull$$$0(5);
        }
        if (refs == null) {
            BranchPopupBuilder.$$$reportNull$$$0(6);
        }
        AnAction anAction = this.createAction(actionName, refs);
        if (anAction == null) {
            BranchPopupBuilder.$$$reportNull$$$0(7);
        }
        return anAction;
    }

    public ActionGroup build() {
        return this.createActions(BranchPopupBuilder.prepareGroups(this.myDataPack, this.myVisibleRoots, this.myRecentItems));
    }

    private static Groups prepareGroups(@NotNull VcsLogDataPack dataPack, @Nullable Collection<VirtualFile> visibleRoots, @Nullable List<List<String>> recentItems) {
        if (dataPack == null) {
            BranchPopupBuilder.$$$reportNull$$$0(8);
        }
        Groups filteredGroups = new Groups();
        Collection allRefs = dataPack.getRefs().getBranches();
        for (Map.Entry<VirtualFile, Set<VcsRef>> entry : VcsLogUtil.groupRefsByRoot(allRefs).entrySet()) {
            VirtualFile root = entry.getKey();
            if (visibleRoots != null && !visibleRoots.contains(root)) continue;
            List refGroups = ((VcsLogProvider)dataPack.getLogProviders().get(root)).getReferenceManager().groupForBranchFilter((Collection)entry.getValue());
            BranchPopupBuilder.putActionsForReferences(dataPack, refGroups, filteredGroups);
        }
        if (recentItems != null) {
            filteredGroups.recentGroups.addAll(recentItems);
        }
        return filteredGroups;
    }

    @NotNull
    private DefaultActionGroup createActions(@NotNull Groups groups) {
        if (groups == null) {
            BranchPopupBuilder.$$$reportNull$$$0(9);
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (Map.Entry entry : groups.singletonGroups.entrySet()) {
            actionGroup.add(this.createAction((String)entry.getKey(), (Collection)entry.getValue()));
        }
        if (!groups.recentGroups.isEmpty()) {
            DefaultActionGroup recentGroup = new DefaultActionGroup("Recent", true);
            for (Object recentItem : groups.recentGroups) {
                this.createRecentAction(recentGroup, (List<String>)recentItem);
            }
            actionGroup.add((AnAction)recentGroup);
        }
        if (groups.favoriteGroups.size() > 1) {
            this.createFavoritesAction(actionGroup, ContainerUtil.newArrayList(groups.favoriteGroups.keySet()));
        }
        for (Map.Entry entry : groups.favoriteGroups.entrySet()) {
            actionGroup.add(this.createAction((String)entry.getKey(), (Collection)entry.getValue()));
        }
        for (Map.Entry group : groups.expandedGroups.entrySet()) {
            actionGroup.addSeparator((String)group.getKey());
            for (Map.Entry entry : ((TreeMap)group.getValue()).entrySet()) {
                actionGroup.add(this.createAction((String)entry.getKey(), (Collection)entry.getValue()));
            }
        }
        actionGroup.addSeparator();
        for (Map.Entry group : groups.collapsedGroups.entrySet()) {
            DefaultActionGroup popupGroup = new DefaultActionGroup((String)group.getKey(), true);
            for (Map.Entry entry : ((TreeMap)group.getValue()).entrySet()) {
                popupGroup.add(this.createCollapsedAction((String)entry.getKey(), (Collection)entry.getValue()));
            }
            actionGroup.add((AnAction)popupGroup);
        }
        DefaultActionGroup defaultActionGroup = actionGroup;
        if (defaultActionGroup == null) {
            BranchPopupBuilder.$$$reportNull$$$0(10);
        }
        return defaultActionGroup;
    }

    private static void putActionsForReferences(@NotNull VcsLogDataPack pack, @NotNull List<RefGroup> references, @NotNull Groups actions) {
        if (pack == null) {
            BranchPopupBuilder.$$$reportNull$$$0(11);
        }
        if (references == null) {
            BranchPopupBuilder.$$$reportNull$$$0(12);
        }
        if (actions == null) {
            BranchPopupBuilder.$$$reportNull$$$0(13);
        }
        for (RefGroup refGroup : references) {
            if (refGroup instanceof SingletonRefGroup) {
                VcsRef ref = ((SingletonRefGroup)refGroup).getRef();
                if (BranchPopupBuilder.isFavorite(pack, ref)) {
                    BranchPopupBuilder.append(actions.favoriteGroups, refGroup.getName(), ref);
                    continue;
                }
                BranchPopupBuilder.append(actions.singletonGroups, refGroup.getName(), ref);
                continue;
            }
            TreeMap groups = refGroup.isExpanded() ? actions.expandedGroups : actions.collapsedGroups;
            TreeMap groupActions = groups.computeIfAbsent(refGroup.getName(), key -> new TreeMap());
            for (VcsRef ref : refGroup.getRefs()) {
                if (BranchPopupBuilder.isFavorite(pack, ref)) {
                    BranchPopupBuilder.append(actions.favoriteGroups, ref.getName(), ref);
                }
                BranchPopupBuilder.append(groupActions, ref.getName(), ref);
            }
        }
    }

    public static boolean isFavorite(@NotNull VcsLogDataPack pack, @NotNull VcsRef ref) {
        if (pack == null) {
            BranchPopupBuilder.$$$reportNull$$$0(14);
        }
        if (ref == null) {
            BranchPopupBuilder.$$$reportNull$$$0(15);
        }
        return ((VcsLogProvider)pack.getLogProviders().get(ref.getRoot())).getReferenceManager().isFavorite(ref);
    }

    private static <T> void append(@NotNull TreeMap<String, Collection<T>> map2, @NotNull String key, @NotNull T value) {
        if (map2 == null) {
            BranchPopupBuilder.$$$reportNull$$$0(16);
        }
        if (key == null) {
            BranchPopupBuilder.$$$reportNull$$$0(17);
        }
        if (value == null) {
            BranchPopupBuilder.$$$reportNull$$$0(18);
        }
        BranchPopupBuilder.append(map2, key, Collections.singleton(value));
    }

    private static <T> void append(@NotNull TreeMap<String, Collection<T>> map2, @NotNull String key, @NotNull Collection<T> values) {
        if (map2 == null) {
            BranchPopupBuilder.$$$reportNull$$$0(19);
        }
        if (key == null) {
            BranchPopupBuilder.$$$reportNull$$$0(20);
        }
        if (values == null) {
            BranchPopupBuilder.$$$reportNull$$$0(21);
        }
        map2.computeIfAbsent(key, k -> new HashSet()).addAll(values);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recentItem";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "favorites";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/BranchPopupBuilder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pack";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/BranchPopupBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCollapsedAction";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRecentAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFavoritesAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCollapsedAction";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareGroups";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createActions";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "putActionsForReferences";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isFavorite";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Groups {
        private final TreeMap<String, Collection<VcsRef>> favoriteGroups = ContainerUtil.newTreeMap();
        private final TreeMap<String, Collection<VcsRef>> singletonGroups = ContainerUtil.newTreeMap();
        private final List<List<String>> recentGroups = ContainerUtil.newArrayList();
        private final TreeMap<String, TreeMap<String, Collection<VcsRef>>> expandedGroups = ContainerUtil.newTreeMap();
        private final TreeMap<String, TreeMap<String, Collection<VcsRef>>> collapsedGroups = ContainerUtil.newTreeMap();

        private Groups() {
        }
    }
}

