/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.VoidDataExternalizer;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsUserRegistryImpl;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogUserIndex
extends VcsLogFullDetailsIndex<Void> {
    private static final Logger LOG = Logger.getInstance(VcsLogUserIndex.class);
    public static final String USERS = "users";
    @NotNull
    private final VcsUserRegistryImpl myUserRegistry;

    public VcsLogUserIndex(@NotNull String logId, @NotNull VcsUserRegistryImpl userRegistry, @NotNull FatalErrorHandler consumer, @NotNull Disposable disposableParent) throws IOException {
        if (logId == null) {
            VcsLogUserIndex.$$$reportNull$$$0(0);
        }
        if (userRegistry == null) {
            VcsLogUserIndex.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            VcsLogUserIndex.$$$reportNull$$$0(2);
        }
        if (disposableParent == null) {
            VcsLogUserIndex.$$$reportNull$$$0(3);
        }
        super(logId, USERS, VcsLogPersistentIndex.getVersion(), new UserIndexer(userRegistry), VoidDataExternalizer.INSTANCE, true, consumer, disposableParent);
        this.myUserRegistry = userRegistry;
        ((UserIndexer)this.myIndexer).setFatalErrorConsumer((Consumer<Exception>)((Consumer)e -> {
            if (consumer == null) {
                VcsLogUserIndex.$$$reportNull$$$0(5);
            }
            consumer.consume(this, (Throwable)e);
        }));
    }

    public TIntHashSet getCommitsForUsers(@NotNull Set<VcsUser> users) throws IOException, StorageException {
        if (users == null) {
            VcsLogUserIndex.$$$reportNull$$$0(4);
        }
        HashSet ids = ContainerUtil.newHashSet();
        for (VcsUser user : users) {
            ids.add(this.myUserRegistry.getUserId(user));
        }
        return this.getCommitsWithAnyKey(ids);
    }

    @Nullable
    public VcsUser getAuthorForCommit(int commit) throws IOException {
        Collection<Integer> userIds = this.getKeysForCommit(commit);
        if (userIds == null || userIds.isEmpty()) {
            return null;
        }
        LOG.assertTrue(userIds.size() == 1);
        return this.myUserRegistry.getUserById((Integer)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(userIds)));
    }

    @Nullable
    public VcsUser getUserById(int id) throws IOException {
        return this.myUserRegistry.getUserById(id);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userRegistry";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = USERS;
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogUserIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommitsForUsers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class UserIndexer
    implements DataIndexer<Integer, Void, VcsFullCommitDetails> {
        @NotNull
        private final VcsUserRegistryImpl myRegistry;
        @NotNull
        private Consumer<Exception> myFatalErrorConsumer;

        public UserIndexer(@NotNull VcsUserRegistryImpl registry) {
            if (registry == null) {
                UserIndexer.$$$reportNull$$$0(0);
            }
            this.myFatalErrorConsumer = arg_0 -> ((Logger)LOG).error(arg_0);
            this.myRegistry = registry;
        }

        @NotNull
        public Map<Integer, Void> map(@NotNull VcsFullCommitDetails inputData) {
            if (inputData == null) {
                UserIndexer.$$$reportNull$$$0(1);
            }
            THashMap result2 = new THashMap();
            try {
                result2.put(this.myRegistry.getUserId(inputData.getAuthor()), null);
            }
            catch (IOException e) {
                this.myFatalErrorConsumer.consume((Object)e);
            }
            THashMap tHashMap = result2;
            if (tHashMap == null) {
                UserIndexer.$$$reportNull$$$0(2);
            }
            return tHashMap;
        }

        public void setFatalErrorConsumer(@NotNull Consumer<Exception> fatalErrorConsumer) {
            if (fatalErrorConsumer == null) {
                UserIndexer.$$$reportNull$$$0(3);
            }
            this.myFatalErrorConsumer = fatalErrorConsumer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "registry";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogUserIndex$UserIndexer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fatalErrorConsumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogUserIndex$UserIndexer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setFatalErrorConsumer";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

