/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputListener;
import org.intellij.lang.annotations.JdkConstants;

abstract class WindowMouseListener
extends MouseAdapter
implements MouseInputListener {
    private final Component myContent;
    @JdkConstants.CursorType
    int myType;
    private Point myLocation;
    private Rectangle myViewBounds;
    private boolean wasDragged;

    WindowMouseListener(Component content) {
        this.myContent = content;
    }

    @JdkConstants.CursorType
    abstract int getCursorType(Component var1, Point var2);

    abstract void updateBounds(Rectangle var1, Component var2, int var3, int var4);

    @Override
    public void mouseMoved(MouseEvent event) {
        this.update(event, false);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.update(event, true);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.process(event, false);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.process(event, true);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.process(event, true);
    }

    protected boolean isDisabled(Component view) {
        if (view instanceof Frame) {
            int state2 = ((Frame)view).getExtendedState();
            if (WindowMouseListener.isStateSet(1, state2)) {
                return true;
            }
            if (WindowMouseListener.isStateSet(6, state2)) {
                return true;
            }
        }
        return false;
    }

    private void update(MouseEvent event, boolean start) {
        Component content;
        Component view;
        if (event.isConsumed()) {
            return;
        }
        if (start) {
            this.wasDragged = false;
        }
        if (this.myLocation == null && (view = this.getView(content = this.getContent(event))) != null) {
            this.myType = this.isDisabled(view) ? -1 : this.getCursorType(view, event.getLocationOnScreen());
            this.setCursor(content, Cursor.getPredefinedCursor(this.myType == -1 ? 0 : this.myType));
            if (start && this.myType != -1) {
                this.myLocation = event.getLocationOnScreen();
                this.myViewBounds = view.getBounds();
                event.consume();
            }
        }
    }

    private void process(MouseEvent event, boolean stop2) {
        if (event.isConsumed()) {
            return;
        }
        if (!stop2) {
            this.wasDragged = true;
        }
        if (this.myLocation != null && this.myViewBounds != null) {
            Component content = this.getContent(event);
            Component view = this.getView(content);
            if (view != null) {
                Rectangle bounds = new Rectangle(this.myViewBounds);
                int dx = event.getXOnScreen() - this.myLocation.x;
                int dy = event.getYOnScreen() - this.myLocation.y;
                if (this.myType == 0 && view instanceof Frame) {
                    int state2 = ((Frame)view).getExtendedState();
                    if (WindowMouseListener.isStateSet(2, state2)) {
                        dx = 0;
                    }
                    if (WindowMouseListener.isStateSet(4, state2)) {
                        dy = 0;
                    }
                }
                this.updateBounds(bounds, view, dx, dy);
                if (!bounds.equals(view.getBounds())) {
                    view.setBounds(bounds);
                    view.invalidate();
                    view.validate();
                    view.repaint();
                }
            }
            if (stop2) {
                this.setCursor(content, Cursor.getPredefinedCursor(0));
                this.myLocation = null;
                if (this.wasDragged) {
                    this.myViewBounds = null;
                }
            }
            event.consume();
        } else if (stop2 && this.myViewBounds != null) {
            this.myViewBounds = null;
            event.consume();
        }
    }

    protected Component getContent(MouseEvent event) {
        return this.myContent != null ? this.myContent : event.getComponent();
    }

    protected Component getView(Component component) {
        return UIUtil.getWindow((Component)component);
    }

    protected void setCursor(Component content, Cursor cursor) {
        UIUtil.setCursor((Component)content, (Cursor)cursor);
    }

    public boolean isBusy() {
        return this.myLocation != null;
    }

    static boolean isStateSet(int mask, int state2) {
        return mask == (mask & state2);
    }
}

