/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Cell;
import com.intellij.ui.ColorPicker;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.PairFunction;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nullable;

public class ShowUIDefaultsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        UIDefaults defaults = UIManager.getDefaults();
        Enumeration keys = defaults.keys();
        final Object[][] data = new Object[defaults.size()][2];
        int i = 0;
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            data[i][0] = key;
            data[i][1] = defaults.get(key);
            ++i;
        }
        Arrays.sort(data, (o1, o2) -> StringUtil.naturalCompare((String)o1[0].toString(), (String)o2[0].toString()));
        final Project project = ShowUIDefaultsAction.getEventProject((AnActionEvent)e);
        new DialogWrapper(project){
            public JBTable myTable;
            {
                super(arg0);
                this.setTitle("Edit LaF Defaults");
                this.setModal(false);
                this.init();
            }

            @Nullable
            public JComponent getPreferredFocusedComponent() {
                return this.myTable;
            }

            @Nullable
            protected String getDimensionServiceKey() {
                return project == null ? null : "UI.Defaults.Dialog";
            }

            protected JComponent createCenterPanel() {
                JBTable table = new JBTable(new DefaultTableModel(data, new Object[]{"Name", "Value"}){

                    @Override
                    public boolean isCellEditable(int row, int column) {
                        Object value = this.getValueAt(row, column);
                        return column == 1 && (value instanceof Color || value instanceof Integer || value instanceof Border || value instanceof UIUtil.GrayFilter);
                    }
                }){

                    public boolean editCellAt(int row, int column, EventObject e) {
                        if (this.isCellEditable(row, column) && e instanceof MouseEvent) {
                            Object key = this.getValueAt(row, 0);
                            Object value = this.getValueAt(row, column);
                            if (value instanceof Color) {
                                Color newColor = ColorPicker.showDialog((Component)((Object)this), "Choose Color", (Color)value, true, null, true);
                                if (newColor != null) {
                                    ColorUIResource colorUIResource = new ColorUIResource(newColor);
                                    UIManager.getDefaults().remove(key);
                                    UIManager.getDefaults().put(key, colorUIResource);
                                    this.setValueAt(colorUIResource, row, column);
                                }
                            } else if (value instanceof Integer) {
                                Integer newValue = this.editNumber(key.toString(), value.toString());
                                if (newValue != null) {
                                    UIManager.getDefaults().remove(key);
                                    UIManager.getDefaults().put(key, newValue);
                                    this.setValueAt(newValue, row, column);
                                }
                            } else if (value instanceof Border) {
                                Insets i = ((Border)value).getBorderInsets(null);
                                String oldBorder = String.format("%d,%d,%d,%d", i.top, i.left, i.bottom, i.right);
                                Border newValue = this.editBorder(key.toString(), oldBorder);
                                if (newValue != null) {
                                    UIManager.getDefaults().remove(key);
                                    UIManager.getDefaults().put(key, newValue);
                                    this.setValueAt(newValue, row, column);
                                }
                            } else if (value instanceof UIUtil.GrayFilter) {
                                UIUtil.GrayFilter f = (UIUtil.GrayFilter)value;
                                String oldFilter = String.format("%d,%d,%d", f.getBrightness(), f.getContrast(), f.getAlpha());
                                UIUtil.GrayFilter newValue = this.editGrayFilter(key.toString(), oldFilter);
                                if (newValue != null) {
                                    UIManager.getDefaults().remove(key);
                                    UIManager.getDefaults().put(key, newValue);
                                    this.setValueAt(newValue, row, column);
                                }
                            }
                        }
                        return false;
                    }
                };
                table.setDefaultRenderer(Object.class, (TableCellRenderer)new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        JPanel panel2 = new JPanel(new BorderLayout());
                        JLabel label2 = new JLabel(value == null ? "" : value.toString());
                        panel2.add((Component)label2, "Center");
                        if (value instanceof Color) {
                            Color c = (Color)value;
                            label2.setText(String.format("[r=%d,g=%d,b=%d] hex=0x%s", c.getRed(), c.getGreen(), c.getBlue(), ColorUtil.toHex((Color)c)));
                            label2.setForeground((Color)(ColorUtil.isDark((Color)c) ? JBColor.white : JBColor.black));
                            panel2.setBackground(c);
                            return panel2;
                        }
                        if (value instanceof Icon) {
                            try {
                                IconWrap icon = new IconWrap((Icon)value);
                                if (icon.getIconHeight() <= 20) {
                                    label2.setIcon(icon);
                                }
                                label2.setText(String.format("(%dx%d) %s)", icon.getIconWidth(), icon.getIconHeight(), label2.getText()));
                            }
                            catch (Throwable icon) {
                                // empty catch block
                            }
                            return panel2;
                        }
                        if (value instanceof Border) {
                            try {
                                Insets i = ((Border)value).getBorderInsets(null);
                                label2.setText(String.format("[%d, %d, %d, %d] %s", i.top, i.left, i.bottom, i.right, label2.getText()));
                                return panel2;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    }
                });
                JBScrollPane pane = new JBScrollPane((Component)table);
                new TableSpeedSearch((JTable)table, (PairFunction<Object, Cell, String>)((PairFunction)(o, cell) -> cell.column == 1 ? null : String.valueOf(o)));
                table.setShowGrid(false);
                JPanel panel2 = new JPanel(new BorderLayout());
                panel2.add((Component)pane, "Center");
                this.myTable = table;
                TableUtil.ensureSelectionExists((JTable)this.myTable);
                return panel2;
            }

            @Nullable
            private Integer editNumber(String key, String value) {
                String newValue = Messages.showInputDialog((Component)this.getRootPane(), (String)("Enter new value for " + key), (String)"Number Editor", null, (String)value, (InputValidator)new InputValidator(){

                    public boolean checkInput(String inputString) {
                        try {
                            Integer.parseInt(inputString);
                            return true;
                        }
                        catch (NumberFormatException nfe) {
                            return false;
                        }
                    }

                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                });
                return newValue != null ? Integer.valueOf(newValue) : null;
            }

            @Nullable
            private Border editBorder(String key, String value) {
                String newValue = Messages.showInputDialog((Component)this.getRootPane(), (String)("Enter new value for " + key + "\nin form top,left,bottom,right"), (String)"Border Editor", null, (String)value, (InputValidator)new InputValidator(){

                    public boolean checkInput(String inputString) {
                        return this.parseBorder(inputString) != null;
                    }

                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                });
                return newValue != null ? this.parseBorder(newValue) : null;
            }

            @Nullable
            private Border parseBorder(String value) {
                String[] parts = value.split(",");
                if (parts.length != 4) {
                    return null;
                }
                try {
                    List v = Arrays.stream(parts).map(p -> Integer.parseInt(p)).collect(Collectors.toList());
                    return JBUI.Borders.empty((int)((Integer)v.get(0)), (int)((Integer)v.get(1)), (int)((Integer)v.get(2)), (int)((Integer)v.get(3)));
                }
                catch (NumberFormatException nex) {
                    return null;
                }
            }

            @Nullable
            private UIUtil.GrayFilter editGrayFilter(String key, String value) {
                String newValue = Messages.showInputDialog((Component)this.getRootPane(), (String)("Enter new value for " + key + "\nin form brightness,contrast,alpha"), (String)"Gray Filter Editor", null, (String)value, (InputValidator)new InputValidator(){

                    public boolean checkInput(String inputString) {
                        return this.parseGrayFilter(inputString) != null;
                    }

                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                });
                return newValue != null ? this.parseGrayFilter(newValue) : null;
            }

            @Nullable
            private UIUtil.GrayFilter parseGrayFilter(String value) {
                String[] parts = value.split(",");
                if (parts.length != 3) {
                    return null;
                }
                try {
                    List v = Arrays.stream(parts).map(p -> Integer.parseInt(p)).collect(Collectors.toList());
                    return new UIUtil.GrayFilter(((Integer)v.get(0)).intValue(), ((Integer)v.get(1)).intValue(), ((Integer)v.get(2)).intValue());
                }
                catch (NumberFormatException nex) {
                    return null;
                }
            }
        }.show();
    }

    private static class IconWrap
    implements Icon {
        private final Icon myIcon;

        public IconWrap(Icon icon) {
            this.myIcon = icon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            try {
                this.myIcon.paintIcon(c, g, x, y);
            }
            catch (Exception e) {
                EmptyIcon.ICON_0.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.myIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.myIcon.getIconHeight();
        }
    }
}

