/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.terminal.AppendableTerminalDataStream;
import com.intellij.terminal.JBTerminalPanel;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.PendingTasksRunner;
import com.intellij.terminal.ProcessHandlerTtyConnector;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.jediterm.terminal.HyperlinkStyle;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalKeyEncoder;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.TerminalSession;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import com.pty4j.PtyProcess;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TerminalExecutionConsole
implements ConsoleView,
ObservableConsoleView {
    private static final Logger LOG = Logger.getInstance(TerminalExecutionConsole.class);
    private JBTerminalWidget myTerminalWidget;
    private final Project myProject;
    private final AppendableTerminalDataStream myDataStream;
    private final AtomicBoolean myAttachedToProcess;
    private final Collection<ObservableConsoleView.ChangeListener> myChangeListeners;
    private volatile boolean myLastCR;
    private final PendingTasksRunner myOnResizedRunner;
    private final TerminalKeyEncoder myKeyEncoder;

    public TerminalExecutionConsole(@NotNull Project project, @Nullable ProcessHandler processHandler2) {
        if (project == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(0);
        }
        this.myAttachedToProcess = new AtomicBoolean(false);
        this.myChangeListeners = new CopyOnWriteArraySet<ObservableConsoleView.ChangeListener>();
        this.myLastCR = false;
        this.myKeyEncoder = new TerminalKeyEncoder();
        this.myKeyEncoder.setAutoNewLine(true);
        this.myProject = project;
        this.myOnResizedRunner = new PendingTasksRunner(2000L, project);
        JBTerminalSystemSettingsProviderBase provider = new JBTerminalSystemSettingsProviderBase(){

            public HyperlinkStyle.HighlightMode getHyperlinkHighlightingMode() {
                return HyperlinkStyle.HighlightMode.ALWAYS;
            }
        };
        this.myDataStream = new AppendableTerminalDataStream();
        this.myTerminalWidget = new JBTerminalWidget(project, 200, 24, provider, (Disposable)this){

            @Override
            protected JBTerminalPanel createTerminalPanel(@NotNull SettingsProvider settingsProvider, @NotNull StyleState styleState, @NotNull TerminalTextBuffer textBuffer) {
                if (settingsProvider == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (styleState == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (textBuffer == null) {
                    2.$$$reportNull$$$0(2);
                }
                JBTerminalPanel panel2 = new JBTerminalPanel((JBTerminalSystemSettingsProviderBase)settingsProvider, textBuffer, styleState){

                    public Dimension requestResize(Dimension newSize, RequestOrigin origin, int cursorY, JediTerminal.ResizeHandler resizeHandler) {
                        Dimension dimension = super.requestResize(newSize, origin, cursorY, resizeHandler);
                        TerminalExecutionConsole.this.myOnResizedRunner.setReady();
                        return dimension;
                    }

                    public void clearBuffer() {
                        super.clearBuffer(false);
                    }
                };
                Disposer.register((Disposable)this, (Disposable)panel2);
                return panel2;
            }

            @Override
            protected TerminalStarter createTerminalStarter(JediTerminal terminal, TtyConnector connector) {
                return new TerminalStarter((Terminal)terminal, connector, TerminalExecutionConsole.this.myDataStream){

                    public byte[] getCode(int key, int modifiers) {
                        if (key == 10) {
                            return TerminalExecutionConsole.this.myKeyEncoder.getCode(key, modifiers);
                        }
                        return super.getCode(key, modifiers);
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "settingsProvider";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "styleState";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "textBuffer";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/terminal/TerminalExecutionConsole$2";
                objectArray[2] = "createTerminalPanel";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Disposer.register((Disposable)this.myTerminalWidget, (Disposable)provider);
        if (processHandler2 != null) {
            this.attachToProcess(processHandler2);
        }
    }

    private void printText(@NotNull String text2, @Nullable ConsoleViewContentType contentType) throws IOException {
        if (text2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(1);
        }
        if (contentType != null) {
            this.myDataStream.append(TerminalExecutionConsole.encodeColor(contentType.getAttributes().getForegroundColor()));
        }
        this.myDataStream.append(text2);
        if (contentType != null) {
            this.myDataStream.append("\u001b[39m");
        }
        this.fireContentAdded((ConsoleViewContentType)ObjectUtils.notNull((Object)contentType, (Object)ConsoleViewContentType.NORMAL_OUTPUT));
    }

    public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(3);
        }
        this.myChangeListeners.add(listener2);
        Disposer.register((Disposable)parent, () -> {
            if (listener2 == null) {
                TerminalExecutionConsole.$$$reportNull$$$0(17);
            }
            this.myChangeListeners.remove(listener2);
        });
    }

    private static String encodeColor(Color color) {
        return String.valueOf('\u001b') + "[38;2;" + color.getRed() + ";" + color.getGreen() + ";" + color.getBlue() + "m";
    }

    public void setAutoNewLineMode(boolean enabled) {
        this.myKeyEncoder.setAutoNewLine(enabled);
    }

    public void addMessageFilter(Project project, Filter filter) {
        this.myTerminalWidget.addMessageFilter(project, filter);
    }

    public void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
        if (text2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(4);
        }
        if (contentType == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(5);
        }
        String textCRLF = this.convertTextToCRLF(text2);
        try {
            this.printText(textCRLF, contentType);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    @NotNull
    private String convertTextToCRLF(@NotNull String text2) {
        boolean preserveLastCR;
        if (text2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(6);
        }
        if (text2.isEmpty()) {
            String string = text2;
            if (string == null) {
                TerminalExecutionConsole.$$$reportNull$$$0(7);
            }
            return string;
        }
        boolean preserveFirstLF = text2.startsWith(LineSeparator.LF.getSeparatorString()) && this.myLastCR;
        this.myLastCR = preserveLastCR = text2.endsWith(LineSeparator.CR.getSeparatorString());
        String textToConvert = text2.substring(preserveFirstLF ? 1 : 0, preserveLastCR ? text2.length() - 1 : text2.length());
        String textCRLF = StringUtil.convertLineSeparators((String)textToConvert, (String)LineSeparator.CRLF.getSeparatorString());
        if (preserveFirstLF) {
            textCRLF = LineSeparator.LF.getSeparatorString() + textCRLF;
        }
        if (preserveLastCR) {
            textCRLF = textCRLF + LineSeparator.CR.getSeparatorString();
        }
        String string = textCRLF;
        if (string == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(8);
        }
        return string;
    }

    private void fireContentAdded(@NotNull ConsoleViewContentType contentType) {
        if (contentType == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(9);
        }
        List<ConsoleViewContentType> contentTypes = Collections.singletonList(contentType);
        for (ObservableConsoleView.ChangeListener listener2 : this.myChangeListeners) {
            listener2.contentAdded(contentTypes);
        }
    }

    public void clear() {
        this.myLastCR = false;
        this.myTerminalWidget.getTerminalPanel().clearBuffer();
    }

    public void scrollTo(int offset) {
    }

    public void attachToProcess(ProcessHandler processHandler2) {
        if (processHandler2 != null) {
            this.attachToProcess(processHandler2, true);
        }
    }

    protected final void attachToProcess(@NotNull ProcessHandler processHandler2, final boolean attachToProcessOutput) {
        if (processHandler2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(10);
        }
        if (!this.myAttachedToProcess.compareAndSet(false, true)) {
            return;
        }
        final TerminalSession session2 = this.myTerminalWidget.createTerminalSession(new ProcessHandlerTtyConnector(processHandler2, EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset()));
        processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                session2.start();
            }

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (outputType == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (attachToProcessOutput) {
                    TerminalExecutionConsole.this.myOnResizedRunner.execute(() -> {
                        if (outputType == null) {
                            3.$$$reportNull$$$0(4);
                        }
                        if (event == null) {
                            3.$$$reportNull$$$0(5);
                        }
                        try {
                            ConsoleViewContentType contentType = null;
                            if (outputType != ProcessOutputTypes.STDOUT) {
                                contentType = ConsoleViewContentType.getConsoleViewType((Key)outputType);
                            }
                            String text2 = event.getText();
                            if (outputType == ProcessOutputTypes.SYSTEM) {
                                text2 = StringUtil.convertLineSeparators((String)text2, (String)LineSeparator.CRLF.getSeparatorString());
                            }
                            TerminalExecutionConsole.this.printText(text2, contentType);
                        }
                        catch (IOException e) {
                            LOG.info((Throwable)e);
                        }
                    });
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(3);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    JBTerminalWidget widget = TerminalExecutionConsole.this.myTerminalWidget;
                    if (widget != null) {
                        widget.getTerminalPanel().setCursorVisible(false);
                    }
                }, ModalityState.any());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/terminal/TerminalExecutionConsole$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$onTextAvailable$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void setOutputPaused(boolean value) {
    }

    public boolean isOutputPaused() {
        return false;
    }

    public boolean hasDeferredOutput() {
        return false;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(11);
        }
    }

    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(12);
        }
    }

    public void addMessageFilter(@NotNull Filter filter) {
        if (filter == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(13);
        }
        this.addMessageFilter(this.myProject, filter);
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        if (hyperlinkText == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(14);
        }
    }

    public int getContentSize() {
        return 0;
    }

    public boolean canPause() {
        return false;
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        if (AnAction.EMPTY_ARRAY == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(15);
        }
        return AnAction.EMPTY_ARRAY;
    }

    public void allowHeavyFilters() {
    }

    public JComponent getComponent() {
        return this.myTerminalWidget.getComponent();
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myTerminalWidget.getComponent();
    }

    public void dispose() {
        this.myTerminalWidget = null;
    }

    public static boolean isAcceptable(@NotNull ProcessHandler processHandler2) {
        if (processHandler2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(16);
        }
        return processHandler2 instanceof OSProcessHandler && ((OSProcessHandler)processHandler2).getProcess() instanceof PtyProcess;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 7: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/terminal/TerminalExecutionConsole";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/terminal/TerminalExecutionConsole";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convertTextToCRLF";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "printText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertTextToCRLF";
                break;
            }
            case 7: 
            case 8: 
            case 15: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fireContentAdded";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addChangeListener$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

