/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class FindDependencyUtil {
    private FindDependencyUtil() {
    }

    public static UsageInfo[] findDependencies(@Nullable List<DependenciesBuilder> builders2, Set<PsiFile> searchIn, Set<PsiFile> searchFor) {
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        int totalCount = searchIn.size();
        int count = 0;
        for (PsiFile psiFile : searchIn) {
            Set<PsiFile> precomputedDeps;
            count = FindDependencyUtil.updateIndicator(indicator, totalCount, count, psiFile);
            if (!psiFile.isValid()) continue;
            if (builders2 != null) {
                HashSet<PsiFile> depsByFile = new HashSet<PsiFile>();
                for (DependenciesBuilder builder2 : builders2) {
                    Set<PsiFile> deps = builder2.getDependencies().get(psiFile);
                    if (deps == null) continue;
                    depsByFile.addAll(deps);
                }
                precomputedDeps = new HashSet<PsiFile>(depsByFile);
                precomputedDeps.retainAll(searchFor);
                if (precomputedDeps.isEmpty()) {
                    continue;
                }
            } else {
                precomputedDeps = Collections.unmodifiableSet(searchFor);
            }
            FindDependencyUtil.analyzeFileDependencies(psiFile, precomputedDeps, usages);
        }
        return usages.toArray(UsageInfo.EMPTY_ARRAY);
    }

    public static UsageInfo[] findBackwardDependencies(List<DependenciesBuilder> builders2, Set<PsiFile> searchIn, Set<PsiFile> searchFor) {
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        HashSet<PsiFile> deps = new HashSet<PsiFile>();
        for (PsiFile psiFile : searchFor) {
            for (DependenciesBuilder builder2 : builders2) {
                Set<PsiFile> depsByBuilder = builder2.getDependencies().get(psiFile);
                if (depsByBuilder == null) continue;
                deps.addAll(depsByBuilder);
            }
        }
        deps.retainAll(searchIn);
        if (deps.isEmpty()) {
            return UsageInfo.EMPTY_ARRAY;
        }
        int totalCount = deps.size();
        int count = 0;
        for (PsiFile psiFile : deps) {
            count = FindDependencyUtil.updateIndicator(indicator, totalCount, count, psiFile);
            FindDependencyUtil.analyzeFileDependencies(psiFile, searchFor, usages);
        }
        return usages.toArray(UsageInfo.EMPTY_ARRAY);
    }

    private static void analyzeFileDependencies(PsiFile psiFile, final Set<PsiFile> searchFor, final List<UsageInfo> result2) {
        DependenciesBuilder.analyzeFileDependencies(psiFile, new DependenciesBuilder.DependencyProcessor(){

            @Override
            public void process(PsiElement place, PsiElement dependency) {
                PsiElement navigationElement;
                PsiFile dependencyFile = dependency.getContainingFile();
                if (dependencyFile != null && (navigationElement = dependencyFile.getNavigationElement()) instanceof PsiFile) {
                    dependencyFile = (PsiFile)navigationElement;
                }
                if (searchFor.contains(dependencyFile)) {
                    result2.add(new UsageInfo(place));
                }
            }
        });
    }

    private static int updateIndicator(ProgressIndicator indicator, int totalCount, int count, PsiFile psiFile) {
        if (indicator != null) {
            if (indicator.isCanceled()) {
                throw new ProcessCanceledException();
            }
            indicator.setFraction((double)(++count) / (double)totalCount);
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile != null) {
                indicator.setText(AnalysisScopeBundle.message((String)"find.dependencies.progress.text", (Object[])new Object[]{virtualFile.getPresentableUrl()}));
            }
        }
        return count;
    }

    public static UsageInfo[] findDependencies(DependenciesBuilder builder2, Set<PsiFile> searchIn, Set<PsiFile> searchFor) {
        return FindDependencyUtil.findDependencies(Collections.singletonList(builder2), searchIn, searchFor);
    }

    public static UsageInfo[] findBackwardDependencies(DependenciesBuilder builder2, Set<PsiFile> searchIn, Set<PsiFile> searchFor) {
        return FindDependencyUtil.findBackwardDependencies(Collections.singletonList(builder2), searchIn, searchFor);
    }
}

