/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.IntSLRUCache;
import com.intellij.util.containers.IntObjectLinkedMap;
import com.intellij.util.io.PersistentStringEnumerator;
import com.intellij.util.text.ByteArrayCharSequence;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class FileNameCache {
    private static final PersistentStringEnumerator ourNames = FSRecords.getNames();
    private static final IntSLRUCache<IntObjectLinkedMap.MapEntry<CharSequence>>[] ourNameCache = new IntSLRUCache[16];
    private static final boolean ourTrackStats = false;
    private static final int ourLOneSize = 1024;
    private static final IntObjectLinkedMap.MapEntry<CharSequence>[] ourArrayCache;
    private static final AtomicInteger ourQueries;
    private static final AtomicInteger ourMisses;

    public static int storeName(@NotNull String name) {
        if (name == null) {
            FileNameCache.$$$reportNull$$$0(0);
        }
        int idx = FSRecords.getNameId(name);
        FileNameCache.cacheData(name, idx, FileNameCache.calcStripeIdFromNameId(idx));
        return idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static IntObjectLinkedMap.MapEntry<CharSequence> cacheData(String name, int id, int stripe) {
        IntSLRUCache<IntObjectLinkedMap.MapEntry<CharSequence>> cache;
        if (name == null) {
            ourNames.markCorrupted();
            throw new RuntimeException("VFS name enumerator corrupted");
        }
        CharSequence rawName = ByteArrayCharSequence.convertToBytesIfAsciiString((String)name);
        IntObjectLinkedMap.MapEntry<CharSequence> entry = new IntObjectLinkedMap.MapEntry<CharSequence>(id, rawName);
        IntSLRUCache<IntObjectLinkedMap.MapEntry<CharSequence>> intSLRUCache = cache = ourNameCache[stripe];
        // MONITORENTER : intSLRUCache
        IntObjectLinkedMap.MapEntry<CharSequence> mapEntry = cache.cacheEntry(entry);
        // MONITOREXIT : intSLRUCache
        if (mapEntry != null) return mapEntry;
        FileNameCache.$$$reportNull$$$0(1);
        return mapEntry;
    }

    private static int calcStripeIdFromNameId(int id) {
        int h = id;
        h -= h << 6;
        h ^= h >> 17;
        h -= h << 9;
        h ^= h << 4;
        h -= h << 3;
        h ^= h << 10;
        h ^= h >> 15;
        return h % ourNameCache.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static CharSequence getVFileName(int nameId, @NotNull NameComputer computeName) throws IOException {
        IntSLRUCache<IntObjectLinkedMap.MapEntry<CharSequence>> cache;
        if (computeName == null) {
            FileNameCache.$$$reportNull$$$0(2);
        }
        assert (nameId > 0);
        int l1 = nameId % 1024;
        IntObjectLinkedMap.MapEntry<CharSequence> entry = ourArrayCache[l1];
        if (entry != null && entry.key == nameId) {
            CharSequence charSequence = (CharSequence)entry.value;
            if (charSequence == null) {
                FileNameCache.$$$reportNull$$$0(3);
            }
            return charSequence;
        }
        int stripe = FileNameCache.calcStripeIdFromNameId(nameId);
        IntSLRUCache<IntObjectLinkedMap.MapEntry<CharSequence>> intSLRUCache = cache = ourNameCache[stripe];
        synchronized (intSLRUCache) {
            entry = cache.getCachedEntry(nameId);
        }
        if (entry == null) {
            entry = FileNameCache.cacheData(computeName.compute(nameId), nameId, stripe);
        }
        FileNameCache.ourArrayCache[l1] = entry;
        CharSequence charSequence = (CharSequence)entry.value;
        if (charSequence == null) {
            FileNameCache.$$$reportNull$$$0(4);
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getVFileName(int nameId) {
        CharSequence charSequence;
        try {
            charSequence = FileNameCache.getVFileName(nameId, FSRecords::getNameByNameId);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (charSequence == null) {
            FileNameCache.$$$reportNull$$$0(5);
        }
        return charSequence;
    }

    static {
        int protectedSize = 40000 / ourNameCache.length;
        int probationalSize = 20000 / ourNameCache.length;
        for (int i = 0; i < ourNameCache.length; ++i) {
            FileNameCache.ourNameCache[i] = new IntSLRUCache(protectedSize, probationalSize);
        }
        ourArrayCache = new IntObjectLinkedMap.MapEntry[1024];
        ourQueries = new AtomicInteger();
        ourMisses = new AtomicInteger();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/FileNameCache";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/FileNameCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheData";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "storeName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVFileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface NameComputer {
        public String compute(int var1) throws IOException;
    }
}

