/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChooseFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.xmlb.annotations.Attribute;
import gnu.trove.Equality;
import gnu.trove.THashSet;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

@com.intellij.openapi.components.State(name="Encoding", storages={@Storage(value="encoding.xml")})
public class EncodingManagerImpl
extends EncodingManager
implements PersistentStateComponent<State>,
Disposable {
    private static final Logger LOG = Logger.getInstance(EncodingManagerImpl.class);
    private static final Equality<Reference<Document>> REFERENCE_EQUALITY = new Equality<Reference<Document>>(){

        public boolean equals(Reference<Document> o1, Reference<Document> o2) {
            Equality v1 = o1 == null ? REFERENCE_EQUALITY : o1.get();
            Equality v2 = o2 == null ? REFERENCE_EQUALITY : o2.get();
            return v1 == v2;
        }
    };
    private final PropertyChangeSupport myPropertyChangeSupport;
    private State myState;
    private static final Key<Charset> CACHED_CHARSET_FROM_CONTENT = Key.create((String)"CACHED_CHARSET_FROM_CONTENT");
    private final ExecutorService changedDocumentExecutor;
    private final AtomicBoolean myDisposed;
    @NonNls
    public static final String PROP_CACHED_ENCODING_CHANGED = "cachedEncoding";
    private static final Key<String> DETECTING_ENCODING_KEY = Key.create((String)"DETECTING_ENCODING_KEY");

    public EncodingManagerImpl(@NotNull EditorFactory editorFactory, MessageBus messageBus) {
        if (editorFactory == null) {
            EncodingManagerImpl.$$$reportNull$$$0(0);
        }
        this.myPropertyChangeSupport = new PropertyChangeSupport((Object)this);
        this.myState = new State();
        this.changedDocumentExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"EncodingManagerImpl Document Pool", (Executor)PooledThreadExecutor.INSTANCE, (int)JobSchedulerImpl.getJobPoolParallelism(), (Disposable)this);
        this.myDisposed = new AtomicBoolean();
        messageBus.connect().subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            @Override
            public void appClosing() {
                EncodingManagerImpl.this.myDisposed.set(true);
                EncodingManagerImpl.this.clearDocumentQueue();
            }
        });
        editorFactory.getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                Document document = e.getDocument();
                if (EncodingManagerImpl.isEditorOpenedFor(document)) {
                    EncodingManagerImpl.this.queueUpdateEncodingFromContent(document);
                }
            }
        }, (Disposable)this);
        editorFactory.addEditorFactoryListener((EditorFactoryListener)new EditorFactoryAdapter(){

            public void editorCreated(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                EncodingManagerImpl.this.queueUpdateEncodingFromContent(event.getEditor().getDocument());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/encoding/EncodingManagerImpl$4", "editorCreated"));
            }
        }, (Disposable)this);
    }

    private static boolean isEditorOpenedFor(Document document) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null) {
            return false;
        }
        Project project = EncodingManagerImpl.guessProject(virtualFile);
        return project != null && !project.isDisposed() && FileEditorManager.getInstance((Project)project).getEditors(virtualFile).length != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDocument(@NotNull Document document) {
        if (document == null) {
            EncodingManagerImpl.$$$reportNull$$$0(1);
        }
        if (document.getUserData(DETECTING_ENCODING_KEY) == null) {
            return;
        }
        try {
            Charset oldCached;
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            if (virtualFile == null) {
                return;
            }
            Project project = EncodingManagerImpl.guessProject(virtualFile);
            if (project != null && project.isDisposed()) {
                return;
            }
            Charset charset = LoadTextUtil.charsetFromContentOrNull(project, virtualFile, document.getImmutableCharSequence());
            if (!Comparing.equal((Object)charset, (Object)(oldCached = this.getCachedCharsetFromContent(document)))) {
                this.setCachedCharsetFromContent(charset, oldCached, document);
            }
        }
        finally {
            document.putUserData(DETECTING_ENCODING_KEY, null);
        }
    }

    private void setCachedCharsetFromContent(Charset charset, Charset oldCached, @NotNull Document document) {
        if (document == null) {
            EncodingManagerImpl.$$$reportNull$$$0(2);
        }
        document.putUserData(CACHED_CHARSET_FROM_CONTENT, (Object)charset);
        this.firePropertyChange(document, PROP_CACHED_ENCODING_CHANGED, oldCached, charset);
    }

    @Nullable(value="returns null if charset set cannot be determined from content")
    Charset computeCharsetFromContent(@NotNull VirtualFile virtualFile) {
        Document document;
        if (virtualFile == null) {
            EncodingManagerImpl.$$$reportNull$$$0(3);
        }
        if ((document = FileDocumentManager.getInstance().getDocument(virtualFile)) == null) {
            return null;
        }
        Charset cached = EncodingManager.getInstance().getCachedCharsetFromContent(document);
        if (cached != null) {
            return cached;
        }
        Project project = ProjectLocator.getInstance().guessProjectForFile(virtualFile);
        return (Charset)ReadAction.compute(() -> {
            Charset charsetFromContent;
            if (virtualFile == null) {
                EncodingManagerImpl.$$$reportNull$$$0(17);
            }
            if ((charsetFromContent = LoadTextUtil.charsetFromContentOrNull(project, virtualFile, document.getImmutableCharSequence())) != null) {
                this.setCachedCharsetFromContent(charsetFromContent, null, document);
            }
            return charsetFromContent;
        });
    }

    public void dispose() {
        this.myDisposed.set(true);
    }

    private void queueUpdateEncodingFromContent(@NotNull Document document) {
        if (document == null) {
            EncodingManagerImpl.$$$reportNull$$$0(4);
        }
        if (this.myDisposed.get()) {
            return;
        }
        document.putUserData(DETECTING_ENCODING_KEY, (Object)"");
        this.changedDocumentExecutor.execute(new DocumentEncodingDetectRequest(document, this.myDisposed));
    }

    @Nullable
    public Charset getCachedCharsetFromContent(@NotNull Document document) {
        if (document == null) {
            EncodingManagerImpl.$$$reportNull$$$0(5);
        }
        return (Charset)document.getUserData(CACHED_CHARSET_FROM_CONTENT);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state2) {
        if (state2 == null) {
            EncodingManagerImpl.$$$reportNull$$$0(6);
        }
        this.myState = state2;
    }

    @NotNull
    public Collection<Charset> getFavorites() {
        Project[] projects;
        THashSet result2 = new THashSet();
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            result2.addAll(EncodingProjectManager.getInstance((Project)project).getFavorites());
        }
        result2.addAll(EncodingProjectManagerImpl.widelyKnownCharsets());
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            EncodingManagerImpl.$$$reportNull$$$0(7);
        }
        return tHashSet;
    }

    @Nullable
    public Charset getEncoding(@Nullable VirtualFile virtualFile, boolean useParentDefaults) {
        Project project = EncodingManagerImpl.guessProject(virtualFile);
        if (project == null) {
            return null;
        }
        EncodingProjectManager encodingManager = EncodingProjectManager.getInstance((Project)project);
        if (encodingManager == null) {
            return null;
        }
        return encodingManager.getEncoding(virtualFile, useParentDefaults);
    }

    public void clearDocumentQueue() {
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IllegalStateException("Must not call clearDocumentQueue() from under write action because some queued detectors require read action");
        }
        ((BoundedTaskExecutor)this.changedDocumentExecutor).clearAndCancelAll();
        try {
            ((BoundedTaskExecutor)this.changedDocumentExecutor).waitAllTasksExecuted(1L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    private static Project guessProject(VirtualFile virtualFile) {
        return ProjectLocator.getInstance().guessProjectForFile(virtualFile);
    }

    public void setEncoding(@Nullable VirtualFile virtualFileOrDir, @Nullable Charset charset) {
        Project project = EncodingManagerImpl.guessProject(virtualFileOrDir);
        EncodingProjectManager.getInstance((Project)project).setEncoding(virtualFileOrDir, charset);
    }

    public boolean isNative2Ascii(@NotNull VirtualFile virtualFile) {
        Project project;
        if (virtualFile == null) {
            EncodingManagerImpl.$$$reportNull$$$0(8);
        }
        return (project = EncodingManagerImpl.guessProject(virtualFile)) != null && EncodingProjectManager.getInstance((Project)project).isNative2Ascii(virtualFile);
    }

    public boolean isNative2AsciiForPropertiesFiles() {
        Project project = EncodingManagerImpl.guessProject(null);
        return project != null && EncodingProjectManager.getInstance((Project)project).isNative2AsciiForPropertiesFiles();
    }

    public void setNative2AsciiForPropertiesFiles(VirtualFile virtualFile, boolean native2Ascii) {
        Project project = EncodingManagerImpl.guessProject(virtualFile);
        if (project == null) {
            return;
        }
        EncodingProjectManager.getInstance((Project)project).setNative2AsciiForPropertiesFiles(virtualFile, native2Ascii);
    }

    @NotNull
    public Charset getDefaultCharset() {
        Charset charset = this.myState.myDefaultEncoding == ChooseFileEncodingAction.NO_ENCODING ? CharsetToolkit.getDefaultSystemCharset() : this.myState.myDefaultEncoding;
        if (charset == null) {
            EncodingManagerImpl.$$$reportNull$$$0(9);
        }
        return charset;
    }

    @NotNull
    public String getDefaultCharsetName() {
        String string = this.myState.getDefaultCharsetName();
        if (string == null) {
            EncodingManagerImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void setDefaultCharsetName(@NotNull String name) {
        if (name == null) {
            EncodingManagerImpl.$$$reportNull$$$0(11);
        }
        this.myState.setDefaultCharsetName(name);
    }

    @Nullable
    public Charset getDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile) {
        Project project = EncodingManagerImpl.guessProject(virtualFile);
        if (project == null) {
            return null;
        }
        return EncodingProjectManager.getInstance((Project)project).getDefaultCharsetForPropertiesFiles(virtualFile);
    }

    public void setDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile, Charset charset) {
        Project project = EncodingManagerImpl.guessProject(virtualFile);
        if (project == null) {
            return;
        }
        EncodingProjectManager.getInstance((Project)project).setDefaultCharsetForPropertiesFiles(virtualFile, charset);
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            EncodingManagerImpl.$$$reportNull$$$0(12);
        }
        if (parentDisposable == null) {
            EncodingManagerImpl.$$$reportNull$$$0(13);
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> {
            if (listener2 == null) {
                EncodingManagerImpl.$$$reportNull$$$0(16);
            }
            this.removePropertyChangeListener(listener2);
        });
    }

    private void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            EncodingManagerImpl.$$$reportNull$$$0(14);
        }
        this.myPropertyChangeSupport.removePropertyChangeListener(listener2);
    }

    void firePropertyChange(@Nullable Document document, @NotNull String propertyName, Object oldValue, Object newValue) {
        if (propertyName == null) {
            EncodingManagerImpl.$$$reportNull$$$0(15);
        }
        EncodingManagerImpl source = document == null ? this : document;
        this.myPropertyChangeSupport.firePropertyChange(new PropertyChangeEvent((Object)source, propertyName, oldValue, newValue));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorFactory";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/encoding/EncodingManagerImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/encoding/EncodingManagerImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFavorites";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCharset";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCharsetName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleDocument";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setCachedCharsetFromContent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeCharsetFromContent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "queueUpdateEncodingFromContent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCachedCharsetFromContent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isNative2Ascii";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultCharsetName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "firePropertyChange";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addPropertyChangeListener$1";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$computeCharsetFromContent$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DocumentEncodingDetectRequest
    implements Runnable {
        private final Reference<Document> ref;
        @NotNull
        private final AtomicBoolean myDisposed;

        private DocumentEncodingDetectRequest(@NotNull Document document, @NotNull AtomicBoolean disposed) {
            if (document == null) {
                DocumentEncodingDetectRequest.$$$reportNull$$$0(0);
            }
            if (disposed == null) {
                DocumentEncodingDetectRequest.$$$reportNull$$$0(1);
            }
            this.ref = new WeakReference<Document>(document);
            this.myDisposed = disposed;
        }

        @Override
        public void run() {
            if (this.myDisposed.get()) {
                return;
            }
            Document document = this.ref.get();
            if (document == null) {
                return;
            }
            ((EncodingManagerImpl)EncodingManager.getInstance()).handleDocument(document);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "disposed";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vfs/encoding/EncodingManagerImpl$DocumentEncodingDetectRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class State {
        @NotNull
        private Charset myDefaultEncoding = CharsetToolkit.UTF8_CHARSET;

        State() {
        }

        @Attribute(value="default_encoding")
        @NotNull
        public String getDefaultCharsetName() {
            String string = this.myDefaultEncoding == ChooseFileEncodingAction.NO_ENCODING ? "" : this.myDefaultEncoding.name();
            if (string == null) {
                State.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void setDefaultCharsetName(@NotNull String name) {
            if (name == null) {
                State.$$$reportNull$$$0(1);
            }
            this.myDefaultEncoding = name.isEmpty() ? ChooseFileEncodingAction.NO_ENCODING : (Charset)ObjectUtils.notNull((Object)CharsetToolkit.forName((String)name), (Object)CharsetToolkit.getDefaultSystemCharset());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/encoding/EncodingManagerImpl$State";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultCharsetName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/encoding/EncodingManagerImpl$State";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setDefaultCharsetName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

