/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenericNotifierImpl<T, Key> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.GenericNotifier");
    protected final Project myProject;
    @NotNull
    private final String myGroupId;
    @NotNull
    private final String myTitle;
    @NotNull
    private final NotificationType myType;
    @NotNull
    private final Map<Key, MyNotification> myState;
    private final MyListener myListener;
    private final Object myLock;

    protected GenericNotifierImpl(Project project, @NotNull String groupId, @NotNull String title, @NotNull NotificationType type) {
        if (groupId == null) {
            GenericNotifierImpl.$$$reportNull$$$0(0);
        }
        if (title == null) {
            GenericNotifierImpl.$$$reportNull$$$0(1);
        }
        if (type == null) {
            GenericNotifierImpl.$$$reportNull$$$0(2);
        }
        this.myGroupId = groupId;
        this.myTitle = title;
        this.myType = type;
        this.myProject = project;
        this.myState = new HashMap<Key, MyNotification>();
        this.myListener = new MyListener();
        this.myLock = new Object();
    }

    protected abstract boolean ask(T var1, String var2);

    @NotNull
    protected abstract Key getKey(T var1);

    @NotNull
    protected abstract String getNotificationContent(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Key> getAllCurrentKeys() {
        Object object = this.myLock;
        synchronized (object) {
            return new ArrayList<Key>(this.myState.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getStateFor(Key key) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myState.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<MyNotification> notifications;
        Object object = this.myLock;
        synchronized (object) {
            notifications = new ArrayList<MyNotification>(this.myState.values());
            this.myState.clear();
        }
        Application application = ApplicationManager.getApplication();
        Runnable runnable2 = () -> {
            for (MyNotification notification2 : notifications) {
                notification2.expire();
            }
        };
        if (application.isDispatchThread()) {
            runnable2.run();
        } else {
            application.invokeLater(runnable2, ModalityState.NON_MODAL, this.myProject.getDisposed());
        }
    }

    private void expireNotification(MyNotification notification2) {
        UIUtil.invokeLaterIfNeeded(() -> notification2.expire());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ensureNotify(T obj) {
        MyNotification notification2;
        Object object = this.myLock;
        synchronized (object) {
            Key key = this.getKey(obj);
            if (this.myState.containsKey(key)) {
                return false;
            }
            notification2 = new MyNotification(this.myGroupId, this.myTitle, this.getNotificationContent(obj), this.myType, this.myListener, obj);
            this.myState.put(key, notification2);
        }
        boolean state2 = this.onFirstNotification(obj);
        if (state2) {
            this.removeLazyNotification(obj);
            return true;
        }
        Notifications.Bus.notify((Notification)notification2, (Project)this.myProject);
        return false;
    }

    protected boolean onFirstNotification(T obj) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLazyNotificationByKey(Key key) {
        MyNotification notification2;
        Object object = this.myLock;
        synchronized (object) {
            notification2 = this.myState.get(key);
            if (notification2 != null) {
                this.myState.remove(key);
            }
        }
        if (notification2 != null) {
            this.expireNotification(notification2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLazyNotification(T obj) {
        MyNotification notification2;
        Object object = this.myLock;
        synchronized (object) {
            Key key = this.getKey(obj);
            notification2 = this.myState.get(key);
            if (notification2 != null) {
                this.myState.remove(key);
            }
        }
        if (notification2 != null) {
            this.expireNotification(notification2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected T getObj(Key key) {
        Object object = this.myLock;
        synchronized (object) {
            MyNotification notification2 = this.myState.get(key);
            return notification2 == null ? null : (T)notification2.getObj();
        }
    }

    private static void log(String s) {
        LOG.debug(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myState.isEmpty();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "groupId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "type";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/impl/GenericNotifierImpl";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class MyNotification
    extends Notification {
        private final T myObj;

        protected MyNotification(@NotNull String groupId, @NotNull String title, @NotNull String content, @Nullable NotificationType type, @NotNull NotificationListener listener2, T obj) {
            if (groupId == null) {
                MyNotification.$$$reportNull$$$0(0);
            }
            if (title == null) {
                MyNotification.$$$reportNull$$$0(1);
            }
            if (content == null) {
                MyNotification.$$$reportNull$$$0(2);
            }
            if (type == null) {
                MyNotification.$$$reportNull$$$0(3);
            }
            if (obj == null) {
                MyNotification.$$$reportNull$$$0(4);
            }
            super(groupId, title, content, type, listener2);
            this.myObj = obj;
        }

        public T getObj() {
            return this.myObj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expire() {
            super.expire();
            Object object = GenericNotifierImpl.this.myLock;
            synchronized (object) {
                GenericNotifierImpl.this.myState.remove(GenericNotifierImpl.this.getKey(this.myObj));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "groupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "content";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "obj";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/impl/GenericNotifierImpl$MyNotification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyListener
    implements NotificationListener {
        private MyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
            MyNotification concreteNotification;
            Object obj;
            boolean state2;
            if (notification2 == null) {
                MyListener.$$$reportNull$$$0(0);
            }
            if (event == null) {
                MyListener.$$$reportNull$$$0(1);
            }
            if (state2 = GenericNotifierImpl.this.ask(obj = (concreteNotification = (MyNotification)notification2).getObj(), event.getDescription())) {
                Object object = GenericNotifierImpl.this.myLock;
                synchronized (object) {
                    Object key = GenericNotifierImpl.this.getKey(obj);
                    GenericNotifierImpl.this.myState.remove(key);
                }
                GenericNotifierImpl.this.expireNotification(concreteNotification);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/impl/GenericNotifierImpl$MyListener";
            objectArray[2] = "hyperlinkUpdate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

