/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LineStatusMarkerRenderer {
    @NotNull
    protected final LineStatusTrackerBase<?> myTracker;

    public LineStatusMarkerRenderer(@NotNull LineStatusTrackerBase<?> tracker) {
        if (tracker == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(0);
        }
        this.myTracker = tracker;
    }

    protected boolean canDoAction(@NotNull Range range2, MouseEvent e) {
        if (range2 == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(1);
        }
        return false;
    }

    protected void doAction(@NotNull Editor editor, @NotNull Range range2, MouseEvent e) {
        if (editor == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(2);
        }
        if (range2 == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(3);
        }
    }

    @Nullable
    protected MarkupEditorFilter getEditorFilter() {
        return null;
    }

    protected int getFramingBorderSize() {
        return 0;
    }

    @NotNull
    RangeHighlighter createHighlighter(@NotNull Range range2) {
        if (range2 == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(4);
        }
        MarkupModel markupModel = DocumentMarkupModel.forDocument(this.myTracker.getDocument(), this.myTracker.getProject(), true);
        RangeHighlighter highlighter = LineStatusMarkerRenderer.createRangeHighlighter(range2, markupModel);
        MarkupEditorFilter editorFilter = this.getEditorFilter();
        if (editorFilter != null) {
            highlighter.setEditorFilter(editorFilter);
        }
        highlighter.setLineMarkerRenderer((LineMarkerRenderer)new MyActiveGutterRenderer(range2));
        RangeHighlighter rangeHighlighter = highlighter;
        if (rangeHighlighter == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(5);
        }
        return rangeHighlighter;
    }

    @NotNull
    public static RangeHighlighter createRangeHighlighter(@NotNull Range range2, @NotNull MarkupModel markupModel) {
        if (range2 == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(6);
        }
        if (markupModel == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(7);
        }
        TextRange textRange = DiffUtil.getLinesRange(markupModel.getDocument(), range2.getLine1(), range2.getLine2(), true);
        TextAttributes attributes = LineStatusMarkerRenderer.getTextAttributes(range2);
        RangeHighlighter highlighter = markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 5999, attributes, HighlighterTargetArea.LINES_IN_RANGE);
        highlighter.setThinErrorStripeMark(true);
        highlighter.setGreedyToLeft(true);
        highlighter.setGreedyToRight(true);
        RangeHighlighter rangeHighlighter = highlighter;
        if (rangeHighlighter == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(8);
        }
        return rangeHighlighter;
    }

    @NotNull
    private static TextAttributes getTextAttributes(final @NotNull Range range2) {
        if (range2 == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(9);
        }
        TextAttributes textAttributes = new TextAttributes(){

            public Color getErrorStripeColor() {
                return LineStatusMarkerRenderer.getErrorStripeColor(range2, null);
            }
        };
        if (textAttributes == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(10);
        }
        return textAttributes;
    }

    protected void paint(@NotNull Editor editor, @NotNull Range range2, @NotNull Graphics g) {
        if (editor == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(11);
        }
        if (range2 == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(12);
        }
        if (g == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(13);
        }
        LineStatusMarkerRenderer.paintRange(g, editor, range2, this.getFramingBorderSize());
    }

    public static void paintRange(@NotNull Graphics g, @NotNull Editor editor, @NotNull Range range2, int framingBorder) {
        if (g == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(14);
        }
        if (editor == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(15);
        }
        if (range2 == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(16);
        }
        Color gutterColor = LineStatusMarkerRenderer.getGutterColor(range2, editor);
        Color borderColor = LineStatusMarkerRenderer.getGutterBorderColor(editor);
        Color gutterBackgroundColor = ((EditorEx)editor).getGutterComponentEx().getBackground();
        Rectangle area = LineStatusMarkerRenderer.getMarkerArea(editor, range2.getLine1(), range2.getLine2());
        int x = area.x;
        int endX = area.x + area.width;
        int y = area.y;
        int endY = area.y + area.height;
        if (framingBorder > 0 && y != endY) {
            g.setColor(gutterBackgroundColor);
            g.fillRect(x - framingBorder, y - framingBorder, endX - x + framingBorder, endY - y + framingBorder * 2);
        }
        if (y == endY) {
            LineStatusMarkerRenderer.paintTriangle(g, gutterColor, borderColor, x, endX, y);
        } else if (range2.getInnerRanges() == null) {
            LineStatusMarkerRenderer.paintRect(g, gutterColor, borderColor, x, y, endX, endY);
        } else {
            int start;
            List<Range.InnerRange> innerRanges = range2.getInnerRanges();
            for (Range.InnerRange innerRange : innerRanges) {
                if (innerRange.getType() == 3) continue;
                start = DiffDrawUtil.lineToY(editor, range2.getLine1() + innerRange.getLine1());
                int end = DiffDrawUtil.lineToY(editor, range2.getLine1() + innerRange.getLine2());
                LineStatusMarkerRenderer.paintRect(g, LineStatusMarkerRenderer.getGutterColor(innerRange, editor), null, x, start, endX, end);
            }
            LineStatusMarkerRenderer.paintRect(g, null, borderColor, x, y, endX, endY);
            for (Range.InnerRange innerRange : innerRanges) {
                if (innerRange.getType() != 3) continue;
                start = DiffDrawUtil.lineToY(editor, range2.getLine1() + innerRange.getLine1());
                LineStatusMarkerRenderer.paintTriangle(g, LineStatusMarkerRenderer.getGutterColor(innerRange, editor), borderColor, x, endX, start);
            }
        }
    }

    public static void paintIgnoredRange(@NotNull Graphics g, @NotNull Editor editor, @NotNull Range range2) {
        if (g == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(17);
        }
        if (editor == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(18);
        }
        if (range2 == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(19);
        }
        Color borderColor = LineStatusMarkerRenderer.getGutterBorderColor(editor);
        Color ignoredBorderColor = LineStatusMarkerRenderer.getIgnoredGutterBorderColor(range2, editor);
        Color color = borderColor != null ? borderColor : ignoredBorderColor;
        Rectangle area = LineStatusMarkerRenderer.getMarkerArea(editor, range2.getLine1(), range2.getLine2());
        int x = area.x;
        int endX = area.x + area.width;
        int y = area.y;
        int endY = area.y + area.height;
        if (area.height == 0) {
            LineStatusMarkerRenderer.paintTriangle(g, null, color, x, endX, y);
        } else {
            LineStatusMarkerRenderer.paintRect(g, null, color, x, y, endX, endY);
        }
    }

    public static void paintSimpleRange(Graphics g, Editor editor, int line1, int line2, @Nullable Color color) {
        Rectangle area = LineStatusMarkerRenderer.getMarkerArea(editor, line1, line2);
        Color borderColor = LineStatusMarkerRenderer.getGutterBorderColor(editor);
        if (area.height != 0) {
            LineStatusMarkerRenderer.paintRect(g, color, borderColor, area.x, area.y, area.x + area.width, area.y + area.height);
        } else {
            LineStatusMarkerRenderer.paintTriangle(g, color, borderColor, area.x, area.x + area.width, area.y);
        }
    }

    @NotNull
    public static Rectangle getMarkerArea(@NotNull Editor editor, int line1, int line2) {
        if (editor == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(20);
        }
        EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
        int x = gutter.getLineMarkerFreePaintersAreaOffset() + 1;
        int endX = gutter.getWhitespaceSeparatorOffset();
        int y = DiffDrawUtil.lineToY(editor, line1);
        int endY = DiffDrawUtil.lineToY(editor, line2);
        Rectangle rectangle = new Rectangle(x, y, endX - x, endY - y);
        if (rectangle == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(21);
        }
        return rectangle;
    }

    public static boolean isInsideMarkerArea(@NotNull MouseEvent e) {
        if (e == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(22);
        }
        EditorGutterComponentEx gutter = (EditorGutterComponentEx)e.getComponent();
        return e.getX() > gutter.getLineMarkerFreePaintersAreaOffset();
    }

    private static void paintRect(@NotNull Graphics g, @Nullable Color color, @Nullable Color borderColor, int x1, int y1, int x2, int y2) {
        if (g == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(23);
        }
        if (color != null) {
            g.setColor(color);
            g.fillRect(x1, y1, x2 - x1, y2 - y1);
        }
        if (borderColor != null) {
            ((Graphics2D)g).setStroke(new BasicStroke(JBUI.scale((int)1)));
            g.setColor(borderColor);
            UIUtil.drawLine((Graphics)g, (int)x1, (int)y1, (int)(x2 - 1), (int)y1);
            UIUtil.drawLine((Graphics)g, (int)x1, (int)y1, (int)x1, (int)(y2 - 1));
            UIUtil.drawLine((Graphics)g, (int)x1, (int)(y2 - 1), (int)(x2 - 1), (int)(y2 - 1));
        }
    }

    private static void paintTriangle(@NotNull Graphics g, @Nullable Color color, @Nullable Color borderColor, int x1, int x2, int y) {
        if (g == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(24);
        }
        int size = JBUI.scale((int)4);
        int[] xPoints = new int[]{x1, x1, x2};
        int[] yPoints = new int[]{y - size, y + size, y};
        if (color != null) {
            g.setColor(color);
            g.fillPolygon(xPoints, yPoints, xPoints.length);
        }
        if (borderColor != null) {
            ((Graphics2D)g).setStroke(new BasicStroke(JBUI.scale((int)1)));
            g.setColor(borderColor);
            g.drawPolygon(xPoints, yPoints, xPoints.length);
        }
    }

    @Nullable
    private static Color getGutterColor(@NotNull Range.InnerRange range2, @Nullable Editor editor) {
        if (range2 == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(25);
        }
        EditorColorsScheme scheme2 = LineStatusMarkerRenderer.getColorScheme(editor);
        switch (range2.getType()) {
            case 2: {
                return scheme2.getColor(EditorColors.ADDED_LINES_COLOR);
            }
            case 3: {
                return scheme2.getColor(EditorColors.DELETED_LINES_COLOR);
            }
            case 1: {
                return scheme2.getColor(EditorColors.MODIFIED_LINES_COLOR);
            }
            case 0: {
                return scheme2.getColor(EditorColors.WHITESPACES_MODIFIED_LINES_COLOR);
            }
        }
        assert (false);
        return null;
    }

    @Nullable
    private static Color getErrorStripeColor(@NotNull Range range2, @Nullable Editor editor) {
        if (range2 == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(26);
        }
        EditorColorsScheme scheme2 = LineStatusMarkerRenderer.getColorScheme(editor);
        switch (range2.getType()) {
            case 2: {
                return scheme2.getAttributes(DiffColors.DIFF_INSERTED).getErrorStripeColor();
            }
            case 3: {
                return scheme2.getAttributes(DiffColors.DIFF_DELETED).getErrorStripeColor();
            }
            case 1: {
                return scheme2.getAttributes(DiffColors.DIFF_MODIFIED).getErrorStripeColor();
            }
        }
        assert (false);
        return null;
    }

    @Nullable
    private static Color getGutterColor(@NotNull Range range2, @Nullable Editor editor) {
        if (range2 == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(27);
        }
        EditorColorsScheme scheme2 = LineStatusMarkerRenderer.getColorScheme(editor);
        switch (range2.getType()) {
            case 2: {
                return scheme2.getColor(EditorColors.ADDED_LINES_COLOR);
            }
            case 3: {
                return scheme2.getColor(EditorColors.DELETED_LINES_COLOR);
            }
            case 1: {
                return scheme2.getColor(EditorColors.MODIFIED_LINES_COLOR);
            }
        }
        assert (false);
        return null;
    }

    @Nullable
    private static Color getIgnoredGutterBorderColor(@NotNull Range range2, @Nullable Editor editor) {
        if (range2 == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(28);
        }
        EditorColorsScheme scheme2 = LineStatusMarkerRenderer.getColorScheme(editor);
        switch (range2.getType()) {
            case 2: {
                return scheme2.getColor(EditorColors.IGNORED_ADDED_LINES_BORDER_COLOR);
            }
            case 3: {
                return scheme2.getColor(EditorColors.IGNORED_DELETED_LINES_BORDER_COLOR);
            }
            case 1: {
                return scheme2.getColor(EditorColors.IGNORED_MODIFIED_LINES_BORDER_COLOR);
            }
        }
        assert (false);
        return null;
    }

    @Nullable
    private static Color getGutterBorderColor(@Nullable Editor editor) {
        return LineStatusMarkerRenderer.getColorScheme(editor).getColor(EditorColors.BORDER_LINES_COLOR);
    }

    @NotNull
    private static EditorColorsScheme getColorScheme(@Nullable Editor editor) {
        EditorColorsScheme editorColorsScheme = editor != null ? editor.getColorsScheme() : EditorColorsManager.getInstance().getGlobalScheme();
        if (editorColorsScheme == null) {
            LineStatusMarkerRenderer.$$$reportNull$$$0(29);
        }
        return editorColorsScheme;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 21: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 21: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 11: 
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markupModel";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlighter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createRangeHighlighter";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAttributes";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkerArea";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorScheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canDoAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 21: 
            case 29: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRangeHighlighter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTextAttributes";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "paintRange";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "paintIgnoredRange";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getMarkerArea";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isInsideMarkerArea";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "paintRect";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "paintTriangle";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getGutterColor";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getErrorStripeColor";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoredGutterBorderColor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 21: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyActiveGutterRenderer
    implements ActiveGutterRenderer {
        @NotNull
        private final Range myRange;

        public MyActiveGutterRenderer(Range range2) {
            if (range2 == null) {
                MyActiveGutterRenderer.$$$reportNull$$$0(0);
            }
            this.myRange = range2;
        }

        public void paint(Editor editor, Graphics g, Rectangle r) {
            LineStatusMarkerRenderer.this.paint(editor, this.myRange, g);
        }

        public boolean canDoAction(MouseEvent e) {
            return LineStatusMarkerRenderer.this.canDoAction(this.myRange, e);
        }

        public void doAction(Editor editor, MouseEvent e) {
            LineStatusMarkerRenderer.this.doAction(editor, this.myRange, e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer$MyActiveGutterRenderer", "<init>"));
        }
    }
}

