/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.messages.MessageBus;
import java.util.HashSet;
import java.util.Set;

public class NoAccessDuringPsiEvents {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.project.NoAccessDuringPsiEvents");
    private static final Set<String> ourReportedTraces = new HashSet<String>();

    public static void checkCallContext() {
        if (NoAccessDuringPsiEvents.isInsideEventProcessing() && ourReportedTraces.add(DebugUtil.currentStackTrace())) {
            LOG.error("It's prohibited to access index during event dispatching");
        }
    }

    public static boolean isInsideEventProcessing() {
        Application application = ApplicationManager.getApplication();
        if (!application.isWriteAccessAllowed()) {
            return false;
        }
        MessageBus bus = application.getMessageBus();
        return bus.hasUndeliveredEvents(VirtualFileManager.VFS_CHANGES) || bus.hasUndeliveredEvents(PsiModificationTracker.TOPIC);
    }
}

