/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.DocumentUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

class LogicalPositionCache
implements PrioritizedDocumentListener,
Disposable,
Dumpable {
    private final Document myDocument;
    private final EditorView myView;
    private ArrayList<LineData> myLines = new ArrayList();
    private int myTabSize = -1;
    private int myDocumentChangeOldEndLine;
    private boolean myUpdateInProgress;

    LogicalPositionCache(EditorView view) {
        this.myView = view;
        this.myDocument = view.getEditor().getDocument();
        this.myDocument.addDocumentListener((DocumentListener)this, (Disposable)this);
    }

    @Override
    public int getPriority() {
        return 65;
    }

    public void beforeDocumentChange(DocumentEvent event) {
        this.myUpdateInProgress = true;
        this.myDocumentChangeOldEndLine = this.getAdjustedLineNumber(event.getOffset() + event.getOldLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void documentChanged(DocumentEvent event) {
        try {
            int startLine = this.myDocument.getLineNumber(event.getOffset());
            int newEndLine = this.getAdjustedLineNumber(event.getOffset() + event.getNewLength());
            this.invalidateLines(startLine, this.myDocumentChangeOldEndLine, newEndLine, LogicalPositionCache.isSimpleText(event.getNewFragment()));
        }
        finally {
            this.myUpdateInProgress = false;
        }
    }

    private static boolean isSimpleText(@NotNull CharSequence text2) {
        if (text2 == null) {
            LogicalPositionCache.$$$reportNull$$$0(0);
        }
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (c != '\t' && (c < '\ud800' || c > '\udfff')) continue;
            return false;
        }
        return true;
    }

    synchronized void reset(boolean force) {
        this.checkDisposed();
        int oldTabSize = this.myTabSize;
        this.myTabSize = this.myView.getTabSize();
        if (force || oldTabSize != this.myTabSize) {
            this.invalidateLines(0, this.myLines.size() - 1, this.myDocument.getLineCount() - 1, !force && this.myLines.size() == this.myDocument.getLineCount());
        }
    }

    @NotNull
    synchronized LogicalPosition offsetToLogicalPosition(int offset) {
        if (this.myUpdateInProgress) {
            throw new IllegalStateException();
        }
        int textLength = this.myDocument.getTextLength();
        if (offset <= 0 || textLength == 0) {
            LogicalPosition logicalPosition = new LogicalPosition(0, 0);
            if (logicalPosition == null) {
                LogicalPositionCache.$$$reportNull$$$0(1);
            }
            return logicalPosition;
        }
        offset = Math.min(offset, textLength);
        int line = this.myDocument.getLineNumber(offset);
        LineData lineData = this.getLineInfo(line);
        LogicalPosition logicalPosition = new LogicalPosition(line, lineData.offsetToLogicalColumn(this.myDocument, line, this.myTabSize, offset));
        if (logicalPosition == null) {
            LogicalPositionCache.$$$reportNull$$$0(2);
        }
        return logicalPosition;
    }

    synchronized int offsetToLogicalColumn(int line, int intraLineOffset) {
        if (this.myUpdateInProgress) {
            throw new IllegalStateException();
        }
        if (line < 0 || line >= this.myDocument.getLineCount()) {
            return 0;
        }
        LineData lineData = this.getLineInfo(line);
        return lineData.offsetToLogicalColumn(this.myDocument, line, this.myTabSize, this.myDocument.getLineStartOffset(line) + intraLineOffset);
    }

    synchronized int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        if (pos == null) {
            LogicalPositionCache.$$$reportNull$$$0(3);
        }
        int line = pos.line;
        int column = pos.column;
        if (line >= this.myDocument.getLineCount()) {
            return this.myDocument.getTextLength();
        }
        if (this.myUpdateInProgress) {
            int lineStartOffset = this.myDocument.getLineStartOffset(line);
            int lineEndOffset = this.myDocument.getLineEndOffset(line);
            return LogicalPositionCache.calcOffset(this.myDocument, column, 0, lineStartOffset, lineEndOffset, this.myTabSize);
        }
        LineData lineData = this.getLineInfo(line);
        return lineData.logicalColumnToOffset(this.myDocument, line, this.myTabSize, column);
    }

    private static int calcOffset(@NotNull Document document, int column, int startColumn, int startOffset, int endOffset, int tabSize) {
        if (document == null) {
            LogicalPositionCache.$$$reportNull$$$0(4);
        }
        int currentColumn = startColumn;
        CharSequence text2 = document.getImmutableCharSequence();
        for (int i = startOffset; i < endOffset; ++i) {
            if (text2.charAt(i) == '\t') {
                currentColumn = (currentColumn / tabSize + 1) * tabSize;
            } else if (DocumentUtil.isSurrogatePair(document, i)) {
                if (currentColumn == column) {
                    return i;
                }
            } else {
                ++currentColumn;
            }
            if (currentColumn <= column) continue;
            return i;
        }
        return endOffset;
    }

    static int calcColumn(@NotNull CharSequence text2, int startOffset, int startColumn, int offset, int tabSize) {
        if (text2 == null) {
            LogicalPositionCache.$$$reportNull$$$0(5);
        }
        int column = startColumn;
        for (int i = startOffset; i < offset; ++i) {
            char c = text2.charAt(i);
            if (c == '\t') {
                column = (column / tabSize + 1) * tabSize;
                continue;
            }
            if (i + 1 < text2.length() && Character.isHighSurrogate(c) && Character.isLowSurrogate(text2.charAt(i + 1))) continue;
            ++column;
        }
        return column;
    }

    private int getAdjustedLineNumber(int offset) {
        return this.myDocument.getTextLength() == 0 ? -1 : this.myDocument.getLineNumber(offset);
    }

    private synchronized void invalidateLines(int startLine, int oldEndLine, int newEndLine, boolean preserveTrivialLines) {
        this.checkDisposed();
        if (preserveTrivialLines) {
            for (int line = startLine; line <= oldEndLine; ++line) {
                LineData data = this.myLines.get(line);
                if (data != null && data.columnCache == null) continue;
                preserveTrivialLines = false;
                break;
            }
        }
        if (!preserveTrivialLines) {
            int endLine = Math.min(oldEndLine, newEndLine);
            for (int line = startLine; line <= endLine; ++line) {
                this.myLines.set(line, null);
            }
        }
        if (oldEndLine < newEndLine) {
            this.myLines.addAll(oldEndLine + 1, Collections.nCopies(newEndLine - oldEndLine, preserveTrivialLines ? LineData.TRIVIAL : null));
        } else if (oldEndLine > newEndLine) {
            this.myLines.subList(newEndLine + 1, oldEndLine + 1).clear();
        }
    }

    @NotNull
    private LineData getLineInfo(int line) {
        this.checkDisposed();
        LineData result2 = this.myLines.get(line);
        if (result2 == null) {
            result2 = LineData.create(this.myDocument, line, this.myTabSize);
            this.myLines.set(line, result2);
        }
        LineData lineData = result2;
        if (lineData == null) {
            LogicalPositionCache.$$$reportNull$$$0(6);
        }
        return lineData;
    }

    public synchronized void dispose() {
        this.myLines = null;
    }

    private void checkDisposed() {
        if (this.myLines == null) {
            this.myView.getEditor().throwDisposalError("Editor is already disposed");
        }
    }

    synchronized void validateState() {
        int lineCount = this.myDocument.getLineCount();
        int cacheSize = this.myLines.size();
        if (cacheSize != lineCount) {
            throw new IllegalStateException("Line count: " + lineCount + ", cache size: " + cacheSize);
        }
        int tabSize = this.myView.getTabSize();
        for (int i = 0; i < cacheSize; ++i) {
            LineData data = this.myLines.get(i);
            if (data == null) continue;
            LineData actual = LineData.create(this.myDocument, i, tabSize);
            if (Arrays.equals(data.columnCache, actual.columnCache)) continue;
            throw new IllegalStateException("Wrong cache state at line " + i);
        }
    }

    @NotNull
    public String dumpState() {
        String string;
        block3: {
            try {
                this.validateState();
                string = "valid";
                if ("valid" != null) break block3;
            }
            catch (Exception e) {
                String string2 = "invalid (" + e.getMessage() + ")";
                if (string2 == null) {
                    LogicalPositionCache.$$$reportNull$$$0(8);
                }
                return string2;
            }
            LogicalPositionCache.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/view/LogicalPositionCache";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/view/LogicalPositionCache";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToLogicalPosition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineInfo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSimpleText";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "logicalPositionToOffset";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcOffset";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calcColumn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LineData {
        private static final LineData TRIVIAL = new LineData(null);
        private static final int CACHE_FREQUENCY = 1024;
        private final int[] columnCache;

        private LineData(int[] columnData) {
            this.columnCache = columnData;
        }

        private static LineData create(@NotNull Document document, int line, int tabSize) {
            if (document == null) {
                LineData.$$$reportNull$$$0(0);
            }
            int start = document.getLineStartOffset(line);
            int end = document.getLineEndOffset(line);
            int cacheSize = (end - start) / 1024;
            int[] cache = ArrayUtil.newIntArray((int)cacheSize);
            CharSequence text2 = document.getImmutableCharSequence();
            int column = 0;
            boolean hasTabsOrSurrogates = false;
            for (int i = start; i < end; ++i) {
                char c;
                if (i > start && (i - start) % 1024 == 0) {
                    cache[(i - start) / 1024 - 1] = column;
                }
                if ((c = text2.charAt(i)) == '\t') {
                    column = (column / tabSize + 1) * tabSize;
                    hasTabsOrSurrogates = true;
                    continue;
                }
                if (Character.isHighSurrogate(c)) {
                    hasTabsOrSurrogates = true;
                    if (i + 1 < text2.length() && Character.isLowSurrogate(text2.charAt(i + 1))) {
                        continue;
                    }
                } else {
                    hasTabsOrSurrogates |= Character.isLowSurrogate(c);
                }
                ++column;
            }
            if (cacheSize > 0 && (end - start) % 1024 == 0) {
                cache[cacheSize - 1] = column;
            }
            return hasTabsOrSurrogates ? new LineData(cache) : TRIVIAL;
        }

        private int offsetToLogicalColumn(@NotNull Document document, int line, int tabSize, int offset) {
            if (document == null) {
                LineData.$$$reportNull$$$0(1);
            }
            offset = Math.min(offset, document.getLineEndOffset(line));
            int lineStartOffset = document.getLineStartOffset(line);
            int relOffset = offset - lineStartOffset;
            if (this.columnCache == null) {
                return relOffset;
            }
            int cacheIndex = relOffset / 1024;
            int startOffset = lineStartOffset + cacheIndex * 1024;
            int startColumn = cacheIndex == 0 ? 0 : this.columnCache[cacheIndex - 1];
            return LogicalPositionCache.calcColumn(document.getImmutableCharSequence(), startOffset, startColumn, offset, tabSize);
        }

        private int logicalColumnToOffset(@NotNull Document document, int line, int tabSize, int logicalColumn) {
            if (document == null) {
                LineData.$$$reportNull$$$0(2);
            }
            int lineStartOffset = document.getLineStartOffset(line);
            int lineEndOffset = document.getLineEndOffset(line);
            if (this.columnCache == null) {
                int result2 = lineStartOffset + logicalColumn;
                return result2 < 0 || result2 > lineEndOffset ? lineEndOffset : result2;
            }
            int pos = Arrays.binarySearch(this.columnCache, logicalColumn);
            if (pos >= 0) {
                int result3 = lineStartOffset + (pos + 1) * 1024;
                return DocumentUtil.isInsideSurrogatePair(document, result3) ? result3 - 1 : result3;
            }
            int startOffset = lineStartOffset + (-pos - 1) * 1024;
            int column = pos == -1 ? 0 : this.columnCache[-pos - 2];
            return LogicalPositionCache.calcOffset(document, logicalColumn, column, startOffset, lineEndOffset, tabSize);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "document";
            objectArray2[1] = "com/intellij/openapi/editor/impl/view/LogicalPositionCache$LineData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "offsetToLogicalColumn";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "logicalColumnToOffset";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

