/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.SoftWrapModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CommonProcessors;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IterationState {
    private static final Logger LOG = Logger.getInstance(IterationState.class);
    public static final Comparator<RangeHighlighterEx> BY_LAYER_THEN_ATTRIBUTES = (o1, o2) -> {
        Color back2;
        Color fore2;
        TextAttributes a2;
        int result2 = LayerComparator.INSTANCE.compare((RangeHighlighterEx)o1, (RangeHighlighterEx)o2);
        if (result2 != 0) {
            return result2;
        }
        TextAttributes a1 = o1.getTextAttributes();
        if (a1 == null ^ (a2 = o2.getTextAttributes()) == null) {
            return a1 == null ? 1 : -1;
        }
        if (a1 == null) {
            return result2;
        }
        Color fore1 = a1.getForegroundColor();
        if (fore1 == null ^ (fore2 = a2.getForegroundColor()) == null) {
            return fore1 == null ? 1 : -1;
        }
        Color back1 = a1.getBackgroundColor();
        if (back1 == null ^ (back2 = a2.getBackgroundColor()) == null) {
            return back1 == null ? 1 : -1;
        }
        return result2;
    };
    private static final Comparator<RangeHighlighterEx> BY_AFFECTED_END_OFFSET_REVERSED = (r1, r2) -> r2.getAffectedAreaEndOffset() - r1.getAffectedAreaEndOffset();
    private static final CaretData NULL_CARET_DATA = new CaretData(-1, -1, false, false, ArrayUtilRt.EMPTY_INT_ARRAY, ArrayUtilRt.EMPTY_INT_ARRAY);
    private final TextAttributes myMergedAttributes;
    @Nullable
    private final HighlighterIterator myHighlighterIterator;
    private final HighlighterSweep myView;
    private final HighlighterSweep myDoc;
    private int myStartOffset;
    private int myEndOffset;
    private final int myEnd;
    private int myCurrentSelectionIndex;
    private Color myCurrentBackgroundColor;
    private Color myLastBackgroundColor;
    private final List<RangeHighlighterEx> myCurrentHighlighters;
    private final FoldingModelEx myFoldingModel;
    private final TextAttributes myFoldTextAttributes;
    private FoldRegion myCurrentFold;
    private final TextAttributes mySelectionAttributes;
    private final TextAttributes myCaretRowAttributes;
    private final Color myDefaultBackground;
    private final Color myDefaultForeground;
    private final int myDefaultFontType;
    private final List<TextAttributes> myCachedAttributesList;
    private final DocumentEx myDocument;
    private final EditorEx myEditor;
    private final CaretData myCaretData;
    private final Color myReadOnlyColor;
    private final boolean myUseOnlyFullLineHighlighters;
    private final boolean myReverseIteration;
    private boolean myNextIsFoldRegion;

    public IterationState(@NotNull EditorEx editor, int start, int end, @Nullable CaretData caretData, boolean useOnlyFullLineHighlighters, boolean useOnlyFontOrForegroundAffectingHighlighters, boolean useFoldRegions, boolean iterateBackwards) {
        if (editor == null) {
            IterationState.$$$reportNull$$$0(0);
        }
        this.myMergedAttributes = new TextAttributes();
        this.myCurrentSelectionIndex = 0;
        this.myCurrentHighlighters = new ArrayList<RangeHighlighterEx>();
        this.myCachedAttributesList = new ArrayList<TextAttributes>(5);
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.myDocument = editor.getDocument();
        assert (!DocumentUtil.isInsideSurrogatePair(this.myDocument, start));
        assert (!DocumentUtil.isInsideSurrogatePair(this.myDocument, end));
        this.myStartOffset = start;
        this.myEnd = end;
        this.myEditor = editor;
        this.myUseOnlyFullLineHighlighters = useOnlyFullLineHighlighters;
        this.myReverseIteration = iterateBackwards;
        LOG.assertTrue(this.myReverseIteration ? this.myStartOffset >= this.myEnd : this.myStartOffset <= this.myEnd);
        this.myHighlighterIterator = useOnlyFullLineHighlighters ? null : editor.getHighlighter().createIterator(start);
        this.myCaretData = (CaretData)ObjectUtils.notNull((Object)caretData, (Object)NULL_CARET_DATA);
        this.myFoldingModel = useFoldRegions ? editor.getFoldingModel() : null;
        this.myFoldTextAttributes = useFoldRegions ? this.myFoldingModel.getPlaceholderAttributes() : null;
        this.mySelectionAttributes = editor.getSelectionModel().getTextAttributes();
        this.myReadOnlyColor = this.myEditor.getColorsScheme().getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
        CaretModel caretModel = editor.getCaretModel();
        this.myCaretRowAttributes = editor.isRendererMode() ? null : caretModel.getTextAttributes();
        this.myDefaultBackground = editor.getColorsScheme().getDefaultBackground();
        this.myDefaultForeground = editor.getColorsScheme().getDefaultForeground();
        TextAttributes defaultAttributes = editor.getColorsScheme().getAttributes(HighlighterColors.TEXT);
        this.myDefaultFontType = defaultAttributes == null ? 0 : defaultAttributes.getFontType();
        MarkupModelEx editorMarkup = editor.getMarkupModel();
        this.myView = new HighlighterSweep(editorMarkup, start, this.myEnd, useOnlyFullLineHighlighters, useOnlyFontOrForegroundAffectingHighlighters);
        MarkupModelEx docMarkup = editor.getFilteredDocumentMarkupModel();
        this.myDoc = new HighlighterSweep(docMarkup, start, this.myEnd, useOnlyFullLineHighlighters, useOnlyFontOrForegroundAffectingHighlighters);
        this.myEndOffset = this.myStartOffset;
        this.advance();
    }

    public static CaretData createCaretData(@NotNull EditorEx editor) {
        if (editor == null) {
            IterationState.$$$reportNull$$$0(1);
        }
        DocumentEx document = editor.getDocument();
        CaretModel caretModel = editor.getCaretModel();
        SoftWrapModelEx softWrapModel = editor.getSoftWrapModel();
        int caretRowStart = caretModel.getVisualLineStart();
        int caretRowEnd = caretModel.getVisualLineEnd();
        if (caretRowEnd == document.getTextLength() && document.getLineCount() > 0 && caretRowEnd > document.getLineStartOffset(document.getLineCount() - 1)) {
            ++caretRowEnd;
        }
        boolean caretRowStartsWithSoftWrap = softWrapModel.getSoftWrap(caretRowStart) != null;
        boolean caretRowEndsWithSoftWrap = softWrapModel.getSoftWrap(caretRowEnd) != null;
        List carets = editor.getCaretModel().getAllCarets();
        int caretCount = carets.size();
        int[] selectionStarts = new int[caretCount];
        int[] selectionEnds = new int[caretCount];
        for (int i = 0; i < caretCount; ++i) {
            Caret caret = (Caret)carets.get(i);
            selectionStarts[i] = caret.getSelectionStart();
            selectionEnds[i] = caret.getSelectionEnd();
        }
        return new CaretData(caretRowStart, caretRowEnd, caretRowStartsWithSoftWrap, caretRowEndsWithSoftWrap, selectionStarts, selectionEnds);
    }

    private boolean skipHighlighter(@NotNull RangeHighlighterEx highlighter) {
        FoldRegion region;
        if (highlighter == null) {
            IterationState.$$$reportNull$$$0(2);
        }
        if (!highlighter.isValid() || highlighter.isAfterEndOfLine() || highlighter.getTextAttributes() == null) {
            return true;
        }
        FoldRegion foldRegion = region = this.myFoldingModel == null ? null : this.myFoldingModel.getCollapsedRegionAtOffset(highlighter.getAffectedAreaStartOffset());
        return region != null && region == this.myFoldingModel.getCollapsedRegionAtOffset(highlighter.getAffectedAreaEndOffset());
    }

    public void advance() {
        this.myNextIsFoldRegion = false;
        this.myStartOffset = this.myEndOffset;
        this.advanceSegmentHighlighters();
        this.advanceCurrentSelectionIndex();
        if (!this.myUseOnlyFullLineHighlighters) {
            FoldRegion foldRegion = this.myFoldingModel == null ? null : (this.myCurrentFold = this.myFoldingModel.getCollapsedRegionAtOffset(this.myReverseIteration ? this.myStartOffset - 1 : this.myStartOffset));
        }
        if (this.myCurrentFold != null) {
            int n = this.myEndOffset = this.myReverseIteration ? this.myCurrentFold.getStartOffset() : this.myCurrentFold.getEndOffset();
            assert (!DocumentUtil.isInsideSurrogatePair(this.myDocument, this.myEndOffset));
        } else {
            int highlighterEnd = this.getHighlighterEnd(this.myStartOffset);
            int selectionEnd = this.getSelectionEnd();
            int minSegmentHighlightersEnd = this.getMinSegmentHighlightersEnd();
            int foldRangesEnd = this.getFoldRangesEnd(this.myStartOffset);
            int caretEnd = this.getCaretEnd(this.myStartOffset);
            int guardedBlockEnd = this.getGuardedBlockEnd(this.myStartOffset);
            this.myEndOffset = highlighterEnd;
            this.setEndOffsetIfCloser(selectionEnd);
            this.setEndOffsetIfCloser(minSegmentHighlightersEnd);
            this.setEndOffsetIfCloser(foldRangesEnd);
            this.setEndOffsetIfCloser(caretEnd);
            this.setEndOffsetIfCloser(guardedBlockEnd);
            boolean bl = this.myNextIsFoldRegion = this.myEndOffset == foldRangesEnd && this.myEndOffset < this.myEnd;
            assert (!DocumentUtil.isInsideSurrogatePair(this.myDocument, this.myEndOffset)) : "caret: " + DocumentUtil.isInsideSurrogatePair(this.myDocument, caretEnd) + ", selection: " + DocumentUtil.isInsideSurrogatePair(this.myDocument, selectionEnd) + ", guarded block: " + DocumentUtil.isInsideSurrogatePair(this.myDocument, guardedBlockEnd) + ", folding: " + DocumentUtil.isInsideSurrogatePair(this.myDocument, foldRangesEnd) + ", lexer: " + DocumentUtil.isInsideSurrogatePair(this.myDocument, highlighterEnd) + ", highlighters: " + DocumentUtil.isInsideSurrogatePair(this.myDocument, minSegmentHighlightersEnd);
        }
        this.reinit();
    }

    private void setEndOffsetIfCloser(int offset) {
        if (this.myReverseIteration ? offset > this.myEndOffset : offset < this.myEndOffset) {
            this.myEndOffset = offset;
        }
    }

    private int getHighlighterEnd(int start) {
        if (this.myHighlighterIterator == null) {
            return this.myEnd;
        }
        while (!this.myHighlighterIterator.atEnd()) {
            int end = this.alignOffset(this.myReverseIteration ? this.myHighlighterIterator.getStart() : this.myHighlighterIterator.getEnd());
            if (this.myReverseIteration ? end < start : end > start) {
                return end;
            }
            if (this.myReverseIteration) {
                this.myHighlighterIterator.retreat();
                continue;
            }
            this.myHighlighterIterator.advance();
        }
        return this.myEnd;
    }

    private int getCaretEnd(int start) {
        return this.getNearestValueAhead(start, this.myCaretData.caretRowStart, this.myCaretData.caretRowEnd);
    }

    private int getNearestValueAhead(int offset, int rangeStart, int rangeEnd) {
        if (this.myReverseIteration) {
            if (rangeEnd < offset) {
                return rangeEnd;
            }
            if (rangeStart < offset) {
                return rangeStart;
            }
        } else {
            if (rangeStart > offset) {
                return rangeStart;
            }
            if (rangeEnd > offset) {
                return rangeEnd;
            }
        }
        return this.myEnd;
    }

    private int getGuardedBlockEnd(int start) {
        if (this.myUseOnlyFullLineHighlighters) {
            return this.myEnd;
        }
        List<RangeMarker> blocks = this.myDocument.getGuardedBlocks();
        int result2 = this.myEnd;
        for (int i = 0; i < blocks.size(); ++i) {
            RangeMarker block = blocks.get(i);
            int nearestValue = this.getNearestValueAhead(start, this.alignOffset(block.getStartOffset()), this.alignOffset(block.getEndOffset()));
            result2 = this.myReverseIteration ? Math.max(result2, nearestValue) : Math.min(result2, nearestValue);
        }
        return result2;
    }

    private void advanceCurrentSelectionIndex() {
        while (this.myCurrentSelectionIndex < this.myCaretData.selectionsSize() && (this.myReverseIteration ? this.myStartOffset <= this.myCaretData.selectionStart(this.myCurrentSelectionIndex, true) : this.myStartOffset >= this.myCaretData.selectionEnd(this.myCurrentSelectionIndex, false))) {
            ++this.myCurrentSelectionIndex;
        }
    }

    private int getSelectionEnd() {
        if (this.myCurrentSelectionIndex >= this.myCaretData.selectionsSize()) {
            return this.myEnd;
        }
        return this.getNearestValueAhead(this.myStartOffset, this.myCaretData.selectionStart(this.myCurrentSelectionIndex, this.myReverseIteration), this.myCaretData.selectionEnd(this.myCurrentSelectionIndex, this.myReverseIteration));
    }

    private boolean isInSelection(boolean atBreak) {
        return this.myCurrentSelectionIndex < this.myCaretData.selectionsSize() && (this.myReverseIteration ? IterationState.lessThan(this.myStartOffset, this.myCaretData.selectionEnd(this.myCurrentSelectionIndex, true), !atBreak) : IterationState.lessThan(this.myCaretData.selectionStart(this.myCurrentSelectionIndex, false), this.myStartOffset, !atBreak));
    }

    private static boolean lessThan(int x, int y, boolean orEquals) {
        return x < y || orEquals && x == y;
    }

    private void advanceSegmentHighlighters() {
        this.myDoc.advance();
        this.myView.advance();
        boolean fileEnd = this.myStartOffset == this.myDocument.getTextLength();
        for (int i = this.myCurrentHighlighters.size() - 1; i >= 0; --i) {
            RangeHighlighterEx highlighter = this.myCurrentHighlighters.get(i);
            if (!(this.myReverseIteration ? this.getAlignedStartOffset(highlighter) >= this.myStartOffset : (fileEnd && highlighter.getTargetArea() == HighlighterTargetArea.LINES_IN_RANGE ? this.getAlignedEndOffset(highlighter) < this.myStartOffset : this.getAlignedEndOffset(highlighter) <= this.myStartOffset))) continue;
            this.myCurrentHighlighters.remove(i);
        }
    }

    private int getFoldRangesEnd(int startOffset) {
        int end;
        block7: {
            if (this.myUseOnlyFullLineHighlighters || this.myFoldingModel == null) {
                return this.myEnd;
            }
            end = this.myEnd;
            FoldRegion[] topLevelCollapsed = this.myFoldingModel.fetchTopLevel();
            if (topLevelCollapsed == null) break block7;
            if (this.myReverseIteration) {
                for (int i = this.myFoldingModel.getLastCollapsedRegionBefore(startOffset); i >= 0 && i < topLevelCollapsed.length; --i) {
                    int rangeEnd;
                    FoldRegion range2 = topLevelCollapsed[i];
                    if (!range2.isValid() || (rangeEnd = range2.getEndOffset()) >= startOffset) continue;
                    if (rangeEnd > end) {
                        end = rangeEnd;
                        continue;
                    }
                    break;
                }
            } else {
                for (int i = this.myFoldingModel.getLastCollapsedRegionBefore(startOffset) + 1; i >= 0 && i < topLevelCollapsed.length; ++i) {
                    int rangeEnd;
                    FoldRegion range3 = topLevelCollapsed[i];
                    if (!range3.isValid() || (rangeEnd = range3.getStartOffset()) <= startOffset) continue;
                    if (rangeEnd < end) {
                        end = rangeEnd;
                        continue;
                    }
                    break;
                }
            }
        }
        return end;
    }

    private int getMinSegmentHighlightersEnd() {
        int end = this.myEnd;
        for (int i = 0; i < this.myCurrentHighlighters.size(); ++i) {
            RangeHighlighterEx highlighter = this.myCurrentHighlighters.get(i);
            end = this.myReverseIteration ? Math.max(end, this.getAlignedStartOffset(highlighter)) : Math.min(end, this.getAlignedEndOffset(highlighter));
        }
        end = this.myReverseIteration ? Math.max(end, this.myDoc.getMinSegmentHighlighterEnd()) : Math.min(end, this.myDoc.getMinSegmentHighlighterEnd());
        end = this.myReverseIteration ? Math.max(end, this.myView.getMinSegmentHighlighterEnd()) : Math.min(end, this.myView.getMinSegmentHighlighterEnd());
        return end;
    }

    private void reinit() {
        this.setAttributes(this.myMergedAttributes, false);
        this.myLastBackgroundColor = this.myCurrentBackgroundColor;
        this.myCurrentBackgroundColor = this.myMergedAttributes.getBackgroundColor();
    }

    public TextAttributes getBreakAttributes() {
        TextAttributes attributes = new TextAttributes();
        this.setAttributes(attributes, true);
        return attributes;
    }

    private void setAttributes(TextAttributes attributes, boolean atBreak) {
        boolean isInSelection = this.isInSelection(atBreak);
        boolean isInCaretRow = this.isInCaretRow(!this.myReverseIteration, this.myReverseIteration);
        boolean isInGuardedBlock = false;
        if (!this.myUseOnlyFullLineHighlighters) {
            RangeMarker guard = this.myDocument.getOffsetGuard(this.myReverseIteration ? this.myStartOffset - 1 : this.myStartOffset);
            boolean bl = guard != null && (!atBreak || this.myReverseIteration ? guard.getEndOffset() > this.myStartOffset : guard.getStartOffset() < this.myStartOffset) ? true : (isInGuardedBlock = false);
        }
        TextAttributes syntax = this.myHighlighterIterator == null || this.myHighlighterIterator.atEnd() ? null : (atBreak && this.myStartOffset == (this.myReverseIteration ? this.myHighlighterIterator.getEnd() : this.myHighlighterIterator.getStart()) ? null : this.myHighlighterIterator.getTextAttributes());
        TextAttributes selection = isInSelection ? this.mySelectionAttributes : null;
        TextAttributes caret = isInCaretRow ? this.myCaretRowAttributes : null;
        TextAttributes fold2 = this.myCurrentFold != null ? this.myFoldTextAttributes : null;
        TextAttributes guard = isInGuardedBlock ? new TextAttributes(null, this.myReadOnlyColor, null, EffectType.BOXED, 0) : null;
        int size = this.myCurrentHighlighters.size();
        if (size > 1) {
            ContainerUtil.quickSort(this.myCurrentHighlighters, BY_LAYER_THEN_ATTRIBUTES);
        }
        for (int i = 0; i < size; ++i) {
            RangeHighlighterEx highlighter = this.myCurrentHighlighters.get(i);
            if (highlighter.getTextAttributes() != TextAttributes.ERASE_MARKER) continue;
            syntax = null;
        }
        List<TextAttributes> cachedAttributes = this.myCachedAttributesList;
        if (!cachedAttributes.isEmpty()) {
            cachedAttributes.clear();
        }
        for (int i = 0; i < size; ++i) {
            TextAttributes textAttributes;
            RangeHighlighterEx highlighter = this.myCurrentHighlighters.get(i);
            if (atBreak && highlighter.getTargetArea() == HighlighterTargetArea.EXACT_RANGE && this.myStartOffset == (this.myReverseIteration ? highlighter.getEndOffset() : highlighter.getStartOffset())) continue;
            if (highlighter.getLayer() < 6000 && selection != null) {
                cachedAttributes.add(selection);
                selection = null;
            }
            if (fold2 != null && highlighter.getLayer() < 3500) {
                cachedAttributes.add(fold2);
                fold2 = null;
            }
            if (guard != null && highlighter.getLayer() < 3500) {
                cachedAttributes.add(guard);
                guard = null;
            }
            if (caret != null && highlighter.getLayer() < 2000) {
                cachedAttributes.add(caret);
                caret = null;
            }
            if (syntax != null && highlighter.getLayer() < 1000) {
                cachedAttributes.add(syntax);
                syntax = null;
            }
            if ((textAttributes = highlighter.getTextAttributes()) == null || textAttributes == TextAttributes.ERASE_MARKER) continue;
            cachedAttributes.add(textAttributes);
        }
        if (selection != null) {
            cachedAttributes.add(selection);
        }
        if (fold2 != null) {
            cachedAttributes.add(fold2);
        }
        if (guard != null) {
            cachedAttributes.add(guard);
        }
        if (caret != null) {
            cachedAttributes.add(caret);
        }
        if (syntax != null) {
            cachedAttributes.add(syntax);
        }
        Color fore = null;
        Color back = isInGuardedBlock ? this.myReadOnlyColor : null;
        Color effect = null;
        EffectType effectType = null;
        int fontType = 0;
        for (int i = 0; i < cachedAttributes.size(); ++i) {
            TextAttributes attrs = cachedAttributes.get(i);
            if (fore == null) {
                fore = attrs.getForegroundColor();
            }
            if (back == null) {
                back = attrs.getBackgroundColor();
            }
            if (fontType == 0) {
                fontType = attrs.getFontType();
            }
            if (effect != null) continue;
            effect = attrs.getEffectColor();
            effectType = attrs.getEffectType();
        }
        if (fore == null) {
            fore = this.myDefaultForeground;
        }
        if (back == null) {
            back = this.myDefaultBackground;
        }
        if (effectType == null) {
            effectType = EffectType.BOXED;
        }
        if (fontType == 0) {
            fontType = this.myDefaultFontType;
        }
        attributes.setAttributes(fore, back, effect, null, effectType, fontType);
    }

    private boolean isInCaretRow(boolean includeLineStart, boolean includeLineEnd) {
        return this.myStartOffset > this.myCaretData.caretRowStart && this.myStartOffset < this.myCaretData.caretRowEnd || includeLineStart && this.myStartOffset == this.myCaretData.caretRowStart || includeLineEnd && this.myStartOffset == this.myCaretData.caretRowEnd;
    }

    public boolean atEnd() {
        return this.myReverseIteration ? this.myStartOffset <= this.myEnd : this.myStartOffset >= this.myEnd;
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    @NotNull
    public TextAttributes getMergedAttributes() {
        TextAttributes textAttributes = this.myMergedAttributes;
        if (textAttributes == null) {
            IterationState.$$$reportNull$$$0(3);
        }
        return textAttributes;
    }

    public FoldRegion getCurrentFold() {
        return this.myCurrentFold;
    }

    public boolean nextIsFoldRegion() {
        return this.myNextIsFoldRegion;
    }

    @NotNull
    public TextAttributes getPastLineEndBackgroundAttributes() {
        this.myMergedAttributes.setBackgroundColor(this.hasSoftWrap() ? this.getBreakBackgroundColor(true) : (this.isEditorRightAligned() && this.myLastBackgroundColor != null ? this.myLastBackgroundColor : this.myCurrentBackgroundColor));
        TextAttributes textAttributes = this.myMergedAttributes;
        if (textAttributes == null) {
            IterationState.$$$reportNull$$$0(4);
        }
        return textAttributes;
    }

    @NotNull
    public TextAttributes getBeforeLineStartBackgroundAttributes() {
        TextAttributes textAttributes = this.isEditorRightAligned() && !this.hasSoftWrap() ? this.getBreakAttributes() : new TextAttributes(null, this.getBreakBackgroundColor(false), null, null, 0);
        if (textAttributes == null) {
            IterationState.$$$reportNull$$$0(5);
        }
        return textAttributes;
    }

    private Color getBreakBackgroundColor(boolean lineEnd) {
        return Comparing.equal((Object)this.myCurrentBackgroundColor, (Object)this.myLastBackgroundColor) ? this.myCurrentBackgroundColor : (this.isInCaretRow(!this.myCaretData.caretRowStartsWithSoftWrap || !lineEnd, this.myCaretData.caretRowEndsWithSoftWrap && lineEnd) && this.myCaretRowAttributes != null ? this.myCaretRowAttributes.getBackgroundColor() : this.myDefaultBackground);
    }

    private boolean hasSoftWrap() {
        return this.myEditor.getSoftWrapModel().getSoftWrap(this.myStartOffset) != null;
    }

    private int alignOffset(int offset) {
        return DocumentUtil.alignToCodePointBoundary(this.myDocument, offset);
    }

    private int getAlignedStartOffset(RangeHighlighterEx highlighter) {
        return this.alignOffset(highlighter.getAffectedAreaStartOffset());
    }

    private int getAlignedEndOffset(RangeHighlighterEx highlighter) {
        return this.alignOffset(highlighter.getAffectedAreaEndOffset());
    }

    private boolean isEditorRightAligned() {
        return this.myEditor instanceof EditorImpl && ((EditorImpl)this.myEditor).isRightAligned();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/view/IterationState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/view/IterationState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedAttributes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPastLineEndBackgroundAttributes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeLineStartBackgroundAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createCaretData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "skipHighlighter";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CaretData {
        private final int caretRowStart;
        private final int caretRowEnd;
        private final boolean caretRowStartsWithSoftWrap;
        private final boolean caretRowEndsWithSoftWrap;
        private final int[] selectionStarts;
        private final int[] selectionEnds;

        private CaretData(int caretRowStart, int caretRowEnd, boolean caretRowStartsWithSoftWrap, boolean caretRowEndsWithSoftWrap, int[] selectionStarts, int[] selectionEnds) {
            this.caretRowStart = caretRowStart;
            this.caretRowEnd = caretRowEnd;
            this.caretRowStartsWithSoftWrap = caretRowStartsWithSoftWrap;
            this.caretRowEndsWithSoftWrap = caretRowEndsWithSoftWrap;
            this.selectionStarts = selectionStarts;
            this.selectionEnds = selectionEnds;
        }

        private int selectionsSize() {
            return this.selectionStarts.length;
        }

        private int selectionStart(int index, boolean reverse) {
            return this.selectionStarts[reverse ? this.selectionStarts.length - 1 - index : index];
        }

        private int selectionEnd(int index, boolean reverse) {
            return this.selectionEnds[reverse ? this.selectionStarts.length - 1 - index : index];
        }
    }

    private static class LayerComparator
    implements Comparator<RangeHighlighterEx> {
        private static final LayerComparator INSTANCE = new LayerComparator();

        private LayerComparator() {
        }

        @Override
        public int compare(RangeHighlighterEx o1, RangeHighlighterEx o2) {
            int layerDiff = o2.getLayer() - o1.getLayer();
            if (layerDiff != 0) {
                return layerDiff;
            }
            int o1Length = o1.getAffectedAreaEndOffset() - o1.getAffectedAreaStartOffset();
            int o2Length = o2.getAffectedAreaEndOffset() - o2.getAffectedAreaStartOffset();
            return o1Length - o2Length;
        }
    }

    private class HighlighterSweep {
        private RangeHighlighterEx myNextHighlighter;
        int i;
        private final RangeHighlighterEx[] highlighters;

        private HighlighterSweep(MarkupModelEx markupModel, int start, int end, final boolean onlyFullLine, final boolean onlyFontOrForegroundAffecting) {
            if (markupModel == null) {
                HighlighterSweep.$$$reportNull$$$0(0);
            }
            ArrayList list2 = new ArrayList();
            markupModel.processRangeHighlightersOverlappingWith(IterationState.this.myReverseIteration ? end : start, IterationState.this.myReverseIteration ? start : end, (Processor<? super RangeHighlighterEx>)new CommonProcessors.CollectProcessor<RangeHighlighterEx>(list2){

                protected boolean accept(RangeHighlighterEx ex) {
                    return !(onlyFullLine && ex.getTargetArea() != HighlighterTargetArea.LINES_IN_RANGE || onlyFontOrForegroundAffecting && !EditorUtil.attributesImpactFontStyleOrColor(ex.getTextAttributes()));
                }
            });
            this.highlighters = list2.isEmpty() ? RangeHighlighterEx.EMPTY_ARRAY : list2.toArray(RangeHighlighterEx.EMPTY_ARRAY);
            Arrays.sort(this.highlighters, IterationState.this.myReverseIteration ? BY_AFFECTED_END_OFFSET_REVERSED : RangeHighlighterEx.BY_AFFECTED_START_OFFSET);
            while (this.i < this.highlighters.length) {
                RangeHighlighterEx highlighter;
                if (IterationState.this.skipHighlighter(highlighter = this.highlighters[this.i++])) continue;
                this.myNextHighlighter = highlighter;
                break;
            }
        }

        private void advance() {
            if (this.myNextHighlighter != null) {
                if (IterationState.this.myReverseIteration ? IterationState.this.getAlignedEndOffset(this.myNextHighlighter) < IterationState.this.myStartOffset : IterationState.this.getAlignedStartOffset(this.myNextHighlighter) > IterationState.this.myStartOffset) {
                    return;
                }
                IterationState.this.myCurrentHighlighters.add(this.myNextHighlighter);
                this.myNextHighlighter = null;
            }
            while (this.i < this.highlighters.length) {
                RangeHighlighterEx highlighter;
                if (IterationState.this.skipHighlighter(highlighter = this.highlighters[this.i++])) continue;
                if (IterationState.this.myReverseIteration ? IterationState.this.getAlignedEndOffset(highlighter) < IterationState.this.myStartOffset : IterationState.this.getAlignedStartOffset(highlighter) > IterationState.this.myStartOffset) {
                    this.myNextHighlighter = highlighter;
                    break;
                }
                IterationState.this.myCurrentHighlighters.add(highlighter);
            }
        }

        private int getMinSegmentHighlighterEnd() {
            if (this.myNextHighlighter != null) {
                return IterationState.this.myReverseIteration ? IterationState.this.getAlignedEndOffset(this.myNextHighlighter) : IterationState.this.getAlignedStartOffset(this.myNextHighlighter);
            }
            return IterationState.this.myReverseIteration ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markupModel", "com/intellij/openapi/editor/impl/view/IterationState$HighlighterSweep", "<init>"));
        }
    }
}

