/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.DataManager;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.CommandMerger;
import com.intellij.openapi.command.impl.CurrentEditorProvider;
import com.intellij.openapi.command.impl.DocumentUndoProvider;
import com.intellij.openapi.command.impl.DummyProject;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.FocusBasedCurrentEditorProvider;
import com.intellij.openapi.command.impl.MentionOnlyUndoableAction;
import com.intellij.openapi.command.impl.NonUndoableAction;
import com.intellij.openapi.command.impl.UndoProvider;
import com.intellij.openapi.command.impl.UndoRedoStacksHolder;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.DocumentReferenceProvider;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.util.ObjectUtils;
import gnu.trove.THashSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UndoManagerImpl
extends UndoManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.command.impl.UndoManagerImpl");
    public static boolean ourNeverAskUser;
    private static final int COMMANDS_TO_KEEP_LIVE_QUEUES = 100;
    private static final int COMMAND_TO_RUN_COMPACT = 20;
    private static final int FREE_QUEUES_LIMIT = 30;
    @Nullable
    private final ProjectEx myProject;
    private final CommandProcessor myCommandProcessor;
    private UndoProvider[] myUndoProviders;
    private CurrentEditorProvider myEditorProvider;
    private final UndoRedoStacksHolder myUndoStacksHolder = new UndoRedoStacksHolder(true);
    private final UndoRedoStacksHolder myRedoStacksHolder = new UndoRedoStacksHolder(false);
    private final CommandMerger myMerger;
    private CommandMerger myCurrentMerger;
    private Project myCurrentActionProject = DummyProject.getInstance();
    private int myCommandTimestamp = 1;
    private int myCommandLevel;
    private OperationState myCurrentOperationState = OperationState.NONE;
    private DocumentReference myOriginatorReference;

    public static boolean isRefresh() {
        return ApplicationManager.getApplication().hasWriteAction(ExternalChangeAction.class);
    }

    public static int getGlobalUndoLimit() {
        return Registry.intValue((String)"undo.globalUndoLimit");
    }

    public static int getDocumentUndoLimit() {
        return Registry.intValue((String)"undo.documentUndoLimit");
    }

    public UndoManagerImpl(CommandProcessor commandProcessor) {
        this(null, commandProcessor);
    }

    public UndoManagerImpl(@Nullable ProjectEx project, CommandProcessor commandProcessor) {
        this.myProject = project;
        this.myCommandProcessor = commandProcessor;
        if (this.myProject == null || !this.myProject.isDefault()) {
            this.runStartupActivity();
        }
        this.myMerger = new CommandMerger(this);
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public void dispose() {
    }

    private void runStartupActivity() {
        this.myEditorProvider = new FocusBasedCurrentEditorProvider();
        this.myCommandProcessor.addCommandListener(new CommandListener(){
            private boolean myStarted;

            public void commandStarted(CommandEvent event) {
                if (UndoManagerImpl.this.myProject != null && UndoManagerImpl.this.myProject.isDisposed() || this.myStarted) {
                    return;
                }
                UndoManagerImpl.this.onCommandStarted(event.getProject(), event.getUndoConfirmationPolicy(), event.shouldRecordActionForOriginalDocument());
            }

            public void commandFinished(CommandEvent event) {
                if (UndoManagerImpl.this.myProject != null && UndoManagerImpl.this.myProject.isDisposed() || this.myStarted) {
                    return;
                }
                UndoManagerImpl.this.onCommandFinished(event.getProject(), event.getCommandName(), event.getCommandGroupId());
            }

            public void undoTransparentActionStarted() {
                if (UndoManagerImpl.this.myProject != null && UndoManagerImpl.this.myProject.isDisposed()) {
                    return;
                }
                if (!UndoManagerImpl.this.isInsideCommand()) {
                    this.myStarted = true;
                    UndoManagerImpl.this.onCommandStarted(UndoManagerImpl.this.myProject, UndoConfirmationPolicy.DEFAULT, true);
                }
            }

            public void undoTransparentActionFinished() {
                if (UndoManagerImpl.this.myProject != null && UndoManagerImpl.this.myProject.isDisposed()) {
                    return;
                }
                if (this.myStarted) {
                    this.myStarted = false;
                    UndoManagerImpl.this.onCommandFinished(UndoManagerImpl.this.myProject, "", null);
                }
            }
        }, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)new DocumentUndoProvider(this.myProject));
        for (UndoProvider undoProvider : this.myUndoProviders = this.myProject == null ? (UndoProvider[])Extensions.getExtensions(UndoProvider.EP_NAME) : (UndoProvider[])Extensions.getExtensions(UndoProvider.PROJECT_EP_NAME, (AreaInstance)this.myProject)) {
            if (!(undoProvider instanceof Disposable)) continue;
            Disposer.register((Disposable)this, (Disposable)((Disposable)undoProvider));
        }
    }

    public boolean isActive() {
        return Comparing.equal((Object)this.myProject, (Object)this.myCurrentActionProject);
    }

    private boolean isInsideCommand() {
        return this.myCommandLevel > 0;
    }

    private void onCommandStarted(Project project, UndoConfirmationPolicy undoConfirmationPolicy, boolean recordOriginalReference) {
        if (this.myCommandLevel == 0) {
            for (UndoProvider undoProvider : this.myUndoProviders) {
                undoProvider.commandStarted(project);
            }
            this.myCurrentActionProject = project;
        }
        this.commandStarted(undoConfirmationPolicy, this.myProject == project && recordOriginalReference);
        LOG.assertTrue(this.myCommandLevel == 0 || !(this.myCurrentActionProject instanceof DummyProject));
    }

    private void onCommandFinished(Project project, String commandName, Object commandGroupId) {
        this.commandFinished(commandName, commandGroupId);
        if (this.myCommandLevel == 0) {
            for (UndoProvider undoProvider : this.myUndoProviders) {
                undoProvider.commandFinished(project);
            }
            this.myCurrentActionProject = DummyProject.getInstance();
        }
        LOG.assertTrue(this.myCommandLevel == 0 || !(this.myCurrentActionProject instanceof DummyProject));
    }

    private void commandStarted(UndoConfirmationPolicy undoConfirmationPolicy, boolean recordOriginalReference) {
        if (this.myCommandLevel == 0) {
            this.myCurrentMerger = new CommandMerger(this, CommandProcessor.getInstance().isUndoTransparentActionInProgress());
            if (recordOriginalReference && this.myProject != null) {
                Editor editor = null;
                Application application = ApplicationManager.getApplication();
                if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
                    editor = (Editor)CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext());
                } else {
                    Component component = WindowManagerEx.getInstanceEx().getFocusedComponent(this.myProject);
                    if (component != null) {
                        editor = (Editor)CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext(component));
                    }
                }
                if (editor != null) {
                    Document document = editor.getDocument();
                    VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
                    if (file2 != null && file2.isValid()) {
                        this.myOriginatorReference = DocumentReferenceManager.getInstance().create(file2);
                    }
                }
            }
        }
        LOG.assertTrue(this.myCurrentMerger != null, (Object)String.valueOf(this.myCommandLevel));
        this.myCurrentMerger.setBeforeState(this.getCurrentState());
        this.myCurrentMerger.mergeUndoConfirmationPolicy(undoConfirmationPolicy);
        ++this.myCommandLevel;
    }

    private void commandFinished(String commandName, Object groupId) {
        if (this.myCommandLevel == 0) {
            return;
        }
        --this.myCommandLevel;
        if (this.myCommandLevel > 0) {
            return;
        }
        if (this.myProject != null && this.myCurrentMerger.hasActions() && !this.myCurrentMerger.isTransparent() && this.myCurrentMerger.isPhysical()) {
            this.addFocusedDocumentAsAffected();
        }
        this.myOriginatorReference = null;
        this.myCurrentMerger.setAfterState(this.getCurrentState());
        this.myMerger.commandFinished(commandName, groupId, this.myCurrentMerger);
        this.disposeCurrentMerger();
    }

    private void addFocusedDocumentAsAffected() {
        if (this.myOriginatorReference == null || this.myCurrentMerger.hasChangesOf(this.myOriginatorReference, true)) {
            return;
        }
        DocumentReference[] refs = new DocumentReference[]{this.myOriginatorReference};
        this.myCurrentMerger.addAction(new MentionOnlyUndoableAction(refs));
    }

    private EditorAndState getCurrentState() {
        FileEditor editor = this.myEditorProvider.getCurrentEditor();
        if (editor == null) {
            return null;
        }
        if (!editor.isValid()) {
            return null;
        }
        return new EditorAndState(editor, editor.getState(FileEditorStateLevel.UNDO));
    }

    private void disposeCurrentMerger() {
        LOG.assertTrue(this.myCommandLevel == 0);
        if (this.myCurrentMerger != null) {
            this.myCurrentMerger = null;
        }
    }

    public void nonundoableActionPerformed(@NotNull DocumentReference ref, boolean isGlobal) {
        if (ref == null) {
            UndoManagerImpl.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject != null && this.myProject.isDisposed()) {
            return;
        }
        this.undoableActionPerformed(new NonUndoableAction(ref, isGlobal));
    }

    public void undoableActionPerformed(@NotNull UndoableAction action) {
        if (action == null) {
            UndoManagerImpl.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject != null && this.myProject.isDisposed()) {
            return;
        }
        if (this.myCurrentOperationState != OperationState.NONE) {
            return;
        }
        if (this.myCommandLevel == 0) {
            LOG.assertTrue(action instanceof NonUndoableAction, (Object)"Undoable actions allowed inside commands only (see com.intellij.openapi.command.CommandProcessor.executeCommand())");
            this.commandStarted(UndoConfirmationPolicy.DEFAULT, false);
            this.myCurrentMerger.addAction(action);
            this.commandFinished("", null);
            return;
        }
        if (UndoManagerImpl.isRefresh()) {
            this.myOriginatorReference = null;
        }
        this.myCurrentMerger.addAction(action);
    }

    public void markCurrentCommandAsGlobal() {
        this.myCurrentMerger.markAsGlobal();
    }

    void addAffectedDocuments(Document ... docs) {
        if (docs == null) {
            UndoManagerImpl.$$$reportNull$$$0(2);
        }
        if (!this.isInsideCommand()) {
            LOG.error("Must be called inside command");
            return;
        }
        ArrayList<DocumentReference> refs = new ArrayList<DocumentReference>(docs.length);
        for (Document each : docs) {
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(each);
            if (file2 != null && !file2.isValid()) continue;
            refs.add(DocumentReferenceManager.getInstance().create(each));
        }
        this.myCurrentMerger.addAdditionalAffectedDocuments(refs);
    }

    public void addAffectedFiles(VirtualFile ... files2) {
        if (files2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(3);
        }
        if (!this.isInsideCommand()) {
            LOG.error("Must be called inside command");
            return;
        }
        ArrayList<DocumentReference> refs = new ArrayList<DocumentReference>(files2.length);
        for (VirtualFile each : files2) {
            refs.add(DocumentReferenceManager.getInstance().create(each));
        }
        this.myCurrentMerger.addAdditionalAffectedDocuments(refs);
    }

    public void invalidateActionsFor(@NotNull DocumentReference ref) {
        if (ref == null) {
            UndoManagerImpl.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myMerger.invalidateActionsFor(ref);
        if (this.myCurrentMerger != null) {
            this.myCurrentMerger.invalidateActionsFor(ref);
        }
        this.myUndoStacksHolder.invalidateActionsFor(ref);
        this.myRedoStacksHolder.invalidateActionsFor(ref);
    }

    public void undo(@Nullable FileEditor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(this.isUndoAvailable(editor));
        this.undoOrRedo(editor, true);
    }

    public void redo(@Nullable FileEditor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(this.isRedoAvailable(editor));
        this.undoOrRedo(editor, false);
    }

    private void undoOrRedo(FileEditor editor, boolean isUndo) {
        this.myCurrentOperationState = isUndo ? OperationState.UNDO : OperationState.REDO;
        RuntimeException[] exception = new RuntimeException[1];
        Runnable executeUndoOrRedoAction = () -> {
            try {
                CopyPasteManager.getInstance().stopKillRings();
                this.myMerger.undoOrRedo(editor, isUndo);
            }
            catch (RuntimeException ex) {
                exception[0] = ex;
            }
            finally {
                this.myCurrentOperationState = OperationState.NONE;
            }
        };
        String name = (String)this.getUndoOrRedoActionNameAndDescription((FileEditor)editor, (boolean)this.isUndoInProgress()).second;
        CommandProcessor.getInstance().executeCommand((Project)this.myProject, executeUndoOrRedoAction, name, null, this.myMerger.getUndoConfirmationPolicy());
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    public boolean isUndoInProgress() {
        return this.myCurrentOperationState == OperationState.UNDO;
    }

    public boolean isRedoInProgress() {
        return this.myCurrentOperationState == OperationState.REDO;
    }

    public boolean isUndoAvailable(@Nullable FileEditor editor) {
        return this.isUndoOrRedoAvailable(editor, true);
    }

    public boolean isRedoAvailable(@Nullable FileEditor editor) {
        return this.isUndoOrRedoAvailable(editor, false);
    }

    boolean isUndoOrRedoAvailable(@Nullable FileEditor editor, boolean undo) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Collection<DocumentReference> refs = UndoManagerImpl.getDocRefs(editor);
        return refs != null && this.isUndoOrRedoAvailable(refs, undo);
    }

    boolean isUndoOrRedoAvailable(@NotNull DocumentReference ref) {
        Set<DocumentReference> refs;
        if (ref == null) {
            UndoManagerImpl.$$$reportNull$$$0(5);
        }
        return this.isUndoOrRedoAvailable(refs = Collections.singleton(ref), true) || this.isUndoOrRedoAvailable(refs, false);
    }

    private boolean isUndoOrRedoAvailable(@NotNull Collection<DocumentReference> refs, boolean isUndo) {
        if (refs == null) {
            UndoManagerImpl.$$$reportNull$$$0(6);
        }
        if (isUndo && this.myMerger.isUndoAvailable(refs)) {
            return true;
        }
        UndoRedoStacksHolder stackHolder = this.getStackHolder(isUndo);
        return stackHolder.canBeUndoneOrRedone(refs);
    }

    private static Collection<DocumentReference> getDocRefs(@Nullable FileEditor editor) {
        if (editor instanceof TextEditor && ((TextEditor)editor).getEditor().isViewer()) {
            return null;
        }
        if (editor == null) {
            return Collections.emptyList();
        }
        return UndoManagerImpl.getDocumentReferences(editor);
    }

    @NotNull
    static Set<DocumentReference> getDocumentReferences(@NotNull FileEditor editor) {
        if (editor == null) {
            UndoManagerImpl.$$$reportNull$$$0(7);
        }
        THashSet result2 = new THashSet();
        if (editor instanceof DocumentReferenceProvider) {
            result2.addAll(((DocumentReferenceProvider)editor).getDocumentReferences());
            THashSet tHashSet = result2;
            if (tHashSet == null) {
                UndoManagerImpl.$$$reportNull$$$0(8);
            }
            return tHashSet;
        }
        Document[] documents = TextEditorProvider.getDocuments(editor);
        if (documents != null) {
            for (Document each : documents) {
                Document original = UndoManagerImpl.getOriginal(each);
                VirtualFile f = FileDocumentManager.getInstance().getFile(each);
                if (f != null && !f.isValid()) continue;
                result2.add(DocumentReferenceManager.getInstance().create(original));
            }
        }
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            UndoManagerImpl.$$$reportNull$$$0(9);
        }
        return tHashSet;
    }

    @NotNull
    private UndoRedoStacksHolder getStackHolder(boolean isUndo) {
        UndoRedoStacksHolder undoRedoStacksHolder = isUndo ? this.myUndoStacksHolder : this.myRedoStacksHolder;
        if (undoRedoStacksHolder == null) {
            UndoManagerImpl.$$$reportNull$$$0(10);
        }
        return undoRedoStacksHolder;
    }

    @NotNull
    public Pair<String, String> getUndoActionNameAndDescription(FileEditor editor) {
        Pair<String, String> pair = this.getUndoOrRedoActionNameAndDescription(editor, true);
        if (pair == null) {
            UndoManagerImpl.$$$reportNull$$$0(11);
        }
        return pair;
    }

    @NotNull
    public Pair<String, String> getRedoActionNameAndDescription(FileEditor editor) {
        Pair<String, String> pair = this.getUndoOrRedoActionNameAndDescription(editor, false);
        if (pair == null) {
            UndoManagerImpl.$$$reportNull$$$0(12);
        }
        return pair;
    }

    @NotNull
    private Pair<String, String> getUndoOrRedoActionNameAndDescription(FileEditor editor, boolean undo) {
        String desc;
        String string = desc = this.isUndoOrRedoAvailable(editor, undo) ? this.doFormatAvailableUndoRedoAction(editor, undo) : null;
        if (desc == null) {
            desc = "";
        }
        String shortActionName = StringUtil.first((String)desc, (int)30, (boolean)true);
        if (desc.isEmpty()) {
            desc = undo ? ActionsBundle.message((String)"action.undo.description.empty", (Object[])new Object[0]) : ActionsBundle.message((String)"action.redo.description.empty", (Object[])new Object[0]);
        }
        Pair pair = Pair.create((Object)(undo ? ActionsBundle.message((String)"action.undo.text", (Object[])new Object[]{shortActionName}) : ActionsBundle.message((String)"action.redo.text", (Object[])new Object[]{shortActionName})).trim(), (Object)(undo ? ActionsBundle.message((String)"action.undo.description", (Object[])new Object[]{desc}) : ActionsBundle.message((String)"action.redo.description", (Object[])new Object[]{desc})).trim());
        if (pair == null) {
            UndoManagerImpl.$$$reportNull$$$0(13);
        }
        return pair;
    }

    @Nullable
    private String doFormatAvailableUndoRedoAction(FileEditor editor, boolean isUndo) {
        Collection<DocumentReference> refs = UndoManagerImpl.getDocRefs(editor);
        if (refs == null) {
            return null;
        }
        if (isUndo && this.myMerger.isUndoAvailable(refs)) {
            return this.myMerger.getCommandName();
        }
        return this.getStackHolder(isUndo).getLastAction(refs).getCommandName();
    }

    @NotNull
    UndoRedoStacksHolder getUndoStacksHolder() {
        UndoRedoStacksHolder undoRedoStacksHolder = this.myUndoStacksHolder;
        if (undoRedoStacksHolder == null) {
            UndoManagerImpl.$$$reportNull$$$0(14);
        }
        return undoRedoStacksHolder;
    }

    @NotNull
    UndoRedoStacksHolder getRedoStacksHolder() {
        UndoRedoStacksHolder undoRedoStacksHolder = this.myRedoStacksHolder;
        if (undoRedoStacksHolder == null) {
            UndoManagerImpl.$$$reportNull$$$0(15);
        }
        return undoRedoStacksHolder;
    }

    int nextCommandTimestamp() {
        return ++this.myCommandTimestamp;
    }

    @NotNull
    private static Document getOriginal(@NotNull Document document) {
        Document result2;
        if (document == null) {
            UndoManagerImpl.$$$reportNull$$$0(16);
        }
        Document document2 = (result2 = (Document)document.getUserData(ORIGINAL_DOCUMENT)) == null ? document : result2;
        if (document2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(17);
        }
        return document2;
    }

    static boolean isCopy(@NotNull Document d) {
        if (d == null) {
            UndoManagerImpl.$$$reportNull$$$0(18);
        }
        return d.getUserData(ORIGINAL_DOCUMENT) != null;
    }

    protected void compact() {
        if (this.myCurrentOperationState == OperationState.NONE && this.myCommandTimestamp % 20 == 0) {
            this.doCompact();
        }
    }

    private void doCompact() {
        DocumentReference each;
        Collection<DocumentReference> refs = this.collectReferencesWithoutMergers();
        HashSet<DocumentReference> openDocs = new HashSet<DocumentReference>();
        for (DocumentReference each2 : refs) {
            VirtualFile file2 = each2.getFile();
            if (file2 == null) {
                Document document = each2.getDocument();
                if (document == null || EditorFactory.getInstance().getEditors(document, (Project)this.myProject).length <= 0) continue;
                openDocs.add(each2);
                continue;
            }
            if (this.myProject == null || !FileEditorManager.getInstance((Project)this.myProject).isFileOpen(file2)) continue;
            openDocs.add(each2);
        }
        refs.removeAll(openDocs);
        if (refs.size() <= 30) {
            return;
        }
        DocumentReference[] backSorted = refs.toArray(DocumentReference.EMPTY_ARRAY);
        Arrays.sort(backSorted, Comparator.comparingInt(this::getLastCommandTimestamp));
        for (int i = 0; i < backSorted.length - 30 && this.getLastCommandTimestamp(each = backSorted[i]) + 100 <= this.myCommandTimestamp; ++i) {
            this.clearUndoRedoQueue(each);
        }
    }

    private int getLastCommandTimestamp(@NotNull DocumentReference ref) {
        if (ref == null) {
            UndoManagerImpl.$$$reportNull$$$0(19);
        }
        return Math.max(this.myUndoStacksHolder.getLastCommandTimestamp(ref), this.myRedoStacksHolder.getLastCommandTimestamp(ref));
    }

    @NotNull
    private Collection<DocumentReference> collectReferencesWithoutMergers() {
        THashSet result2 = new THashSet();
        this.myUndoStacksHolder.collectAllAffectedDocuments((Collection<DocumentReference>)result2);
        this.myRedoStacksHolder.collectAllAffectedDocuments((Collection<DocumentReference>)result2);
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            UndoManagerImpl.$$$reportNull$$$0(20);
        }
        return tHashSet;
    }

    private void clearUndoRedoQueue(@NotNull DocumentReference docRef) {
        if (docRef == null) {
            UndoManagerImpl.$$$reportNull$$$0(21);
        }
        this.myMerger.flushCurrentCommand();
        this.disposeCurrentMerger();
        this.myUndoStacksHolder.clearStacks(false, Collections.singleton(docRef));
        this.myRedoStacksHolder.clearStacks(false, Collections.singleton(docRef));
    }

    public void setEditorProvider(@NotNull CurrentEditorProvider p) {
        if (p == null) {
            UndoManagerImpl.$$$reportNull$$$0(22);
        }
        this.myEditorProvider = p;
    }

    @NotNull
    public CurrentEditorProvider getEditorProvider() {
        CurrentEditorProvider currentEditorProvider = this.myEditorProvider;
        if (currentEditorProvider == null) {
            UndoManagerImpl.$$$reportNull$$$0(23);
        }
        return currentEditorProvider;
    }

    public void dropHistoryInTests() {
        this.flushMergers();
        LOG.assertTrue(this.myCommandLevel == 0, (Object)this.myCommandLevel);
        this.myUndoStacksHolder.clearAllStacksInTests();
        this.myRedoStacksHolder.clearAllStacksInTests();
    }

    private void flushMergers() {
        assert (this.myProject == null || !this.myProject.isDisposed());
        CommandProcessor.getInstance().executeCommand((Project)this.myProject, EmptyRunnable.getInstance(), CommonBundle.message((String)"drop.undo.history.command.name", (Object[])new Object[0]), null);
    }

    public void flushCurrentCommandMerger() {
        this.myMerger.flushCurrentCommand();
    }

    public void clearUndoRedoQueueInTests(@NotNull VirtualFile file2) {
        if (file2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(24);
        }
        this.clearUndoRedoQueue(DocumentReferenceManager.getInstance().create(file2));
    }

    public void clearUndoRedoQueueInTests(@NotNull Document document) {
        if (document == null) {
            UndoManagerImpl.$$$reportNull$$$0(25);
        }
        this.clearUndoRedoQueue(DocumentReferenceManager.getInstance().create(document));
    }

    public String toString() {
        return "UndoManager for " + ObjectUtils.notNull((Object)this.myProject, (Object)"application");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/UndoManagerImpl";
                break;
            }
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docRef";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/UndoManagerImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentReferences";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStackHolder";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoActionNameAndDescription";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRedoActionNameAndDescription";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoOrRedoActionNameAndDescription";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoStacksHolder";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRedoStacksHolder";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginal";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "collectReferencesWithoutMergers";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "nonundoableActionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "undoableActionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addAffectedDocuments";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addAffectedFiles";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invalidateActionsFor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isUndoOrRedoAvailable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentReferences";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 23: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOriginal";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isCopy";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommandTimestamp";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "clearUndoRedoQueue";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setEditorProvider";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "clearUndoRedoQueueInTests";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum OperationState {
        NONE,
        UNDO,
        REDO;

    }
}

