/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.CodeInsightWorkspaceSettings;
import com.intellij.internal.statistic.AbstractProjectsUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.editor.richcopy.settings.RichCopySettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.BooleanFunction;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

class LegacyEditorSettingsStatisticsCollector
extends UsagesCollector {
    private static final GroupDescriptor GROUP_DESCRIPTOR = GroupDescriptor.create("Editor");

    LegacyEditorSettingsStatisticsCollector() {
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GROUP_DESCRIPTOR;
        if (groupDescriptor == null) {
            LegacyEditorSettingsStatisticsCollector.$$$reportNull$$$0(0);
        }
        return groupDescriptor;
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() {
        HashSet<UsageDescriptor> set2 = new HashSet<UsageDescriptor>();
        EditorSettingsExternalizable es = EditorSettingsExternalizable.getInstance();
        EditorSettingsExternalizable esDefault = new EditorSettingsExternalizable();
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isVirtualSpace(), "caretAfterLineEnd");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isCaretInsideTabs(), "caretInsideTabs");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isAdditionalPageAtBottom(), "virtualSpaceAtFileBottom");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isUseSoftWraps(SoftWrapAppliancePlaces.MAIN_EDITOR), "softWraps");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isUseSoftWraps(SoftWrapAppliancePlaces.CONSOLE), "softWraps.console");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isUseSoftWraps(SoftWrapAppliancePlaces.PREVIEW), "softWraps.preview");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isUseCustomSoftWrapIndent(), "softWraps.relativeIndent");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isAllSoftWrapsShown(), "softWraps.showAll");
        LegacyEditorSettingsStatisticsCollector.addIfDiffers(set2, es, esDefault, s -> s.getStripTrailingSpaces(), "stripTrailingSpaces");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isEnsureNewLineAtEOF(), "ensureNewlineAtEOF");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isShowQuickDocOnMouseOverElement(), "quickDocOnMouseHover");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isBlinkCaret(), "blinkingCaret");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isBlockCursor(), "blockCaret");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isRightMarginShown(), "rightMargin");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isLineNumbersShown(), "lineNumbers");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.areGutterIconsShown(), "gutterIcons");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isFoldingOutlineShown(), "foldingOutline");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isWhitespacesShown() && s.isLeadingWhitespacesShown(), "showLeadingWhitespace");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isWhitespacesShown() && s.isInnerWhitespacesShown(), "showInnerWhitespace");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isWhitespacesShown() && s.isTrailingWhitespacesShown(), "showTrailingWhitespace");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isIndentGuidesShown(), "indentGuides");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isSmoothScrolling(), "animatedScroll");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isDndEnabled(), "dragNDrop");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isWheelFontChangeEnabled(), "wheelZoom");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isMouseClickSelectionHonorsCamelWords(), "mouseCamel");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isVariableInplaceRenameEnabled(), "inplaceRename");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isPreselectRename(), "preselectOnRename");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isShowInlineLocalDialog(), "inlineDialog");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isRefrainFromScrolling(), "minimizeScrolling");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.getOptions().SHOW_NOTIFICATION_AFTER_REFORMAT_CODE_ACTION, "afterReformatNotification");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.getOptions().SHOW_NOTIFICATION_AFTER_OPTIMIZE_IMPORTS_ACTION, "afterOptimizeNotification");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isSmartHome(), "smartHome");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isCamelWords(), "camelWords");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isShowParameterNameHints(), "editor.inlay.parameter.hints");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isBreadcrumbsAbove(), "noBreadcrumbsBelow");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isBreadcrumbsShown(), "breadcrumbs");
        for (String language : es.getOptions().getLanguageBreadcrumbsMap().keySet()) {
            LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isBreadcrumbsShownFor(language), "breadcrumbsFor" + language);
        }
        RichCopySettings rcs = RichCopySettings.getInstance();
        RichCopySettings rcsDefault = new RichCopySettings();
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, rcs, rcsDefault, s -> s.isEnabled(), "richCopy");
        CodeInsightSettings cis = CodeInsightSettings.getInstance();
        CodeInsightSettings cisDefault = new CodeInsightSettings();
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTO_POPUP_PARAMETER_INFO, "parameterAutoPopup");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTO_POPUP_JAVADOC_INFO, "javadocAutoPopup");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTO_POPUP_COMPLETION_LOOKUP, "completionAutoPopup");
        LegacyEditorSettingsStatisticsCollector.addIfDiffers(set2, cis, cisDefault, s -> s.COMPLETION_CASE_SENSITIVE, "completionCaseSensitivity");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS, "autoPopupCharComplete");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTOCOMPLETE_ON_CODE_COMPLETION, "autoCompleteBasic");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION, "autoCompleteSmart");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO, "parameterInfoFullSignature");
        LegacyEditorSettingsStatisticsCollector.addIfDiffers(set2, cis, cisDefault, s -> s.getBackspaceMode(), "smartBackspace");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SMART_INDENT_ON_ENTER, "indentOnEnter");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.INSERT_BRACE_ON_ENTER, "braceOnEnter");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.JAVADOC_STUB_ON_ENTER, "javadocOnEnter");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SMART_END_ACTION, "smartEnd");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.JAVADOC_GENERATE_CLOSING_TAG, "autoCloseJavadocTags");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SURROUND_SELECTION_ON_QUOTE_TYPED, "surroundByQuoteOrBrace");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTOINSERT_PAIR_BRACKET, "pairBracketAutoInsert");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTOINSERT_PAIR_QUOTE, "pairQuoteAutoInsert");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.REFORMAT_BLOCK_ON_RBRACE, "reformatOnRBrace");
        LegacyEditorSettingsStatisticsCollector.addIfDiffers(set2, cis, cisDefault, s -> s.REFORMAT_ON_PASTE, "reformatOnPaste");
        LegacyEditorSettingsStatisticsCollector.addIfDiffers(set2, cis, cisDefault, s -> s.ADD_IMPORTS_ON_PASTE, "importsOnPaste");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.HIGHLIGHT_BRACES, "bracesHighlight");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.HIGHLIGHT_SCOPE, "scopeHighlight");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.HIGHLIGHT_IDENTIFIER_UNDER_CARET, "identifierUnderCaretHighlight");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY, "autoAddImports");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION, "completionHints");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SHOW_EXTERNAL_ANNOTATIONS_INLINE, "externalAnnotationsInline");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SHOW_INFERRED_ANNOTATIONS_INLINE, "inferredAnnotationsInline");
        LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.TAB_EXITS_BRACKETS_AND_QUOTES, "tabExitsBracketsAndQuotes");
        HashSet<UsageDescriptor> hashSet = set2;
        if (hashSet == null) {
            LegacyEditorSettingsStatisticsCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private static <T> void addBoolIfDiffers(Set<UsageDescriptor> set2, T settingsBean, T defaultSettingsBean, BooleanFunction<T> valueFunction, String featureId) {
        boolean defaultValue;
        boolean value = valueFunction.fun(settingsBean);
        if (value != (defaultValue = valueFunction.fun(defaultSettingsBean))) {
            set2.add(new UsageDescriptor(defaultValue ? "no" + StringUtil.capitalize((String)featureId) : featureId, 1));
        }
    }

    private static <T> void addIfDiffers(Set<UsageDescriptor> set2, T settingsBean, T defaultSettingsBean, Function<T, Object> valueFunction, String featureIdPrefix) {
        Object defaultValue;
        Object value = valueFunction.apply(settingsBean);
        if (!Comparing.equal((Object)value, (Object)(defaultValue = valueFunction.apply(defaultSettingsBean)))) {
            set2.add(new UsageDescriptor(featureIdPrefix + "." + value, 1));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/internal/statistic/editor/LegacyEditorSettingsStatisticsCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class ProjectUsages
    extends AbstractProjectsUsagesCollector {
        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GROUP_DESCRIPTOR;
            if (groupDescriptor == null) {
                ProjectUsages.$$$reportNull$$$0(0);
            }
            return groupDescriptor;
        }

        @Override
        @NotNull
        public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) throws CollectUsagesException {
            if (project == null) {
                ProjectUsages.$$$reportNull$$$0(1);
            }
            HashSet<UsageDescriptor> set2 = new HashSet<UsageDescriptor>();
            CodeInsightWorkspaceSettings ciws = CodeInsightWorkspaceSettings.getInstance(project);
            CodeInsightWorkspaceSettings ciwsDefault = new CodeInsightWorkspaceSettings();
            LegacyEditorSettingsStatisticsCollector.addBoolIfDiffers(set2, ciws, ciwsDefault, s -> s.optimizeImportsOnTheFly, "autoOptimizeImports");
            HashSet<UsageDescriptor> hashSet = set2;
            if (hashSet == null) {
                ProjectUsages.$$$reportNull$$$0(2);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/editor/LegacyEditorSettingsStatisticsCollector$ProjectUsages";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/editor/LegacyEditorSettingsStatisticsCollector$ProjectUsages";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProjectUsages";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getProjectUsages";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

