/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.todo.TodoFileDirAndModuleComparator;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.nodes.TodoDirNode;
import com.intellij.ide.todo.nodes.TodoFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class TodoTreeHelper {
    private final Project myProject;

    public static TodoTreeHelper getInstance(Project project) {
        return (TodoTreeHelper)ServiceManager.getService((Project)project, TodoTreeHelper.class);
    }

    public TodoTreeHelper(Project project) {
        this.myProject = project;
    }

    public void addPackagesToChildren(ArrayList<AbstractTreeNode> children2, Module module2, TodoTreeBuilder builder2) {
        this.addDirsToChildren(this.collectContentRoots(module2), children2, builder2);
    }

    protected List<VirtualFile> collectContentRoots(Module module2) {
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        if (module2 == null) {
            ContainerUtil.addAll(roots, (Object[])ProjectRootManager.getInstance((Project)this.myProject).getContentRoots());
        } else {
            ContainerUtil.addAll(roots, (Object[])ModuleRootManager.getInstance((Module)module2).getContentRoots());
        }
        return roots;
    }

    protected void addDirsToChildren(List<VirtualFile> roots, ArrayList<AbstractTreeNode> children2, TodoTreeBuilder builder2) {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile dir : roots) {
            TodoDirNode dirNode;
            Iterator<PsiFile> files2;
            PsiDirectory directory2 = psiManager.findDirectory(dir);
            if (directory2 == null || !(files2 = builder2.getFiles(directory2)).hasNext() || children2.contains(dirNode = new TodoDirNode(this.myProject, directory2, builder2))) continue;
            children2.add((AbstractTreeNode)dirNode);
        }
    }

    public Collection<AbstractTreeNode> getDirectoryChildren(PsiDirectory psiDirectory, TodoTreeBuilder builder2, boolean isFlatten) {
        ArrayList<AbstractTreeNode> children2 = new ArrayList<AbstractTreeNode>();
        if (!isFlatten || !this.skipDirectory(psiDirectory)) {
            Iterator<PsiFile> iterator = builder2.getFiles(psiDirectory);
            block0: while (iterator.hasNext()) {
                PsiFile psiFile = iterator.next();
                PsiDirectory containingDirectory = psiFile.getContainingDirectory();
                TodoFileNode todoFileNode = new TodoFileNode(this.getProject(), psiFile, builder2, false);
                if (psiDirectory.equals(containingDirectory) && !children2.contains(todoFileNode)) {
                    children2.add((AbstractTreeNode)todoFileNode);
                    continue;
                }
                PsiDirectory _dir = psiFile.getContainingDirectory();
                while (_dir != null && !this.skipDirectory(_dir)) {
                    PsiDirectory parentDirectory = _dir.getParentDirectory();
                    TodoDirNode todoDirNode = new TodoDirNode(this.getProject(), _dir, builder2);
                    if (parentDirectory != null && psiDirectory.equals(parentDirectory) && !children2.contains(todoDirNode)) {
                        children2.add((AbstractTreeNode)todoDirNode);
                        continue block0;
                    }
                    _dir = parentDirectory;
                }
            }
        } else {
            PsiDirectory parentDirectory = psiDirectory.getParentDirectory();
            if (parentDirectory == null || !this.skipDirectory(parentDirectory) || !ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex().isInContent(parentDirectory.getVirtualFile())) {
                Iterator<PsiFile> iterator = builder2.getFiles(psiDirectory);
                while (iterator.hasNext()) {
                    PsiFile psiFile = iterator.next();
                    TodoFileNode todoFileNode = new TodoFileNode(this.getProject(), psiFile, builder2, false);
                    if (psiDirectory.equals(psiFile.getContainingDirectory()) && !children2.contains(todoFileNode)) {
                        children2.add((AbstractTreeNode)todoFileNode);
                        continue;
                    }
                    PsiDirectory _dir = psiFile.getContainingDirectory();
                    if (this.skipDirectory(_dir)) continue;
                    TodoDirNode todoDirNode = new TodoDirNode(this.getProject(), _dir, builder2);
                    if (!PsiTreeUtil.isAncestor((PsiElement)psiDirectory, (PsiElement)_dir, (boolean)true) || children2.contains(todoDirNode) || builder2.isDirectoryEmpty(_dir)) continue;
                    children2.add((AbstractTreeNode)todoDirNode);
                }
            } else {
                Iterator<PsiFile> iterator = builder2.getFiles(psiDirectory);
                while (iterator.hasNext()) {
                    PsiFile psiFile = iterator.next();
                    PsiDirectory containingDirectory = psiFile.getContainingDirectory();
                    TodoFileNode todoFileNode = new TodoFileNode(this.getProject(), psiFile, builder2, false);
                    if (!psiDirectory.equals(containingDirectory) || children2.contains(todoFileNode)) continue;
                    children2.add((AbstractTreeNode)todoFileNode);
                }
            }
        }
        Collections.sort(children2, TodoFileDirAndModuleComparator.INSTANCE);
        return children2;
    }

    public boolean skipDirectory(PsiDirectory directory2) {
        return false;
    }

    @Nullable
    public PsiElement getSelectedElement(Object userObject) {
        if (userObject instanceof TodoDirNode) {
            TodoDirNode descriptor2 = (TodoDirNode)userObject;
            return (PsiElement)descriptor2.getValue();
        }
        if (userObject instanceof TodoFileNode) {
            TodoFileNode descriptor3 = (TodoFileNode)userObject;
            return (PsiElement)descriptor3.getValue();
        }
        return null;
    }

    public Project getProject() {
        return this.myProject;
    }
}

