/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.DataManager;
import com.intellij.ide.macro.AffectedModuleNamesMacro;
import com.intellij.ide.macro.ClipboardContentMacro;
import com.intellij.ide.macro.ColumnNumberMacro;
import com.intellij.ide.macro.CompilerContextMakeMacro;
import com.intellij.ide.macro.ContentRootMacro;
import com.intellij.ide.macro.FileDirMacro;
import com.intellij.ide.macro.FileDirNameMacro;
import com.intellij.ide.macro.FileDirPathFromParentMacro;
import com.intellij.ide.macro.FileDirRelativeToProjectRootMacro;
import com.intellij.ide.macro.FileDirRelativeToProjectRootMacro2;
import com.intellij.ide.macro.FileDirRelativeToSourcepathMacro;
import com.intellij.ide.macro.FileDirRelativeToSourcepathMacro2;
import com.intellij.ide.macro.FileEncodingMacro;
import com.intellij.ide.macro.FileExtMacro;
import com.intellij.ide.macro.FileNameMacro;
import com.intellij.ide.macro.FileNameWithoutAllExtensions;
import com.intellij.ide.macro.FileNameWithoutExtension;
import com.intellij.ide.macro.FileParentDirMacro;
import com.intellij.ide.macro.FilePathMacro;
import com.intellij.ide.macro.FilePathRelativeToProjectRootMacro;
import com.intellij.ide.macro.FilePathRelativeToProjectRootMacro2;
import com.intellij.ide.macro.FilePathRelativeToSourcepathMacro;
import com.intellij.ide.macro.FilePathRelativeToSourcepathMacro2;
import com.intellij.ide.macro.FilePromptMacro;
import com.intellij.ide.macro.FileRelativeDirMacro;
import com.intellij.ide.macro.FileRelativeDirMacro2;
import com.intellij.ide.macro.FileRelativePathMacro;
import com.intellij.ide.macro.FileRelativePathMacro2;
import com.intellij.ide.macro.JdkPathMacro;
import com.intellij.ide.macro.LineNumberMacro;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.ModuleFileDirMacro;
import com.intellij.ide.macro.ModuleFilePathMacro;
import com.intellij.ide.macro.ModuleNameMacro;
import com.intellij.ide.macro.ModulePathMacro;
import com.intellij.ide.macro.ModuleSdkPathMacro;
import com.intellij.ide.macro.ProjectFileDirMacro;
import com.intellij.ide.macro.ProjectNameMacro;
import com.intellij.ide.macro.ProjectPathMacro;
import com.intellij.ide.macro.PromptMacro;
import com.intellij.ide.macro.PromptingMacro;
import com.intellij.ide.macro.SecondQueueExpandMacro;
import com.intellij.ide.macro.SelectedTextMacro;
import com.intellij.ide.macro.SelectionEndColumnMacro;
import com.intellij.ide.macro.SelectionEndLineMacro;
import com.intellij.ide.macro.SelectionStartColumnMacro;
import com.intellij.ide.macro.SelectionStartLineMacro;
import com.intellij.ide.macro.SourcepathEntryMacro;
import com.intellij.ide.macro.SourcepathMacro;
import com.intellij.ide.macro.UnixSeparatorsMacro;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ConvertingIterator;
import com.intellij.util.containers.Convertor;
import gnu.trove.THashMap;
import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MacroManager {
    private final Map<String, Macro> myMacrosMap = new LinkedHashMap<String, Macro>();
    private static final Pattern MACRO_PATTERN = Pattern.compile("\\$.+\\$");

    public static MacroManager getInstance() {
        return (MacroManager)ServiceManager.getService(MacroManager.class);
    }

    private MacroManager() {
        this.registerMacro(new SourcepathMacro());
        this.registerMacro(new FileDirMacro());
        this.registerMacro(new FileDirNameMacro());
        this.registerMacro(new FileParentDirMacro());
        this.registerMacro(new FileDirPathFromParentMacro());
        this.registerMacro(new FileExtMacro());
        this.registerMacro(new FileNameMacro());
        this.registerMacro(new FileNameWithoutExtension());
        this.registerMacro(new FileNameWithoutAllExtensions());
        this.registerMacro(new FilePathMacro());
        this.registerMacro(new UnixSeparatorsMacro());
        this.registerMacro(new FileEncodingMacro());
        this.registerMacro(new FileDirRelativeToProjectRootMacro());
        this.registerMacro(new FilePathRelativeToProjectRootMacro());
        this.registerMacro(new FileDirRelativeToSourcepathMacro());
        this.registerMacro(new FilePathRelativeToSourcepathMacro());
        this.registerMacro(new JdkPathMacro());
        this.registerMacro(new PromptMacro());
        this.registerMacro(new FilePromptMacro());
        this.registerMacro(new SourcepathEntryMacro());
        this.registerMacro(new ProjectFileDirMacro());
        this.registerMacro(new ProjectNameMacro());
        this.registerMacro(new ProjectPathMacro());
        this.registerMacro(new ContentRootMacro());
        this.registerMacro(new ModuleFilePathMacro());
        this.registerMacro(new ModuleFileDirMacro());
        this.registerMacro(new ModuleNameMacro());
        this.registerMacro(new AffectedModuleNamesMacro());
        this.registerMacro(new CompilerContextMakeMacro());
        this.registerMacro(new ModulePathMacro());
        this.registerMacro(new ModuleSdkPathMacro());
        this.registerMacro(new FileRelativePathMacro());
        this.registerMacro(new FileRelativeDirMacro());
        this.registerMacro(new LineNumberMacro());
        this.registerMacro(new ColumnNumberMacro());
        this.registerMacro(new ClipboardContentMacro());
        this.registerMacro(new SelectedTextMacro());
        this.registerMacro(new SelectionStartLineMacro());
        this.registerMacro(new SelectionStartColumnMacro());
        this.registerMacro(new SelectionEndLineMacro());
        this.registerMacro(new SelectionEndColumnMacro());
        if (File.separatorChar != '/') {
            this.registerMacro(new FileDirRelativeToProjectRootMacro2());
            this.registerMacro(new FilePathRelativeToProjectRootMacro2());
            this.registerMacro(new FileDirRelativeToSourcepathMacro2());
            this.registerMacro(new FilePathRelativeToSourcepathMacro2());
            this.registerMacro(new FileRelativeDirMacro2());
            this.registerMacro(new FileRelativePathMacro2());
        }
        for (Macro macro : (Macro[])Extensions.getExtensions(Macro.EP_NAME)) {
            this.registerMacro(macro);
        }
    }

    private void registerMacro(Macro macro) {
        this.myMacrosMap.put(macro.getName(), macro);
    }

    public Collection<Macro> getMacros() {
        return this.myMacrosMap.values();
    }

    @NotNull
    public Set<String> getMacroNames() {
        Set<String> set2 = this.myMacrosMap.keySet();
        if (set2 == null) {
            MacroManager.$$$reportNull$$$0(0);
        }
        return set2;
    }

    public void cacheMacrosPreview(DataContext dataContext) {
        dataContext = MacroManager.getCorrectContext(dataContext);
        for (Macro macro : this.getMacros()) {
            macro.cachePreview(dataContext);
        }
    }

    private static DataContext getCorrectContext(DataContext dataContext) {
        if (PlatformDataKeys.FILE_EDITOR.getData(dataContext) != null) {
            return dataContext;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return dataContext;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        VirtualFile[] files2 = editorManager.getSelectedFiles();
        if (files2.length == 0) {
            return dataContext;
        }
        FileEditor fileEditor = editorManager.getSelectedEditor(files2[0]);
        return fileEditor == null ? dataContext : DataManager.getInstance().getDataContext((Component)fileEditor.getComponent());
    }

    public static boolean containsMacros(@Nullable String str) {
        if (str == null) {
            return false;
        }
        return MACRO_PATTERN.matcher(str).find();
    }

    @Nullable
    public String expandMacrosInString(@Nullable String str, boolean firstQueueExpand, DataContext dataContext) throws Macro.ExecutionCancelledException {
        return this.expandMacrosInString(str, firstQueueExpand, dataContext, "", false);
    }

    @Nullable
    public String expandSilentMacros(@Nullable String str, boolean firstQueueExpand, DataContext dataContext) throws Macro.ExecutionCancelledException {
        return this.expandMacrosInString(str, firstQueueExpand, dataContext, "", true);
    }

    @Nullable
    public String expandMacrosInString(@Nullable String str, boolean firstQueueExpand, DataContext dataContext, @Nullable String defaultExpandValue, boolean onlySilent) throws Macro.ExecutionCancelledException {
        ConvertingIterator macros = this.getMacros().iterator();
        if (onlySilent) {
            Convertor convertor = macro -> macro instanceof PromptingMacro ? new Macro.Silent((Macro)macro, defaultExpandValue) : macro;
            macros = ConvertingIterator.create(this.getMacros().iterator(), (Convertor)convertor);
        }
        return MacroManager.expandMacroSet(str, firstQueueExpand, dataContext, macros, defaultExpandValue);
    }

    @Nullable
    private static String expandMacroSet(@Nullable String str, boolean firstQueueExpand, DataContext dataContext, Iterator<Macro> macros, @Nullable String defaultExpandValue) throws Macro.ExecutionCancelledException {
        if (str == null) {
            return null;
        }
        while (macros.hasNext()) {
            int j;
            Macro macro = macros.next();
            if (macro instanceof SecondQueueExpandMacro && firstQueueExpand) continue;
            String name = "$" + macro.getName() + "$";
            String macroNameWithParamStart = "$" + macro.getName() + "(";
            if (str.contains(name)) {
                String expanded = macro.expand(dataContext);
                String string = expanded = expanded == null ? defaultExpandValue : expanded;
                if (expanded == null) {
                    return null;
                }
                str = StringUtil.replace((String)str, (String)name, (String)expanded);
                continue;
            }
            if (!str.contains(macroNameWithParamStart)) continue;
            String macroNameWithParamEnd = ")$";
            Map toReplace = null;
            int i = str.indexOf(macroNameWithParamStart);
            while (i != -1 && (j = str.indexOf(macroNameWithParamEnd, i + macroNameWithParamStart.length())) > i) {
                String expanded;
                String param = str.substring(i + macroNameWithParamStart.length(), j);
                if (toReplace == null) {
                    toReplace = new THashMap();
                }
                String string = expanded = (expanded = macro.expand(dataContext, param)) == null ? defaultExpandValue : expanded;
                if (expanded == null) {
                    return null;
                }
                toReplace.put(macroNameWithParamStart + param + macroNameWithParamEnd, expanded);
                i = j + macroNameWithParamEnd.length();
            }
            if (toReplace == null) continue;
            for (Map.Entry entry : toReplace.entrySet()) {
                str = StringUtil.replace((String)str, (String)((String)entry.getKey()), (String)((String)entry.getValue()));
            }
        }
        return str;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/macro/MacroManager", "getMacroNames"));
    }
}

