/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFileAction;
import com.intellij.ide.actions.CreateFromTemplateAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Set;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class CreateTemplateInPackageAction<T extends PsiElement>
extends CreateFromTemplateAction<T> {
    private final Set<? extends JpsModuleSourceRootType<?>> mySourceRootTypes;

    protected CreateTemplateInPackageAction(String text2, String description, Icon icon, Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        super(text2, description, icon);
        this.mySourceRootTypes = rootTypes;
    }

    @Override
    @Nullable
    protected T createFile(String name, String templateName, PsiDirectory dir) {
        return this.checkOrCreate(name, dir, templateName);
    }

    @Nullable
    protected abstract PsiElement getNavigationElement(@NotNull T var1);

    @Override
    protected boolean isAvailable(DataContext dataContext) {
        return CreateTemplateInPackageAction.isAvailable(dataContext, this.mySourceRootTypes, this::checkPackageExists);
    }

    public static boolean isAvailable(DataContext dataContext, Set<? extends JpsModuleSourceRootType<?>> sourceRootTypes, Function<PsiDirectory, Boolean> checkPackageExists) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (project == null || view == null || view.getDirectories().length == 0) {
            return false;
        }
        if (sourceRootTypes == null) {
            return true;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (PsiDirectory dir : view.getDirectories()) {
            if (!projectFileIndex.isUnderSourceRootOfType(dir.getVirtualFile(), sourceRootTypes) || !checkPackageExists.apply(dir).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean checkPackageExists(PsiDirectory var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private T checkOrCreate(String newName, PsiDirectory directory2, String templateName) throws IncorrectOperationException {
        PsiDirectory dir = directory2;
        String className = this.removeExtension(templateName, newName);
        if (className.contains(".")) {
            String[] names = className.split("\\.");
            for (int i = 0; i < names.length - 1; ++i) {
                dir = CreateFileAction.findOrCreateSubdirectory(dir, names[i]);
            }
            className = names[names.length - 1];
        }
        DumbService service2 = DumbService.getInstance((Project)dir.getProject());
        service2.setAlternativeResolveEnabled(true);
        try {
            T t = this.doCreate(dir, className, templateName);
            return t;
        }
        finally {
            service2.setAlternativeResolveEnabled(false);
        }
    }

    protected String removeExtension(String templateName, String className) {
        String extension = StringUtil.getShortName((String)templateName);
        if (StringUtil.isNotEmpty((String)extension)) {
            className = StringUtil.trimEnd((String)className, (String)("." + extension));
        }
        return className;
    }

    @Nullable
    protected abstract T doCreate(PsiDirectory var1, String var2, String var3) throws IncorrectOperationException;
}

