/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.ClipboardSynchronizer;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ide.CutElementMarker;
import com.intellij.openapi.ide.KillRingTransferable;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.EventDispatcher;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyPasteManagerEx
extends CopyPasteManager
implements ClipboardOwner {
    private final List<Transferable> myData = new ArrayList<Transferable>();
    private final EventDispatcher<CopyPasteManager.ContentChangedListener> myDispatcher = EventDispatcher.create(CopyPasteManager.ContentChangedListener.class);
    private final ClipboardSynchronizer myClipboardSynchronizer;
    private boolean myOwnContent;

    public static CopyPasteManagerEx getInstanceEx() {
        return (CopyPasteManagerEx)CopyPasteManagerEx.getInstance();
    }

    public CopyPasteManagerEx(ClipboardSynchronizer clipboardSynchronizer) {
        this.myClipboardSynchronizer = clipboardSynchronizer;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.myOwnContent = false;
        this.myClipboardSynchronizer.resetContent();
        this.fireContentChanged(contents, null);
    }

    private void fireContentChanged(@Nullable Transferable oldContent, @Nullable Transferable newContent) {
        ((CopyPasteManager.ContentChangedListener)this.myDispatcher.getMulticaster()).contentChanged(oldContent, newContent);
    }

    public void addContentChangedListener(@NotNull CopyPasteManager.ContentChangedListener listener2) {
        if (listener2 == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(0);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void addContentChangedListener(@NotNull CopyPasteManager.ContentChangedListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(2);
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeContentChangedListener(@NotNull CopyPasteManager.ContentChangedListener listener2) {
        if (listener2 == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(3);
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
        if (flavors == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(4);
        }
        return flavors.length > 0 && this.myClipboardSynchronizer.areDataFlavorsAvailable(flavors);
    }

    public void setContents(@NotNull Transferable content) {
        if (content == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(5);
        }
        Transferable oldContent = this.myOwnContent && !this.myData.isEmpty() ? this.myData.get(0) : null;
        Transferable contentToUse = this.addNewContentToStack(content);
        this.setSystemClipboardContent(contentToUse);
        this.fireContentChanged(oldContent, contentToUse);
    }

    public boolean isCutElement(@Nullable Object element) {
        for (CutElementMarker marker : (CutElementMarker[])Extensions.getExtensions((ExtensionPointName)CutElementMarker.EP_NAME)) {
            if (!marker.isCutElement(element)) continue;
            return true;
        }
        return false;
    }

    public void stopKillRings() {
        for (Transferable data : this.myData) {
            if (!(data instanceof KillRingTransferable)) continue;
            ((KillRingTransferable)data).setReadyToCombine(false);
        }
    }

    private void setSystemClipboardContent(Transferable content) {
        this.myClipboardSynchronizer.setContent(content, this);
        this.myOwnContent = true;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private Transferable addNewContentToStack(@NotNull Transferable content) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 6[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addToTheTopOfTheStack(@NotNull Transferable content) {
        if (content == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(12);
        }
        this.myData.add(0, content);
        this.deleteAfterAllowedMaximum();
    }

    @Nullable
    private static Transferable merge(@NotNull KillRingTransferable newData, @NotNull KillRingTransferable oldData) throws IOException, UnsupportedFlavorException {
        if (newData == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(13);
        }
        if (oldData == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(14);
        }
        if (!oldData.isReadyToCombine() || !newData.isReadyToCombine()) {
            return null;
        }
        Document document = newData.getDocument();
        if (document == null || document != oldData.getDocument()) {
            return null;
        }
        Object newDataText = newData.getTransferData(DataFlavor.stringFlavor);
        Object oldDataText = oldData.getTransferData(DataFlavor.stringFlavor);
        if (newDataText == null || oldDataText == null) {
            return null;
        }
        if (oldData.isCut() && newData.getStartOffset() == oldData.getStartOffset()) {
            return new KillRingTransferable(oldDataText.toString() + newDataText, document, oldData.getStartOffset(), newData.getEndOffset(), newData.isCut());
        }
        if (newData.getStartOffset() == oldData.getEndOffset()) {
            return new KillRingTransferable(oldDataText.toString() + newDataText, document, oldData.getStartOffset(), newData.getEndOffset(), false);
        }
        if (newData.getEndOffset() == oldData.getStartOffset()) {
            return new KillRingTransferable(newDataText.toString() + oldDataText, document, newData.getStartOffset(), oldData.getEndOffset(), false);
        }
        return null;
    }

    private static String getStringContent(Transferable content) {
        try {
            return (String)content.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            return null;
        }
    }

    private void deleteAfterAllowedMaximum() {
        int max = UISettings.getInstance().getMaxClipboardContents();
        for (int i = this.myData.size() - 1; i >= max; --i) {
            this.myData.remove(i);
        }
    }

    public Transferable getContents() {
        return this.myClipboardSynchronizer.getContents();
    }

    @Nullable
    public <T> T getContents(@NotNull DataFlavor flavor) {
        if (flavor == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(15);
        }
        if (this.areDataFlavorsAvailable(flavor)) {
            return (T)this.myClipboardSynchronizer.getData(flavor);
        }
        return null;
    }

    @NotNull
    public Transferable[] getAllContents() {
        String clipString = (String)this.getContents(DataFlavor.stringFlavor);
        if (clipString != null && (this.myData.isEmpty() || !Comparing.equal((String)clipString, (String)CopyPasteManagerEx.getStringContent(this.myData.get(0))))) {
            this.addToTheTopOfTheStack(new StringSelection(clipString));
        }
        Transferable[] transferableArray = this.myData.toArray(new Transferable[0]);
        if (transferableArray == null) {
            CopyPasteManagerEx.$$$reportNull$$$0(16);
        }
        return transferableArray;
    }

    public void removeContent(Transferable t) {
        Transferable current = this.myData.isEmpty() ? null : this.myData.get(0);
        this.myData.remove(t);
        if (Comparing.equal((Object)t, (Object)current)) {
            Transferable newContent = !this.myData.isEmpty() ? this.myData.get(0) : new StringSelection("");
            this.setSystemClipboardContent(newContent);
            this.fireContentChanged(current, newContent);
        }
    }

    public void moveContentToStackTop(Transferable t) {
        Transferable current;
        Transferable transferable = current = this.myData.isEmpty() ? null : this.myData.get(0);
        if (!Comparing.equal((Object)t, (Object)current)) {
            this.myData.remove(t);
            this.myData.add(0, t);
            this.setSystemClipboardContent(t);
            this.fireContentChanged(current, t);
        } else {
            this.setSystemClipboardContent(t);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavors";
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/CopyPasteManagerEx";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newData";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldData";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/CopyPasteManagerEx";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addNewContentToStack";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllContents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addContentChangedListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeContentChangedListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "areDataFlavorsAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setContents";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addNewContentToStack";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addToTheTopOfTheStack";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getContents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

