/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.help.impl;

import com.intellij.help.impl.IdeaJHelp;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.sun.java.help.impl.JHelpPrintHandler;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.IllegalComponentStateException;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.WeakHashMap;
import javax.help.BadIDException;
import javax.help.CSH;
import javax.help.DefaultHelpBroker;
import javax.help.DefaultHelpModel;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelp;
import javax.help.JHelpNavigator;
import javax.help.Map;
import javax.help.TextHelpModel;
import javax.help.UnsupportedOperationException;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

class IdeaHelpBroker
extends DefaultHelpBroker
implements KeyListener {
    private HelpSet myHelpSet = null;
    private JFrame myFrame = null;
    private JHelp jhelp = null;
    private Locale myLocale = null;
    private Font myFont = null;
    private JDialog myDialog = null;
    private Window myOwnerWindow = null;
    private boolean myModallyActivated = false;
    private int HELP_WIDTH;
    private int HELP_HEIGHT;
    private WindowListener dl;
    private boolean modalDeactivated;
    private ActionListener displayHelpFromFocus;
    private ActionListener displayHelpFromSource;

    public IdeaHelpBroker(HelpSet hs) {
        this.HELP_WIDTH = (int)((double)ScreenUtil.getMainScreenBounds().width * 0.8);
        this.HELP_HEIGHT = (int)((double)ScreenUtil.getMainScreenBounds().height * 0.8);
        this.modalDeactivated = true;
        this.setHelpSet(hs);
    }

    public HelpSet getHelpSet() {
        return this.myHelpSet;
    }

    public void setHelpSet(HelpSet hs) {
        if (hs != null && this.myHelpSet != hs) {
            if (this.jhelp != null) {
                DefaultHelpModel model = new DefaultHelpModel(hs);
                this.jhelp.setModel((TextHelpModel)model);
            }
            this.myHelpSet = hs;
        }
    }

    public Locale getLocale() {
        if (this.myLocale == null) {
            return Locale.getDefault();
        }
        return this.myLocale;
    }

    public void setLocale(Locale l) {
        this.myLocale = l;
        if (this.jhelp != null) {
            this.jhelp.setLocale(this.myLocale);
        }
    }

    public Font getFont() {
        this.createHelpWindow();
        if (this.myFont == null) {
            return this.jhelp.getFont();
        }
        return this.myFont;
    }

    public void setFont(Font f) {
        this.myFont = f;
        if (this.jhelp != null) {
            this.jhelp.setFont(this.myFont);
        }
    }

    public void setCurrentView(String name) {
        this.createHelpWindow();
        JHelpNavigator nav = null;
        Enumeration e = this.jhelp.getHelpNavigators();
        while (e.hasMoreElements() && !(nav = (JHelpNavigator)e.nextElement()).getNavigatorName().equals(name)) {
            nav = null;
        }
        if (nav == null) {
            throw new IllegalArgumentException("Invalid view name");
        }
        this.jhelp.setCurrentNavigator(nav);
    }

    public String getCurrentView() {
        this.createHelpWindow();
        return this.jhelp.getCurrentNavigator().getNavigatorName();
    }

    public void initPresentation() {
        this.createHelpWindow();
    }

    public void setDisplayed(boolean visible) {
        this.createHelpWindow();
        if (this.myModallyActivated) {
            this.myDialog.setVisible(visible);
            if (visible) {
                this.myDialog.setLocationRelativeTo(this.myDialog.getOwner());
            }
        } else {
            this.myFrame.setVisible(visible);
            this.myFrame.setState(0);
            IdeFocusManager focusManager = IdeFocusManager.findInstance();
            JComponent target2 = focusManager.getFocusTargetFor((JComponent)this.myFrame.getRootPane());
            focusManager.requestFocus((Component)(target2 != null ? target2 : this.myFrame), true);
        }
    }

    public boolean isDisplayed() {
        if (this.myModallyActivated) {
            if (this.myDialog != null) {
                return this.myDialog.isShowing();
            }
            return false;
        }
        if (this.myFrame != null) {
            if (!this.myFrame.isVisible()) {
                return false;
            }
            return this.myFrame.getState() == 0;
        }
        return false;
    }

    public void setLocation(Point p) throws UnsupportedOperationException {
        this.createHelpWindow();
        if (this.myModallyActivated) {
            this.myDialog.setLocation(p);
        } else {
            this.myFrame.setLocation(p);
        }
    }

    public Point getLocation() throws UnsupportedOperationException {
        if (this.jhelp == null) {
            throw new IllegalComponentStateException("presentation not displayed");
        }
        if (this.myModallyActivated) {
            if (this.myDialog != null) {
                return this.myDialog.getLocation();
            }
        } else if (this.myFrame != null) {
            return this.myFrame.getLocation();
        }
        return null;
    }

    public void setSize(Dimension d) throws UnsupportedOperationException {
        this.HELP_WIDTH = d.width;
        this.HELP_HEIGHT = d.height;
        this.createHelpWindow();
        if (this.myModallyActivated) {
            this.myDialog.setSize(d);
            this.myDialog.validate();
        } else {
            this.myFrame.setSize(d);
            this.myFrame.validate();
        }
    }

    public Dimension getSize() throws UnsupportedOperationException {
        if (this.jhelp == null) {
            throw new IllegalComponentStateException("presentation not displayed");
        }
        if (this.myModallyActivated) {
            if (this.myDialog != null) {
                return this.myDialog.getSize();
            }
        } else if (this.myFrame != null) {
            return this.myFrame.getSize();
        }
        return null;
    }

    public void setViewDisplayed(boolean displayed) {
        this.createHelpWindow();
        this.jhelp.setNavigatorDisplayed(displayed);
    }

    public boolean isViewDisplayed() {
        this.createHelpWindow();
        return this.jhelp.isNavigatorDisplayed();
    }

    public void setCurrentID(String id) throws BadIDException {
        try {
            this.setCurrentID(Map.ID.create((String)id, (HelpSet)this.myHelpSet));
        }
        catch (InvalidHelpSetContextException ex) {
            throw new Error("internal error?");
        }
    }

    public void setCurrentID(Map.ID id) throws InvalidHelpSetContextException {
        this.createJHelp();
        this.jhelp.getModel().setCurrentID(id);
    }

    public Map.ID getCurrentID() {
        if (this.jhelp != null) {
            return this.jhelp.getModel().getCurrentID();
        }
        return null;
    }

    public void setCurrentURL(URL url) {
        this.createHelpWindow();
        this.jhelp.getModel().setCurrentURL(url);
        if (this.myModallyActivated) {
            this.myDialog.setVisible(true);
            this.myDialog.setVisible(true);
        } else {
            this.myFrame.setVisible(true);
        }
    }

    public URL getCurrentURL() {
        return this.jhelp.getModel().getCurrentURL();
    }

    public void enableHelpKey(Component comp, @NotNull String id, HelpSet hs) {
        if (id == null) {
            IdeaHelpBroker.$$$reportNull$$$0(0);
        }
        CSH.setHelpIDString((Component)comp, (String)id);
        if (hs != null) {
            CSH.setHelpSet((Component)comp, (HelpSet)hs);
        }
        if (comp instanceof JComponent) {
            JComponent root = (JComponent)comp;
            root.registerKeyboardAction(this.getDisplayHelpFromFocus(), KeyStroke.getKeyStroke(156, 0), 1);
            root.registerKeyboardAction(this.getDisplayHelpFromFocus(), KeyStroke.getKeyStroke(112, 0), 1);
        } else {
            comp.addKeyListener(this);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 112 || code == 156) {
            ActionListener al = this.getDisplayHelpFromFocus();
            al.actionPerformed(new ActionEvent(e.getComponent(), 1001, null));
        }
    }

    public void enableHelp(Component comp, @NotNull String id, HelpSet hs) {
        if (id == null) {
            IdeaHelpBroker.$$$reportNull$$$0(1);
        }
        CSH.setHelpIDString((Component)comp, (String)id);
        if (hs != null) {
            CSH.setHelpSet((Component)comp, (HelpSet)hs);
        }
    }

    public void enableHelp(MenuItem comp, @NotNull String id, HelpSet hs) {
        if (id == null) {
            IdeaHelpBroker.$$$reportNull$$$0(2);
        }
        CSH.setHelpIDString((MenuItem)comp, (String)id);
        if (hs != null) {
            CSH.setHelpSet((MenuItem)comp, (HelpSet)hs);
        }
    }

    public void enableHelpOnButton(Component comp, @NotNull String id, HelpSet hs) {
        if (id == null) {
            IdeaHelpBroker.$$$reportNull$$$0(3);
        }
        if (!(comp instanceof AbstractButton) && !(comp instanceof Button)) {
            throw new IllegalArgumentException("Invalid Component. comp must be either a javax.swing.AbstractButton or a java.awt.Button");
        }
        CSH.setHelpIDString((Component)comp, (String)id);
        if (hs != null) {
            CSH.setHelpSet((Component)comp, (HelpSet)hs);
        }
        if (comp instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)comp;
            button.addActionListener(this.getDisplayHelpFromSource());
        } else {
            Button button = (Button)comp;
            button.addActionListener(this.getDisplayHelpFromSource());
        }
    }

    public void enableHelpOnButton(@NotNull MenuItem comp, @NotNull String id, HelpSet hs) {
        if (comp == null) {
            IdeaHelpBroker.$$$reportNull$$$0(4);
        }
        if (id == null) {
            IdeaHelpBroker.$$$reportNull$$$0(5);
        }
        CSH.setHelpIDString((MenuItem)comp, (String)id);
        if (hs != null) {
            CSH.setHelpSet((MenuItem)comp, (HelpSet)hs);
        }
        comp.addActionListener(this.getDisplayHelpFromSource());
    }

    protected ActionListener getDisplayHelpFromFocus() {
        if (this.displayHelpFromFocus == null) {
            this.displayHelpFromFocus = new CSH.DisplayHelpFromFocus((HelpBroker)this);
        }
        return this.displayHelpFromFocus;
    }

    protected ActionListener getDisplayHelpFromSource() {
        if (this.displayHelpFromSource == null) {
            this.displayHelpFromSource = new CSH.DisplayHelpFromSource((HelpBroker)this);
        }
        return this.displayHelpFromSource;
    }

    public void setActivationWindow(Window window) {
        if (window instanceof Dialog) {
            Dialog tmpDialog = (Dialog)window;
            if (tmpDialog.isModal()) {
                this.myOwnerWindow = window;
                this.myModallyActivated = true;
            } else {
                this.myOwnerWindow = null;
                this.myModallyActivated = false;
            }
        } else {
            this.myOwnerWindow = null;
            this.myModallyActivated = false;
        }
    }

    private synchronized void createJHelp() {
        if (this.jhelp == null) {
            this.jhelp = new IdeaJHelp(this.myHelpSet);
            if (this.myFont != null) {
                this.jhelp.setFont(this.myFont);
            }
            if (this.myLocale != null) {
                this.jhelp.setLocale(this.myLocale);
            }
        }
    }

    private synchronized void createHelpWindow() {
        JDialog tmpDialog = null;
        Dimension size = null;
        Point pos = null;
        boolean resize = false;
        this.createJHelp();
        String helpTitle = this.myHelpSet.getTitle();
        if (this.myModallyActivated) {
            Window owner = null;
            try {
                Method m = Window.class.getMethod("getOwner", ArrayUtil.EMPTY_CLASS_ARRAY);
                if (m != null && this.myDialog != null) {
                    owner = (Window)m.invoke((Object)this.myDialog, ArrayUtil.EMPTY_OBJECT_ARRAY);
                }
            }
            catch (NoSuchMethodError | NoSuchMethodException throwable) {
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
            if (this.myDialog == null || owner != this.myOwnerWindow || this.modalDeactivated) {
                if (this.myFrame != null) {
                    pos = this.myFrame.getLocation();
                    size = this.myFrame.getSize();
                    this.myFrame.dispose();
                }
                if (this.myDialog != null) {
                    pos = this.myDialog.getLocation();
                    size = this.myDialog.getSize();
                    tmpDialog = this.myDialog;
                }
                this.myDialog = new JDialog((Dialog)this.myOwnerWindow, helpTitle);
                this.dl = new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        if (IdeaHelpBroker.this.myDialog.isShowing()) {
                            IdeaHelpBroker.this.myDialog.hide();
                        }
                        if (IdeaHelpBroker.this.myOwnerWindow != null) {
                            IdeaHelpBroker.this.myOwnerWindow.removeWindowListener(IdeaHelpBroker.this.dl);
                        }
                        IdeaHelpBroker.this.myOwnerWindow = null;
                        IdeaHelpBroker.this.modalDeactivated = true;
                    }
                };
                this.myOwnerWindow.addWindowListener(this.dl);
                this.modalDeactivated = false;
                if (size != null) {
                    this.myDialog.setSize(size);
                } else {
                    this.myDialog.setSize(this.HELP_WIDTH, this.HELP_HEIGHT);
                }
                if (pos != null) {
                    this.myDialog.setLocation(pos);
                }
                this.myDialog.getContentPane().add((Component)this.jhelp);
                if (tmpDialog != null) {
                    tmpDialog.dispose();
                }
            }
        } else {
            if (this.myFrame == null) {
                this.myFrame = new JFrame(helpTitle);
                resize = true;
                AppUIUtil.updateWindowIcon(this.myFrame);
                WindowAdapter l = new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        IdeaHelpBroker.this.myFrame.dispose();
                        WeakHashMap handlers = (WeakHashMap)ReflectionUtil.getField(JHelpPrintHandler.class, null, WeakHashMap.class, (String)"handlers");
                        if (handlers != null) {
                            handlers.remove(IdeaHelpBroker.this.jhelp);
                        }
                    }
                };
                this.myFrame.addWindowListener(l);
            } else {
                pos = this.myFrame.getLocation();
            }
            if (this.myDialog != null) {
                pos = this.myDialog.getLocation();
                size = this.myDialog.getSize();
                this.myDialog.dispose();
                this.myDialog = null;
                this.myOwnerWindow = null;
            }
            if (size != null) {
                this.myFrame.setSize(size);
            } else if (resize) {
                this.myFrame.setSize(this.HELP_WIDTH, this.HELP_HEIGHT);
            }
            if (pos != null) {
                this.myFrame.setLocation(pos);
            }
            this.myFrame.getContentPane().add((Component)this.jhelp);
            this.myFrame.setTitle(this.myHelpSet.getTitle());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
        }
        objectArray2[1] = "com/intellij/help/impl/IdeaHelpBroker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "enableHelpKey";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "enableHelp";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "enableHelpOnButton";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

