/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.tree;

import com.intellij.execution.dashboard.RunDashboardAnimator;
import com.intellij.execution.dashboard.RunDashboardNode;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

public class RunDashboardAnimatorImpl
implements RunDashboardAnimator,
Runnable,
Disposable {
    private static final int FRAMES_COUNT = 12;
    private static final int MOVIE_TIME = 1200;
    private static final int FRAME_TIME = 100;
    public static final Icon[] FRAMES = new Icon[12];
    private long myLastInvocationTime = -1L;
    private Alarm myAlarm;
    private final Set<RunDashboardNode> myNodes = new HashSet<RunDashboardNode>();
    private AbstractTreeBuilder myTreeBuilder;

    public RunDashboardAnimatorImpl(AbstractTreeBuilder builder2) {
        Disposer.register((Disposable)builder2, (Disposable)this);
        this.init(builder2);
    }

    public static int getCurrentFrameIndex() {
        return (int)(System.currentTimeMillis() % 1200L / 100L);
    }

    public static Icon getCurrentFrame() {
        return FRAMES[RunDashboardAnimatorImpl.getCurrentFrameIndex()];
    }

    protected void init(AbstractTreeBuilder treeBuilder) {
        this.myAlarm = new Alarm();
        this.myTreeBuilder = treeBuilder;
    }

    @Override
    public void run() {
        long time;
        if (!this.myNodes.isEmpty() && (time = System.currentTimeMillis()) - this.myLastInvocationTime >= 100L) {
            this.repaintSubTree();
            this.myLastInvocationTime = time;
        }
        this.scheduleRepaint();
    }

    public void addNode(@NotNull RunDashboardNode node) {
        if (node == null) {
            RunDashboardAnimatorImpl.$$$reportNull$$$0(0);
        }
        if (this.myNodes.add(node) && this.myNodes.size() == 1) {
            this.scheduleRepaint();
        }
    }

    public void removeNode(@NotNull RunDashboardNode node) {
        if (node == null) {
            RunDashboardAnimatorImpl.$$$reportNull$$$0(1);
        }
        if (this.myNodes.remove(node) && this.myNodes.isEmpty()) {
            this.repaintSubTree();
            if (this.myAlarm != null) {
                this.myAlarm.cancelAllRequests();
            }
        }
    }

    public void dispose() {
        this.myTreeBuilder = null;
        this.myNodes.clear();
        if (this.myAlarm != null) {
            this.myAlarm.cancelAllRequests();
            this.myAlarm = null;
        }
    }

    private void repaintSubTree() {
        if (this.myTreeBuilder == null || this.myTreeBuilder.isDisposed()) {
            return;
        }
        List toRemove2 = ContainerUtil.newSmartList();
        for (RunDashboardNode node : this.myNodes) {
            DefaultMutableTreeNode treeNode = this.myTreeBuilder.getUi().getNodeForElement((Object)node, false);
            if (treeNode != null) {
                this.myTreeBuilder.queueUpdateFrom((Object)node, false, false);
                continue;
            }
            toRemove2.add(node);
        }
        this.myNodes.removeAll(toRemove2);
    }

    private void scheduleRepaint() {
        if (this.myAlarm == null) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        if (!this.myNodes.isEmpty()) {
            this.myAlarm.addRequest((Runnable)this, 100);
        }
    }

    static {
        RunDashboardAnimatorImpl.FRAMES[0] = AllIcons.Process.Step_1;
        RunDashboardAnimatorImpl.FRAMES[1] = AllIcons.Process.Step_2;
        RunDashboardAnimatorImpl.FRAMES[2] = AllIcons.Process.Step_3;
        RunDashboardAnimatorImpl.FRAMES[3] = AllIcons.Process.Step_4;
        RunDashboardAnimatorImpl.FRAMES[4] = AllIcons.Process.Step_5;
        RunDashboardAnimatorImpl.FRAMES[5] = AllIcons.Process.Step_6;
        RunDashboardAnimatorImpl.FRAMES[6] = AllIcons.Process.Step_7;
        RunDashboardAnimatorImpl.FRAMES[7] = AllIcons.Process.Step_8;
        RunDashboardAnimatorImpl.FRAMES[8] = AllIcons.Process.Step_9;
        RunDashboardAnimatorImpl.FRAMES[9] = AllIcons.Process.Step_10;
        RunDashboardAnimatorImpl.FRAMES[10] = AllIcons.Process.Step_11;
        RunDashboardAnimatorImpl.FRAMES[11] = AllIcons.Process.Step_12;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "node";
        objectArray2[1] = "com/intellij/execution/dashboard/tree/RunDashboardAnimatorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeNode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

