/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.BraceHighlightingHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class BraceHighlighter
implements StartupActivity {
    private final Alarm myAlarm = new Alarm();

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            BraceHighlighter.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        eventMulticaster.addCaretListener(new CaretListener(){

            public void caretPositionChanged(CaretEvent e) {
                BraceHighlighter.this.myAlarm.cancelAllRequests();
                Editor editor = e.getEditor();
                SelectionModel selectionModel = editor.getSelectionModel();
                if (editor.getProject() != project || selectionModel.hasSelection()) {
                    return;
                }
                Document document = editor.getDocument();
                int line = e.getNewPosition().line;
                if (line < 0 || line >= document.getLineCount()) {
                    return;
                }
                BraceHighlighter.updateBraces(editor, BraceHighlighter.this.myAlarm);
            }
        }, (Disposable)project);
        SelectionListener mySelectionListener = new SelectionListener(){

            public void selectionChanged(SelectionEvent e) {
                BraceHighlighter.this.myAlarm.cancelAllRequests();
                Editor editor = e.getEditor();
                if (editor.getProject() != project) {
                    return;
                }
                TextRange oldRange = e.getOldRange();
                TextRange newRange = e.getNewRange();
                if (oldRange != null && newRange != null && !(oldRange.isEmpty() ^ newRange.isEmpty())) {
                    return;
                }
                BraceHighlighter.updateBraces(editor, BraceHighlighter.this.myAlarm);
            }
        };
        eventMulticaster.addSelectionListener(mySelectionListener, (Disposable)project);
        DocumentListener documentListener2 = new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                Editor[] editors;
                BraceHighlighter.this.myAlarm.cancelAllRequests();
                for (Editor editor : editors = EditorFactory.getInstance().getEditors(e.getDocument(), project)) {
                    BraceHighlighter.updateBraces(editor, BraceHighlighter.this.myAlarm);
                }
            }
        };
        eventMulticaster.addDocumentListener(documentListener2, (Disposable)project);
        project.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent e) {
                FileEditor newEditor;
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                BraceHighlighter.this.myAlarm.cancelAllRequests();
                FileEditor oldEditor = e.getOldEditor();
                if (oldEditor instanceof TextEditor) {
                    BraceHighlighter.this.clearBraces(((TextEditor)oldEditor).getEditor());
                }
                if ((newEditor = e.getNewEditor()) instanceof TextEditor) {
                    BraceHighlighter.updateBraces(((TextEditor)newEditor).getEditor(), BraceHighlighter.this.myAlarm);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/highlighting/BraceHighlighter$4", "selectionChanged"));
            }
        });
    }

    static void updateBraces(@NotNull Editor editor, @NotNull Alarm alarm) {
        Document document;
        if (editor == null) {
            BraceHighlighter.$$$reportNull$$$0(1);
        }
        if (alarm == null) {
            BraceHighlighter.$$$reportNull$$$0(2);
        }
        if ((document = editor.getDocument()) instanceof DocumentEx && ((DocumentEx)document).isInBulkUpdate()) {
            return;
        }
        BraceHighlightingHandler.lookForInjectedAndMatchBracesInOtherThread(editor, alarm, (Processor<BraceHighlightingHandler>)((Processor)handler2 -> {
            handler2.updateBraces();
            return false;
        }));
    }

    private void clearBraces(@NotNull Editor editor) {
        if (editor == null) {
            BraceHighlighter.$$$reportNull$$$0(3);
        }
        BraceHighlightingHandler.lookForInjectedAndMatchBracesInOtherThread(editor, this.myAlarm, (Processor<BraceHighlightingHandler>)((Processor)handler2 -> {
            handler2.clearBraceHighlighters();
            return false;
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alarm";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/highlighting/BraceHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateBraces";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "clearBraces";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

