/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.GeneralCodeStyleOptionsProvider;
import com.intellij.application.options.GeneralCodeStyleOptionsProviderEP;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.GradientViewport;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.CommaSeparatedIntegersField;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralCodeStylePanel
extends CodeStyleAbstractPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.GeneralCodeStylePanel");
    private static final String SYSTEM_DEPENDANT_STRING = ApplicationBundle.message((String)"combobox.crlf.system.dependent", (Object[])new Object[0]);
    private static final String UNIX_STRING = ApplicationBundle.message((String)"combobox.crlf.unix", (Object[])new Object[0]);
    private static final String WINDOWS_STRING = ApplicationBundle.message((String)"combobox.crlf.windows", (Object[])new Object[0]);
    private static final String MACINTOSH_STRING = ApplicationBundle.message((String)"combobox.crlf.mac", (Object[])new Object[0]);
    private final List<GeneralCodeStyleOptionsProvider> myAdditionalOptions;
    private IntegerField myRightMarginField;
    private JComboBox myLineSeparatorCombo;
    private JPanel myPanel;
    private JBCheckBox myCbWrapWhenTypingReachesRightMargin;
    private JCheckBox myEnableFormatterTags;
    private JTextField myFormatterOnTagField;
    private JTextField myFormatterOffTagField;
    private JCheckBox myAcceptRegularExpressionsCheckBox;
    private JPanel myMarkersPanel;
    private JBLabel myFormatterOffLabel;
    private JBLabel myFormatterOnLabel;
    private JPanel myMarkerOptionsPanel;
    private JPanel myAdditionalSettingsPanel;
    private JCheckBox myAutodetectIndentsBox;
    private JCheckBox myShowDetectedIndentNotification;
    private JPanel myIndentsDetectionPanel;
    private CommaSeparatedIntegersField myVisualGuides;
    private JBLabel myVisualGuidesHint;
    private JBLabel myLineSeparatorHint;
    private JBLabel myVisualGuidesLabel;
    private final JScrollPane myScrollPane;

    public GeneralCodeStylePanel(CodeStyleSettings settings) {
        super(settings);
        this.$$$setupUI$$$();
        this.myLineSeparatorCombo.addItem(SYSTEM_DEPENDANT_STRING);
        this.myLineSeparatorCombo.addItem(UNIX_STRING);
        this.myLineSeparatorCombo.addItem(WINDOWS_STRING);
        this.myLineSeparatorCombo.addItem(MACINTOSH_STRING);
        this.addPanelToWatch(this.myPanel);
        this.myRightMarginField.setDefaultValue(Integer.valueOf(settings.getDefaultRightMargin()));
        this.myEnableFormatterTags.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean tagsEnabled = GeneralCodeStylePanel.this.myEnableFormatterTags.isSelected();
                GeneralCodeStylePanel.this.setFormatterTagControlsEnabled(tagsEnabled);
            }
        });
        this.myAutodetectIndentsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isDetectIndent = GeneralCodeStylePanel.this.myAutodetectIndentsBox.isSelected();
                GeneralCodeStylePanel.this.myShowDetectedIndentNotification.setEnabled(isDetectIndent);
            }
        });
        this.myIndentsDetectionPanel.setBorder(IdeBorderFactory.createTitledBorder((String)ApplicationBundle.message((String)"settings.code.style.general.indents.detection", (Object[])new Object[0])));
        this.myPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
        this.myScrollPane = ScrollPaneFactory.createScrollPane(null, (boolean)true);
        this.myScrollPane.setViewport((JViewport)((Object)new GradientViewport(this.myPanel, (Insets)JBUI.insetsTop((int)5), true)));
        this.myAdditionalSettingsPanel.setLayout((LayoutManager)new VerticalFlowLayout(true, true));
        this.myAdditionalSettingsPanel.removeAll();
        this.myAdditionalOptions = ConfigurableWrapper.createConfigurables(GeneralCodeStyleOptionsProviderEP.EP_NAME);
        for (GeneralCodeStyleOptionsProvider provider : this.myAdditionalOptions) {
            JComponent generalSettingsComponent = provider.createComponent();
            if (generalSettingsComponent == null) continue;
            this.myAdditionalSettingsPanel.add(generalSettingsComponent);
        }
        this.myVisualGuidesLabel.setText(ApplicationBundle.message((String)"settings.code.style.visual.guides", (Object[])new Object[0]) + ":");
        this.myVisualGuidesHint.setForeground((Color)JBColor.GRAY);
        this.myVisualGuidesHint.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        this.myLineSeparatorHint.setForeground((Color)JBColor.GRAY);
        this.myLineSeparatorHint.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        this.myMarkersPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)30));
    }

    @Override
    protected int getRightMargin() {
        return this.myRightMarginField.getValue();
    }

    @Override
    @NotNull
    protected FileType getFileType() {
        LanguageFileType languageFileType = FileTypes.PLAIN_TEXT;
        if (languageFileType == null) {
            GeneralCodeStylePanel.$$$reportNull$$$0(0);
        }
        return languageFileType;
    }

    @Override
    protected String getPreviewText() {
        return null;
    }

    @Override
    public void apply(CodeStyleSettings settings) throws ConfigurationException {
        this.myVisualGuides.validateContent();
        this.myRightMarginField.validateContent();
        settings.setDefaultSoftMargins(this.myVisualGuides.getValue());
        settings.LINE_SEPARATOR = this.getSelectedLineSeparator();
        settings.setDefaultRightMargin(this.getRightMargin());
        settings.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN = this.myCbWrapWhenTypingReachesRightMargin.isSelected();
        settings.FORMATTER_TAGS_ENABLED = this.myEnableFormatterTags.isSelected();
        settings.FORMATTER_TAGS_ACCEPT_REGEXP = this.myAcceptRegularExpressionsCheckBox.isSelected();
        settings.FORMATTER_OFF_TAG = GeneralCodeStylePanel.getTagText(this.myFormatterOffTagField, settings.FORMATTER_OFF_TAG);
        settings.setFormatterOffPattern(GeneralCodeStylePanel.compilePattern(settings, this.myFormatterOffTagField, settings.FORMATTER_OFF_TAG));
        settings.FORMATTER_ON_TAG = GeneralCodeStylePanel.getTagText(this.myFormatterOnTagField, settings.FORMATTER_ON_TAG);
        settings.setFormatterOnPattern(GeneralCodeStylePanel.compilePattern(settings, this.myFormatterOnTagField, settings.FORMATTER_ON_TAG));
        settings.AUTODETECT_INDENTS = this.myAutodetectIndentsBox.isSelected();
        if (this.myShowDetectedIndentNotification.isEnabled()) {
            FileIndentOptionsProvider.setShowNotification((boolean)this.myShowDetectedIndentNotification.isSelected());
        }
        for (GeneralCodeStyleOptionsProvider option : this.myAdditionalOptions) {
            option.apply(settings);
        }
    }

    private void createUIComponents() {
        this.myRightMarginField = new IntegerField(ApplicationBundle.message((String)"editbox.right.margin.columns", (Object[])new Object[0]), 0, 1000);
        this.myVisualGuides = new CommaSeparatedIntegersField(ApplicationBundle.message((String)"settings.code.style.visual.guides", (Object[])new Object[0]), 0, 1000, "Optional");
    }

    @Nullable
    private static Pattern compilePattern(CodeStyleSettings settings, JTextField field, String patternText) {
        try {
            return Pattern.compile(patternText);
        }
        catch (PatternSyntaxException pse) {
            settings.FORMATTER_TAGS_ACCEPT_REGEXP = false;
            GeneralCodeStylePanel.showError(field, ApplicationBundle.message((String)"settings.code.style.general.formatter.marker.invalid.regexp", (Object[])new Object[0]));
            return null;
        }
    }

    private static String getTagText(JTextField field, String defaultValue) {
        String fieldText = field.getText();
        if (StringUtil.isEmpty((String)field.getText())) {
            return defaultValue;
        }
        return fieldText;
    }

    @Nullable
    private String getSelectedLineSeparator() {
        if (UNIX_STRING.equals(this.myLineSeparatorCombo.getSelectedItem())) {
            return "\n";
        }
        if (MACINTOSH_STRING.equals(this.myLineSeparatorCombo.getSelectedItem())) {
            return "\r";
        }
        if (WINDOWS_STRING.equals(this.myLineSeparatorCombo.getSelectedItem())) {
            return "\r\n";
        }
        return null;
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        if (!this.myVisualGuides.getValue().equals(settings.getDefaultSoftMargins())) {
            return true;
        }
        if (!Comparing.equal((String)this.getSelectedLineSeparator(), (String)settings.LINE_SEPARATOR)) {
            return true;
        }
        if (settings.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN ^ this.myCbWrapWhenTypingReachesRightMargin.isSelected()) {
            return true;
        }
        if (this.getRightMargin() != settings.getDefaultRightMargin()) {
            return true;
        }
        if (this.myEnableFormatterTags.isSelected() ? !settings.FORMATTER_TAGS_ENABLED || settings.FORMATTER_TAGS_ACCEPT_REGEXP != this.myAcceptRegularExpressionsCheckBox.isSelected() || !StringUtil.equals((CharSequence)this.myFormatterOffTagField.getText(), (CharSequence)settings.FORMATTER_OFF_TAG) || !StringUtil.equals((CharSequence)this.myFormatterOnTagField.getText(), (CharSequence)settings.FORMATTER_ON_TAG) : settings.FORMATTER_TAGS_ENABLED) {
            return true;
        }
        for (GeneralCodeStyleOptionsProvider option : this.myAdditionalOptions) {
            if (!option.isModified(settings)) continue;
            return true;
        }
        if (settings.AUTODETECT_INDENTS != this.myAutodetectIndentsBox.isSelected()) {
            return true;
        }
        return this.myShowDetectedIndentNotification.isEnabled() && FileIndentOptionsProvider.isShowNotification() != this.myShowDetectedIndentNotification.isSelected();
    }

    @Override
    public JComponent getPanel() {
        return this.myScrollPane;
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        this.myVisualGuides.setValue(settings.getDefaultSoftMargins());
        String lineSeparator = settings.LINE_SEPARATOR;
        if ("\n".equals(lineSeparator)) {
            this.myLineSeparatorCombo.setSelectedItem(UNIX_STRING);
        } else if ("\r\n".equals(lineSeparator)) {
            this.myLineSeparatorCombo.setSelectedItem(WINDOWS_STRING);
        } else if ("\r".equals(lineSeparator)) {
            this.myLineSeparatorCombo.setSelectedItem(MACINTOSH_STRING);
        } else {
            this.myLineSeparatorCombo.setSelectedItem(SYSTEM_DEPENDANT_STRING);
        }
        this.myRightMarginField.setValue(Integer.valueOf(settings.getDefaultRightMargin()));
        this.myCbWrapWhenTypingReachesRightMargin.setSelected(settings.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN);
        this.myAcceptRegularExpressionsCheckBox.setSelected(settings.FORMATTER_TAGS_ACCEPT_REGEXP);
        this.myEnableFormatterTags.setSelected(settings.FORMATTER_TAGS_ENABLED);
        this.myFormatterOnTagField.setText(settings.FORMATTER_ON_TAG);
        this.myFormatterOffTagField.setText(settings.FORMATTER_OFF_TAG);
        this.setFormatterTagControlsEnabled(settings.FORMATTER_TAGS_ENABLED);
        this.myAutodetectIndentsBox.setSelected(settings.AUTODETECT_INDENTS);
        this.myShowDetectedIndentNotification.setEnabled(this.myAutodetectIndentsBox.isSelected());
        this.myShowDetectedIndentNotification.setSelected(FileIndentOptionsProvider.isShowNotification());
        for (GeneralCodeStyleOptionsProvider option : this.myAdditionalOptions) {
            option.reset(settings);
        }
    }

    private void setFormatterTagControlsEnabled(boolean isEnabled) {
        this.myFormatterOffTagField.setEnabled(isEnabled);
        this.myFormatterOnTagField.setEnabled(isEnabled);
        this.myMarkersPanel.setEnabled(isEnabled);
        this.myAcceptRegularExpressionsCheckBox.setEnabled(isEnabled);
        this.myFormatterOffLabel.setEnabled(isEnabled);
        this.myFormatterOnLabel.setEnabled(isEnabled);
        this.myMarkerOptionsPanel.setEnabled(isEnabled);
    }

    @Override
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme2) {
        return EditorHighlighterFactory.getInstance().createEditorHighlighter(this.getFileType(), scheme2, null);
    }

    @Override
    public Language getDefaultLanguage() {
        return null;
    }

    private static void showError(JTextField field, String message) {
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.ERROR, null);
        balloonBuilder.setFadeoutTime(1500L);
        Balloon balloon = balloonBuilder.createBalloon();
        Rectangle rect = field.getBounds();
        Point p = new Point(0, rect.height);
        RelativePoint point = new RelativePoint((Component)field, p);
        balloon.show(point, Balloon.Position.below);
        Disposer.register((Disposable)ProjectManager.getInstance().getDefaultProject(), (Disposable)balloon);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/GeneralCodeStylePanel", "getFileType"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        JBLabel jBLabel;
        JComboBox jComboBox;
        JBCheckBox jBCheckBox;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JPanel jPanel2;
        JCheckBox jCheckBox3;
        JPanel jPanel3;
        JTextField jTextField;
        JTextField jTextField2;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        JPanel jPanel4;
        JCheckBox jCheckBox4;
        JPanel jPanel5;
        this.createUIComponents();
        this.myPanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, "West");
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel6.add((Component)jPanel7, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.formatter.control"), (int)0, (int)0, null, null));
        this.myEnableFormatterTags = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.enable.formatter.tags"));
        jPanel7.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myMarkersPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel4, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myFormatterOffLabel = jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.formatter.off.tag"));
        jPanel4.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFormatterOnLabel = jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.formatter.on.tag"));
        jPanel4.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFormatterOnTagField = jTextField2 = new JTextField();
        jPanel4.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myFormatterOffTagField = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myMarkerOptionsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, this.$$$getFont$$$(null, -1, -1, jPanel3.getFont()), null));
        this.myAcceptRegularExpressionsCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.formatter.marker.regexp"));
        jPanel3.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAdditionalSettingsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel2, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(5, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel8, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.right.margin.columns"));
        jPanel8.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel8.add((Component)spacer2, new GridConstraints(2, 5, 1, 1, 0, 1, 6, 1, null, null, null));
        IntegerField integerField = this.myRightMarginField;
        jPanel8.add((Component)integerField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myVisualGuidesLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.visual.guides"));
        jPanel8.add((Component)jBLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        CommaSeparatedIntegersField commaSeparatedIntegersField = this.myVisualGuides;
        jPanel8.add((Component)commaSeparatedIntegersField, new GridConstraints(3, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myVisualGuidesHint = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.visual.guides.hint"));
        jPanel8.add((Component)jBLabel2, new GridConstraints(4, 1, 1, 3, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setEnabled(true);
        this.$$$loadLabelText$$$((JLabel)jBLabel6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("margin.columns"));
        jPanel8.add((Component)jBLabel6, new GridConstraints(2, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel7, ResourceBundle.getBundle("messages/ApplicationBundle").getString("margin.columns"));
        jPanel8.add((Component)jBLabel7, new GridConstraints(3, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myCbWrapWhenTypingReachesRightMargin = jBCheckBox = new JBCheckBox();
        jBCheckBox.setHideActionText(false);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("wrapping.wrap.on.typing"));
        jPanel8.add((Component)jBCheckBox, new GridConstraints(2, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("combobox.line.separator.for.new.files"));
        jPanel8.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLineSeparatorCombo = jComboBox = new JComboBox();
        jPanel8.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(100, -1), null));
        this.myLineSeparatorHint = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("combobox.lineseparator.for.new.files.hint"));
        jPanel8.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIndentsDetectionPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.indents.detection"), 0, 0, null, null));
        this.myAutodetectIndentsBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.autodetect.indents"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowDetectedIndentNotification = jCheckBox = new JCheckBox();
        jCheckBox.setText("Show notifications about detected indents");
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, "Center");
        jBLabel5.setLabelFor(jTextField);
        jBLabel4.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

