/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application;

import com.intellij.openapi.application.ExperimentalFeature;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nullable;

public class ExperimentsDialog
extends DialogWrapper {
    protected ExperimentsDialog(@Nullable Project project) {
        super(project);
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        ExperimentalFeature[] features = (ExperimentalFeature[])Experiments.EP_NAME.getExtensions();
        JBTable table = new JBTable(this.createModel(features));
        table.getEmptyText().setText("No features available");
        table.getColumnModel().getColumn(0).setCellRenderer(this.getIdRenderer());
        table.getColumnModel().getColumn(1).setCellRenderer(this.getValueRenderer());
        table.getColumnModel().getColumn(1).setCellEditor((TableCellEditor)new BooleanTableCellEditor());
        table.setStriped(true);
        table.getSelectionModel().setSelectionMode(0);
        JTextArea myDescription = new JTextArea(3, 50);
        myDescription.setWrapStyleWord(true);
        myDescription.setLineWrap(true);
        myDescription.setEditable(false);
        table.getSelectionModel().addListSelectionListener(e -> myDescription.setText(features[table.getSelectedRow()].description));
        JScrollPane label2 = ScrollPaneFactory.createScrollPane((Component)myDescription);
        BorderLayoutPanel descriptionPanel = (BorderLayoutPanel)JBUI.Panels.simplePanel((Component)label2).withBorder((Border)IdeBorderFactory.createTitledBorder((String)"Description", (boolean)false));
        return JBUI.Panels.simplePanel((Component)ScrollPaneFactory.createScrollPane((Component)table)).addToBottom((Component)descriptionPanel);
    }

    private TableCellRenderer getValueRenderer() {
        return new BooleanTableCellRenderer(0);
    }

    private TableCellRenderer getIdRenderer() {
        return new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                this.append(String.valueOf(value));
            }
        };
    }

    private TableModel createModel(final ExperimentalFeature[] experimentalFeatures) {
        return new AbstractTableModel(){
            ExperimentalFeature[] features;
            {
                this.features = experimentalFeatures;
            }

            @Override
            public int getRowCount() {
                return this.features.length;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                String id = this.features[rowIndex].id;
                switch (columnIndex) {
                    case 0: {
                        return id;
                    }
                    case 1: {
                        return Experiments.isFeatureEnabled((String)id);
                    }
                }
                throw new IllegalArgumentException("Wrong column number");
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return "Name";
                    }
                    case 1: {
                        return "Value";
                    }
                }
                throw new IllegalArgumentException("Wrong column number");
            }

            @Override
            public void setValueAt(Object value, int rowIndex, int columnIndex) {
                if (value instanceof Boolean) {
                    Experiments.setFeatureEnabled((String)this.features[rowIndex].id, (boolean)((Boolean)value));
                }
            }
        };
    }
}

