/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.command.PSystemSingleLineFactory;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemVersionFactory
extends PSystemSingleLineFactory {
    @Override
    protected AbstractPSystem executeLine(String line) {
        try {
            if (line.matches("(?i)^(authors?|about)\\s*$")) {
                return PSystemVersion.createShowAuthors();
            }
            if (line.matches("(?i)^version\\s*$")) {
                return PSystemVersion.createShowVersion();
            }
            if (line.matches("(?i)^testdot\\s*$")) {
                return PSystemVersion.createTestDot();
            }
            if (line.matches("(?i)^checkversion\\s*$")) {
                return PSystemVersion.createCheckVersions(null, null);
            }
            Pattern p1 = Pattern.compile("(?i)^checkversion\\(proxy=([\\w.]+),port=(\\d+)\\)$");
            Matcher m1 = p1.matcher(line);
            if (m1.matches()) {
                String host = m1.group(1);
                String port2 = m1.group(2);
                return PSystemVersion.createCheckVersions(host, port2);
            }
            Pattern p2 = Pattern.compile("(?i)^checkversion\\(proxy=([\\w.]+)\\)$");
            Matcher m2 = p2.matcher(line);
            if (m2.matches()) {
                String host = m2.group(1);
                String port3 = "80";
                return PSystemVersion.createCheckVersions(host, "80");
            }
        }
        catch (IOException e) {
            Log.error("Error " + e);
        }
        return null;
    }
}

