/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.timingdiagram.ChangeState;
import net.sourceforge.plantuml.timingdiagram.Histogram;
import net.sourceforge.plantuml.timingdiagram.IntricatedPoint;
import net.sourceforge.plantuml.timingdiagram.Ribbon;
import net.sourceforge.plantuml.timingdiagram.TimeConstraint;
import net.sourceforge.plantuml.timingdiagram.TimeDrawing;
import net.sourceforge.plantuml.timingdiagram.TimeProjected;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.TimingStyle;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Player
implements TextBlock,
TimeProjected {
    private final String code;
    private final Display full;
    private final TimingStyle type;
    private final ISkinParam skinParam;
    private final TimingRuler ruler;
    private String initialState;
    private final Set<ChangeState> changes = new TreeSet<ChangeState>();
    private final List<TimeConstraint> constraints = new ArrayList<TimeConstraint>();
    private TimeDrawing cached;
    private Colors initialColors;

    public Player(String code, String full, TimingStyle type, ISkinParam skinParam, TimingRuler ruler) {
        this.code = code;
        this.full = Display.getWithNewlines(full);
        this.type = type;
        this.skinParam = skinParam;
        this.ruler = ruler;
    }

    private FontConfiguration getFontConfiguration() {
        return new FontConfiguration(this.skinParam, FontParam.ACTIVITY, null);
    }

    @Override
    public void drawU(UGraphic ug) {
        TextBlock title = this.getTitle();
        title.drawU(ug);
        Dimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
        this.drawLine(ug.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(new UStroke(1.0)), -5.0, dimTitle.getHeight() + 1.0, dimTitle.getWidth() + 1.0, dimTitle.getHeight() + 1.0, dimTitle.getWidth() + 1.0 + 10.0, 0.0);
    }

    public void drawContent(UGraphic ug) {
        ug = ug.apply(this.getTranslateForTimeDrawing(ug.getStringBounder()));
        this.getTimeDrawing().drawU(ug);
    }

    public void drawWidthHeader(UGraphic ug) {
        ug = ug.apply(this.getTranslateForTimeDrawing(ug.getStringBounder()));
        this.getTimeDrawing().getWidthHeader(ug.getStringBounder()).drawU(ug);
    }

    public double getGetWidthHeader(StringBounder stringBounder) {
        return this.getTimeDrawing().getWidthHeader(stringBounder).calculateDimension(stringBounder).getWidth();
    }

    private void drawLine(UGraphic ug, double ... coord) {
        for (int i = 0; i < coord.length - 2; i += 2) {
            double x1 = coord[i];
            double y1 = coord[i + 1];
            double x2 = coord[i + 2];
            double y2 = coord[i + 3];
            ug.apply(new UTranslate(x1, y1)).draw(new ULine(x2 - x1, y2 - y1));
        }
    }

    private UTranslate getTranslateForTimeDrawing(StringBounder stringBounder) {
        TextBlock title = this.getTitle();
        return new UTranslate(0.0, title.calculateDimension(stringBounder).getHeight() * 2.0);
    }

    private TextBlock getTitle() {
        return this.full.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    private TimeDrawing getTimeDrawing() {
        if (this.cached == null) {
            this.cached = this.computeTimeDrawing();
        }
        return this.cached;
    }

    private TimeDrawing computeTimeDrawing() {
        TimeDrawing result;
        if (this.type == TimingStyle.CONCISE) {
            result = new Ribbon(this.ruler, this.skinParam);
        } else if (this.type == TimingStyle.ROBUST) {
            result = new Histogram(this.ruler, this.skinParam);
        } else {
            throw new IllegalStateException();
        }
        result.setInitialState(this.initialState, this.initialColors);
        for (ChangeState change : this.changes) {
            result.addChange(change);
        }
        for (TimeConstraint constraint : this.constraints) {
            result.addConstraint(constraint);
        }
        return result;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        TextBlock title = this.getTitle();
        double width = this.ruler.getWidth();
        double zoneHeight = this.getZoneHeight();
        return new Dimension2DDouble(width, title.calculateDimension(stringBounder).getHeight() * 2.0 + zoneHeight);
    }

    private double getZoneHeight() {
        return this.getTimeDrawing().getHeight();
    }

    @Override
    public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        return null;
    }

    public void setState(TimeTick now, String state, String comment, Colors color) {
        if (now == null) {
            this.initialState = state;
            this.initialColors = color;
        } else {
            if (state == null) {
                throw new IllegalArgumentException();
            }
            this.changes.add(new ChangeState(now, state, comment, color));
        }
    }

    @Override
    public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick tick) {
        IntricatedPoint point2 = this.getTimeDrawing().getTimeProjection(stringBounder, tick);
        if (point2 == null) {
            return null;
        }
        UTranslate translation = this.getTranslateForTimeDrawing(stringBounder);
        return point2.translated(translation);
    }

    public void createConstraint(TimeTick tick1, TimeTick tick2, String message) {
        this.constraints.add(new TimeConstraint(tick1, tick2, message));
    }
}

