/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineConfigurable;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.svek.image.EntityImageClassHeader2;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UComment;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageClass
extends AbstractEntityImage
implements Stencil,
WithPorts {
    private final TextBlock body;
    private final Margins shield;
    private final EntityImageClassHeader2 header;
    private final Url url;
    private final double roundCorner;
    private final LineConfigurable lineConfig;

    public EntityImageClass(GraphvizVersion version, ILeaf entity, ISkinParam skinParam, PortionShower portionShower) {
        super(entity, entity.getColors(skinParam).mute(skinParam));
        this.lineConfig = entity;
        this.roundCorner = this.getSkinParam().getRoundCorner("", null);
        this.shield = version != null && version.useShield() && entity.hasNearDecoration() ? Margins.uniform(16.0) : Margins.NONE;
        boolean showMethods = portionShower.showPortion(EntityPortion.METHOD, entity);
        boolean showFields = portionShower.showPortion(EntityPortion.FIELD, entity);
        this.body = entity.getBodier().getBody(FontParam.CLASS_ATTRIBUTE, this.getSkinParam(), showMethods, showFields, entity.getStereotype());
        this.header = new EntityImageClassHeader2(entity, this.getSkinParam(), portionShower);
        this.url = entity.getUrl99();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimHeader = this.header.calculateDimension(stringBounder);
        Dimension2D dimBody = this.body == null ? new Dimension2DDouble(0.0, 0.0) : this.body.calculateDimension(stringBounder);
        double width = Math.max(dimBody.getWidth(), dimHeader.getWidth());
        if (width < this.getSkinParam().minClassWidth()) {
            width = this.getSkinParam().minClassWidth();
        }
        double height = dimBody.getHeight() + dimHeader.getHeight();
        return new Dimension2DDouble(width, height);
    }

    @Override
    public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        Rectangle2D result = this.body.getInnerPosition(member, stringBounder, strategy);
        if (result == null) {
            return result;
        }
        Dimension2D dimHeader = this.header.calculateDimension(stringBounder);
        UTranslate translate = new UTranslate(0.0, dimHeader.getHeight());
        return translate.apply(result);
    }

    @Override
    public final void drawU(UGraphic ug) {
        ug.draw(new UComment("class " + this.getEntity().getCode().getFullName()));
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        this.drawInternal(ug);
        if (this.url != null) {
            ug.closeAction();
        }
    }

    private void drawInternal(UGraphic ug) {
        HtmlColor classBorder;
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        Dimension2D dimHeader = this.header.calculateDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        URectangle rect = new URectangle(widthTotal, heightTotal, this.roundCorner, this.roundCorner, this.getEntity().getCode().getFullName());
        if (this.getSkinParam().shadowing()) {
            rect.setDeltaShadow(4.0);
        }
        if ((classBorder = this.lineConfig.getColors(this.getSkinParam()).getColor(ColorType.LINE)) == null) {
            classBorder = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.classBorder, this.getStereo());
        }
        ug = ug.apply(new UChangeColor(classBorder));
        HtmlColor backcolor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.classBackground, this.getStereo());
        }
        ug = ug.apply(new UChangeBackColor(backcolor));
        UStroke stroke = this.getStroke();
        ug.apply(stroke).draw(rect);
        HtmlColor headerBackcolor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.HEADER);
        if (headerBackcolor == null) {
            headerBackcolor = this.getSkinParam().getHtmlColor(ColorParam.classHeaderBackground, this.getStereo(), false);
        }
        if (headerBackcolor != null) {
            URectangle rect2 = new URectangle(widthTotal, dimHeader.getHeight());
            ug.apply(new UChangeBackColor(headerBackcolor)).apply(stroke).draw(rect2);
        }
        this.header.drawU(ug, dimTotal.getWidth(), dimHeader.getHeight());
        if (this.body != null) {
            UGraphic ug2 = UGraphicStencil.create(ug, this, stroke);
            UTranslate translate = new UTranslate(0.0, dimHeader.getHeight());
            this.body.drawU(ug2.apply(translate));
        }
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        Dimension2D dimHeader = this.header.calculateDimension(stringBounder);
        return ((WithPorts)((Object)this.body)).getPorts(stringBounder).translateY(dimHeader.getHeight());
    }

    private UStroke getStroke() {
        UStroke stroke = this.lineConfig.getColors(this.getSkinParam()).getSpecificLineStroke();
        if (stroke == null) {
            stroke = this.getSkinParam().getThickness(LineParam.classBorder, this.getStereo());
        }
        if (stroke == null) {
            stroke = new UStroke(1.5);
        }
        return stroke;
    }

    @Override
    public ShapeType getShapeType() {
        if (((ILeaf)this.getEntity()).getPortShortNames().size() > 0) {
            return ShapeType.RECTANGLE_HTML_FOR_PORTS;
        }
        return ShapeType.RECTANGLE;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return this.shield;
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return 0.0;
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.calculateDimension(stringBounder).getWidth();
    }
}

