/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileKilled;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.MergeStrategy;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.ParallelFtilesBuilder;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.UGraphicInterceptorOneSwimlane;
import net.sourceforge.plantuml.graphic.HtmlColorAndStyle;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ParallelBuilderSplit
extends ParallelFtilesBuilder {
    public ParallelBuilderSplit(ISkinParam skinParam, StringBounder stringBounder, List<Ftile> list, Ftile inner, Swimlane swimlane) {
        super(skinParam, stringBounder, list, inner, swimlane);
    }

    @Override
    protected Ftile doStep1() {
        Ftile result = this.getMiddle();
        ArrayList<Connection> conns = new ArrayList<Connection>();
        double x1 = 0.0;
        for (Ftile tmp : this.getList()) {
            FtileGeometry dim = tmp.calculateDimension(this.getStringBounder());
            conns.add(new ConnectionIn(tmp, x1, tmp.getInLinkRendering().getRainbow(HtmlColorAndStyle.build(this.skinParam())), this.getTextBlock(tmp.getInLinkRendering())));
            x1 += ((Dimension2D)dim).getWidth();
        }
        double totalWidth1 = result.calculateDimension(this.getStringBounder()).getWidth();
        conns.add(new ConnectionHline2(result, HtmlColorAndStyle.build(this.skinParam()), 0.0, this.getList(), totalWidth1));
        result = FtileUtils.addConnection(result, conns);
        return result;
    }

    @Override
    protected Ftile doStep2(Ftile result) {
        ArrayList<Connection> conns2 = new ArrayList<Connection>();
        double x2 = 0.0;
        boolean hasOut = false;
        for (Ftile tmp : this.getList()) {
            FtileGeometry dim = tmp.calculateDimension(this.getStringBounder());
            boolean hasOutTmp = tmp.calculateDimension(this.getStringBounder()).hasPointOut();
            if (hasOutTmp) {
                conns2.add(new ConnectionOut(tmp, x2, tmp.getOutLinkRendering().getRainbow(HtmlColorAndStyle.build(this.skinParam())), this.getHeightOfMiddle(), this.getTextBlock(tmp.getOutLinkRendering())));
                hasOut = true;
            }
            x2 += ((Dimension2D)dim).getWidth();
        }
        if (hasOut) {
            double totalWidth2 = result.calculateDimension(this.getStringBounder()).getWidth();
            conns2.add(new ConnectionHline2(result, HtmlColorAndStyle.build(this.skinParam()), this.getHeightOfMiddle(), this.getList(), totalWidth2));
            result = FtileUtils.addConnection(result, conns2);
        } else {
            result = new FtileKilled(result);
        }
        return result;
    }

    static class ConnectionOut
    extends AbstractConnection {
        private final double x;
        private final Rainbow arrowColor;
        private final double height;
        private final TextBlock text;

        public ConnectionOut(Ftile tmp, double x, Rainbow arrowColor, double height, TextBlock text) {
            super(tmp, null);
            this.x = x;
            this.arrowColor = arrowColor;
            this.height = height;
            this.text = text;
        }

        @Override
        public void drawU(UGraphic ug) {
            ug = ug.apply(new UTranslate(this.x, 0.0));
            FtileGeometry geo = this.getFtile1().calculateDimension(ug.getStringBounder());
            if (!geo.hasPointOut()) {
                assert (false);
                return;
            }
            Snake s = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            s.setLabel(this.text);
            s.goUnmergeable(MergeStrategy.NONE);
            s.addPoint(geo.getLeft(), geo.getOutY());
            s.addPoint(geo.getLeft(), this.height);
            ug.draw(s);
        }
    }

    static class ConnectionIn
    extends AbstractConnection {
        private final double x;
        private final Rainbow arrowColor;
        private final TextBlock text;

        public ConnectionIn(Ftile tmp, double x, Rainbow arrowColor, TextBlock text) {
            super(null, tmp);
            this.x = x;
            this.arrowColor = arrowColor;
            this.text = text;
        }

        @Override
        public void drawU(UGraphic ug) {
            ug = ug.apply(new UTranslate(this.x, 0.0));
            FtileGeometry geo = this.getFtile2().calculateDimension(ug.getStringBounder());
            double left = geo.getLeft();
            Snake s = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            s.setLabel(this.text);
            s.addPoint(left, 0.0);
            s.addPoint(left, geo.getInY());
            ug.draw(s);
        }
    }

    static class ConnectionHline3
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Ftile inner;
        private final double y;
        private final Rainbow arrowColor;
        private final List<Ftile> list;
        private final double totalWidth;

        public ConnectionHline3(Ftile inner, Rainbow arrowColor, double y, List<Ftile> list, double totalWidth) {
            super(null, null);
            this.inner = inner;
            this.y = y;
            this.arrowColor = arrowColor;
            this.list = list;
            this.totalWidth = totalWidth;
        }

        @Override
        public void drawU(UGraphic ug) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            double minX;
            StringBounder stringBounder = ug.getStringBounder();
            UTranslate left = this.inner.getSwimlaneIn().getTranslate();
            double maxX = minX = this.inner.calculateDimension(stringBounder).getLeft() + left.getDx();
            for (Ftile tmp : this.list) {
                FtileGeometry tmpGeom = tmp.calculateDimension(stringBounder);
                UTranslate tpos = this.inner.getTranslateFor(tmp, stringBounder);
                for (Swimlane sw : tmp.getSwimlanes()) {
                    double x = tmpGeom.translate(sw.getTranslate().compose(tpos)).getLeft();
                    minX = Math.min(minX, x);
                    maxX = Math.max(maxX, x);
                }
            }
            FtileGeometry dimInner = this.inner.calculateDimension(stringBounder);
            Snake s = new Snake(this.arrowHorizontalAlignment(), this.arrowColor);
            s.goUnmergeable(MergeStrategy.LIMITED);
            s.addPoint(minX, this.y);
            s.addPoint(maxX, this.y);
            ug.draw(s);
        }
    }

    static class ConnectionHline2
    extends AbstractConnection {
        private final Ftile inner;
        private final double y;
        private final Rainbow arrowColor;
        private final List<Ftile> list;
        private final double totalWidth;

        public ConnectionHline2(Ftile inner, Rainbow arrowColor, double y, List<Ftile> list, double totalWidth) {
            super(null, null);
            this.inner = inner;
            this.y = y;
            this.arrowColor = arrowColor;
            this.list = list;
            this.totalWidth = totalWidth;
        }

        @Override
        public void drawU(UGraphic ug) {
            double minX = Double.MAX_VALUE;
            double maxX = 0.0;
            if (this.y == 0.0 && ug instanceof UGraphicInterceptorOneSwimlane) {
                Swimlane intoSw = ((UGraphicInterceptorOneSwimlane)ug).getSwimlane();
                boolean found = false;
                for (Ftile tmp : this.list) {
                    if (tmp.getSwimlaneIn() != intoSw) continue;
                    found = true;
                }
                if (!found) {
                    return;
                }
            }
            StringBounder stringBounder = ug.getStringBounder();
            for (Ftile tmp : this.list) {
                UTranslate ut;
                if (this.y > 0.0 && !tmp.calculateDimension(stringBounder).hasPointOut() || (ut = this.inner.getTranslateFor(tmp, stringBounder)) == null) continue;
                double middle = tmp.calculateDimension(stringBounder).translate(ut).getLeft();
                minX = Math.min(minX, middle);
                maxX = Math.max(maxX, middle);
            }
            if (minX > this.totalWidth / 2.0) {
                minX = this.totalWidth / 2.0;
            }
            if (maxX < this.totalWidth / 2.0) {
                maxX = this.totalWidth / 2.0;
            }
            Snake s = new Snake(this.arrowHorizontalAlignment(), this.arrowColor);
            s.goUnmergeable(MergeStrategy.NONE);
            s.addPoint(minX, this.y);
            s.addPoint(maxX, this.y);
            ug.draw(s);
        }
    }
}

