/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SvgString {
    private final String svg;
    private final double scale;

    public SvgString(String svg, double scale) {
        this.svg = svg;
        this.scale = scale;
    }

    public String getSvg() {
        int idx;
        String result = this.svg;
        if (result.startsWith("<?xml")) {
            idx = result.indexOf("<svg");
            result = result.substring(idx);
        }
        if (result.startsWith("<svg")) {
            idx = result.indexOf(">");
            result = "<svg>" + result.substring(idx + 1);
        }
        if (!result.startsWith("<svg>")) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public int getData(String name) {
        Pattern p = Pattern.compile("(?i)" + name + "\\W+(\\d+)");
        Matcher m = p.matcher(this.svg);
        if (m.find()) {
            String s = m.group(1);
            return Integer.parseInt(s);
        }
        throw new IllegalStateException("Cannot find " + name);
    }

    public double getScale() {
        return this.scale;
    }
}

