/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.ui.CvsTabbedWindow;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class CvsTabbedWindowComponent
extends JPanel
implements DataProvider,
CvsTabbedWindow.DeactivateListener {
    private final JComponent myComponent;
    private final ContentManager myContentManager;
    private Content myContent;
    private final boolean myAddToolbar;
    private final String myHelpId;

    public CvsTabbedWindowComponent(JComponent component, boolean addDefaultToolbar, @Nullable ActionGroup toolbarActions, ContentManager contentManager, String helpId) {
        super(new BorderLayout());
        this.myAddToolbar = addDefaultToolbar;
        this.myComponent = component;
        this.myContentManager = contentManager;
        this.myHelpId = helpId;
        this.add((Component)this.myComponent, "Center");
        if (this.myAddToolbar) {
            DefaultActionGroup actionGroup = new DefaultActionGroup(null, false);
            actionGroup.add((AnAction)new CloseAction());
            if (toolbarActions != null) {
                actionGroup.add((AnAction)toolbarActions);
            }
            actionGroup.add((AnAction)new ContextHelpAction(helpId));
            this.add((Component)ActionManager.getInstance().createActionToolbar("DefaultCvsComponentToolbar", (ActionGroup)actionGroup, false).getComponent(), "West");
        }
    }

    public Object getData(String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.myHelpId;
        }
        return null;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public void setContent(Content content) {
        this.myContent = content;
    }

    public JComponent getShownComponent() {
        return this.myAddToolbar ? this : this.myComponent;
    }

    @Override
    public void deactivated() {
        if (this.myComponent instanceof CvsTabbedWindow.DeactivateListener) {
            ((CvsTabbedWindow.DeactivateListener)((Object)this.myComponent)).deactivated();
        }
    }

    private class CloseAction
    extends AnAction
    implements DumbAware {
        public CloseAction() {
            super(CvsBundle.message((String)"close.tab.action.name", (Object[])new Object[0]), "", AllIcons.Actions.Cancel);
        }

        public void actionPerformed(AnActionEvent e) {
            CvsTabbedWindowComponent.this.myContentManager.removeContent(CvsTabbedWindowComponent.this.myContent, true);
            CvsTabbedWindowComponent.this.deactivated();
        }
    }
}

