/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SmallMapSerializer;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.branchConfig.SvnLoadedBranchesStorage;
import org.jetbrains.idea.svn.branchConfig.UrlDescriptor;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000A\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\b\u0006*\u0001\u0012\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\r\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\u0014\u001a\u00020\u0010J\u0019\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\fH\u0086\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\b\u001a\"\u0012\u0004\u0012\u00020\n\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/idea/svn/branchConfig/SvnLoadedBranchesStorage;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myFile", "Ljava/io/File;", "myLock", "myState", "Lorg/jetbrains/idea/svn/SmallMapSerializer;", "", "", "Lorg/jetbrains/idea/svn/api/Url;", "", "Lorg/jetbrains/idea/svn/branchConfig/SvnBranchItem;", "activate", "", "createExternalizer", "org/jetbrains/idea/svn/branchConfig/SvnLoadedBranchesStorage$createExternalizer$1", "()Lorg/jetbrains/idea/svn/branchConfig/SvnLoadedBranchesStorage$createExternalizer$1;", "deactivate", "get", "url", "intellij.vcs.svn"})
public final class SvnLoadedBranchesStorage {
    private final Object myLock;
    private SmallMapSerializer<String, Map<Url, Collection<SvnBranchItem>>> myState;
    private final File myFile;
    private final Project myProject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Collection<SvnBranchItem> get(@NotNull Url url) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Object object = this.myLock;
        synchronized (object) {
            SmallMapSerializer<String, Map<Url, Collection<SvnBranchItem>>> smallMapSerializer = this.myState;
            collection = smallMapSerializer != null && (smallMapSerializer = smallMapSerializer.get("")) != null ? (Collection)smallMapSerializer.get(url) : null;
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void activate() {
        Object object = this.myLock;
        synchronized (object) {
            this.myState = new SmallMapSerializer(this.myFile, (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, this.createExternalizer());
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deactivate() {
        Map branchLocations = new LinkedHashMap();
        Map<VirtualFile, SvnBranchConfigurationNew> branchConfigurations = SvnBranchConfigurationManager.Companion.getInstance(this.myProject).getSvnBranchConfigManager().getMapCopy();
        for (SvnBranchConfigurationNew configuration : branchConfigurations.values()) {
            Map<Url, InfoStorage<List<SvnBranchItem>>> map = configuration.getBranchMap();
            for (Map.Entry<Url, InfoStorage<List<SvnBranchItem>>> unit : map.entrySet()) {
                Object object = unit;
                Url branchLocation = object.getKey();
                object = unit;
                InfoStorage<List<SvnBranchItem>> branches = object.getValue();
                object = branchLocations;
                List<SvnBranchItem> list = branches.getValue();
                object.put(branchLocation, list);
            }
        }
        Object object = this.myLock;
        synchronized (object) {
            SmallMapSerializer<String, Map<Url, Collection<SvnBranchItem>>> smallMapSerializer = this.myState;
            if (smallMapSerializer == null) {
                Intrinsics.throwNpe();
            }
            smallMapSerializer.put("", branchLocations);
            SmallMapSerializer<String, Map<Url, Collection<SvnBranchItem>>> smallMapSerializer2 = this.myState;
            if (smallMapSerializer2 == null) {
                Intrinsics.throwNpe();
            }
            smallMapSerializer2.force();
            this.myState = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final createExternalizer.1 createExternalizer() {
        return new DataExternalizer<Map<Url, ? extends Collection<? extends SvnBranchItem>>>(){

            public void save(@NotNull DataOutput out, @NotNull Map<Url, ? extends Collection<SvnBranchItem>> branchLocations) throws IOException {
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
                Intrinsics.checkParameterIsNotNull(branchLocations, (String)"branchLocations");
                DataOutput $receiver = out;
                $receiver.writeInt(branchLocations.size());
                Iterable iterable = $receiver$iv = (Iterable)branchLocations.entrySet();
                Object object = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)a;
                        Comparable comparable = (Comparable)((Object)((Url)it.getKey()).toDecodedString());
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        String string = ((Url)it.getKey()).toDecodedString();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                    }
                };
                for (Map.Entry entry : CollectionsKt.sortedWith((Iterable)iterable, (Comparator)object)) {
                    Comparator comparator;
                    object = entry;
                    Url branchLocation = (Url)object.getKey();
                    object = entry;
                    Collection branches = (Collection)object.getValue();
                    UrlDescriptor.ENCODED_URL_DESCRIPTOR.save($receiver, branchLocation);
                    $receiver.writeInt(branches.size());
                    Iterable iterable2 = branches;
                    Intrinsics.checkExpressionValueIsNotNull((Object)String.CASE_INSENSITIVE_ORDER, (String)"CASE_INSENSITIVE_ORDER");
                    Iterable iterable3 = iterable2;
                    Comparator comparator2 = new Comparator<T>(comparator){
                        final /* synthetic */ Comparator $comparator;
                        {
                            this.$comparator = comparator;
                        }

                        public final int compare(T a, T b) {
                            SvnBranchItem it;
                            Comparator comparator = this.$comparator;
                            SvnBranchItem svnBranchItem = (SvnBranchItem)a;
                            Comparator comparator2 = comparator;
                            String string = it.getUrl().toDecodedString();
                            it = (SvnBranchItem)b;
                            String string2 = it.getUrl().toDecodedString();
                            return comparator2.compare(string, string2);
                        }
                    };
                    for (SvnBranchItem item : CollectionsKt.sortedWith((Iterable)iterable3, (Comparator)comparator2)) {
                        UrlDescriptor.DECODED_URL_DESCRIPTOR.save($receiver, item.getUrl());
                        $receiver.writeLong(item.getCreationDateMillis());
                        $receiver.writeLong(item.getRevision());
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public Map<Url, Collection<SvnBranchItem>> read(@NotNull DataInput in) throws IOException {
                void var3_3;
                Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
                DataInput $receiver = in;
                Map branchLocations = new LinkedHashMap<K, V>();
                int branchLocationsSize = $receiver.readInt();
                int n = branchLocationsSize;
                for (int i = 0; i < n; ++i) {
                    int it = i;
                    Url branchLocation = UrlDescriptor.ENCODED_URL_DESCRIPTOR.read($receiver);
                    int branchesSize = $receiver.readInt();
                    List branches = new ArrayList<E>();
                    int n2 = 0;
                    int n3 = branchesSize;
                    while (n2 < n3) {
                        int it2 = n2++;
                        Url url = UrlDescriptor.DECODED_URL_DESCRIPTOR.read($receiver);
                        long creationDateMillis = $receiver.readLong();
                        long revision = $receiver.readLong();
                        branches.add(new SvnBranchItem(url, creationDateMillis, revision));
                    }
                    Map map = branchLocations;
                    List list = branches;
                    map.put(branchLocation, list);
                }
                return var3_3;
            }
        };
    }

    public SvnLoadedBranchesStorage(@NotNull Project myProject) {
        Intrinsics.checkParameterIsNotNull((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.myLock = new Object();
        File vcsFile = new File(PathManager.getSystemPath(), "vcs");
        File file = new File(vcsFile, "svn_branches");
        file.mkdirs();
        this.myFile = new File(file, this.myProject.getLocationHash());
    }
}

