/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.google.common.collect.HashMultiset;
import com.intellij.CommonBundle;
import com.intellij.diff.util.Side;
import com.intellij.dvcs.AmendComponent;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.SelectFilePathsDialog;
import com.intellij.openapi.vcs.checkin.CheckinChangeListSpecificComponent;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.PartialChangesUtil;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.textCompletion.DefaultTextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.textCompletion.ValuesCompletionProvider;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUserRegistry;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.checkin.GitCheckinExplicitMovementProvider;
import git4idea.checkin.GitCommitAuthorCorrector;
import git4idea.checkin.GitPushAfterCommitDialog;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.i18n.GitBundle;
import git4idea.index.GitIndexUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitFileUtils;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCheckinEnvironment
implements CheckinEnvironment {
    private static final Logger LOG = Logger.getInstance(GitCheckinEnvironment.class);
    @NonNls
    private static final String GIT_COMMIT_MSG_FILE_PREFIX = "git-commit-msg-";
    @NonNls
    private static final String GIT_COMMIT_MSG_FILE_EXT = ".txt";
    private final Project myProject;
    public static final SimpleDateFormat COMMIT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final VcsDirtyScopeManager myDirtyScopeManager;
    private final GitVcsSettings mySettings;
    private String myNextCommitAuthor;
    private boolean myNextCommitAmend;
    private Boolean myNextCommitIsPushed;
    private Date myNextCommitAuthorDate;
    private boolean myNextCommitSignOff;
    private boolean myNextCommitSkipHook;
    private boolean myNextCommitCommitRenamesSeparately;

    public GitCheckinEnvironment(@NotNull Project project, @NotNull VcsDirtyScopeManager dirtyScopeManager, GitVcsSettings settings) {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(0);
        }
        if (dirtyScopeManager == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(1);
        }
        this.myNextCommitAuthor = null;
        this.myNextCommitIsPushed = null;
        this.myProject = project;
        this.myDirtyScopeManager = dirtyScopeManager;
        this.mySettings = settings;
    }

    public boolean keepChangeListAfterCommit(ChangeList changeList) {
        return false;
    }

    public boolean isRefreshAfterCommitNeeded() {
        return true;
    }

    @Nullable
    public RefreshableOnComponent createAdditionalOptionsPanel(CheckinProjectPanel panel, PairConsumer<Object, Object> additionalDataConsumer) {
        return new GitCheckinOptions(this.myProject, panel);
    }

    @Nullable
    public String getDefaultMessageFor(FilePath[] filesToCheckin) {
        LinkedHashSet messages = ContainerUtil.newLinkedHashSet();
        GitRepositoryManager manager = GitUtil.getRepositoryManager(this.myProject);
        for (VirtualFile root : GitUtil.gitRoots(Arrays.asList(filesToCheckin))) {
            GitRepository repository = (GitRepository)manager.getRepositoryForRoot(root);
            if (repository == null) {
                LOG.warn("Unregistered repository: " + root);
                continue;
            }
            File mergeMsg = repository.getRepositoryFiles().getMergeMessageFile();
            File squashMsg = repository.getRepositoryFiles().getSquashMessageFile();
            try {
                if (!mergeMsg.exists() && !squashMsg.exists()) continue;
                String encoding = GitConfigUtil.getCommitEncoding(this.myProject, root);
                if (mergeMsg.exists()) {
                    messages.add(GitCheckinEnvironment.loadMessage(mergeMsg, encoding));
                    continue;
                }
                messages.add(GitCheckinEnvironment.loadMessage(squashMsg, encoding));
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Unable to load merge message", (Throwable)e);
            }
        }
        return DvcsUtil.joinMessagesOrNull((Collection)messages);
    }

    private static String loadMessage(@NotNull File messageFile, @NotNull String encoding) throws IOException {
        if (messageFile == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(2);
        }
        if (encoding == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(3);
        }
        return FileUtil.loadFile((File)messageFile, (String)encoding);
    }

    public String getHelpId() {
        return null;
    }

    public String getCheckinOperationName() {
        return GitBundle.getString("commit.action.name");
    }

    public List<VcsException> commit(@NotNull List<Change> changes, @NotNull String message, @NotNull NullableFunction<Object, Object> parametersHolder, Set<String> feedback) {
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(4);
        }
        if (message == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(5);
        }
        if (parametersHolder == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(6);
        }
        GitRepositoryManager manager = GitUtil.getRepositoryManager(this.myProject);
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        Map<VirtualFile, Collection<Change>> sortedChanges = GitCheckinEnvironment.sortChangesByGitRoot(changes, exceptions);
        LOG.assertTrue(!sortedChanges.isEmpty(), (Object)("Trying to commit an empty list of changes: " + changes));
        List<GitRepository> repositories = manager.sortByDependency(GitUtil.getRepositoriesFromRoots(manager, sortedChanges.keySet()));
        for (GitRepository repository : repositories) {
            Collection<Change> rootChanges = sortedChanges.get(repository.getRoot());
            Collection toCommit = ContainerUtil.map(rootChanges, CommitChange::new);
            if (this.myNextCommitCommitRenamesSeparately) {
                Pair<Collection<CommitChange>, List<VcsException>> pair = this.commitExplicitRenames(repository, toCommit, message);
                toCommit = (Collection)pair.first;
                List moveExceptions = (List)pair.second;
                if (!moveExceptions.isEmpty()) {
                    exceptions.addAll(moveExceptions);
                    continue;
                }
            }
            exceptions.addAll(this.commitRepository(repository, toCommit, message));
        }
        if (this.myNextCommitIsPushed != null && this.myNextCommitIsPushed.booleanValue() && exceptions.isEmpty()) {
            ModalityState modality = ModalityState.defaultModalityState();
            TransactionGuard.getInstance().assertWriteSafeContext(modality);
            ArrayList preselectedRepositories = ContainerUtil.newArrayList(repositories);
            GuiUtils.invokeLaterIfNeeded(() -> new GitPushAfterCommitDialog(this.myProject, preselectedRepositories, GitBranchUtil.getCurrentRepository(this.myProject)).showOrPush(), (ModalityState)modality, (Condition)this.myProject.getDisposed());
        }
        return exceptions;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    private List<VcsException> commitRepository(@NotNull GitRepository repository, @NotNull Collection<CommitChange> changes, @NotNull String message) {
        block14: {
            block13: {
                if (repository == null) {
                    GitCheckinEnvironment.$$$reportNull$$$0(7);
                }
                if (changes == null) {
                    GitCheckinEnvironment.$$$reportNull$$$0(8);
                }
                if (message == null) {
                    GitCheckinEnvironment.$$$reportNull$$$0(9);
                }
                exceptions = new ArrayList<VcsException>();
                root = repository.getRoot();
                partialAddResult = this.addPartialChangesToIndex(repository, changes);
                callback = (Runnable)partialAddResult.first;
                changedWithIndex = new HashSet<CommitChange>((Collection)partialAddResult.second);
                caseOnlyRenameChanges = this.addCaseOnlyRenamesToIndex(repository, changes, changedWithIndex, exceptions);
                if (exceptions.isEmpty()) break block13;
                v0 = exceptions;
                if (v0 == null) {
                    GitCheckinEnvironment.$$$reportNull$$$0(10);
                }
                return v0;
            }
            changedWithIndex.addAll(caseOnlyRenameChanges);
            if (changedWithIndex.isEmpty() && !Registry.is((String)"git.force.commit.using.staging.area")) ** GOTO lbl34
            GitCheckinEnvironment.runWithMessageFile(this.myProject, root, message, (ThrowableConsumer<File, VcsException>)(ThrowableConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$commitRepository$1(java.util.List com.intellij.openapi.vfs.VirtualFile java.util.Collection java.util.Set java.io.File ), (Ljava/io/File;)V)((GitCheckinEnvironment)this, exceptions, (VirtualFile)root, changes, changedWithIndex));
            if (exceptions.isEmpty()) break block14;
            v1 = exceptions;
            if (v1 == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(11);
            }
            return v1;
        }
        try {
            block15: {
                callback.run();
                break block15;
lbl34:
                // 1 sources

                try {
                    GitCheckinEnvironment.runWithMessageFile(this.myProject, root, message, (ThrowableConsumer<File, VcsException>)(ThrowableConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$commitRepository$2(java.util.Collection com.intellij.openapi.vfs.VirtualFile java.io.File ), (Ljava/io/File;)V)((GitCheckinEnvironment)this, changes, (VirtualFile)root));
                }
                catch (VcsException ex) {
                    partialOperation = GitCheckinEnvironment.isMergeCommit(ex);
                    if (partialOperation == PartialOperation.NONE) {
                        throw ex;
                    }
                    GitCheckinEnvironment.runWithMessageFile(this.myProject, root, message, (ThrowableConsumer<File, VcsException>)(ThrowableConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$commitRepository$3(com.intellij.openapi.vfs.VirtualFile java.util.Collection java.util.List git4idea.checkin.GitCheckinEnvironment$PartialOperation com.intellij.openapi.vcs.VcsException java.io.File ), (Ljava/io/File;)V)((GitCheckinEnvironment)this, (VirtualFile)root, changes, exceptions, (PartialOperation)partialOperation, (VcsException)ex));
                }
            }
            GitUtil.getRepositoryManager(this.myProject).updateRepository(root);
        }
        catch (VcsException e) {
            exceptions.add(e);
        }
        v2 = exceptions;
        if (v2 == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(12);
        }
        return v2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private List<VcsException> commitUsingIndex(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<CommitChange> rootChanges, @NotNull Set<CommitChange> changedWithIndex, @NotNull File messageFile) {
        ArrayList<VcsException> exceptions;
        block18: {
            List excludedStagedChanges;
            block16: {
                ArrayList<VcsException> arrayList;
                block17: {
                    if (project == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(13);
                    }
                    if (root == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(14);
                    }
                    if (rootChanges == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(15);
                    }
                    if (changedWithIndex == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(16);
                    }
                    if (messageFile == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(17);
                    }
                    exceptions = new ArrayList<VcsException>();
                    Set added = ContainerUtil.map2SetNotNull(rootChanges, it -> it.afterPath);
                    Set removed = ContainerUtil.map2SetNotNull(rootChanges, it -> it.beforePath);
                    removed.removeAll(added);
                    String rootPath = root.getPath();
                    Collection<Change> stagedChanges = GitChangeUtils.getStagedChanges(project, root);
                    LOG.debug("Found staged changes: " + GitUtil.getLogString(rootPath, stagedChanges));
                    excludedStagedChanges = ContainerUtil.filter(stagedChanges, change -> !added.contains(ChangesUtil.getAfterPath((Change)change)) && !removed.contains(ChangesUtil.getBeforePath((Change)change)));
                    if (!excludedStagedChanges.isEmpty()) {
                        LOG.info("Staged changes excluded for commit: " + GitUtil.getLogString(rootPath, excludedStagedChanges));
                        GitCheckinEnvironment.resetExcluded(project, root, excludedStagedChanges);
                    }
                    List<FilePath> alreadyHandledPaths = GitCheckinEnvironment.getPaths(changedWithIndex);
                    HashSet<FilePath> toAdd = new HashSet<FilePath>(added);
                    toAdd.removeAll(alreadyHandledPaths);
                    HashSet<FilePath> toRemove = new HashSet<FilePath>(removed);
                    toRemove.removeAll(alreadyHandledPaths);
                    LOG.debug(String.format("Updating index: added: %s, removed: %s", toAdd, toRemove));
                    GitCheckinEnvironment.updateIndex(project, root, toAdd, toRemove, exceptions);
                    if (exceptions.isEmpty()) break block16;
                    arrayList = exceptions;
                    if (excludedStagedChanges.isEmpty()) break block17;
                    GitCheckinEnvironment.restoreExcluded(project, root, excludedStagedChanges, exceptions);
                }
                ArrayList<VcsException> arrayList2 = arrayList;
                if (arrayList2 == null) {
                    GitCheckinEnvironment.$$$reportNull$$$0(18);
                }
                return arrayList2;
            }
            try {
                LOG.debug("Performing commit...");
                this.commitWithoutPaths(project, root, messageFile);
                break block18;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    if (!excludedStagedChanges.isEmpty()) {
                        GitCheckinEnvironment.restoreExcluded(project, root, excludedStagedChanges, exceptions);
                    }
                }
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        ArrayList<VcsException> arrayList = exceptions;
        if (arrayList == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @NotNull
    private Pair<Runnable, List<CommitChange>> addPartialChangesToIndex(@NotNull GitRepository repository, @NotNull Collection<CommitChange> changes) throws VcsException {
        Set changelistIds;
        if (repository == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(20);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(21);
        }
        if ((changelistIds = ContainerUtil.map2SetNotNull(changes, change -> change.changelistId)).isEmpty()) {
            Pair pair = Pair.create((Object)EmptyRunnable.INSTANCE, (Object)ContainerUtil.emptyList());
            if (pair == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(22);
            }
            return pair;
        }
        if (changelistIds.size() != 1) {
            throw new VcsException("Can't commit changes from multiple changelists at once");
        }
        String changelistId = (String)changelistIds.iterator().next();
        Pair result2 = (Pair)GitCheckinEnvironment.computeAfterLSTManagerUpdate(repository.getProject(), () -> {
            if (changes == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(89);
            }
            ArrayList<PartialLocalLineStatusTracker.PartialCommitHelper> helpers = new ArrayList<PartialLocalLineStatusTracker.PartialCommitHelper>();
            ArrayList<CommitChange> partialChanges = new ArrayList<CommitChange>();
            for (CommitChange change : changes) {
                PartialLocalLineStatusTracker tracker;
                if (change.changelistId == null || change.virtualFile == null || change.beforePath == null || change.afterPath == null || (tracker = PartialChangesUtil.getPartialTracker((Project)this.myProject, (VirtualFile)change.virtualFile)) == null) continue;
                if (!tracker.isOperational()) {
                    LOG.warn("Tracker is not operational for " + tracker.getVirtualFile().getPresentableUrl());
                    return null;
                }
                if (!tracker.hasPartialChangesToCommit()) continue;
                helpers.add(tracker.handlePartialCommit(Side.LEFT, Collections.singletonList(changelistId)));
                partialChanges.add(change);
            }
            return Pair.create(helpers, partialChanges);
        });
        if (result2 == null) {
            throw new VcsException("Can't collect partial changes to commit");
        }
        List helpers = (List)result2.first;
        List partialChanges = (List)result2.second;
        ArrayList<FilePath> pathsToDelete = new ArrayList<FilePath>();
        for (CommitChange change2 : partialChanges) {
            if (!change2.isMove()) continue;
            pathsToDelete.add((FilePath)ObjectUtils.assertNotNull((Object)change2.beforePath));
        }
        LOG.debug(String.format("Updating index for partial changes: removing: %s", pathsToDelete));
        GitFileUtils.delete(this.myProject, repository.getRoot(), pathsToDelete, "--ignore-unmatch");
        LOG.debug(String.format("Updating index for partial changes: changes: %s", partialChanges));
        for (int i = 0; i < partialChanges.size(); ++i) {
            CommitChange change2;
            change2 = (CommitChange)partialChanges.get(i);
            FilePath path = (FilePath)ObjectUtils.assertNotNull((Object)change2.afterPath);
            PartialLocalLineStatusTracker.PartialCommitHelper helper = (PartialLocalLineStatusTracker.PartialCommitHelper)helpers.get(i);
            VirtualFile file = change2.virtualFile;
            if (file == null) {
                throw new VcsException("Can't find file: " + path.getPath());
            }
            GitIndexUtil.StagedFile stagedFile = GitCheckinEnvironment.getStagedFile(repository, change2);
            boolean isExecutable = stagedFile != null && stagedFile.isExecutable();
            Pair.NonNull fileContent = LoadTextUtil.charsetForWriting((Project)repository.getProject(), (VirtualFile)file, (String)helper.getContent(), (Charset)file.getCharset());
            GitIndexUtil.write(repository, path, (byte[])fileContent.second, isExecutable);
        }
        Runnable callback = () -> ApplicationManager.getApplication().invokeLater(() -> {
            for (PartialLocalLineStatusTracker.PartialCommitHelper helper : helpers) {
                try {
                    helper.applyChanges();
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        });
        Pair pair = Pair.create((Object)callback, (Object)partialChanges);
        if (pair == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(23);
        }
        return pair;
    }

    @Nullable
    private static GitIndexUtil.StagedFile getStagedFile(@NotNull GitRepository repository, @NotNull CommitChange change) throws VcsException {
        GitIndexUtil.StagedFile file;
        GitIndexUtil.StagedFile file2;
        FilePath bPath;
        if (repository == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(24);
        }
        if (change == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(25);
        }
        if ((bPath = change.beforePath) != null && (file2 = GitIndexUtil.listStaged(repository, bPath)) != null) {
            return file2;
        }
        FilePath aPath = change.afterPath;
        if (aPath != null && (file = GitIndexUtil.listStaged(repository, aPath)) != null) {
            return file;
        }
        return null;
    }

    @Nullable
    private static <T> T computeAfterLSTManagerUpdate(@NotNull Project project, @NotNull Computable<T> computation) {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(26);
        }
        if (computation == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(27);
        }
        assert (!ApplicationManager.getApplication().isDispatchThread());
        FutureResult ref = new FutureResult();
        LineStatusTrackerManager.getInstance((Project)project).invokeAfterUpdate(() -> {
            if (computation == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(88);
            }
            try {
                ref.set(computation.compute());
            }
            catch (Throwable e) {
                ref.setException(e);
            }
        });
        try {
            return (T)ref.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    @NotNull
    private List<CommitChange> addCaseOnlyRenamesToIndex(@NotNull GitRepository repository, @NotNull Collection<CommitChange> changes, @NotNull Set<CommitChange> alreadyProcessed, @NotNull List<VcsException> exceptions) {
        if (repository == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(28);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(29);
        }
        if (alreadyProcessed == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(30);
        }
        if (exceptions == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(31);
        }
        if (SystemInfo.isFileSystemCaseSensitive) {
            List<CommitChange> list = Collections.emptyList();
            if (list == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(32);
            }
            return list;
        }
        List caseOnlyRenames = ContainerUtil.filter(changes, it -> {
            if (alreadyProcessed == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(87);
            }
            return !alreadyProcessed.contains(it) && GitCheckinEnvironment.isCaseOnlyRename(it);
        });
        if (caseOnlyRenames.isEmpty()) {
            List list = caseOnlyRenames;
            if (list == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(33);
            }
            return list;
        }
        LOG.info("Committing case only rename: " + GitCheckinEnvironment.getLogString(repository.getRoot().getPath(), caseOnlyRenames) + " in " + DvcsUtil.getShortRepositoryName((Repository)repository));
        List pathsToAdd = ContainerUtil.map((Collection)caseOnlyRenames, it -> it.afterPath);
        List pathsToDelete = ContainerUtil.map((Collection)caseOnlyRenames, it -> it.beforePath);
        LOG.debug(String.format("Updating index for case only changes: added: %s,\n removed: %s", pathsToAdd, pathsToDelete));
        GitCheckinEnvironment.updateIndex(this.myProject, repository.getRoot(), pathsToAdd, pathsToDelete, exceptions);
        List list = caseOnlyRenames;
        if (list == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(34);
        }
        return list;
    }

    private static boolean isCaseOnlyRename(@NotNull CommitChange change) {
        if (change == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(35);
        }
        if (SystemInfo.isFileSystemCaseSensitive) {
            return false;
        }
        if (!change.isMove()) {
            return false;
        }
        FilePath afterPath = (FilePath)ObjectUtils.assertNotNull((Object)change.afterPath);
        FilePath beforePath = (FilePath)ObjectUtils.assertNotNull((Object)change.beforePath);
        return GitUtil.isCaseOnlyChange(beforePath.getPath(), afterPath.getPath());
    }

    @NotNull
    private static List<FilePath> getPaths(@NotNull Collection<CommitChange> changes) {
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(36);
        }
        ArrayList<FilePath> files = new ArrayList<FilePath>();
        for (CommitChange change : changes) {
            if (ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY.equals((Object)change.beforePath, (Object)change.afterPath)) {
                ContainerUtil.addIfNotNull(files, (Object)change.beforePath);
                continue;
            }
            ContainerUtil.addIfNotNull(files, (Object)change.beforePath);
            ContainerUtil.addIfNotNull(files, (Object)change.afterPath);
        }
        ArrayList<FilePath> arrayList = files;
        if (arrayList == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    @NotNull
    private static String getLogString(@NotNull String root, @NotNull Collection<CommitChange> changes) {
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(38);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(39);
        }
        String string = GitUtil.getLogString(root, changes, it -> it.beforePath, it -> it.afterPath);
        if (string == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    private Pair<Collection<CommitChange>, List<VcsException>> commitExplicitRenames(@NotNull GitRepository repository, @NotNull Collection<CommitChange> changes, @NotNull String message) {
        Pair<List<CommitChange>, List<CommitChange>> committedAndNewChanges;
        VirtualFile root;
        ArrayList<VcsException> exceptions;
        block10: {
            Pair pair;
            if (repository == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(41);
            }
            if (changes == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(42);
            }
            if (message == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(43);
            }
            exceptions = new ArrayList<VcsException>();
            root = repository.getRoot();
            List beforePaths = ContainerUtil.mapNotNull(changes, it -> it.beforePath);
            List afterPaths = ContainerUtil.mapNotNull(changes, it -> it.afterPath);
            HashSet<GitCheckinExplicitMovementProvider.Movement> movedPaths = new HashSet<GitCheckinExplicitMovementProvider.Movement>();
            for (GitCheckinExplicitMovementProvider provider : (GitCheckinExplicitMovementProvider[])GitCheckinExplicitMovementProvider.EP_NAME.getExtensions()) {
                Collection<GitCheckinExplicitMovementProvider.Movement> providerMovements = provider.collectExplicitMovements(this.myProject, beforePaths, afterPaths);
                if (providerMovements.isEmpty()) continue;
                message = provider.getCommitMessage(message);
                movedPaths.addAll(providerMovements);
            }
            try {
                committedAndNewChanges = this.addExplicitMovementsToIndex(repository, changes, movedPaths);
                if (committedAndNewChanges != null) break block10;
                pair = Pair.create(changes, exceptions);
            }
            catch (VcsException e) {
                exceptions.add(e);
                Pair pair2 = Pair.create(changes, exceptions);
                if (pair2 == null) {
                    GitCheckinEnvironment.$$$reportNull$$$0(46);
                }
                return pair2;
            }
            if (pair == null) {
                GitCheckinEnvironment.$$$reportNull$$$0(44);
            }
            return pair;
        }
        List movedChanges = (List)committedAndNewChanges.first;
        Collection newRootChanges = (Collection)committedAndNewChanges.second;
        GitCheckinEnvironment.runWithMessageFile(this.myProject, root, message, (ThrowableConsumer<File, VcsException>)((ThrowableConsumer)moveMessageFile -> exceptions.addAll(this.commitUsingIndex(this.myProject, root, movedChanges, (Set<CommitChange>)new HashSet<CommitChange>(movedChanges), (File)moveMessageFile))));
        Pair pair = Pair.create((Object)newRootChanges, exceptions);
        if (pair == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(45);
        }
        return pair;
    }

    @Nullable
    private Pair<List<CommitChange>, List<CommitChange>> addExplicitMovementsToIndex(@NotNull GitRepository repository, @NotNull Collection<CommitChange> changes, @NotNull Collection<GitCheckinExplicitMovementProvider.Movement> explicitMoves) throws VcsException {
        if (repository == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(47);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(48);
        }
        if (explicitMoves == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(49);
        }
        if ((explicitMoves = GitCheckinEnvironment.filterExcludedChanges(explicitMoves, changes)).isEmpty()) {
            return null;
        }
        LOG.info("Committing explicit rename: " + explicitMoves + " in " + DvcsUtil.getShortRepositoryName((Repository)repository));
        HashMap<FilePath, GitCheckinExplicitMovementProvider.Movement> movesMap = new HashMap<FilePath, GitCheckinExplicitMovementProvider.Movement>();
        for (GitCheckinExplicitMovementProvider.Movement move2 : explicitMoves) {
            movesMap.put(move2.getBefore(), move2);
            movesMap.put(move2.getAfter(), move2);
        }
        ArrayList<CommitChange> nextCommitChanges = new ArrayList<CommitChange>();
        ArrayList<CommitChange> movedChanges = new ArrayList<CommitChange>();
        HashMap<FilePath, CommitChange> affectedBeforePaths = new HashMap<FilePath, CommitChange>();
        HashMap<FilePath, CommitChange> affectedAfterPaths = new HashMap<FilePath, CommitChange>();
        for (CommitChange change2 : changes) {
            if (!movesMap.containsKey(change2.beforePath) && !movesMap.containsKey(change2.afterPath)) {
                nextCommitChanges.add(change2);
                continue;
            }
            if (change2.beforePath != null) {
                affectedBeforePaths.put(change2.beforePath, change2);
            }
            if (change2.afterPath == null) continue;
            affectedAfterPaths.put(change2.afterPath, change2);
        }
        List pathsToDelete = ContainerUtil.map(explicitMoves, move -> move.getBefore());
        LOG.debug(String.format("Updating index for explicit movements: removing: %s", pathsToDelete));
        GitFileUtils.delete(this.myProject, repository.getRoot(), pathsToDelete, "--ignore-unmatch");
        for (GitCheckinExplicitMovementProvider.Movement move3 : explicitMoves) {
            FilePath beforeFilePath = move3.getBefore();
            FilePath afterFilePath = move3.getAfter();
            CommitChange bChange = (CommitChange)ObjectUtils.assertNotNull(affectedBeforePaths.get(beforeFilePath));
            CommitChange aChange = (CommitChange)ObjectUtils.assertNotNull(affectedAfterPaths.get(afterFilePath));
            if (bChange.beforeRevision == null) {
                LOG.warn(String.format("Unknown before revision: %s, %s", bChange, aChange));
                continue;
            }
            GitIndexUtil.StagedFile stagedFile = GitIndexUtil.listTree(repository, beforeFilePath, bChange.beforeRevision);
            if (stagedFile == null) {
                LOG.warn(String.format("Can't get revision for explicit move: %s -> %s", beforeFilePath, afterFilePath));
                continue;
            }
            LOG.debug(String.format("Updating index for explicit movements: adding movement: %s -> %s", beforeFilePath, afterFilePath));
            Hash hash = HashImpl.build((String)stagedFile.getBlobHash());
            boolean isExecutable = stagedFile.isExecutable();
            GitIndexUtil.updateIndex(repository, afterFilePath, hash, isExecutable);
            nextCommitChanges.add(new CommitChange(afterFilePath, afterFilePath, null, null, aChange.changelistId, aChange.virtualFile));
            movedChanges.add(new CommitChange(beforeFilePath, afterFilePath, null, null, null, null));
            affectedBeforePaths.remove(beforeFilePath);
            affectedAfterPaths.remove(afterFilePath);
        }
        affectedBeforePaths.forEach((bPath, change) -> nextCommitChanges.add(new CommitChange(change.beforePath, null, change.beforeRevision, null, change.changelistId, change.virtualFile)));
        affectedAfterPaths.forEach((aPath, change) -> nextCommitChanges.add(new CommitChange(null, change.afterPath, null, change.afterRevision, change.changelistId, change.virtualFile)));
        if (movedChanges.isEmpty()) {
            return null;
        }
        return Pair.create(movedChanges, nextCommitChanges);
    }

    @NotNull
    private static List<GitCheckinExplicitMovementProvider.Movement> filterExcludedChanges(@NotNull Collection<GitCheckinExplicitMovementProvider.Movement> explicitMoves, @NotNull Collection<CommitChange> changes) {
        if (explicitMoves == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(50);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(51);
        }
        HashMultiset movedPathsMultiSet = HashMultiset.create();
        for (GitCheckinExplicitMovementProvider.Movement move2 : explicitMoves) {
            movedPathsMultiSet.add((Object)move2.getBefore());
            movedPathsMultiSet.add((Object)move2.getAfter());
        }
        HashMultiset beforePathsMultiSet = HashMultiset.create();
        HashMultiset afterPathsMultiSet = HashMultiset.create();
        for (CommitChange change : changes) {
            ContainerUtil.addIfNotNull((Collection)beforePathsMultiSet, (Object)change.beforePath);
            ContainerUtil.addIfNotNull((Collection)afterPathsMultiSet, (Object)change.afterPath);
        }
        List list = ContainerUtil.filter(explicitMoves, move -> movedPathsMultiSet.count((Object)move.getBefore()) == 1 && movedPathsMultiSet.count((Object)move.getAfter()) == 1 && beforePathsMultiSet.count((Object)move.getBefore()) == 1 && afterPathsMultiSet.count((Object)move.getAfter()) == 1 && beforePathsMultiSet.count((Object)move.getAfter()) == 0 && afterPathsMultiSet.count((Object)move.getBefore()) == 0);
        if (list == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(52);
        }
        return list;
    }

    private static void resetExcluded(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<Change> changes) throws VcsException {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(53);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(54);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(55);
        }
        THashSet allPaths = new THashSet(ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY);
        allPaths.addAll(ContainerUtil.mapNotNull(changes, ChangesUtil::getAfterPath));
        allPaths.addAll(ContainerUtil.mapNotNull(changes, ChangesUtil::getBeforePath));
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, (Collection)allPaths)) {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.RESET);
            handler.endOptions();
            handler.addParameters(paths);
            Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
        }
    }

    private static void restoreExcluded(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<Change> changes, @NotNull List<VcsException> exceptions) throws VcsException {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(56);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(57);
        }
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(58);
        }
        if (exceptions == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(59);
        }
        HashSet<FilePath> toAdd = new HashSet<FilePath>();
        HashSet<FilePath> toRemove = new HashSet<FilePath>();
        for (Change change : changes) {
            if (GitCheckinEnvironment.addAsCaseOnlyRename(project, root, change)) continue;
            ContainerUtil.addIfNotNull(toAdd, (Object)ChangesUtil.getAfterPath((Change)change));
            ContainerUtil.addIfNotNull(toRemove, (Object)ChangesUtil.getBeforePath((Change)change));
        }
        toRemove.removeAll(toAdd);
        LOG.debug(String.format("Restoring staged changes after commit: added: %s, removed: %s", toAdd, toRemove));
        GitCheckinEnvironment.updateIndex(project, root, toAdd, toRemove, exceptions);
    }

    private static boolean addAsCaseOnlyRename(@NotNull Project project, @NotNull VirtualFile root, @NotNull Change change) {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(60);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(61);
        }
        if (change == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(62);
        }
        try {
            CommitChange commitChange = new CommitChange(change);
            if (!GitCheckinEnvironment.isCaseOnlyRename(commitChange)) {
                return false;
            }
            FilePath beforePath = (FilePath)ObjectUtils.assertNotNull((Object)commitChange.beforePath);
            FilePath afterPath = (FilePath)ObjectUtils.assertNotNull((Object)commitChange.afterPath);
            LOG.debug(String.format("Restoring staged case-only rename after commit: %s", change));
            GitLineHandler h = new GitLineHandler(project, root, GitCommand.MV);
            h.addParameters("-f", beforePath.getPath(), afterPath.getPath());
            Git.getInstance().runCommandWithoutCollectingOutput(h).getOutputOrThrow(new int[0]);
            return true;
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    public List<VcsException> commit(List<Change> changes, String preparedComment) {
        return this.commit(changes, preparedComment, (NullableFunction<Object, Object>)FunctionUtil.nullConstant(), null);
    }

    private boolean mergeCommit(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<CommitChange> rootChanges, @NotNull File messageFile, @NotNull List<VcsException> exceptions, @NotNull PartialOperation partialOperation) {
        String output;
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(63);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(64);
        }
        if (rootChanges == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(65);
        }
        if (messageFile == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(66);
        }
        if (exceptions == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(67);
        }
        if (partialOperation == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(68);
        }
        Set added = ContainerUtil.map2SetNotNull(rootChanges, it -> it.afterPath);
        Set removed = ContainerUtil.map2SetNotNull(rootChanges, it -> it.beforePath);
        removed.removeAll(added);
        HashSet<FilePath> realAdded = new HashSet<FilePath>();
        HashSet<FilePath> realRemoved = new HashSet<FilePath>();
        GitLineHandler diff = new GitLineHandler(project, root, GitCommand.DIFF);
        diff.setSilent(true);
        diff.setStdoutSuppressed(true);
        diff.addParameters("--diff-filter=ADMRUX", "--name-status", "--no-renames", "HEAD");
        diff.endOptions();
        try {
            output = Git.getInstance().runCommand(diff).getOutputOrThrow(new int[0]);
        }
        catch (VcsException ex) {
            exceptions.add(ex);
            return false;
        }
        String rootPath = root.getPath();
        StringTokenizer lines = new StringTokenizer(output, "\n", false);
        block11: while (lines.hasMoreTokens()) {
            String line = lines.nextToken().trim();
            if (line.length() == 0) continue;
            String[] tk = line.split("\t");
            switch (tk[0].charAt(0)) {
                case 'A': 
                case 'M': {
                    realAdded.add(VcsUtil.getFilePath((String)(rootPath + "/" + tk[1])));
                    continue block11;
                }
                case 'D': {
                    realRemoved.add(VcsUtil.getFilePath((String)(rootPath + "/" + tk[1]), (boolean)false));
                    continue block11;
                }
            }
            throw new IllegalStateException("Unexpected status: " + line);
        }
        realAdded.removeAll(added);
        realRemoved.removeAll(removed);
        if (realAdded.size() != 0 || realRemoved.size() != 0) {
            ArrayList<FilePath> files = new ArrayList<FilePath>();
            files.addAll(realAdded);
            files.addAll(realRemoved);
            Ref mergeAll = new Ref();
            try {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    if (partialOperation == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(85);
                    }
                    if (project == null) {
                        GitCheckinEnvironment.$$$reportNull$$$0(86);
                    }
                    String message = GitBundle.message("commit.partial.merge.message", partialOperation.getName());
                    SelectFilePathsDialog dialog = new SelectFilePathsDialog(project, files, message, null, "Commit All Files", CommonBundle.getCancelButtonText(), false);
                    dialog.setTitle(GitBundle.getString("commit.partial.merge.title"));
                    dialog.show();
                    mergeAll.set((Object)dialog.isOK());
                });
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to invoke a message box on AWT thread", ex);
            }
            if (!((Boolean)mergeAll.get()).booleanValue()) {
                return false;
            }
            if (!GitCheckinEnvironment.updateIndex(project, root, realAdded, realRemoved, exceptions)) {
                return false;
            }
            for (FilePath f : realAdded) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(f);
            }
            for (FilePath f : realRemoved) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(f);
            }
        }
        try {
            this.commitWithoutPaths(project, root, messageFile);
        }
        catch (VcsException ex) {
            exceptions.add(ex);
            return false;
        }
        return true;
    }

    private void commitWithoutPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull File messageFile) throws VcsException {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(69);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(70);
        }
        if (messageFile == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(71);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.COMMIT);
        handler.setStdoutSuppressed(false);
        handler.addParameters("-F", messageFile.getAbsolutePath());
        if (this.myNextCommitAmend) {
            handler.addParameters("--amend");
        }
        if (this.myNextCommitAuthor != null) {
            handler.addParameters("--author=" + this.myNextCommitAuthor);
        }
        if (this.myNextCommitAuthorDate != null) {
            handler.addParameters("--date", COMMIT_DATE_FORMAT.format(this.myNextCommitAuthorDate));
        }
        if (this.myNextCommitSignOff) {
            handler.addParameters("--signoff");
        }
        if (this.myNextCommitSkipHook) {
            handler.addParameters("--no-verify");
        }
        handler.endOptions();
        Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
    }

    private static PartialOperation isMergeCommit(VcsException ex) {
        String message = ex.getMessage();
        if (message.contains("cannot do a partial commit during a merge")) {
            return PartialOperation.MERGE;
        }
        if (message.contains("cannot do a partial commit during a cherry-pick")) {
            return PartialOperation.CHERRY_PICK;
        }
        return PartialOperation.NONE;
    }

    private static boolean updateIndex(Project project, VirtualFile root, Collection<FilePath> added, Collection<FilePath> removed, List<VcsException> exceptions) {
        boolean rc = true;
        if (!added.isEmpty()) {
            try {
                GitFileUtils.addPaths(project, root, added);
            }
            catch (VcsException ex) {
                exceptions.add(ex);
                rc = false;
            }
        }
        if (!removed.isEmpty()) {
            try {
                GitFileUtils.delete(project, root, removed, "--ignore-unmatch", "--cached");
            }
            catch (VcsException ex) {
                exceptions.add(ex);
                rc = false;
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static File createCommitMessageFile(@NotNull Project project, @NotNull VirtualFile root, @NotNull String message) throws IOException {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(72);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(73);
        }
        if (message == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(74);
        }
        File file = FileUtil.createTempFile((String)GIT_COMMIT_MSG_FILE_PREFIX, (String)GIT_COMMIT_MSG_FILE_EXT);
        file.deleteOnExit();
        String encoding = GitConfigUtil.getCommitEncoding(project, root);
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);){
            out.write(message);
        }
        File file2 = file;
        if (file2 == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(75);
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runWithMessageFile(@NotNull Project project, @NotNull VirtualFile root, @NotNull String message, @NotNull ThrowableConsumer<File, VcsException> task) throws VcsException {
        File messageFile;
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(76);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(77);
        }
        if (message == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(78);
        }
        if (task == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(79);
        }
        try {
            messageFile = GitCheckinEnvironment.createCommitMessageFile(project, root, message);
        }
        catch (IOException ex) {
            throw new VcsException("Creation of commit message file failed", (Throwable)ex);
        }
        try {
            task.consume((Object)messageFile);
        }
        finally {
            if (!messageFile.delete()) {
                LOG.warn("Failed to remove temporary file: " + messageFile);
            }
        }
    }

    public List<VcsException> scheduleMissingFileForDeletion(List<FilePath> files) {
        Map<VirtualFile, List<FilePath>> sortedFiles;
        ArrayList<VcsException> rc = new ArrayList<VcsException>();
        try {
            sortedFiles = GitUtil.sortFilePathsByGitRoot(files);
        }
        catch (VcsException e) {
            rc.add(e);
            return rc;
        }
        for (Map.Entry<VirtualFile, List<FilePath>> e : sortedFiles.entrySet()) {
            try {
                VirtualFile root = e.getKey();
                GitFileUtils.delete(this.myProject, root, (Collection<FilePath>)e.getValue(), new String[0]);
                this.markRootDirty(root);
            }
            catch (VcsException ex) {
                rc.add(ex);
            }
        }
        return rc;
    }

    private void commit(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<FilePath> files, @NotNull File message) throws VcsException {
        if (project == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(80);
        }
        if (root == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(81);
        }
        if (files == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(82);
        }
        if (message == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(83);
        }
        boolean amend = this.myNextCommitAmend;
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.COMMIT);
            handler.setStdoutSuppressed(false);
            if (this.myNextCommitSignOff) {
                handler.addParameters("--signoff");
            }
            if (amend) {
                handler.addParameters("--amend");
            } else {
                amend = true;
            }
            if (this.myNextCommitSkipHook) {
                handler.addParameters("--no-verify");
            }
            handler.addParameters("--only", "-F", message.getAbsolutePath());
            if (this.myNextCommitAuthor != null) {
                handler.addParameters("--author=" + this.myNextCommitAuthor);
            }
            if (this.myNextCommitAuthorDate != null) {
                handler.addParameters("--date", COMMIT_DATE_FORMAT.format(this.myNextCommitAuthorDate));
            }
            handler.endOptions();
            handler.addParameters(paths);
            Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
        }
    }

    public List<VcsException> scheduleUnversionedFilesForAddition(List<VirtualFile> files) {
        Map<VirtualFile, List<VirtualFile>> sortedFiles;
        ArrayList<VcsException> rc = new ArrayList<VcsException>();
        try {
            sortedFiles = GitUtil.sortFilesByGitRoot(files);
        }
        catch (VcsException e) {
            rc.add(e);
            return rc;
        }
        for (Map.Entry<VirtualFile, List<VirtualFile>> e : sortedFiles.entrySet()) {
            try {
                VirtualFile root = e.getKey();
                GitFileUtils.addFiles(this.myProject, root, (Collection<VirtualFile>)e.getValue());
                this.markRootDirty(root);
            }
            catch (VcsException ex) {
                rc.add(ex);
            }
        }
        return rc;
    }

    private static Map<VirtualFile, Collection<Change>> sortChangesByGitRoot(@NotNull List<Change> changes, List<VcsException> exceptions) {
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(84);
        }
        HashMap<VirtualFile, Collection<Change>> result2 = new HashMap<VirtualFile, Collection<Change>>();
        for (Change change : changes) {
            VirtualFile vcsRoot;
            FilePath filePath = ChangesUtil.getFilePath((Change)change);
            try {
                vcsRoot = GitUtil.getGitRoot(filePath.getParentPath());
            }
            catch (VcsException e) {
                exceptions.add(e);
                continue;
            }
            ArrayList<Change> changeList = (ArrayList<Change>)result2.get(vcsRoot);
            if (changeList == null) {
                changeList = new ArrayList<Change>();
                result2.put(vcsRoot, changeList);
            }
            changeList.add(change);
        }
        return result2;
    }

    private void markRootDirty(VirtualFile root) {
        this.myDirtyScopeManager.dirDirtyRecursively(root);
    }

    public void reset() {
        this.myNextCommitAmend = false;
        this.myNextCommitAuthor = null;
        this.myNextCommitIsPushed = null;
        this.myNextCommitAuthorDate = null;
        this.myNextCommitSkipHook = false;
    }

    public void setNextCommitIsPushed(Boolean nextCommitIsPushed) {
        this.myNextCommitIsPushed = nextCommitIsPushed;
    }

    public void setSkipHooksForNextCommit(boolean skipHooksForNextCommit) {
        this.myNextCommitSkipHook = skipHooksForNextCommit;
    }

    public void setCommitRenamesSeparately(boolean commitRenamesSeparately) {
        this.myNextCommitCommitRenamesSeparately = commitRenamesSeparately;
    }

    private /* synthetic */ void lambda$commitRepository$3(VirtualFile root, @NotNull Collection changes, List exceptions, PartialOperation partialOperation, VcsException ex, File messageFile) throws VcsException {
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(90);
        }
        if (!this.mergeCommit(this.myProject, root, changes, messageFile, exceptions, partialOperation)) {
            throw ex;
        }
    }

    private /* synthetic */ void lambda$commitRepository$2(@NotNull Collection changes, VirtualFile root, File messageFile) throws VcsException {
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(91);
        }
        List<FilePath> files = GitCheckinEnvironment.getPaths(changes);
        this.commit(this.myProject, root, files, messageFile);
    }

    private /* synthetic */ void lambda$commitRepository$1(List exceptions, VirtualFile root, @NotNull Collection changes, Set changedWithIndex, File messageFile) throws VcsException {
        if (changes == null) {
            GitCheckinEnvironment.$$$reportNull$$$0(92);
        }
        exceptions.addAll(this.commitUsingIndex(this.myProject, root, changes, changedWithIndex, messageFile));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 52: 
            case 75: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 52: 
            case 75: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyScopeManager";
                break;
            }
            case 2: 
            case 17: 
            case 66: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 4: 
            case 8: 
            case 21: 
            case 29: 
            case 36: 
            case 39: 
            case 42: 
            case 48: 
            case 51: 
            case 55: 
            case 58: 
            case 84: 
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 5: 
            case 9: 
            case 43: 
            case 74: 
            case 78: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersHolder";
                break;
            }
            case 7: 
            case 20: 
            case 24: 
            case 28: 
            case 41: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 52: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/checkin/GitCheckinEnvironment";
                break;
            }
            case 14: 
            case 38: 
            case 54: 
            case 57: 
            case 61: 
            case 64: 
            case 70: 
            case 73: 
            case 77: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 15: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootChanges";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedWithIndex";
                break;
            }
            case 25: 
            case 35: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 27: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 30: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyProcessed";
                break;
            }
            case 31: 
            case 59: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitMoves";
                break;
            }
            case 68: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partialOperation";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/checkin/GitCheckinEnvironment";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "commitRepository";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "commitUsingIndex";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "addPartialChangesToIndex";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "addCaseOnlyRenamesToIndex";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaths";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogString";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "commitExplicitRenames";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "filterExcludedChanges";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommitMessageFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadMessage";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "commitRepository";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 52: 
            case 75: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "commitUsingIndex";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addPartialChangesToIndex";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getStagedFile";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "computeAfterLSTManagerUpdate";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addCaseOnlyRenamesToIndex";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isCaseOnlyRename";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPaths";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getLogString";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "commitExplicitRenames";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitMovementsToIndex";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "filterExcludedChanges";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "resetExcluded";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "restoreExcluded";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "addAsCaseOnlyRename";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "mergeCommit";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "commitWithoutPaths";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "createCommitMessageFile";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "runWithMessageFile";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "sortChangesByGitRoot";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "lambda$mergeCommit$26";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addCaseOnlyRenamesToIndex$12";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "lambda$computeAfterLSTManagerUpdate$11";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addPartialChangesToIndex$8";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "lambda$commitRepository$3";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "lambda$commitRepository$2";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "lambda$commitRepository$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 52: 
            case 75: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CommitChange {
        @Nullable
        public final FilePath beforePath;
        @Nullable
        public final FilePath afterPath;
        @Nullable
        public final VcsRevisionNumber beforeRevision;
        @Nullable
        public final VcsRevisionNumber afterRevision;
        @Nullable
        public final String changelistId;
        @Nullable
        public final VirtualFile virtualFile;

        public CommitChange(@NotNull Change change) {
            if (change == null) {
                CommitChange.$$$reportNull$$$0(0);
            }
            this.beforePath = ChangesUtil.getBeforePath((Change)change);
            this.afterPath = ChangesUtil.getAfterPath((Change)change);
            ContentRevision bRev = change.getBeforeRevision();
            ContentRevision aRev = change.getAfterRevision();
            this.beforeRevision = bRev != null ? bRev.getRevisionNumber() : null;
            this.afterRevision = aRev != null ? aRev.getRevisionNumber() : null;
            this.changelistId = change instanceof ChangeListChange ? ((ChangeListChange)change).getChangeListId() : null;
            this.virtualFile = aRev instanceof CurrentContentRevision ? ((CurrentContentRevision)aRev).getVirtualFile() : null;
        }

        public CommitChange(@Nullable FilePath beforePath, @Nullable FilePath afterPath, @Nullable VcsRevisionNumber beforeRevision, @Nullable VcsRevisionNumber afterRevision, @Nullable String changelistId, @Nullable VirtualFile virtualFile) {
            assert (beforePath != null || afterPath != null);
            this.beforePath = beforePath;
            this.afterPath = afterPath;
            this.beforeRevision = beforeRevision;
            this.afterRevision = afterRevision;
            this.changelistId = changelistId;
            this.virtualFile = virtualFile;
        }

        public boolean isMove() {
            if (this.beforePath == null || this.afterPath == null) {
                return false;
            }
            return !ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY.equals((Object)this.beforePath, (Object)this.afterPath);
        }

        public String toString() {
            return String.format("%s -> %s, changelist: %s", this.beforePath, this.afterPath, this.changelistId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "git4idea/checkin/GitCheckinEnvironment$CommitChange", "<init>"));
        }
    }

    public class GitCheckinOptions
    implements CheckinChangeListSpecificComponent,
    RefreshableOnComponent {
        private final List<GitCheckinExplicitMovementProvider> myExplicitMovementProviders;
        @NotNull
        private final CheckinProjectPanel myCheckinProjectPanel;
        @NotNull
        private final JPanel myPanel;
        @NotNull
        private final EditorTextField myAuthorField;
        @Nullable
        private Date myAuthorDate;
        @NotNull
        private final AmendComponent myAmendComponent;
        @NotNull
        private final JCheckBox mySignOffCheckbox;
        @NotNull
        private final JCheckBox myCommitRenamesSeparatelyCheckbox;
        @NotNull
        private final BalloonBuilder myAuthorNotificationBuilder;
        @Nullable
        private Balloon myAuthorBalloon;

        GitCheckinOptions(@NotNull Project project, CheckinProjectPanel panel) {
            if (project == null) {
                GitCheckinOptions.$$$reportNull$$$0(0);
            }
            if (panel == null) {
                GitCheckinOptions.$$$reportNull$$$0(1);
            }
            this.myExplicitMovementProviders = ContainerUtil.filter((Object[])GitCheckinExplicitMovementProvider.EP_NAME.getExtensions(), it -> it.isEnabled(GitCheckinEnvironment.this.myProject));
            this.myCheckinProjectPanel = panel;
            this.myAuthorField = this.createTextField(project, this.getAuthors(project));
            this.myAuthorField.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    GitCheckinOptions.this.clearAuthorWarn();
                }
            });
            this.myAuthorNotificationBuilder = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JLabel(GitBundle.getString("commit.author.diffs"))).setBorderInsets(UIManager.getInsets("Balloon.error.textInsets")).setBorderColor(DialogWrapper.BALLOON_WARNING_BORDER).setFillColor(DialogWrapper.BALLOON_WARNING_BACKGROUND).setHideOnClickOutside(true).setHideOnFrameResize(false);
            this.myAuthorField.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L && GitCheckinOptions.this.myAuthorField.isShowing() && !StringUtil.isEmptyOrSpaces((String)GitCheckinOptions.this.myAuthorField.getText())) {
                        GitCheckinOptions.this.showAuthorBalloonNotification();
                        GitCheckinOptions.this.myAuthorField.removeHierarchyListener((HierarchyListener)this);
                    }
                }
            });
            JBLabel authorLabel = new JBLabel(GitBundle.message("commit.author", new Object[0]));
            authorLabel.setLabelFor((Component)this.myAuthorField);
            this.myAmendComponent = new MyAmendComponent(project, GitUtil.getRepositoryManager(project), panel);
            this.mySignOffCheckbox = new JBCheckBox("Sign-off commit", GitCheckinEnvironment.this.mySettings.shouldSignOffCommit());
            this.mySignOffCheckbox.setMnemonic(71);
            this.mySignOffCheckbox.setToolTipText(this.getToolTip(project, panel));
            this.myCommitRenamesSeparatelyCheckbox = new JBCheckBox(this.getExplicitMovementDescription(), GitCheckinEnvironment.this.mySettings.isCommitRenamesSeparately());
            GridBag gb = new GridBag().setDefaultAnchor(17).setDefaultInsets((Insets)JBUI.insets((int)2));
            this.myPanel = new JPanel(new GridBagLayout());
            this.myPanel.add((Component)authorLabel, gb.nextLine().next());
            this.myPanel.add((Component)this.myAuthorField, gb.next().fillCellHorizontally().weightx(1.0));
            this.myPanel.add(this.myAmendComponent.getComponent(), gb.nextLine().next().coverLine());
            this.myPanel.add((Component)this.mySignOffCheckbox, gb.nextLine().next().coverLine());
            this.myPanel.add((Component)this.myCommitRenamesSeparatelyCheckbox, gb.nextLine().next().coverLine());
        }

        public boolean isAmend() {
            return this.myAmendComponent.isAmend();
        }

        @NotNull
        private String getToolTip(@NotNull Project project, @NotNull CheckinProjectPanel panel) {
            VcsUser user;
            if (project == null) {
                GitCheckinOptions.$$$reportNull$$$0(2);
            }
            if (panel == null) {
                GitCheckinOptions.$$$reportNull$$$0(3);
            }
            String signature = (user = (VcsUser)ContainerUtil.getFirstItem((List)ContainerUtil.mapNotNull((Collection)panel.getRoots(), it -> {
                if (project == null) {
                    GitCheckinOptions.$$$reportNull$$$0(17);
                }
                return GitUserRegistry.getInstance(project).getUser((VirtualFile)it);
            }))) != null ? StringUtil.escapeXml((String)VcsUserUtil.toExactString((VcsUser)user)) : "";
            String string = "<html>Adds the following line at the end of the commit message:<br/>Signed-off by: " + signature + "</html>";
            if (string == null) {
                GitCheckinOptions.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        private String getExplicitMovementDescription() {
            if (this.myExplicitMovementProviders.size() == 1) {
                String string = this.myExplicitMovementProviders.get(0).getDescription();
                if (string == null) {
                    GitCheckinOptions.$$$reportNull$$$0(5);
                }
                return string;
            }
            if ("Create extra commit with file movements" == null) {
                GitCheckinOptions.$$$reportNull$$$0(6);
            }
            return "Create extra commit with file movements";
        }

        private void showAuthorBalloonNotification() {
            if (this.myAuthorBalloon == null || this.myAuthorBalloon.isDisposed()) {
                this.myAuthorBalloon = this.myAuthorNotificationBuilder.createBalloon();
                this.myAuthorBalloon.show(new RelativePoint((Component)this.myAuthorField, new Point(this.myAuthorField.getWidth() / 2, this.myAuthorField.getHeight())), Balloon.Position.below);
            }
        }

        @NotNull
        private List<String> getAuthors(@NotNull Project project) {
            if (project == null) {
                GitCheckinOptions.$$$reportNull$$$0(7);
            }
            HashSet<String> authors = new HashSet<String>(this.getUsersList(project));
            ContainerUtil.addAll(authors, (Object[])GitCheckinEnvironment.this.mySettings.getCommitAuthors());
            ArrayList<String> list = new ArrayList<String>(authors);
            Collections.sort(list);
            ArrayList<String> arrayList = list;
            if (arrayList == null) {
                GitCheckinOptions.$$$reportNull$$$0(8);
            }
            return arrayList;
        }

        @NotNull
        private EditorTextField createTextField(@NotNull Project project, @NotNull List<String> list) {
            if (project == null) {
                GitCheckinOptions.$$$reportNull$$$0(9);
            }
            if (list == null) {
                GitCheckinOptions.$$$reportNull$$$0(10);
            }
            ValuesCompletionProvider.ValuesCompletionProviderDumbAware completionProvider = new ValuesCompletionProvider.ValuesCompletionProviderDumbAware((TextCompletionValueDescriptor)new DefaultTextCompletionValueDescriptor.StringValueDescriptor(), list);
            TextFieldWithCompletion textFieldWithCompletion = new TextFieldWithCompletion(project, (TextCompletionProvider)completionProvider, "", true, true, true);
            if (textFieldWithCompletion == null) {
                GitCheckinOptions.$$$reportNull$$$0(11);
            }
            return textFieldWithCompletion;
        }

        @NotNull
        private List<String> getUsersList(@NotNull Project project) {
            if (project == null) {
                GitCheckinOptions.$$$reportNull$$$0(12);
            }
            VcsUserRegistry userRegistry = (VcsUserRegistry)ServiceManager.getService((Project)project, VcsUserRegistry.class);
            List list = ContainerUtil.map((Collection)userRegistry.getUsers(), VcsUserUtil::toExactString);
            if (list == null) {
                GitCheckinOptions.$$$reportNull$$$0(13);
            }
            return list;
        }

        private void updateRenamesCheckboxState() {
            if (this.myExplicitMovementProviders.isEmpty() || !Registry.is((String)"git.allow.explicit.commit.renames")) {
                this.myCommitRenamesSeparatelyCheckbox.setVisible(false);
                this.myCommitRenamesSeparatelyCheckbox.setEnabled(false);
            } else {
                this.myCommitRenamesSeparatelyCheckbox.setVisible(true);
                this.myCommitRenamesSeparatelyCheckbox.setEnabled(!this.myAmendComponent.isAmend());
            }
        }

        public void refresh() {
            this.myAmendComponent.refresh();
            this.updateRenamesCheckboxState();
            this.myAuthorField.setText(null);
            this.clearAuthorWarn();
            this.myAuthorDate = null;
            GitCheckinEnvironment.this.reset();
        }

        public void saveState() {
            String author = this.myAuthorField.getText();
            if (StringUtil.isEmptyOrSpaces((String)author)) {
                GitCheckinEnvironment.this.myNextCommitAuthor = null;
            } else {
                GitCheckinEnvironment.this.myNextCommitAuthor = GitCommitAuthorCorrector.correct(author);
                GitCheckinEnvironment.this.mySettings.saveCommitAuthor(GitCheckinEnvironment.this.myNextCommitAuthor);
            }
            GitCheckinEnvironment.this.myNextCommitAmend = this.isAmend();
            GitCheckinEnvironment.this.myNextCommitAuthorDate = this.myAuthorDate;
            GitCheckinEnvironment.this.mySettings.setSignOffCommit(this.mySignOffCheckbox.isSelected());
            GitCheckinEnvironment.this.myNextCommitSignOff = this.mySignOffCheckbox.isSelected();
            GitCheckinEnvironment.this.mySettings.setCommitRenamesSeparately(this.myCommitRenamesSeparatelyCheckbox.isSelected());
            GitCheckinEnvironment.this.myNextCommitCommitRenamesSeparately = this.myCommitRenamesSeparatelyCheckbox.isEnabled() && this.myCommitRenamesSeparatelyCheckbox.isSelected();
        }

        public void restoreState() {
            this.refresh();
        }

        public void onChangeListSelected(LocalChangeList list) {
            this.updateRenamesCheckboxState();
            Object data = list.getData();
            this.clearAuthorWarn();
            if (data instanceof ChangeListData) {
                this.fillAuthorAndDateFromData((ChangeListData)data);
            } else {
                this.myAuthorField.setText(null);
                this.myAuthorDate = null;
            }
            this.myPanel.revalidate();
            this.myPanel.repaint();
        }

        private void fillAuthorAndDateFromData(@NotNull ChangeListData data) {
            VcsUser author;
            if (data == null) {
                GitCheckinOptions.$$$reportNull$$$0(14);
            }
            if ((author = data.getAuthor()) != null && !this.isDefaultAuthor(author)) {
                this.myAuthorField.setText(VcsUserUtil.toExactString((VcsUser)author));
                this.myAuthorField.putClientProperty((Object)"JComponent.outline", (Object)"warning");
                if (this.myAuthorField.isShowing()) {
                    this.showAuthorBalloonNotification();
                }
            } else {
                this.myAuthorField.setText(null);
            }
            this.myAuthorDate = data.getDate();
        }

        private void clearAuthorWarn() {
            this.myAuthorField.putClientProperty((Object)"JComponent.outline", null);
            if (this.myAuthorBalloon != null) {
                this.myAuthorBalloon.hide();
                this.myAuthorBalloon = null;
            }
        }

        public JComponent getComponent() {
            return this.myPanel;
        }

        public boolean isDefaultAuthor(@NotNull VcsUser author) {
            if (author == null) {
                GitCheckinOptions.$$$reportNull$$$0(15);
            }
            List affectedGitRoots = ContainerUtil.filter((Collection)this.myCheckinProjectPanel.getRoots(), virtualFile -> GitUtil.findGitDir(virtualFile) != null);
            GitUserRegistry gitUserRegistry = GitUserRegistry.getInstance(GitCheckinEnvironment.this.myProject);
            return StreamEx.of((Collection)affectedGitRoots).map(vf -> gitUserRegistry.getUser((VirtualFile)vf)).allMatch(user -> {
                if (author == null) {
                    GitCheckinOptions.$$$reportNull$$$0(16);
                }
                return user != null && VcsUserUtil.isSamePerson((VcsUser)author, (VcsUser)user);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 11: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 11: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "author";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolTip";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExplicitMovementDescription";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAuthors";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTextField";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsersList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getToolTip";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 11: 
                case 13: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getAuthors";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "createTextField";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getUsersList";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "fillAuthorAndDateFromData";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "isDefaultAuthor";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$isDefaultAuthor$4";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$getToolTip$1";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 11: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class MyAmendComponent
        extends AmendComponent {
            public MyAmendComponent(@NotNull Project project, @NotNull GitRepositoryManager manager, CheckinProjectPanel panel) {
                if (project == null) {
                    MyAmendComponent.$$$reportNull$$$0(0);
                }
                if (manager == null) {
                    MyAmendComponent.$$$reportNull$$$0(1);
                }
                if (panel == null) {
                    MyAmendComponent.$$$reportNull$$$0(2);
                }
                super(project, (RepositoryManager)manager, panel);
                this.myAmend.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        GitCheckinOptions.this.updateRenamesCheckboxState();
                    }
                });
            }

            @NotNull
            protected Set<VirtualFile> getVcsRoots(@NotNull Collection<FilePath> files) {
                if (files == null) {
                    MyAmendComponent.$$$reportNull$$$0(3);
                }
                Set<VirtualFile> set = GitUtil.gitRoots(files);
                if (set == null) {
                    MyAmendComponent.$$$reportNull$$$0(4);
                }
                return set;
            }

            @Nullable
            protected String getLastCommitMessage(@NotNull VirtualFile root) throws VcsException {
                if (root == null) {
                    MyAmendComponent.$$$reportNull$$$0(5);
                }
                GitLineHandler h = new GitLineHandler(GitCheckinEnvironment.this.myProject, root, GitCommand.LOG);
                h.addParameters("--max-count=1");
                h.addParameters("--encoding=UTF-8");
                String formatPattern = GitVersionSpecialty.STARTED_USING_RAW_BODY_IN_FORMAT.existsIn(GitCheckinEnvironment.this.myProject) ? "%B" : "%s%n%n%-b";
                h.addParameters("--pretty=format:" + formatPattern);
                return Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "manager";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "panel";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "files";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions$MyAmendComponent";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "root";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions$MyAmendComponent";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVcsRoots";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getVcsRoots";
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "getLastCommitMessage";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    private static enum PartialOperation {
        NONE("none"),
        MERGE("merge"),
        CHERRY_PICK("cherry-pick");

        private final String myName;

        private PartialOperation(String name) {
            this.myName = name;
        }

        String getName() {
            return this.myName;
        }
    }
}

