/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitBranchesCollection {
    public static final GitBranchesCollection EMPTY = new GitBranchesCollection(Collections.emptyMap(), Collections.emptyMap());
    @NotNull
    private final Map<GitLocalBranch, Hash> myLocalBranches;
    @NotNull
    private final Map<GitRemoteBranch, Hash> myRemoteBranches;

    public GitBranchesCollection(@NotNull Map<GitLocalBranch, Hash> localBranches, @NotNull Map<GitRemoteBranch, Hash> remoteBranches) {
        if (localBranches == null) {
            GitBranchesCollection.$$$reportNull$$$0(0);
        }
        if (remoteBranches == null) {
            GitBranchesCollection.$$$reportNull$$$0(1);
        }
        this.myRemoteBranches = remoteBranches;
        this.myLocalBranches = localBranches;
    }

    @NotNull
    public Collection<GitLocalBranch> getLocalBranches() {
        Collection<GitLocalBranch> collection = Collections.unmodifiableCollection(this.myLocalBranches.keySet());
        if (collection == null) {
            GitBranchesCollection.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public Collection<GitRemoteBranch> getRemoteBranches() {
        Collection<GitRemoteBranch> collection = Collections.unmodifiableCollection(this.myRemoteBranches.keySet());
        if (collection == null) {
            GitBranchesCollection.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Nullable
    public Hash getHash(@NotNull GitBranch branch) {
        if (branch == null) {
            GitBranchesCollection.$$$reportNull$$$0(4);
        }
        if (branch instanceof GitLocalBranch) {
            return this.myLocalBranches.get(branch);
        }
        if (branch instanceof GitRemoteBranch) {
            return this.myRemoteBranches.get(branch);
        }
        return null;
    }

    public Collection<GitLocalBranch> findLocalBranchesByHash(Hash hash) {
        return ContainerUtil.filter(this.myLocalBranches.keySet(), key -> this.myLocalBranches.get(key).equals(hash));
    }

    public Collection<GitRemoteBranch> findRemoteBranchesByHash(Hash hash) {
        return ContainerUtil.filter(this.myRemoteBranches.keySet(), key -> this.myRemoteBranches.get(key).equals(hash));
    }

    @Nullable
    public GitLocalBranch findLocalBranch(@NotNull String name) {
        if (name == null) {
            GitBranchesCollection.$$$reportNull$$$0(5);
        }
        return GitBranchesCollection.findByName(this.myLocalBranches.keySet(), name);
    }

    @Nullable
    public GitBranch findBranchByName(@NotNull String name) {
        GitLocalBranch branch;
        if (name == null) {
            GitBranchesCollection.$$$reportNull$$$0(6);
        }
        return (branch = GitBranchesCollection.findByName(this.myLocalBranches.keySet(), name)) != null ? branch : GitBranchesCollection.findByName(this.myRemoteBranches.keySet(), name);
    }

    @Nullable
    private static <T extends GitBranch> T findByName(Collection<T> branches2, @NotNull String name) {
        if (name == null) {
            GitBranchesCollection.$$$reportNull$$$0(7);
        }
        return (T)((GitBranch)ContainerUtil.find(branches2, branch -> {
            if (name == null) {
                GitBranchesCollection.$$$reportNull$$$0(8);
            }
            return GitReference.BRANCH_NAME_HASHING_STRATEGY.equals((Object)name, (Object)branch.getName());
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranches";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteBranches";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitBranchesCollection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitBranchesCollection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalBranches";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHash";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findLocalBranch";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findBranchByName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findByName$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

