/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.DialogManager;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.ui.GithubChooseAccountDialog;
import org.jetbrains.plugins.github.util.GithubAccountsMigrationHelper;
import org.jetbrains.plugins.github.util.GithubGitHelper;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J*\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H&J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J&\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0011H$J\u0012\u0010\u001c\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/github/LegacySingleAccountActionGroup;", "Lcom/intellij/openapi/project/DumbAwareAction;", "text", "", "description", "icon", "Ljavax/swing/Icon;", "(Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "gitRepository", "Lgit4idea/repo/GitRepository;", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "getAccountsForRemotes", "", "repository", "getRemote", "Lcom/intellij/openapi/util/Pair;", "Lgit4idea/repo/GitRemote;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "update", "intellij.vcs.github"})
public abstract class LegacySingleAccountActionGroup
extends DumbAwareAction {
    public void update(@Nullable AnActionEvent e) {
        if (e == null) {
            return;
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || project.isDefault()) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        GitRepository gitRepository = GithubGitHelper.Companion.findGitRepository(project, file);
        if (gitRepository == null) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        if (this.getAccountsForRemotes(project, gitRepository).isEmpty()) {
            Pair<GitRemote, String> pair;
            Object object = ServiceManager.getService(GithubAccountsMigrationHelper.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
            GithubServerPath githubServerPath = ((GithubAccountsMigrationHelper)object).getOldServer$intellij_vcs_github();
            if (githubServerPath != null) {
                GithubServerPath githubServerPath2;
                GithubServerPath it = githubServerPath2 = githubServerPath;
                pair = this.getRemote(it, gitRepository);
            } else {
                pair = null;
            }
            if (pair == null) {
                Presentation presentation = e.getPresentation();
                Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
                presentation.setEnabledAndVisible(false);
                return;
            }
        }
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(true);
    }

    public void actionPerformed(@Nullable AnActionEvent e) {
        GithubAccount githubAccount;
        if (e == null) {
            return;
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || project.isDefault()) {
            return;
        }
        GitRepository gitRepository = GithubGitHelper.Companion.findGitRepository(project, file);
        if (gitRepository == null) {
            return;
        }
        gitRepository.update();
        Object object = ServiceManager.getService(GithubAccountsMigrationHelper.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
        if (!GithubAccountsMigrationHelper.migrate$default((GithubAccountsMigrationHelper)object, project, null, 2, null)) {
            return;
        }
        List<GithubAccount> accounts = this.getAccountsForRemotes(project, gitRepository);
        if (accounts.isEmpty()) {
            return;
        }
        if (accounts.size() == 1) {
            githubAccount = (GithubAccount)CollectionsKt.first(accounts);
        } else {
            GithubChooseAccountDialog dialog2 = new GithubChooseAccountDialog(project, null, (Collection<? extends GithubAccount>)accounts, "Default account is not configured for this project. Choose Github account:", true, !project.isDefault(), "Choose Github Account", "Choose");
            DialogManager.show((DialogWrapper)dialog2);
            if (!dialog2.isOK()) {
                return;
            }
            GithubAccount account = dialog2.getAccount();
            if (dialog2.getSetDefault()) {
                Object object2 = ServiceManager.getService(GithubAuthenticationManager.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"ServiceManager.getService(T::class.java)");
                ((GithubAuthenticationManager)object2).setDefaultAccount(project, account);
            }
            githubAccount = account;
        }
        GithubAccount account = githubAccount;
        this.actionPerformed(project, file, gitRepository, account);
    }

    public abstract void actionPerformed(@NotNull Project var1, @Nullable VirtualFile var2, @NotNull GitRepository var3, @NotNull GithubAccount var4);

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final List<GithubAccount> getAccountsForRemotes(Project project, GitRepository repository) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        List list;
        Object object = ServiceManager.getService(GithubAuthenticationManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
        GithubAuthenticationManager authenticationManager = (GithubAuthenticationManager)object;
        GithubAccount defaultAccount = authenticationManager.getDefaultAccount(project);
        if (defaultAccount != null) {
            GithubServerPath githubServerPath = defaultAccount.getServer();
            Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"defaultAccount.server");
            if (this.getRemote(githubServerPath, repository) != null) {
                list = CollectionsKt.listOf((Object)defaultAccount);
                return list;
            }
        }
        Iterable iterable = $receiver$iv = (Iterable)authenticationManager.getAccounts();
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                list = (List)destination$iv$iv;
                return list;
            }
            Object element$iv$iv = iterator.next();
            GithubAccount it = (GithubAccount)element$iv$iv;
            GithubServerPath githubServerPath = it.getServer();
            Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"it.server");
            if (!(this.getRemote(githubServerPath, repository) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
    }

    @Nullable
    protected abstract Pair<GitRemote, String> getRemote(@NotNull GithubServerPath var1, @NotNull GitRepository var2);

    public LegacySingleAccountActionGroup(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }
}

