/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.BrowserHyperlinkInfo;
import com.intellij.execution.filters.ConsoleFilterProviderEx;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.io.URLUtil;
import java.util.ArrayList;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlFilter
implements Filter,
DumbAware {
    @Override
    @Nullable
    public Filter.Result applyFilter(String line, int entireLength) {
        if (!URLUtil.canContainUrl((String)line)) {
            return null;
        }
        int textStartOffset = entireLength - line.length();
        Matcher m = URLUtil.URL_PATTERN.matcher(line);
        Filter.ResultItem item = null;
        ArrayList<Filter.ResultItem> items = null;
        while (m.find()) {
            if (item == null) {
                item = new Filter.ResultItem(textStartOffset + m.start(), textStartOffset + m.end(), this.buildHyperlinkInfo(m.group()));
                continue;
            }
            if (items == null) {
                items = new ArrayList<Filter.ResultItem>(2);
                items.add(item);
            }
            items.add(new Filter.ResultItem(textStartOffset + m.start(), textStartOffset + m.end(), this.buildHyperlinkInfo(m.group())));
        }
        return items != null ? new Filter.Result(items) : (item != null ? new Filter.Result(item.getHighlightStartOffset(), item.getHighlightEndOffset(), item.getHyperlinkInfo()) : null);
    }

    @NotNull
    protected HyperlinkInfo buildHyperlinkInfo(@NotNull String url) {
        if (url == null) {
            UrlFilter.$$$reportNull$$$0(0);
        }
        BrowserHyperlinkInfo browserHyperlinkInfo = new BrowserHyperlinkInfo(url);
        if (browserHyperlinkInfo == null) {
            UrlFilter.$$$reportNull$$$0(1);
        }
        return browserHyperlinkInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/filters/UrlFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/filters/UrlFilter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHyperlinkInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildHyperlinkInfo";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class UrlFilterProvider
    implements ConsoleFilterProviderEx {
        @Override
        public Filter[] getDefaultFilters(@NotNull Project project, @NotNull GlobalSearchScope scope) {
            if (project == null) {
                UrlFilterProvider.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                UrlFilterProvider.$$$reportNull$$$0(1);
            }
            return new Filter[]{new UrlFilter()};
        }

        @Override
        @NotNull
        public Filter[] getDefaultFilters(@NotNull Project project) {
            if (project == null) {
                UrlFilterProvider.$$$reportNull$$$0(2);
            }
            Filter[] filterArray = this.getDefaultFilters(project, GlobalSearchScope.allScope(project));
            if (filterArray == null) {
                UrlFilterProvider.$$$reportNull$$$0(3);
            }
            return filterArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/filters/UrlFilter$UrlFilterProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/filters/UrlFilter$UrlFilterProvider";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultFilters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefaultFilters";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

