/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.formatter.YAMLCodeStyleSettings;

public class YAMLLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    public static final int[] ALIGN_VALUES = new int[]{0, 2, 1};
    public static final String[] ALIGN_OPTIONS = new String[]{YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.align.options.no"), YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.align.options.colon"), YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.align.options.value")};

    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings defaultSettings = new CommonCodeStyleSettings((Language)YAMLLanguage.INSTANCE);
        CommonCodeStyleSettings.IndentOptions indentOptions = defaultSettings.initIndentOptions();
        indentOptions.INDENT_SIZE = 2;
        indentOptions.CONTINUATION_INDENT_SIZE = 2;
        indentOptions.USE_TAB_CHARACTER = false;
        return defaultSettings;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new YAMLIndentOptionsEditor(this);
    }

    @NotNull
    public Language getLanguage() {
        YAMLLanguage yAMLLanguage = YAMLLanguage.INSTANCE;
        if (yAMLLanguage == null) {
            YAMLLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return yAMLLanguage;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            YAMLLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        if (settingsType == null) {
            YAMLLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS) {
            consumer.showStandardOptions(new String[]{"INDENT_SIZE", "KEEP_INDENTS_ON_EMPTY_LINES"});
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"KEEP_LINE_BREAKS"});
            consumer.showCustomOption(YAMLCodeStyleSettings.class, "ALIGN_VALUES_PROPERTIES", YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.align.values"), null, new Object[]{ALIGN_OPTIONS, ALIGN_VALUES});
            consumer.showCustomOption(YAMLCodeStyleSettings.class, "SEQUENCE_ON_NEW_LINE", YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.sequence.on.new.line"), YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.group.sequence.value"), new Object[0]);
            consumer.showCustomOption(YAMLCodeStyleSettings.class, "BLOCK_MAPPING_ON_NEW_LINE", YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.block.mapping.on.new.line"), YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.group.sequence.value"), new Object[0]);
        }
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            YAMLLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        return CodeStyleAbstractPanel.readFromFile(YAMLBundle.class, (String)"indents.yml");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/YAMLLanguageCodeStyleSettingsProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/YAMLLanguageCodeStyleSettingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class YAMLIndentOptionsEditor
    extends SmartIndentOptionsEditor {
        private JCheckBox myIndentSequence;

        public YAMLIndentOptionsEditor(@Nullable LanguageCodeStyleSettingsProvider provider) {
            super(provider);
        }

        protected void addComponents() {
            super.addComponents();
            this.myIndentSequence = new JCheckBox(YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.indent.sequence.value"));
            this.add(this.myIndentSequence);
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.myIndentSequence.setEnabled(enabled);
        }

        public boolean isModified(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions options) {
            if (settings == null) {
                YAMLIndentOptionsEditor.$$$reportNull$$$0(0);
            }
            if (options == null) {
                YAMLIndentOptionsEditor.$$$reportNull$$$0(1);
            }
            boolean isModified = super.isModified(settings, options);
            YAMLCodeStyleSettings yamlSettings = (YAMLCodeStyleSettings)settings.getCustomSettings(YAMLCodeStyleSettings.class);
            return isModified |= YAMLIndentOptionsEditor.isFieldModified((JCheckBox)this.myIndentSequence, (boolean)yamlSettings.INDENT_SEQUENCE_VALUE);
        }

        public void apply(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions options) {
            if (settings == null) {
                YAMLIndentOptionsEditor.$$$reportNull$$$0(2);
            }
            if (options == null) {
                YAMLIndentOptionsEditor.$$$reportNull$$$0(3);
            }
            super.apply(settings, options);
            YAMLCodeStyleSettings yamlSettings = (YAMLCodeStyleSettings)settings.getCustomSettings(YAMLCodeStyleSettings.class);
            yamlSettings.INDENT_SEQUENCE_VALUE = this.myIndentSequence.isSelected();
        }

        public void reset(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions options) {
            if (settings == null) {
                YAMLIndentOptionsEditor.$$$reportNull$$$0(4);
            }
            if (options == null) {
                YAMLIndentOptionsEditor.$$$reportNull$$$0(5);
            }
            super.reset(settings, options);
            YAMLCodeStyleSettings yamlSettings = (YAMLCodeStyleSettings)settings.getCustomSettings(YAMLCodeStyleSettings.class);
            this.myIndentSequence.setSelected(yamlSettings.INDENT_SEQUENCE_VALUE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/yaml/YAMLLanguageCodeStyleSettingsProvider$YAMLIndentOptionsEditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isModified";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reset";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

