/*
 * Decompiled with CFR 0.152.
 */
package com.projity.server.data;

import com.projity.server.data.AssignmentData;
import com.projity.server.data.CalendarData;
import com.projity.server.data.LinkData;
import com.projity.server.data.SerializedDataObject;
import com.projity.server.data.SerializedDataObjectFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;

public class TaskData
extends SerializedDataObject {
    static final long serialVersionUID = 37382828283746L;
    public static final int CREATION_STATUS_NORMAL = 0;
    public static final int CREATION_STATUS_TIMESHEET = 1;
    protected CalendarData calendar;
    protected Collection assignments;
    protected Collection predecessors;
    protected TaskData parentTask;
    protected long childPosition;
    protected long parentTaskId = -1L;
    protected long calendarId = -1L;
    protected boolean external = false;
    protected long projectId = 0L;
    protected long subprojectId = 0L;
    protected Map subprojectFieldValues = null;
    protected boolean timesheetCreated = false;
    protected String notes;
    protected transient Map attributes;
    public static final SerializedDataObjectFactory FACTORY = new SerializedDataObjectFactory(){

        @Override
        public SerializedDataObject createSerializedDataObject() {
            return new TaskData();
        }
    };

    public Collection getAssignments() {
        return this.assignments;
    }

    public void setAssignments(Collection collection) {
        this.assignments = collection;
    }

    public CalendarData getCalendar() {
        return this.calendar;
    }

    public void setCalendar(CalendarData calendarData) {
        this.calendar = calendarData;
        this.setCalendarId(calendarData == null ? -1L : calendarData.getUniqueId());
    }

    public Collection getPredecessors() {
        return this.predecessors;
    }

    public void setPredecessors(Collection collection) {
        this.predecessors = collection;
    }

    public long getChildPosition() {
        return this.childPosition;
    }

    public void setChildPosition(long l) {
        this.childPosition = l;
    }

    public TaskData getParentTask() {
        return this.parentTask;
    }

    public void setParentTask(TaskData taskData) {
        this.parentTask = taskData;
        this.setParentTaskId(taskData == null ? -1L : taskData.getUniqueId());
    }

    public long getParentTaskId() {
        return this.parentTaskId;
    }

    public void setParentTaskId(long l) {
        this.parentTaskId = l;
    }

    @Override
    public int getType() {
        return 5;
    }

    public long getCalendarId() {
        return this.calendarId;
    }

    public void setCalendarId(long l) {
        this.calendarId = l;
    }

    @Override
    public void emtpy() {
        super.emtpy();
        this.calendar = null;
        this.assignments = null;
        this.predecessors = null;
        this.parentTask = null;
        this.external = false;
    }

    public void addAssignment(AssignmentData assignmentData) {
        if (this.assignments == null) {
            this.assignments = new ArrayList();
        }
        assignmentData.setTask(this);
        this.assignments.add(assignmentData);
    }

    public void addPredecessor(LinkData linkData) {
        if (this.predecessors == null) {
            this.predecessors = new ArrayList();
        }
        linkData.setSuccessor(this);
        this.predecessors.add(linkData);
    }

    @Override
    public final boolean isExternal() {
        return this.external;
    }

    public final void setExternal(boolean bl) {
        this.external = bl;
    }

    public final long getProjectId() {
        return this.projectId;
    }

    public final void setProjectId(long l) {
        this.projectId = l;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public final boolean isSubproject() {
        return this.subprojectId != 0L;
    }

    public final void setSubprojectId(long l) {
        this.subprojectId = l;
    }

    public final long getSubprojectId() {
        return this.subprojectId;
    }

    public final Map getSubprojectFieldValues() {
        return this.subprojectFieldValues;
    }

    public final void setSubprojectFieldValues(Map map) {
        this.subprojectFieldValues = map;
    }

    public boolean isTimesheetCreated() {
        return this.timesheetCreated;
    }

    public void setTimesheetCreated(boolean bl) {
        this.timesheetCreated = bl;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String string) {
        this.notes = string;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map map) {
        this.attributes = map;
    }
}

