/*
 * Decompiled with CFR 0.152.
 */
package com.projity.print;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.offline_graphics.SVGRenderer;
import com.projity.pm.graphic.graph.GraphParams;
import com.projity.print.ExtendedPageFormat;
import com.projity.print.ExtendedPrintService;
import com.projity.print.ExtendedPrintServiceFactory;
import com.projity.print.FitToSettings;
import com.projity.print.GanttSettings;
import com.projity.print.GraphPageable;
import com.projity.print.PDFPrintService;
import com.projity.print.PageSize;
import com.projity.print.PageSizes;
import com.projity.print.PrintSettings;
import com.projity.print.PrintSettingsManager;
import com.projity.print.ScaleToSettings;
import com.projity.print.ScalingSettings;
import com.projity.strings.Messages;
import com.projity.util.Environment;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.print.PrintService;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PageSetup {
    private static final long serialVersionUID = 1L;
    public static final double INCH = 2.54;
    public static final double POINT = 0.035277777777777776;
    private GraphPageable document;
    private ExtendedPageFormat pageFormat;
    private ExtendedPrintService extendedPrintService;
    protected JTabbedPane tabbedPane;
    protected JComboBox paperSize;
    protected JComboBox printers;
    protected JFormattedTextField paperWidth;
    protected JFormattedTextField paperHeight;
    protected JLabel paperWidthLabel;
    protected JLabel paperHeightLabel;
    protected JLabel marginLeftLabel;
    protected JLabel marginRightLabel;
    protected JLabel marginTopLabel;
    protected JLabel marginBottomLabel;
    protected JFormattedTextField marginLeft;
    protected JFormattedTextField marginRight;
    protected JFormattedTextField marginTop;
    protected JFormattedTextField marginBottom;
    protected JComboBox orientation;
    protected String portrait;
    protected String landscape;
    protected String reverseLandscape;
    protected JCheckBox printSpreadSheet;
    protected JCheckBox printGantt;
    protected JRadioButton scaleTo;
    protected JRadioButton fitTo;
    protected JSpinner fitToWidth;
    protected JSpinner fitToHeight;
    protected JSpinner scaleToWidth;
    protected JSpinner scaleToHeight;
    protected JLabel fitToWidthLabel;
    protected JLabel fitToHeightLabel;
    protected JLabel scaleToWidthLabel;
    protected JLabel scaleToHeightLabel;
    protected JLabel scaleToProportions;
    protected JLabel scaleToProportions2;
    protected JCheckBox constrainProportions;
    protected JButton saveSettings;
    protected double svgPaperWidth;
    protected double svgPaperHeight;
    protected PageSizes.MediaSizeNameModel sizesModel;
    protected int updating;
    protected PrintServiceOption[] printerList;
    protected PrintServiceOption pdfPrintServiceOption;

    public static PageSetup getInstance(GraphPageable graphPageable) {
        return new PageSetup(graphPageable);
    }

    private PageSetup(GraphPageable graphPageable) {
        this.document = graphPageable;
        this.pageFormat = graphPageable.getPageFormat();
        this.extendedPrintService = ExtendedPrintServiceFactory.getExtendedPrintService();
    }

    protected void initFont(JComponent jComponent) {
        jComponent.setFont(jComponent.getFont().deriveFont(8));
    }

    protected void beginUpdate() {
        ++this.updating;
    }

    protected void endUpdate() {
        --this.updating;
    }

    protected boolean isUpdaping() {
        return this.updating > 0;
    }

    protected void initControls() {
        this.beginUpdate();
        PrintSettings printSettings = this.document.getPrintSettings();
        PrintService[] printServiceArray = this.document.getPrintServices();
        PrintService printService = this.document.getPrintService();
        PDFPrintService pDFPrintService = this.document.getPdfPrintService();
        this.printerList = new PrintServiceOption[printServiceArray.length];
        PrintServiceOption printServiceOption = null;
        for (int i = 0; i < printServiceArray.length; ++i) {
            this.printerList[i] = new PrintServiceOption(printServiceArray[i]);
            if (printServiceArray[i].equals(printService)) {
                printServiceOption = this.printerList[i];
            }
            if (!printServiceArray[i].equals(pDFPrintService)) continue;
            this.pdfPrintServiceOption = this.printerList[i];
        }
        this.printers = new JComboBox<PrintServiceOption>(this.printerList);
        this.printers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PageSetup.this.isUpdaping()) {
                    return;
                }
                PageSetup.this.beginUpdate();
                PrintServiceOption printServiceOption = (PrintServiceOption)PageSetup.this.printers.getSelectedItem();
                PrintService printService = printServiceOption.getValue();
                PageSetup.this.document.setPrintService(printService, false);
                PageSetup.this.sizesModel.update(printService);
                PageSetup.this.handlePaperSizeChange();
                switch (PageSetup.this.pageFormat.getOrientation()) {
                    case 0: {
                        PageSetup.this.orientation.setSelectedItem(PageSetup.this.landscape);
                        break;
                    }
                    case 2: {
                        PageSetup.this.orientation.setSelectedItem(PageSetup.this.reverseLandscape);
                        break;
                    }
                    default: {
                        PageSetup.this.orientation.setSelectedItem(PageSetup.this.portrait);
                    }
                }
                PageSetup.this.orientation.setEnabled(!PageSetup.this.isBigPage());
                PageSetup.this.updateOrientation();
                PageSetup.this.endUpdate();
                PageSetup.this.refresh();
            }
        });
        this.printers.setSelectedItem(printServiceOption);
        this.initFont(this.printers);
        this.sizesModel = PageSizes.getInstance().createComboBoxModel(this.document.getPrintService());
        this.paperSize = new JComboBox(this.sizesModel);
        this.paperSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PageSetup.this.isUpdaping()) {
                    return;
                }
                PageSetup.this.beginUpdate();
                PageSetup.this.orientation.setEnabled(!PageSetup.this.isBigPage());
                PageSetup.this.handlePaperSizeChange();
                PageSetup.this.endUpdate();
                PageSetup.this.refresh();
            }
        });
        this.initFont(this.paperSize);
        this.paperWidthLabel = new JLabel(Messages.getString("PageSetupDialog.PaperSizeSettings.Custom.Width"));
        this.paperWidthLabel.setEnabled(false);
        this.initFont(this.paperWidthLabel);
        DecimalFormat decimalFormat = new DecimalFormat("#0.0");
        this.paperWidth = new JFormattedTextField(decimalFormat);
        this.paperWidth.setEnabled(false);
        this.paperWidth.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PageSetup.this.isUpdaping()) {
                    return;
                }
                PageSetup.this.updateImageableArea(((Number)propertyChangeEvent.getNewValue()).doubleValue(), -1.0, 2);
                PageSetup.this.refresh();
            }
        });
        this.initFont(this.paperWidth);
        this.paperHeightLabel = new JLabel(Messages.getString("PageSetupDialog.PaperSizeSettings.Custom.Height"));
        this.paperHeightLabel.setEnabled(false);
        this.initFont(this.paperHeightLabel);
        this.paperHeight = new JFormattedTextField(decimalFormat);
        this.paperHeight.setEnabled(false);
        this.paperHeight.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PageSetup.this.isUpdaping()) {
                    return;
                }
                PageSetup.this.updateImageableArea(-1.0, ((Number)propertyChangeEvent.getNewValue()).doubleValue(), 2);
                PageSetup.this.refresh();
            }
        });
        this.initFont(this.paperHeight);
        this.paperSize.setSelectedItem(PageSizes.getInstance().getPageSize(this.pageFormat));
        this.initFont(this.paperSize);
        this.marginLeftLabel = new JLabel(Messages.getString("PageSetupDialog.Margins.Left"));
        this.initFont(this.marginLeftLabel);
        this.marginLeft = new JFormattedTextField(decimalFormat);
        this.marginLeft.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PageSetup.this.isUpdaping()) {
                    return;
                }
                PageSetup.this.beginUpdate();
                double[] dArray = PageSetup.this.updateImageableArea(((Number)propertyChangeEvent.getNewValue()).doubleValue(), -1.0, -1.0, -1.0, 0);
                if (dArray != null) {
                    PageSetup.this.marginLeft.setValue(dArray[0]);
                    PageSetup.this.marginRight.setValue(dArray[1]);
                    PageSetup.this.marginTop.setValue(dArray[2]);
                    PageSetup.this.marginBottom.setValue(dArray[3]);
                }
                PageSetup.this.endUpdate();
                PageSetup.this.refresh();
            }
        });
        this.initFont(this.marginLeft);
        this.marginRightLabel = new JLabel(Messages.getString("PageSetupDialog.Margins.Right"));
        this.initFont(this.marginRightLabel);
        this.marginRight = new JFormattedTextField(decimalFormat);
        this.marginRight.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PageSetup.this.isUpdaping()) {
                    return;
                }
                PageSetup.this.beginUpdate();
                double[] dArray = PageSetup.this.updateImageableArea(-1.0, ((Number)propertyChangeEvent.getNewValue()).doubleValue(), -1.0, -1.0, 1);
                if (dArray != null) {
                    PageSetup.this.marginLeft.setValue(dArray[0]);
                    PageSetup.this.marginRight.setValue(dArray[1]);
                    PageSetup.this.marginTop.setValue(dArray[2]);
                    PageSetup.this.marginBottom.setValue(dArray[3]);
                }
                PageSetup.this.endUpdate();
                PageSetup.this.refresh();
            }
        });
        this.initFont(this.marginRight);
        this.marginTopLabel = new JLabel(Messages.getString("PageSetupDialog.Margins.Top"));
        this.initFont(this.marginTopLabel);
        this.marginTop = new JFormattedTextField(decimalFormat);
        this.marginTop.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PageSetup.this.isUpdaping()) {
                    return;
                }
                PageSetup.this.beginUpdate();
                double[] dArray = PageSetup.this.updateImageableArea(-1.0, -1.0, ((Number)propertyChangeEvent.getNewValue()).doubleValue(), -1.0, 2);
                if (dArray != null) {
                    PageSetup.this.marginLeft.setValue(dArray[0]);
                    PageSetup.this.marginRight.setValue(dArray[1]);
                    PageSetup.this.marginTop.setValue(dArray[2]);
                    PageSetup.this.marginBottom.setValue(dArray[3]);
                }
                PageSetup.this.endUpdate();
                PageSetup.this.refresh();
            }
        });
        this.initFont(this.marginTop);
        this.marginBottomLabel = new JLabel(Messages.getString("PageSetupDialog.Margins.Bottom"));
        this.initFont(this.marginBottomLabel);
        this.marginBottom = new JFormattedTextField(decimalFormat);
        this.marginBottom.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PageSetup.this.isUpdaping()) {
                    return;
                }
                PageSetup.this.beginUpdate();
                double[] dArray = PageSetup.this.updateImageableArea(-1.0, -1.0, -1.0, ((Number)propertyChangeEvent.getNewValue()).doubleValue(), 3);
                if (dArray != null) {
                    PageSetup.this.marginLeft.setValue(dArray[0]);
                    PageSetup.this.marginRight.setValue(dArray[1]);
                    PageSetup.this.marginTop.setValue(dArray[2]);
                    PageSetup.this.marginBottom.setValue(dArray[3]);
                }
                PageSetup.this.endUpdate();
                PageSetup.this.refresh();
            }
        });
        this.initFont(this.marginBottom);
        this.portrait = Messages.getString("PageSetupDialog.Orientation.Portrait");
        this.landscape = Messages.getString("PageSetupDialog.Orientation.Landscape");
        this.reverseLandscape = Messages.getString("PageSetupDialog.Orientation.ReverseLandscape");
        this.orientation = new JComboBox<Object>(new Object[]{this.portrait, this.landscape});
        this.orientation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PageSetup.this.isUpdaping()) {
                    return;
                }
                Object object = PageSetup.this.orientation.getSelectedItem();
                if (PageSetup.this.portrait.equals(object)) {
                    PageSetup.this.pageFormat.setOrientation(1);
                }
                if (PageSetup.this.landscape.equals(object)) {
                    PageSetup.this.pageFormat.setOrientation(0);
                }
                if (PageSetup.this.reverseLandscape.equals(object)) {
                    PageSetup.this.pageFormat.setOrientation(2);
                }
                PageSetup.this.beginUpdate();
                PageSetup.this.updateOrientation();
                PageSetup.this.endUpdate();
                PageSetup.this.refresh();
            }
        });
        this.initFont(this.orientation);
        switch (printSettings.getPageFormat().getOrientation()) {
            case 1: {
                this.orientation.setSelectedItem(this.portrait);
                break;
            }
            case 2: {
                this.orientation.setSelectedItem(this.reverseLandscape);
                break;
            }
            default: {
                this.orientation.setSelectedItem(this.landscape);
            }
        }
        this.orientation.setEnabled(!this.isBigPage());
        if (this.document.getRenderer().getParams().isSupportLeftAndRightParts()) {
            this.printSpreadSheet = new JCheckBox(Messages.getString("PageSetupDialog.ShowSpreadSheet"), this.document.isShowSpreadsheet());
            this.printSpreadSheet.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (PageSetup.this.isUpdaping()) {
                        return;
                    }
                    boolean bl = PageSetup.this.printSpreadSheet.isSelected();
                    GraphParams graphParams = PageSetup.this.document.getRenderer().getParams();
                    graphParams.setLeftPartVisible(bl);
                    if (!bl && !PageSetup.this.printGantt.isSelected()) {
                        graphParams.setRightPartVisible(true);
                        PageSetup.this.beginUpdate();
                        PageSetup.this.printGantt.setSelected(true);
                        PageSetup.this.endUpdate();
                    }
                    PageSetup.this.refresh();
                }
            });
            this.initFont(this.printSpreadSheet);
            this.printGantt = new JCheckBox(Messages.getString("PageSetupDialog.ShowGantt"), this.document.isShowGantt());
            this.printGantt.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (PageSetup.this.isUpdaping()) {
                        return;
                    }
                    boolean bl = PageSetup.this.printGantt.isSelected();
                    GraphParams graphParams = PageSetup.this.document.getRenderer().getParams();
                    graphParams.setRightPartVisible(bl);
                    if (!bl && !PageSetup.this.printGantt.isSelected()) {
                        graphParams.setLeftPartVisible(true);
                        PageSetup.this.beginUpdate();
                        PageSetup.this.printSpreadSheet.setSelected(true);
                        PageSetup.this.endUpdate();
                    }
                    PageSetup.this.refresh();
                }
            });
            this.initFont(this.printGantt);
        }
        this.scaleToWidthLabel = new JLabel(Messages.getString("PageSetupDialog.Scaling.ScaleToWidth"));
        this.scaleToWidthLabel.setEnabled(this.document.isScaleToSelected());
        this.initFont(this.scaleToWidthLabel);
        this.scaleToWidth = new JSpinner(new SpinnerNumberModel(this.document.getScaleToSettings().getWidth(), 0.1, 10.0, 0.05));
        this.scaleToWidth.setEditor(new JSpinner.NumberEditor(this.scaleToWidth, "#%"));
        this.scaleToWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                double d = ((Number)PageSetup.this.scaleToWidth.getValue()).doubleValue();
                PageSetup.this.beginUpdate();
                PageSetup.this.document.setZoomX(d);
                if (PageSetup.this.constrainProportions.isSelected()) {
                    PageSetup.this.document.setZoomY(d);
                    PageSetup.this.scaleToHeight.setValue(d);
                }
                if (PageSetup.this.isBigPage()) {
                    PageSetup.this.handlePaperSizeChange();
                }
                PageSetup.this.endUpdate();
                PageSetup.this.refresh();
            }
        });
        this.scaleToWidth.setEnabled(this.document.isScaleToSelected());
        this.initFont(this.scaleToWidth);
        this.scaleToHeightLabel = new JLabel(Messages.getString("PageSetupDialog.Scaling.ScaleToHeight"));
        this.scaleToHeightLabel.setEnabled(this.document.isScaleToSelected() && !this.document.getScaleToSettings().isConstrainProportions());
        this.initFont(this.scaleToHeightLabel);
        this.scaleToHeight = new JSpinner(new SpinnerNumberModel(this.document.getScaleToSettings().getHeight(), 0.1, 10.0, 0.05));
        this.scaleToHeight.setEditor(new JSpinner.NumberEditor(this.scaleToHeight, "#%"));
        this.scaleToHeight.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (PageSetup.this.isUpdaping()) {
                    return;
                }
                PageSetup.this.beginUpdate();
                double d = ((Number)PageSetup.this.scaleToHeight.getValue()).doubleValue();
                PageSetup.this.document.setZoomY(d);
                if (PageSetup.this.isBigPage() && !PageSetup.this.constrainProportions.isSelected()) {
                    PageSetup.this.handlePaperSizeChange();
                }
                PageSetup.this.endUpdate();
                PageSetup.this.refresh();
            }
        });
        this.scaleToHeight.setEnabled(this.document.isScaleToSelected() && !this.document.getScaleToSettings().isConstrainProportions());
        this.initFont(this.scaleToHeight);
        this.constrainProportions = new JCheckBox("", this.document.getScaleToSettings().isConstrainProportions());
        this.constrainProportions.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = PageSetup.this.constrainProportions.isSelected();
                PageSetup.this.scaleToHeightLabel.setEnabled(!bl);
                PageSetup.this.scaleToHeight.setEnabled(!bl);
                if (bl) {
                    PageSetup.this.scaleToHeight.setValue(PageSetup.this.scaleToWidth.getValue());
                }
            }
        });
        this.constrainProportions.setEnabled(this.document.isScaleToSelected());
        this.initFont(this.constrainProportions);
        this.scaleToProportions = new JLabel(Messages.getString("PageSetupDialog.Scaling.ScaleToProportions"));
        this.scaleToProportions.setEnabled(this.document.isScaleToSelected());
        this.initFont(this.scaleToProportions);
        this.scaleToProportions2 = new JLabel(Messages.getString("PageSetupDialog.Scaling.ScaleToProportions2"));
        this.scaleToProportions2.setEnabled(this.document.isScaleToSelected());
        this.initFont(this.scaleToProportions2);
        this.fitToWidthLabel = new JLabel(Messages.getString("PageSetupDialog.Scaling.FitToWidth"));
        this.fitToWidthLabel.setEnabled(!this.document.isScaleToSelected());
        this.initFont(this.fitToWidthLabel);
        this.fitToWidth = new JSpinner(new SpinnerNumberModel(this.document.getFitToSettings().getColumns(), 1, 99999, 1));
        this.fitToWidth.setEnabled(!this.document.isScaleToSelected());
        this.fitToWidth.setEditor(new JSpinner.NumberEditor(this.fitToWidth, "#"));
        this.fitToWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (PageSetup.this.isUpdaping()) {
                    return;
                }
                PageSetup.this.document.updateZoom(((Number)PageSetup.this.fitToWidth.getValue()).intValue(), ((Number)PageSetup.this.fitToHeight.getValue()).intValue());
                PageSetup.this.refresh();
            }
        });
        this.initFont(this.fitToWidth);
        this.fitToHeightLabel = new JLabel(Messages.getString("PageSetupDialog.Scaling.FitToHeight"));
        this.fitToHeightLabel.setEnabled(!this.document.isScaleToSelected());
        this.initFont(this.fitToHeightLabel);
        this.fitToHeight = new JSpinner(new SpinnerNumberModel(this.document.getFitToSettings().getRows(), 1, 99999, 1));
        this.fitToHeight.setEnabled(!this.document.isScaleToSelected());
        this.fitToHeight.setEditor(new JSpinner.NumberEditor(this.fitToHeight, "#"));
        this.fitToHeight.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (PageSetup.this.isUpdaping()) {
                    return;
                }
                PageSetup.this.document.updateZoom(((Number)PageSetup.this.fitToWidth.getValue()).intValue(), ((Number)PageSetup.this.fitToHeight.getValue()).intValue());
                PageSetup.this.refresh();
            }
        });
        this.initFont(this.fitToHeight);
        this.scaleTo = new JRadioButton(Messages.getString("PageSetupDialog.Scaling.ScaleTo"), this.document.isScaleToSelected());
        this.scaleTo.setEnabled(true);
        this.initFont(this.scaleTo);
        this.fitTo = new JRadioButton(Messages.getString("PageSetupDialog.Scaling.FitTo"), !this.document.isScaleToSelected());
        this.fitTo.setEnabled(true);
        this.initFont(this.fitTo);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.scaleTo);
        buttonGroup.add(this.fitTo);
        this.scaleTo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = PageSetup.this.scaleTo.isSelected();
                PageSetup.this.scaleToWidth.setEnabled(bl);
                PageSetup.this.scaleToWidthLabel.setEnabled(bl);
                boolean bl2 = PageSetup.this.constrainProportions.isSelected();
                PageSetup.this.scaleToHeight.setEnabled(bl && !bl2);
                PageSetup.this.scaleToHeightLabel.setEnabled(bl && !bl2);
                PageSetup.this.constrainProportions.setEnabled(bl);
                PageSetup.this.scaleToProportions.setEnabled(bl);
                PageSetup.this.scaleToProportions2.setEnabled(bl);
                PageSetup.this.fitToWidth.setEnabled(!bl);
                PageSetup.this.fitToWidthLabel.setEnabled(!bl);
                PageSetup.this.fitToHeight.setEnabled(!bl);
                PageSetup.this.fitToHeightLabel.setEnabled(!bl);
                if (!bl && PageSizes.getInstance().isBigPageSize(PageSetup.this.paperSize.getSelectedItem())) {
                    PageSetup.this.paperSize.setSelectedItem(PageSetup.this.sizesModel.selectDefault(PageSetup.this.document.getPrintService(), false));
                    PageSetup.this.paperSize.repaint();
                }
                if (bl) {
                    PageSetup.this.document.restoreZoom();
                } else {
                    PageSetup.this.document.saveZoom();
                    PageSetup.this.updateZoom();
                }
                PageSetup.this.refresh();
            }
        });
        this.saveSettings = new JButton(Messages.getString("PageSetupDialog.SaveSettings"));
        this.saveSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageSetup.this.saveSettings(true, true);
            }
        });
        this.saveSettings.setToolTipText(Messages.getString("PageSetupDialog.SaveSettings.ToolTip"));
        this.initFont(this.saveSettings);
        this.updatePageSize(true);
        this.updateOrientation();
        this.updateFitTo();
        this.endUpdate();
    }

    protected void saveSettings(boolean bl, boolean bl2) {
        Cloneable cloneable;
        PrintSettings printSettings = new PrintSettings();
        printSettings.setPageFormat((ExtendedPageFormat)this.document.getPageFormat().clone());
        printSettings.setPdfService(this.document.getPrintService() instanceof PDFPrintService);
        ArrayList<Cloneable> arrayList = null;
        if (this.printSpreadSheet != null && this.printGantt != null) {
            cloneable = new GanttSettings();
            ((GanttSettings)cloneable).setSpreadSheetVisible(this.printSpreadSheet.isSelected());
            ((GanttSettings)cloneable).setGanttVisible(this.printGantt.isSelected());
            arrayList = new ArrayList<Cloneable>(1);
            arrayList.add(cloneable);
        } else {
            cloneable = this.document.getPrintSettings().getViewSettings();
            if (cloneable != null) {
                arrayList = (ArrayList<Cloneable>)((ArrayList)cloneable).clone();
            }
        }
        printSettings.setViewSettings(arrayList);
        if (!Environment.getStandAlone()) {
            cloneable = new ArrayList(2);
            ScaleToSettings scaleToSettings = new ScaleToSettings();
            scaleToSettings.setWidth(((Number)this.scaleToWidth.getValue()).doubleValue());
            scaleToSettings.setHeight(((Number)this.scaleToHeight.getValue()).doubleValue());
            scaleToSettings.setConstrainProportions(this.constrainProportions.isSelected());
            FitToSettings fitToSettings = new FitToSettings();
            fitToSettings.setColumns(((Number)this.fitToWidth.getValue()).intValue());
            fitToSettings.setRows(((Number)this.fitToHeight.getValue()).intValue());
            ((ArrayList)cloneable).add(scaleToSettings);
            ((ArrayList)cloneable).add(fitToSettings);
            printSettings.setScalingSettings((ArrayList<ScalingSettings>)cloneable);
            printSettings.setScalingIndex(this.scaleTo.isSelected() ? 0 : 1);
        }
        if (!bl) {
            printSettings.setFieldArray(this.document.getRenderer().getProject().getFieldArray());
        }
        printSettings.updateWorkspace();
        PrintSettingsManager.saveSettings(printSettings, bl ? null : this.document.getRenderer().getProject(), bl2);
    }

    private boolean isBigPage() {
        return PageSizes.getInstance().isBigPageSize(this.paperSize.getSelectedItem());
    }

    protected void handlePaperSizeChange() {
        Object object = this.paperSize.getSelectedItem();
        boolean bl = PageSizes.getInstance().isCustomPageSize(object);
        boolean bl2 = this.isBigPage();
        this.paperWidthLabel.setEnabled(bl);
        this.paperWidth.setEnabled(bl);
        this.paperHeightLabel.setEnabled(bl);
        this.paperHeight.setEnabled(bl);
        if (bl2) {
            this.orientation.setSelectedItem(this.portrait);
            this.scaleTo.setSelected(true);
            this.svgPaperWidth = this.pageFormat.getPaper().getWidth();
            this.svgPaperHeight = this.pageFormat.getPaper().getHeight();
            SVGRenderer sVGRenderer = this.document.getRenderer();
            Dimension dimension = sVGRenderer.getCanvasSize();
            GraphParams graphParams = sVGRenderer.getParams();
            double d = this.pageFormat.getOrientation() == 1 ? dimension.getWidth() : dimension.getHeight();
            double d2 = this.pageFormat.getOrientation() == 1 ? dimension.getHeight() : dimension.getWidth();
            int n = graphParams.getConfiguration().getPrintFooterHeight();
            if (this.pageFormat.getOrientation() == 1) {
                d2 += (double)n;
            } else {
                d += (double)n;
            }
            d = d * 25400.0 / 72000.0;
            d2 = d2 * 25400.0 / 72000.0;
            double[] dArray = this.pageFormat.getMargins(false);
            double d3 = this.document.getTotalZoomX();
            double d4 = this.document.getTotalZoomY();
            d = Math.ceil(d * d3 + dArray[0] + dArray[1]);
            d2 = Math.ceil(d2 * d4 + dArray[2] + dArray[3]);
            this.updateImageableArea(d, d2, 1);
        } else {
            Dimension dimension = PageSizes.getInstance().getPageDimension(object);
            if (dimension != null) {
                MediaSizeName mediaSizeName = null;
                if (!bl && !bl2) {
                    mediaSizeName = ((PageSizes.Format)object).getValue();
                }
                this.updateImageableArea(mediaSizeName, true);
                this.paperWidth.setValue(dimension.getWidth());
                this.paperHeight.setValue(dimension.getHeight());
            }
        }
    }

    public void refresh() {
        if (this.fitTo.isSelected()) {
            this.updateZoom();
        }
        this.document.update();
        this.document.getPrintPreviewFrame().updatePanel();
        this.beginUpdate();
        if (!this.fitTo.isSelected()) {
            this.updateFitTo();
        }
        this.endUpdate();
    }

    public void updateFitTo() {
        GraphParams graphParams = this.document.getRenderer().getParams();
        this.fitToWidth.setValue(graphParams.getPrintCols());
        this.fitToHeight.setValue(graphParams.getPrintRows());
    }

    private void updateZoom() {
        this.document.updateZoom(((Number)this.fitToWidth.getValue()).intValue(), ((Number)this.fitToHeight.getValue()).intValue());
    }

    private void updateImageableArea(MediaSizeName mediaSizeName, boolean bl) {
        boolean bl2 = false;
        double[] dArray = this.pageFormat.getMargins(false);
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        this.pageFormat.setSizeName(mediaSizeName);
        PageSize pageSize = this.pageFormat.getSize();
        double d5 = pageSize.getX(1000);
        double d6 = pageSize.getY(1000);
        if (d < 0.0) {
            d = 0.0;
            bl2 = true;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
            bl2 = true;
        }
        if (d + d2 >= d5) {
            d = Math.floor(d5 / 4.0);
            d2 = Math.floor(d5 / 4.0);
            bl2 = true;
        }
        if (d3 < 0.0) {
            d3 = 0.0;
            bl2 = true;
        }
        if (d4 < 0.0) {
            d4 = 0.0;
            bl2 = true;
        }
        if (d3 + d4 >= d6) {
            d3 = Math.floor(d6 / 4.0);
            d4 = Math.floor(d6 / 4.0);
            bl2 = true;
        }
        MediaPrintableArea mediaPrintableArea = new MediaPrintableArea((float)d, (float)d3, (float)(d5 - d - d2), (float)(d6 - d3 - d4), 1000);
        if (bl) {
            MediaPrintableArea mediaPrintableArea2 = ExtendedPageFormat.adaptMediaPrintableArea(mediaPrintableArea, this.document.getPrintService(), mediaSizeName);
            this.pageFormat.setPrintableArea(mediaPrintableArea2);
            if (mediaPrintableArea != mediaPrintableArea2) {
                bl2 = true;
            }
        } else {
            this.pageFormat.setPrintableArea(mediaPrintableArea);
        }
        if (bl2) {
            this.updateOrientation();
        }
    }

    private void updateImageableArea(double d, double d2, int n) {
        boolean bl = false;
        double[] dArray = this.pageFormat.getMargins(false);
        double d3 = dArray[0];
        double d4 = dArray[1];
        double d5 = dArray[2];
        double d6 = dArray[3];
        PageSize pageSize = this.pageFormat.getSize();
        if (d < 0.0) {
            d = pageSize.getX(1000);
        }
        if (d2 < 0.0) {
            d2 = pageSize.getY(1000);
        }
        this.pageFormat.setSize(new PageSize((float)d, (float)d2, 1000), n);
        if (d3 < 0.0) {
            d3 = 0.0;
            bl = true;
        }
        if (d4 < 0.0) {
            d4 = 0.0;
            bl = true;
        }
        if (d3 + d4 >= d) {
            d3 = Math.floor(d / 4.0);
            d4 = Math.floor(d / 4.0);
            bl = true;
        }
        if (d5 < 0.0) {
            d5 = 0.0;
            bl = true;
        }
        if (d6 < 0.0) {
            d6 = 0.0;
            bl = true;
        }
        while (d5 + d6 >= d2) {
            d5 = Math.floor(d2 / 4.0);
            d6 = Math.floor(d2 / 4.0);
            bl = true;
        }
        MediaPrintableArea mediaPrintableArea = new MediaPrintableArea((float)d3, (float)d5, (float)(d - d3 - d4), (float)(d2 - d5 - d6), 1000);
        this.pageFormat.setPrintableArea(mediaPrintableArea);
        if (bl) {
            double[] dArray2 = this.pageFormat.getMargins(true);
            this.marginLeft.setValue(dArray2[0]);
            this.marginRight.setValue(dArray2[1]);
            this.marginTop.setValue(dArray2[2]);
            this.marginBottom.setValue(dArray2[3]);
        }
    }

    private double[] updateImageableArea(double d, double d2, double d3, double d4, int n) {
        boolean bl = false;
        int n2 = this.pageFormat.getOrientation();
        double d5 = d;
        double d6 = d2;
        double d7 = d3;
        double d8 = d4;
        switch (n2) {
            case 0: {
                d5 = d3;
                d6 = d4;
                d7 = d2;
                d8 = d;
                break;
            }
            case 2: {
                d5 = d4;
                d6 = d3;
                d7 = d;
                d8 = d2;
            }
        }
        double[] dArray = this.pageFormat.getMargins(false);
        double d9 = dArray[0];
        double d10 = dArray[1];
        double d11 = dArray[2];
        double d12 = dArray[3];
        if (d5 < 0.0) {
            d5 = d9;
            if (n == 0) {
                bl = true;
            }
        }
        if (d6 < 0.0) {
            d6 = d10;
            if (n == 1) {
                bl = true;
            }
        }
        if (d7 < 0.0) {
            d7 = d11;
            if (n == 2) {
                bl = true;
            }
        }
        if (d8 < 0.0) {
            d8 = d12;
            if (n == 3) {
                bl = true;
            }
        }
        PageSize pageSize = this.pageFormat.getSize();
        double d13 = pageSize.getX(1000);
        double d14 = pageSize.getY(1000);
        if (this.isBigPage()) {
            this.pageFormat.setSize(new PageSize((float)(d13 += d5 - d9 + d6 - d10), (float)(d14 += d7 - d11 + d8 - d12), 1000), 1);
        } else {
            if (d5 + d6 >= d13) {
                d5 = d9;
                d6 = d10;
                bl = true;
            }
            if (d5 + d6 >= d13) {
                d5 = Math.floor(d13 / 4.0);
                d6 = Math.floor(d13 / 4.0);
                bl = true;
            }
            if (d7 + d8 >= d14) {
                d7 = d11;
                d8 = d12;
                bl = true;
            }
            if (d7 + d8 >= d14) {
                d7 = Math.floor(d14 / 4.0);
                d8 = Math.floor(d14 / 4.0);
                bl = true;
            }
        }
        MediaPrintableArea mediaPrintableArea = new MediaPrintableArea((float)d5, (float)d7, (float)(d13 - d5 - d6), (float)(d14 - d7 - d8), 1000);
        MediaPrintableArea mediaPrintableArea2 = ExtendedPageFormat.adaptMediaPrintableArea(mediaPrintableArea, this.document.getPrintService(), this.pageFormat.getSizeName());
        this.pageFormat.setPrintableArea(mediaPrintableArea2);
        if (mediaPrintableArea != mediaPrintableArea2) {
            bl = true;
        }
        this.pageFormat.setPrintableArea(mediaPrintableArea);
        if (bl) {
            double[] dArray2 = this.pageFormat.getMargins(true);
            return new double[]{dArray2[0], dArray2[1], dArray2[2], dArray2[3]};
        }
        return null;
    }

    private void updatePageSize(boolean bl) {
        PageSize pageSize = this.pageFormat.getSize();
        this.paperWidth.setValue(Float.valueOf(pageSize.getX(1000)));
        this.paperHeight.setValue(Float.valueOf(pageSize.getY(1000)));
    }

    private void updateOrientation() {
        double[] dArray = this.pageFormat.getMargins(true);
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        this.marginLeft.setValue(d);
        this.marginRight.setValue(d2);
        this.marginTop.setValue(d3);
        this.marginBottom.setValue(d4);
    }

    public JComponent createContentPanel(boolean bl) {
        this.initControls();
        if (bl) {
            return this.createVerticalPanel();
        }
        return this.createDialogPanel();
    }

    private JComponent createDialogPanel() {
        FormLayout formLayout = new FormLayout("p, 3dlu, p, 3dlu", "p, 3dlu,p, 3dlu, p, 3dlu,p,3dlu");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.setDefaultDialogBorder();
        defaultFormBuilder.add((Component)this.createPrinterPanel(), cellConstraints.xyw(1, 1, 3));
        defaultFormBuilder.add((Component)this.createPaperPanel(), cellConstraints.xywh(1, 3, 1, 3));
        defaultFormBuilder.add((Component)this.createOrientationPanel(), cellConstraints.xy(3, 3));
        defaultFormBuilder.add((Component)this.createMarginsPanel(), cellConstraints.xy(3, 5));
        defaultFormBuilder.add((Component)this.createScalingPanel(), cellConstraints.xyw(1, 7, 3));
        return defaultFormBuilder.getPanel();
    }

    private JComponent createPrinterPanel() {
        FormLayout formLayout = new FormLayout("p", "p, 3dlu");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.append(this.printers);
        return defaultFormBuilder.getPanel();
    }

    private JComponent createVerticalPanel() {
        FormLayout formLayout = new FormLayout("p", this.printSpreadSheet == null ? "p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu" : "p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        defaultFormBuilder.append(this.createFlowPrinterPanel());
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(this.createFlowOrientationPanel());
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(this.createFlowPaperPanel());
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(this.createFlowMarginsPanel());
        defaultFormBuilder.nextLine(2);
        if (this.printSpreadSheet != null) {
            defaultFormBuilder.append(this.createFlowPartPanel());
            defaultFormBuilder.nextLine(2);
        }
        defaultFormBuilder.append(this.createFlowScalingPanel());
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(this.saveSettings);
        return defaultFormBuilder.getPanel();
    }

    private JComponent createFlowPrinterPanel() {
        FormLayout formLayout = new FormLayout("1dlu,p:grow,1dlu", "p, 3dlu");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.nextColumn();
        defaultFormBuilder.append(this.printers);
        JPanel jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(new TitledBorder(Messages.getString("PageSetupDialog.Printers")));
        return jPanel;
    }

    private JComponent createPaperPanel() {
        FormLayout formLayout = new FormLayout("8dlu, p,p,8dlu", "p, 3dlu:grow,p, 2dlu");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.createPaperSizePanel(), cellConstraints.xyw(2, 1, 2));
        JPanel jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(new TitledBorder(Messages.getString("PageSetupDialog.Paper")));
        return jPanel;
    }

    private JComponent createFlowPaperPanel() {
        FormLayout formLayout = new FormLayout("1dlu, p,p,p:grow,1dlu", "p, 3dlu:grow, 2dlu");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.createFlowPaperSizePanel(), cellConstraints.xyw(2, 1, 3));
        JPanel jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(new TitledBorder(Messages.getString("PageSetupDialog.Paper")));
        return jPanel;
    }

    private JComponent createPaperSizePanel() {
        FormLayout formLayout = new FormLayout("p, 3dlu,50dlu", "p, 3dlu, p, 3dlu, p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.paperSize, cellConstraints.xyw(1, 1, 3));
        defaultFormBuilder.add((Component)this.paperWidthLabel, cellConstraints.xy(1, 3));
        defaultFormBuilder.add((Component)this.paperWidth, cellConstraints.xy(3, 3));
        defaultFormBuilder.add((Component)this.paperHeightLabel, cellConstraints.xy(1, 5));
        defaultFormBuilder.add((Component)this.paperHeight, cellConstraints.xy(3, 5));
        return defaultFormBuilder.getPanel();
    }

    private JComponent createFlowPaperSizePanel() {
        FormLayout formLayout = new FormLayout("p, 3dlu,40dlu", "p, 3dlu, p, 3dlu, p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.paperSize, cellConstraints.xyw(1, 1, 3));
        defaultFormBuilder.add((Component)this.paperWidthLabel, cellConstraints.xy(1, 3));
        defaultFormBuilder.add((Component)this.paperWidth, cellConstraints.xy(3, 3));
        defaultFormBuilder.add((Component)this.paperHeightLabel, cellConstraints.xy(1, 5));
        defaultFormBuilder.add((Component)this.paperHeight, cellConstraints.xy(3, 5));
        return defaultFormBuilder.getPanel();
    }

    private JComponent createOrientationPanel() {
        FormLayout formLayout = new FormLayout("8dlu, 100dlu, 8dlu", "p,2dlu");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.orientation, cellConstraints.xy(2, 1));
        JPanel jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(new TitledBorder(Messages.getString("PageSetupDialog.Orientation")));
        return jPanel;
    }

    private JComponent createFlowOrientationPanel() {
        FormLayout formLayout = new FormLayout("1dlu, p:grow, 1dlu", "p,2dlu");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.orientation, cellConstraints.xy(2, 1));
        JPanel jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(new TitledBorder(Messages.getString("PageSetupDialog.Orientation")));
        return jPanel;
    }

    private JComponent createMarginsPanel() {
        FormLayout formLayout = new FormLayout("8dlu, 50dlu, 3dlu, 50dlu, 8dlu", "p,1dlu,p,3dlu, p,1dlu,p,2dlu");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.marginLeftLabel, cellConstraints.xy(2, 1));
        defaultFormBuilder.add((Component)this.marginLeft, cellConstraints.xy(2, 3));
        defaultFormBuilder.add((Component)this.marginRightLabel, cellConstraints.xy(4, 1));
        defaultFormBuilder.add((Component)this.marginRight, cellConstraints.xy(4, 3));
        defaultFormBuilder.add((Component)this.marginTopLabel, cellConstraints.xy(2, 5));
        defaultFormBuilder.add((Component)this.marginTop, cellConstraints.xy(2, 7));
        defaultFormBuilder.add((Component)this.marginBottomLabel, cellConstraints.xy(4, 5));
        defaultFormBuilder.add((Component)this.marginBottom, cellConstraints.xy(4, 7));
        JPanel jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(new TitledBorder(Messages.getString("PageSetupDialog.Margins")));
        return jPanel;
    }

    private JComponent createFlowMarginsPanel() {
        FormLayout formLayout = new FormLayout("1dlu, 41dlu, 3dlu, 41dlu, 1dlu", "p,1dlu,p,3dlu, p,1dlu,p,2dlu");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.marginLeftLabel, cellConstraints.xy(2, 1));
        defaultFormBuilder.add((Component)this.marginLeft, cellConstraints.xy(2, 3));
        defaultFormBuilder.add((Component)this.marginRightLabel, cellConstraints.xy(4, 1));
        defaultFormBuilder.add((Component)this.marginRight, cellConstraints.xy(4, 3));
        defaultFormBuilder.add((Component)this.marginTopLabel, cellConstraints.xy(2, 5));
        defaultFormBuilder.add((Component)this.marginTop, cellConstraints.xy(2, 7));
        defaultFormBuilder.add((Component)this.marginBottomLabel, cellConstraints.xy(4, 5));
        defaultFormBuilder.add((Component)this.marginBottom, cellConstraints.xy(4, 7));
        JPanel jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(new TitledBorder(Messages.getString("PageSetupDialog.Margins")));
        return jPanel;
    }

    private JComponent createFlowPartPanel() {
        FormLayout formLayout = new FormLayout("1dlu, p, 1dlu", "p,3dlu, p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        if (this.printSpreadSheet != null) {
            defaultFormBuilder.add((Component)this.printSpreadSheet, cellConstraints.xy(2, 1));
        }
        if (this.printGantt != null) {
            defaultFormBuilder.add((Component)this.printGantt, cellConstraints.xy(2, 3));
        }
        JPanel jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(new TitledBorder(Messages.getString("PageSetupDialog.ShowParts")));
        return jPanel;
    }

    private JComponent createScalingPanel() {
        FormLayout formLayout = new FormLayout("8dlu, p, 3dlu,30dlu,3dlu,p,3dlu,p,p,p,8dlu", "p, 3dlu,p,10dlu,p,3dlu,p,3dlu");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.scaleTo, cellConstraints.xy(2, 1));
        defaultFormBuilder.add((Component)this.scaleToWidth, cellConstraints.xy(4, 1));
        defaultFormBuilder.add((Component)this.scaleToWidthLabel, cellConstraints.xy(6, 1));
        defaultFormBuilder.add((Component)this.constrainProportions, cellConstraints.xy(8, 1));
        JLabel jLabel = new JLabel(Messages.getString("PageSetupDialog.Scaling.FitToProportions") + " " + Messages.getString("PageSetupDialog.Scaling.FitToProportions2"));
        this.initFont(jLabel);
        defaultFormBuilder.add((Component)this.scaleToProportions, cellConstraints.xy(9, 1));
        defaultFormBuilder.add((Component)this.scaleToProportions2, cellConstraints.xy(10, 1));
        defaultFormBuilder.add((Component)this.scaleToHeight, cellConstraints.xy(4, 3));
        defaultFormBuilder.add((Component)this.scaleToHeightLabel, cellConstraints.xy(6, 3));
        defaultFormBuilder.add((Component)this.fitTo, cellConstraints.xy(2, 5));
        defaultFormBuilder.add((Component)this.fitToWidth, cellConstraints.xy(4, 5));
        defaultFormBuilder.add((Component)this.fitToWidthLabel, cellConstraints.xy(6, 5));
        defaultFormBuilder.add((Component)this.fitToHeight, cellConstraints.xy(4, 7));
        defaultFormBuilder.add((Component)this.fitToHeightLabel, cellConstraints.xy(6, 7));
        JPanel jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(new TitledBorder(Messages.getString("PageSetupDialog.Scaling")));
        return jPanel;
    }

    private JComponent createFlowScalingPanel() {
        FormLayout formLayout = new FormLayout("1dlu, 5dlu,p,22dlu,3dlu,p,1dlu", "p, 3dlu,p,3dlu,p,3dlu,p,p,10dlu,p,3dlu,p,3dlu,p,3dlu");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.scaleTo, cellConstraints.xyw(2, 1, 5));
        defaultFormBuilder.add((Component)this.scaleToWidth, cellConstraints.xyw(3, 3, 2));
        defaultFormBuilder.add((Component)this.scaleToWidthLabel, cellConstraints.xy(6, 3));
        defaultFormBuilder.add((Component)this.scaleToHeight, cellConstraints.xyw(3, 5, 2));
        defaultFormBuilder.add((Component)this.scaleToHeightLabel, cellConstraints.xy(6, 5));
        defaultFormBuilder.add((Component)this.constrainProportions, cellConstraints.xy(3, 7));
        defaultFormBuilder.add((Component)this.scaleToProportions, cellConstraints.xyw(4, 7, 3));
        defaultFormBuilder.add((Component)this.scaleToProportions2, cellConstraints.xyw(4, 8, 4));
        defaultFormBuilder.add((Component)this.fitTo, cellConstraints.xyw(2, 10, 5));
        defaultFormBuilder.add((Component)this.fitToWidth, cellConstraints.xyw(3, 12, 2));
        defaultFormBuilder.add((Component)this.fitToWidthLabel, cellConstraints.xy(6, 12));
        defaultFormBuilder.add((Component)this.fitToHeight, cellConstraints.xyw(3, 14, 2));
        defaultFormBuilder.add((Component)this.fitToHeightLabel, cellConstraints.xy(6, 14));
        JPanel jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(new TitledBorder(Messages.getString("PageSetupDialog.Scaling")));
        return jPanel;
    }

    protected static class PrintServiceOption {
        private static final int maxLen = 25;
        protected PrintService printService;

        public PrintServiceOption(PrintService printService) {
            this.printService = printService;
        }

        public String toString() {
            String string = this.printService.getName();
            if (string.length() > 25) {
                string = string.substring(0, 25);
            }
            return string;
        }

        public PrintService getValue() {
            return this.printService;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof PrintServiceOption)) {
                return false;
            }
            PrintServiceOption printServiceOption = (PrintServiceOption)object;
            return this.printService.equals(printServiceOption.getValue());
        }
    }
}

