/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.timescale;

import com.projity.graphic.configuration.GraphicConfiguration;
import com.projity.pm.graphic.frames.GraphicManager;
import com.projity.pm.graphic.gantt.GanttParams;
import com.projity.pm.graphic.timescale.CoordinatesConverter;
import com.projity.timescale.TimeInterval;
import com.projity.timescale.TimeIterator;
import com.projity.util.Environment;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class TimeScaleComponent
extends JPanel {
    protected CoordinatesConverter coord;
    protected static Color textColor;
    protected static Color lineColor;

    public TimeScaleComponent(CoordinatesConverter coordinatesConverter) {
        this.coord = coordinatesConverter;
        int n = GraphicConfiguration.getInstance().getColumnHeaderHeight();
        if (textColor == null) {
            textColor = Color.BLACK;
        }
        if (lineColor == null) {
            lineColor = Environment.isMac() ? Color.LIGHT_GRAY : Color.BLACK;
        }
        this.setPreferredSize(new Dimension(0, n));
        if (Environment.isMac()) {
            this.setBackground(GraphicManager.getInstance().getLafManager().getUnselectedBackgroundColor());
        } else {
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        TimeScaleComponent.paintTimeScale(graphics2D, this.coord, this.getFont(), new Dimension(0, this.getHeight()), true);
    }

    public static void paintTimeScale(Graphics2D graphics2D, GanttParams ganttParams, Font font) {
        TimeScaleComponent.paintTimeScale(graphics2D, ganttParams.getCoord(), font, new Dimension((int)ganttParams.getGanttBounds().getWidth(), ganttParams.getConfiguration().getColumnHeaderHeight()), false);
    }

    public static void paintTimeScale(Graphics2D graphics2D, CoordinatesConverter coordinatesConverter, Font font, Dimension dimension, boolean bl) {
        double d;
        double d2;
        Rectangle rectangle = graphics2D.getClipBounds();
        double d3 = dimension.getHeight();
        if (bl) {
            d2 = rectangle.getX();
            d = rectangle.getWidth();
            GraphicManager.getInstance().getLafManager().paintTimeScale(graphics2D, rectangle.x, 0, rectangle.width, dimension.height, new Shape[]{new Line2D.Double(d2, 0.0, d2 + d, 0.0), new Line2D.Double(d2, d3 - 1.0, d2 + d, d3 - 1.0)});
        } else {
            d2 = 0.0;
            d = dimension.getWidth();
        }
        graphics2D.setColor(lineColor);
        if (Environment.isMac()) {
            graphics2D.draw(new Line2D.Double(d2, d3 - 1.0, d2 + d, d3 - 1.0));
        }
        graphics2D.draw(new Line2D.Double(d2, d3 / 2.0, d2 + d, d3 / 2.0));
        TimeIterator timeIterator = coordinatesConverter.getTimeIterator(d2, d2 + d);
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        long l = -1L;
        long l2 = -1L;
        while (timeIterator.hasNext()) {
            TimeInterval timeInterval = timeIterator.next();
            if (l == -1L) {
                l = timeInterval.getStart1();
            }
            l2 = timeInterval.getEnd1();
            double d4 = coordinatesConverter.toX(timeInterval.getStart1());
            double d5 = coordinatesConverter.toX(timeInterval.getEnd1());
            graphics2D.setColor(lineColor);
            if (bl) {
                graphics2D.draw(new Line2D.Double(d4, d3 / 2.0, d4, d3));
            }
            graphics2D.draw(new Line2D.Double(d5, d3 / 2.0, d5, d3));
            String string = timeInterval.getText1();
            LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
            graphics2D.setColor(textColor);
            graphics2D.drawString(string, (float)((int)d4 + 2), (float)((int)d3) - lineMetrics.getDescent() - lineMetrics.getLeading());
            if (timeInterval.getText2() == null) continue;
            double d6 = coordinatesConverter.toX(timeInterval.getStart2());
            double d7 = coordinatesConverter.toX(timeInterval.getEnd2());
            graphics2D.setColor(lineColor);
            if (bl) {
                graphics2D.draw(new Line2D.Double(d6, 0.0, d6, d3 / 2.0));
            }
            graphics2D.draw(new Line2D.Double(d7, 0.0, d7, d3 / 2.0));
            string = timeInterval.getText2();
            lineMetrics = font.getLineMetrics(string, fontRenderContext);
            if (!bl && !((double)((int)d6 + 2) >= d2)) continue;
            graphics2D.setColor(textColor);
            graphics2D.drawString(string, (float)((int)d6 + 2), (float)((int)d3 / 2) - lineMetrics.getDescent() - lineMetrics.getLeading());
        }
    }
}

