/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet;

import com.projity.configuration.Dictionary;
import com.projity.field.FieldContext;
import com.projity.graphic.configuration.SpreadSheetFieldArray;
import com.projity.pm.graphic.gantt.GanttParamsImpl;
import com.projity.pm.graphic.graph.GraphParams;
import com.projity.pm.graphic.spreadsheet.SpreadSheetColumnModel;
import com.projity.pm.graphic.spreadsheet.SpreadSheetParams;
import com.projity.pm.graphic.spreadsheet.common.SpreadSheetRowHeaderColumnModel;
import com.projity.strings.Messages;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SpreadSheetParamsImpl
extends GanttParamsImpl
implements SpreadSheetParams {
    protected String spreadsheetCategory = "taskSpreadsheet";
    protected SpreadSheetFieldArray fieldArray;
    protected List<Integer> colWidth;
    protected FieldContext fieldContext;
    protected SpreadSheetColumnModel columnModel;
    protected SpreadSheetRowHeaderColumnModel headerColumnModel = new SpreadSheetRowHeaderColumnModel();
    protected int spreadSheetWidth = -1;
    protected int idColMargin = 2;
    protected int colMargin = 2;
    protected ArrayList colPageInfo;
    protected ArrayList rowPageInfo;

    public SpreadSheetParamsImpl(SpreadSheetFieldArray spreadSheetFieldArray, List<Integer> list, boolean bl) {
        this.setFieldArray(spreadSheetFieldArray == null ? (SpreadSheetFieldArray)Dictionary.get(this.spreadsheetCategory, Messages.getString("Spreadsheet.Task.entry")) : spreadSheetFieldArray, spreadSheetFieldArray == null ? null : (list == null ? spreadSheetFieldArray.getWidths() : list));
        this.setRightPartVisible(bl);
    }

    @Override
    public SpreadSheetFieldArray getFieldArray() {
        return this.fieldArray;
    }

    @Override
    public void setFieldArray(SpreadSheetFieldArray spreadSheetFieldArray, List<Integer> list) {
        this.fieldArray = spreadSheetFieldArray;
        this.colWidth = list;
        this.columnModel = new SpreadSheetColumnModel(spreadSheetFieldArray, list);
        this.columnModel.setSvg(true);
        this.initColumns(this.columnModel, spreadSheetFieldArray.size());
        this.initColumns(this.headerColumnModel, 1);
        this.fieldContext = new FieldContext();
        this.fieldContext.setLeftAssociation(true);
        this.updateWidth();
    }

    @Override
    public String getSpreadsheetCategory() {
        return this.spreadsheetCategory;
    }

    @Override
    public FieldContext getFieldContext() {
        return this.fieldContext;
    }

    public void initColumns(TableColumnModel tableColumnModel, int n) {
        while (tableColumnModel.getColumnCount() > 0) {
            tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
        }
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = new TableColumn(i);
            tableColumn.setHeaderValue("" + i);
            tableColumnModel.addColumn(tableColumn);
        }
    }

    @Override
    public Rectangle getSpreadSheetBounds() {
        return new Rectangle(0, this.configuration.getColumnHeaderHeight(), this.spreadSheetWidth, this.getRowHeight() * this.cache.getSize());
    }

    @Override
    public Rectangle getDrawingBounds() {
        return new Rectangle(0, this.configuration.getColumnHeaderHeight(), (this.isLeftPartVisible() ? this.getSpreadSheetBounds().width : 0) + (this.isRightPartVisible() ? this.getGanttBounds().width : 0), this.getSpreadSheetBounds().height + this.configuration.getColumnHeaderHeight());
    }

    public int getSpreadSheetWidth() {
        return this.spreadSheetWidth;
    }

    @Override
    public SpreadSheetColumnModel getColumnModel() {
        return this.columnModel;
    }

    @Override
    public SpreadSheetRowHeaderColumnModel getHeaderColumnModel() {
        return this.headerColumnModel;
    }

    @Override
    public Iterator getColumnIterator() {
        return new Iterator(){
            protected Enumeration headerE;
            protected Enumeration e;
            {
                this.headerE = SpreadSheetParamsImpl.this.headerColumnModel.getColumns();
                this.e = SpreadSheetParamsImpl.this.columnModel.getColumns();
            }

            @Override
            public boolean hasNext() {
                return this.headerE.hasMoreElements() || this.e.hasMoreElements();
            }

            public Object next() {
                if (this.headerE.hasMoreElements()) {
                    return this.headerE.nextElement();
                }
                return this.e.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void updateDrawingBounds() {
        this.updateWidth();
    }

    private void updateWidth() {
        this.spreadSheetWidth = this.calculateSpreadSheetWidth();
    }

    private int calculateSpreadSheetWidth() {
        int n = this.getConfiguration().getRowHeaderWidth() + 2 * this.idColMargin;
        Enumeration<TableColumn> enumeration = this.columnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            int n2 = tableColumn.getPreferredWidth() + 2 * this.colMargin;
            n += n2;
        }
        return n;
    }

    @Override
    public void setPrintBounds(Rectangle rectangle) {
        super.setPrintBounds(rectangle);
        this.updatePages();
    }

    private void updatePages() {
        if (this.printBounds == null) {
            return;
        }
        if (this.colPageInfo == null) {
            this.colPageInfo = new ArrayList();
        } else {
            this.colPageInfo.clear();
        }
        if (this.rowPageInfo == null) {
            this.rowPageInfo = new ArrayList();
        } else {
            this.rowPageInfo.clear();
        }
        int n = this.getConfiguration().getRowHeaderWidth() + 2 * this.idColMargin;
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        Enumeration<TableColumn> enumeration = this.columnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            if (n + tableColumn.getPreferredWidth() + 2 * this.colMargin > this.printBounds.width) {
                this.colPageInfo.add(new PageInfo(n2, n3 - 1, n4, n));
                n2 = n3;
                n4 += n;
                n = 0;
            }
            n += tableColumn.getPreferredWidth() + 2 * this.colMargin;
            ++n3;
        }
        this.colPageInfo.add(new PageInfo(n2, n3 - 1, n4, n));
        int n5 = this.getRowsPerPage();
        int n6 = this.cache.getSize();
        int n7 = n6 / n5;
        for (n3 = 0; n3 < n7; ++n3) {
            this.rowPageInfo.add(new PageInfo(n3 * n5, (n3 + 1) * n5 - 1, n3 * n5 * this.getRowHeight(), n5 * this.getRowHeight()));
        }
        int n8 = n6 % n5;
        if (n8 != 0) {
            this.rowPageInfo.add(new PageInfo(n3 * n5, n6 - 1, n3 * n5 * this.getRowHeight(), n8 * this.getRowHeight()));
        }
    }

    @Override
    public PageInfo getRowPageInfo(int n) {
        return n < 0 || n >= this.rowPageInfo.size() ? null : (PageInfo)this.rowPageInfo.get(n);
    }

    @Override
    public PageInfo getColPageInfo(int n) {
        return n < 0 || n >= this.colPageInfo.size() ? null : (PageInfo)this.colPageInfo.get(n);
    }

    public int getRowsPerPage() {
        int n = (this.printBounds.height - this.configuration.getColumnHeaderHeight() - this.configuration.getPrintFooterHeight()) / this.getRowHeight();
        if (n <= 0) {
            System.out.println("Error bad rowsPerPage");
            n = 1;
        }
        return n;
    }

    public Rectangle getSpreadsheetPrintBounds(int n, int n2, boolean bl) {
        if (bl && !this.isLeftPartVisible()) {
            return null;
        }
        PageInfo pageInfo = this.getColPageInfo(n2);
        PageInfo pageInfo2 = this.getRowPageInfo(n);
        if (pageInfo == null || pageInfo2 == null) {
            return null;
        }
        return new Rectangle(pageInfo.getX(), pageInfo2.getX() + this.configuration.getColumnHeaderHeight(), pageInfo.getWidth(), pageInfo2.getWidth());
    }

    public Rectangle getGanttPrintBounds(int n, int n2) {
        int n3;
        if (!this.isRightPartVisible()) {
            return null;
        }
        int n4 = this.colPageInfo.size() - 1;
        if (n2 < n4 && this.isLeftPartVisible()) {
            return null;
        }
        int n5 = this.getGanttBounds().width;
        Rectangle rectangle = this.getSpreadsheetPrintBounds(n, n4, true);
        if (!(n2 != n4 && this.isLeftPartVisible() || rectangle == null)) {
            int n6 = rectangle.width;
            int n7 = this.getPrintBounds().width - rectangle.width;
            if (n7 > n5) {
                n7 = n5;
            }
            Rectangle rectangle2 = new Rectangle(0, rectangle.y - this.configuration.getColumnHeaderHeight(), n7, rectangle.height);
            if (rectangle2.width == 0) {
                return null;
            }
            return rectangle2;
        }
        rectangle = this.getSpreadsheetPrintBounds(n, n4, false);
        int n8 = -this.getGanttDeltaX(n, n2);
        if (n8 + (n3 = this.getPrintBounds().width) > n5) {
            n3 = n5 - n8;
        }
        Rectangle rectangle3 = new Rectangle(n8, rectangle == null ? 0 : rectangle.y - this.configuration.getColumnHeaderHeight(), n3, rectangle == null ? 0 : rectangle.height);
        return rectangle3;
    }

    public int getGanttDeltaX(int n, int n2) {
        int n3 = this.colPageInfo.size() - 1;
        if (n2 < n3 && this.isLeftPartVisible()) {
            return -1;
        }
        Rectangle rectangle = this.getSpreadsheetPrintBounds(n, n3, true);
        if (rectangle == null) {
            return -n2 * this.getPrintBounds().width;
        }
        return rectangle.width - (n2 - n3) * this.getPrintBounds().width;
    }

    @Override
    public int getPrintCols() {
        int n = this.colPageInfo.size();
        PageInfo pageInfo = this.getColPageInfo(n - 1);
        int n2 = (this.isLeftPartVisible() ? pageInfo.width : 0) + (this.isRightPartVisible() ? this.getGanttBounds().width : 0);
        return (this.isLeftPartVisible() ? n - 1 : 0) + (int)Math.ceil((double)n2 / this.getPrintBounds().getWidth());
    }

    @Override
    public int getPrintRows() {
        int n = this.rowPageInfo.size();
        return n == 0 ? 1 : n;
    }

    public int getColMargin() {
        return this.colMargin;
    }

    public int getIdColMargin() {
        return this.idColMargin;
    }

    @Override
    public GraphParams createSafePrintCopy() {
        SpreadSheetParamsImpl spreadSheetParamsImpl = (SpreadSheetParamsImpl)super.createSafePrintCopy();
        if (spreadSheetParamsImpl.colPageInfo != null) {
            spreadSheetParamsImpl.colPageInfo = (ArrayList)this.colPageInfo.clone();
        }
        if (spreadSheetParamsImpl.rowPageInfo != null) {
            spreadSheetParamsImpl.rowPageInfo = (ArrayList)this.rowPageInfo.clone();
        }
        return spreadSheetParamsImpl;
    }

    public class PageInfo {
        protected int start;
        protected int end;
        protected int x;
        protected int width;

        public PageInfo(int n, int n2, int n3, int n4) {
            this.start = n;
            this.end = n2;
            this.x = n3;
            this.width = n4;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int n) {
            this.end = n;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int n) {
            this.start = n;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int n) {
            this.width = n;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int n) {
            this.x = n;
        }
    }
}

