/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.dialog.AbstractDialog;
import com.projity.strings.Messages;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTextField;

public final class RenameProjectDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private Form form;
    JTextField nameField;

    public static RenameProjectDialog getInstance(Frame frame, Form form) {
        return new RenameProjectDialog(frame, form);
    }

    private RenameProjectDialog(Frame frame, Form form) {
        super(frame, Messages.getString("RenameProjectDialog.RenameProject"), true);
        this.form = form != null ? form : new Form();
    }

    protected void initControls() {
        this.nameField = new JTextField();
        this.nameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String string = RenameProjectDialog.this.nameField.getText();
                RenameProjectDialog.this.ok.setEnabled(!RenameProjectDialog.this.form.getProjectNames().contains(string) && string.length() > 0);
            }
        });
        this.bind(true);
    }

    @Override
    public void onOk() {
        if (!this.ok.isEnabled()) {
            return;
        }
        super.onOk();
    }

    @Override
    protected boolean bind(boolean bl) {
        if (this.form == null) {
            return false;
        }
        if (bl) {
            String string = this.form.getName();
            String string2 = string == null || string.length() == 0 ? Messages.getString("RenameProjectDialog.NewProject") : string;
            int n = 0;
            while (this.form.getProjectNames().contains(string2)) {
                string2 = string + "(" + n + ")";
                ++n;
            }
            this.nameField.setText(string2);
        } else {
            this.form.setName(this.nameField.getText());
        }
        return true;
    }

    @Override
    public JComponent createContentPanel() {
        this.initControls();
        FormLayout formLayout = new FormLayout("250dlu:grow", "p, 3dlu,p, 3dlu");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        if (this.form.isSaveAs()) {
            defaultFormBuilder.append(Messages.getString("Message.saveProjectAs1") + this.form.getName() + Messages.getString("Message.saveProjectAs2"));
        } else {
            defaultFormBuilder.append(Messages.getString("Message.renameProject1") + this.form.getName() + Messages.getString("Message.renameProject2"));
        }
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(this.createFieldPanel());
        return defaultFormBuilder.getPanel();
    }

    public JComponent createFieldPanel() {
        FormLayout formLayout = new FormLayout("p,3dlu,100dlu:grow", "p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.append(Messages.getString("RenameProjectDialog.NewProjectName"), (Component)this.nameField);
        return defaultFormBuilder.getPanel();
    }

    public Form getForm() {
        return this.form;
    }

    @Override
    public Object getBean() {
        return this.form;
    }

    public static class Form {
        String name;
        Set projectNames;
        boolean saveAs;

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public Set getProjectNames() {
            return this.projectNames;
        }

        public void setProjectNames(Set set) {
            this.projectNames = set;
        }

        public boolean isSaveAs() {
            return this.saveAs;
        }

        public void setSaveAs(boolean bl) {
            this.saveAs = bl;
        }
    }
}

