/*
 * Decompiled with CFR 0.152.
 */
package com.projity.algorithm;

import com.projity.algorithm.IntervalGenerator;
import com.projity.pm.time.HasStartAndEnd;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CollectionIntervalGenerator
implements IntervalGenerator,
HasStartAndEnd {
    protected Collection collection;
    Object current = null;
    protected boolean finished = false;
    long start = 0L;
    boolean active = false;
    Iterator iterator;

    protected CollectionIntervalGenerator(Collection collection) {
        this.collection = collection;
        this.initialize();
    }

    public static CollectionIntervalGenerator getInstance(Collection collection) {
        return new CollectionIntervalGenerator(collection);
    }

    public static CollectionIntervalGenerator getInstance(HasStartAndEnd hasStartAndEnd) {
        LinkedList<HasStartAndEnd> linkedList = new LinkedList<HasStartAndEnd>();
        linkedList.add(hasStartAndEnd);
        return CollectionIntervalGenerator.getInstance(linkedList);
    }

    protected Iterator makeIterator() {
        if (this.collection instanceof List) {
            return ((List)this.collection).listIterator();
        }
        return this.iterator;
    }

    protected void initialize() {
        this.iterator = this.makeIterator();
        if (this.iterator.hasNext()) {
            this.current = this.iterator.next();
            this.updateActiveState();
        }
    }

    private void updateActiveState() {
        this.active = ((HasStartAndEnd)this.current).getStart() == this.start;
    }

    @Override
    public Object current() {
        if (this.active) {
            return this.current;
        }
        return this;
    }

    @Override
    public boolean evaluate(Object object) {
        this.start = this.currentEnd();
        if (this.active) {
            if (!this.iterator.hasNext()) {
                this.current = null;
                this.finished = true;
                this.active = false;
                return false;
            }
            this.current = this.iterator.next();
        }
        this.updateActiveState();
        return true;
    }

    public int compareTo(Object object) {
        return 0;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public boolean isCurrentActive() {
        return this.active;
    }

    @Override
    public long currentEnd() {
        long l;
        long l2 = l = this.current == null ? Long.MAX_VALUE : ((HasStartAndEnd)this.current).getEnd();
        if (l == 1L) {
            System.out.println(" 1 cur end");
        }
        return this.active ? l : ((HasStartAndEnd)this.current).getStart();
    }

    @Override
    public long currentStart() {
        return this.start;
    }

    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public long getEnd() {
        return this.currentEnd();
    }

    @Override
    public long getStart() {
        return this.currentStart();
    }

    @Override
    public boolean canBeShared() {
        return true;
    }
}

