/**
 * Form control.Note: Depending upon the environment in which the page is being viewed, the value property may be read-only for the file upload input type. For the "password" input type, the actual value returned may be masked to prevent unauthorized use. See the INPUT element definition in [HTML 4.01].
 */
var HTMLInputElement = {
}
/**
 * A single character access key to give access to the form control. See the accesskey attribute definition in HTML 4.01.
 * @syntax hTMLInputElement.accessKey
 * @returns {String} 
 */
HTMLInputElement.prototype.accessKey = new String();

/**
 * Returns the FORM element containing this control. Returns null if this control is not within the context of a form.
 * @syntax hTMLInputElement.form
 * @returns {HTMLFormElement} 
 */
HTMLInputElement.prototype.form = new HTMLFormElement();

/**
 * Select the contents of the text area. For INPUT elements whose type attribute has one of the following values: "text", "file", or "password".
 * @syntax hTMLInputElement.select()
 * @returns {undefined} 
 */
HTMLInputElement.prototype.select = function() {};

/**
 * A comma-separated list of content types that a server processing this form will handle correctly. See the accept attribute definition in HTML 4.01.
 * @syntax hTMLInputElement.accept
 * @returns {String} 
 */
HTMLInputElement.prototype.accept = new String();

/**
 * Index that represents the element's position in the tabbing order. See the tabindex attribute definition in HTML 4.01.
 * @syntax hTMLInputElement.tabIndex
 * @returns {Number} 
 */
HTMLInputElement.prototype.tabIndex = new Number();

/**
 * Aligns this object (vertically or horizontally) with respect to its surrounding text. See the align attribute definition in HTML 4.01. This attribute is deprecated in HTML 4.01.
 * @syntax hTMLInputElement.align
 * @returns {String} 
 */
HTMLInputElement.prototype.align = new String();

/**
 * Simulate a mouse-click. For INPUT elements whose type attribute has one of the following values: "button", "checkbox", "radio", "reset", or "submit".
 * @syntax hTMLInputElement.click()
 * @returns {undefined} 
 */
HTMLInputElement.prototype.click = function() {};

/**
 * Removes keyboard focus from this element.
 * @syntax hTMLInputElement.blur()
 * @returns {undefined} 
 */
HTMLInputElement.prototype.blur = function() {};

/**
 * Use client-side image map. See the usemap attribute definition in HTML 4.01.
 * @syntax hTMLInputElement.useMap
 * @returns {String} 
 */
HTMLInputElement.prototype.useMap = new String();

/**
 * The type of control created (all lower case). See the type attribute definition in HTML 4.01.
 * @syntax hTMLInputElement.type
 * @returns {String} 
 */
HTMLInputElement.prototype.type = new String();

/**
 * Size information. The precise meaning is specific to each type of field. See the size attribute definition in HTML 4.01.
 * @syntax hTMLInputElement.size
 * @returns {Number} 
 */
HTMLInputElement.prototype.size = new Number();

/**
 * When type has the value "radio" or "checkbox", this represents the HTML checked attribute of the element. The value of this attribute does not change if the state of the corresponding form control, in an interactive user agent, changes. See the checked attribute definition in HTML 4.01.
 * @syntax hTMLInputElement.defaultChecked
 * @returns {boolean} 
 */
HTMLInputElement.prototype.defaultChecked = new boolean();

/**
 * This control is read-only. Relevant only when type has the value "text" or "password". See the readonly attribute definition in HTML 4.01.
 * @syntax hTMLInputElement.readOnly
 * @returns {boolean} 
 */
HTMLInputElement.prototype.readOnly = new boolean();

/**
 * Maximum number of characters for text fields, when type has the value "text" or "password". See the maxlength attribute definition in HTML 4.01.
 * @syntax hTMLInputElement.maxLength
 * @returns {Number} 
 */
HTMLInputElement.prototype.maxLength = new Number();

/**
 * Alternate text for user agents not rendering the normal content of this element. See the alt attribute definition in HTML 4.01.
 * @syntax hTMLInputElement.alt
 * @returns {String} 
 */
HTMLInputElement.prototype.alt = new String();

/**
 * Form control or object name when submitted with a form. See the name attribute definition in HTML 4.01.
 * @syntax hTMLInputElement.name
 * @returns {String} 
 */
HTMLInputElement.prototype.name = new String();

/**
 * When the type attribute of the element has the value "text", "file" or "password", this represents the current contents of the corresponding form control, in an interactive user agent. Changing this attribute changes the contents of the form control, but does not change the value of the HTML value attribute of the element. When the type attribute of the element has the value "button", "hidden", "submit", "reset", "image", "checkbox" or "radio", this represents the HTML value attribute of the element. See the value attribute definition in HTML 4.01.
 * @syntax hTMLInputElement.value
 * @returns {String} 
 */
HTMLInputElement.prototype.value = new String();

/**
 * Gives keyboard focus to this element.
 * @syntax hTMLInputElement.focus()
 * @returns {undefined} 
 */
HTMLInputElement.prototype.focus = function() {};

/**
 * When the type attribute has the value "image", this attribute specifies the location of the image to be used to decorate the graphical submit button. See the src attribute definition in HTML 4.01.
 * @syntax hTMLInputElement.src
 * @returns {String} 
 */
HTMLInputElement.prototype.src = new String();

/**
 * When the type attribute of the element has the value "text", "file" or "password", this represents the HTML value attribute of the element. The value of this attribute does not change if the contents of the corresponding form control, in an interactive user agent, changes. See the value attribute definition in HTML 4.01.
 * @syntax hTMLInputElement.defaultValue
 * @returns {String} 
 */
HTMLInputElement.prototype.defaultValue = new String();

/**
 * When the type attribute of the element has the value "radio" or "checkbox", this represents the current state of the form control, in an interactive user agent. Changes to this attribute change the state of the form control, but do not change the value of the HTML checked attribute of the INPUT element. Note: During the handling of a click event on an input element with a type attribute that has the value "radio" or "checkbox", some implementations may change the value of this property before the event is being dispatched in the document. If the default action of the event is canceled, the value of the property may be changed back to its original value. This means that the value of this property during the handling of click events is implementation dependent.
 * @syntax hTMLInputElement.checked
 * @returns {boolean} 
 */
HTMLInputElement.prototype.checked = new boolean();

/**
 * The control is unavailable in this context. See the disabled attribute definition in HTML 4.01.
 * @syntax hTMLInputElement.disabled
 * @returns {boolean} 
 */
HTMLInputElement.prototype.disabled = new boolean();

/**
 * Represents the HTMLInputElement prototype object.
 * @syntax HTMLInputElement.prototype
 * @static
 */
HTMLInputElement.prototype;

