/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Name;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Bundle;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.Exceptions;

public class RenameConstructor
implements ErrorRule<Void> {
    private static final Set<String> ERROR_CODES = Collections.singleton("compiler.err.invalid.meth.decl.ret.type.req");

    public Set<String> getCodes() {
        return ERROR_CODES;
    }

    public List<Fix> run(CompilationInfo compilationInfo, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        if (treePath.getLeaf().getKind() == Tree.Kind.METHOD) {
            MethodTree mt = (MethodTree)treePath.getLeaf();
            TreePath parentPath = treePath.getParentPath();
            ClassTree ct = (ClassTree)parentPath.getLeaf();
            Trees trees = compilationInfo.getTrees();
            Types types = compilationInfo.getTypes();
            TreeUtilities tu = compilationInfo.getTreeUtilities();
            TypeMirror type = types.erasure(trees.getTypeMirror(treePath));
            if (!Utilities.isValidType(type)) {
                return null;
            }
            for (Tree tree : ct.getMembers()) {
                TreePath memberPath = new TreePath(parentPath, tree);
                if (tree.getKind() != Tree.Kind.METHOD || !"<init>".contentEquals(((MethodTree)tree).getName()) || tu.isSynthetic(memberPath) || !types.isSameType(types.erasure(trees.getTypeMirror(memberPath)), type)) continue;
                return null;
            }
            RenameConstructorFix fix = new RenameConstructorFix(compilationInfo.getSnapshot().getSource(), TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo), offset, mt.getName(), ct.getSimpleName());
            return Collections.singletonList(fix);
        }
        return null;
    }

    public void cancel() {
    }

    public String getId() {
        return RenameConstructor.class.getName();
    }

    public String getDisplayName() {
        return Bundle.LBL_RenameConstructor();
    }

    public String getDescription() {
        return Bundle.DSC_RenameConstructor();
    }

    static final class RenameConstructorFix
    implements Fix {
        private Source source;
        private TreePathHandle pathHandle;
        private int offset;
        private Name oldConstructorName;
        private Name newConstructorName;

        private RenameConstructorFix(Source source, TreePathHandle pathHandle, int offset, Name oldConstructorName, Name newConstructorName) {
            this.source = source;
            this.pathHandle = pathHandle;
            this.offset = offset;
            this.oldConstructorName = oldConstructorName;
            this.newConstructorName = newConstructorName;
        }

        public String getText() {
            return Bundle.FIX_RenameConstructor(this.oldConstructorName, this.newConstructorName);
        }

        public ChangeInfo implement() throws Exception {
            try {
                ModificationResult.runModificationTask(Collections.singleton(this.source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        WorkingCopy wc = WorkingCopy.get((Parser.Result)resultIterator.getParserResult(offset));
                        wc.toPhase(JavaSource.Phase.PARSED);
                        TreePath path = pathHandle.resolve((CompilationInfo)wc);
                        if (path != null && path.getLeaf().getKind() == Tree.Kind.METHOD) {
                            MethodTree mt = (MethodTree)path.getLeaf();
                            wc.rewrite((Tree)mt, wc.getTreeMaker().setLabel((Tree)mt, (CharSequence)newConstructorName));
                        }
                    }
                }).commit();
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            return null;
        }

        public String toDebugString() {
            return "[RenameConstructorFix:" + this.oldConstructorName + ":" + this.newConstructorName + "]";
        }
    }
}

